'/* BXOR.BAS Encrypt text by bitwise character masking(XOR) */
'/*          By: Dale Thorn                                 */
'/*          Rev. 03.03.2003                                */

'$include: 'basdef.h'
'$include: 'bcrp.h'

'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'midchar.bas'
'$include: 'parmstr2.bas'

main:                                  '/* get user's command-line arguments */
   cmsg = ""                          '/* initialize the User message string */
   cwrd = "!#$%&'()+-.0123456789@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`{}~"
   cwrx = "                                                         "
   ibeg = 0                           '/* initialize the loop-begin variable */
   ibuf = 2048                        '/* set the maximum file buffer length */
   ichr = 0                    '/* initialize a temporary character variable */
   idot = 0                  '/* initialize the filename extension separator */
   idx2 = 0                         '/* initialize a temporary loop variable */
   iend = 0                          '/* initialize the loop-ending variable */
   ilen = 0                       '/* initialize a temporary length variable */
   incr = 0                       '/* initialize the loop-increment variable */
   indx = 0                         '/* initialize a temporary loop variable */
   iopr = 0                                '/* initialize the operation code */
   iwrd = len(cwrd)                  '/* initialize length of filename chars */
   llof = 0                          '/* initialize the file length variable */
   lrnd = 0                        '/* initialize the randomizer accumulator */
   ifil = freefile                    '/* get next available DOS file handle */
   iprm = parmstr1(rtrim$(command$), cfil, cnam, cext, cprm()) '/* cmnd args */
   dim int1(57)                       '/* allocate filename sort index array */
   dim lnt2(57)                       '/* allocate filename sort PRN's array */
   dim istk(57)                       '/* allocate filename sort stack array */

   if command$ = "" then                 '/* a command line was not supplied */
      cmsg = "Usage:  BXOR  filename  [key1  key2  ....]"
      i = ifn.msgs(cmsg, 5, 24, 79, 0, 1) '/* display usage message and exit */
   end if
   if iprm < 0 or iprm > 11 then    '/* no. of seed keys should be one to 12 */
      i = ifn.msgs("Invalid number of parameters", 5, 24, 79, 1, 1)
   end if                         '/* display error message [above] and exit */
   lset cfil = ucase$(cfil)                '/* uppercase the target filename */
   idot = instr(1, cfil, ".")   '/* position of filename extension separator */
   ilen = len(cfil)                            '/* length of target filename */
   if idot > 9 or (idot = 0 and ilen > 8) or (idot > 0 and ilen - idot > 3) then
      i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)  '/* filename is bad */
   end if                         '/* display error message [above] and exit */
   if idot then                      '/* filename extension separator found! */
      if instr(idot + 1, cfil, ".") then              '/* 2nd '.' was found! */
         i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)
      end if                      '/* display error message [above] and exit */
      if idot = ilen then         '/* extension separator at end of filename */
         ilen = ilen - 1             '/* decrement length of target filename */
         cfil = left$(cfil, ilen)    '/* decrement length of target filename */
      end if
   end if
   i = ifn.open(ifil, cfil, "b", llof)            '/* open the selected file */
                                             '/* get length of selected file */
   if llof <= 0 then                             '/* length=0 or call failed */
      close ifil                                 '/* close the selected file */
      i = ifn.kill(ifil, cfil)                 '/* kill the zero-length file */
      cmsg = cfil                               '/* copy filename to message */
      cmsg = cmsg + " not found"              '/* add "not found" to message */
      i = ifn.msgs(cmsg, 5, 24, 79, 1, 1)       '/* display message and exit */
   end if
   i = ifn.msgs("Applying bitmask", 5, 24, 79, 0, 0)  '/* apply bitmask msg. */
   iopr = 1                                           '/* opcode (1=encrypt) */
   if iopr = 1 then                        '/* this is the encrypt operation */
      ibeg = 1                               '/* set the loop-begin variable */
      iend = iprm                           '/* set the loop-ending variable */
      incr = 1                           '/* set the loop-increment variable */
   end if
   for indx = ibeg to iend step incr             '/* loop thru #of seed keys */
      lrnd = pdqvall&(cprm(indx)) mod 1048576&   '/* get randomizer seed key */
      for idx2 = 0 to iwrd - 1               '/* loop through array elements */
         int1(idx2) = idx2              '/* offsets from current byte offset */
         l = lfn.rand(lrnd)              '/* get the next pseudorandom value */
         lnt2(idx2) = lrnd                '/* put random value to sort array */
      next
      i = ifn.sort(int1(), lnt2(), istk(), iwrd - 1)   '/* sort random array */
      for idx2 = 0 to iwrd - 1                  '/* loop thru filename chars */
         mid$(cwrx, int1(idx2) + 1) = mid$(cwrd, idx2 + 1, 1)
      next                 '/* shuffle bytes in valid filename chars [above] */
      lrnd = pdqvall&(cprm(indx)) mod 1048576&   '/* get randomizer seed key */
      for idx2 = 1 to ilen                      '/* loop thru filename chars */
         ichr = instr(cwrx, mid$(cfil, idx2, 1)) '/* filename char. position */
         if ichr = 0 then                '/* character not found in filename */
            i = ifn.msgs("Invalid character in filename", 5, 24, 79, 1, 1)
         end if                   '/* display error message [above] and exit */
         lrnd = (lrnd + ichr) mod 1048576&             '/* add value to seed */
         l = lfn.rand(lrnd)                  '/* reiterate value of seed key */
      next
      cmsg = ltrim$(str$(indx + 1))             '/* convert 'indx' to string */
      i = ifn.msgs(cmsg, -22, 24, 79, 0, 0)    '/* show layer number message */
      i = ifn.cryp((ibuf), ifil, iopr, llof, (lrnd))  '/* encrypt or decrypt */
   next
   close                                            '/* close all open files */
   shell "view " + cfil                               '/* browse output file */
system

function ifn.cryp(ibuf, ifil, iopr, llof, lrnd)          '/* encrypt routine */
   cmsg = ""                          '/* initialize the User message string */
   ibit = 0                              '/* initialize the random bit value */
   ibuffbit = 0                         '/* initialize byte pointer variable */
   ibuffbyt = 0                       '/* initialize buffer pointer variable */
   ichr1 = 0                           '/* initialize byte accumulator value */
   ichr2 = 0                           '/* initialize byte accumulator value */
   iexp = 0                           '/* initialize the exponent of 2 value */
   lbyt = 0                             '/* initialize file pointer variable */
   cbuf = space$(ibuf)                        '/* initialize the file buffer */

   for lbyt = 0 to llof - 1 step ibuf           '/* process in ibuf segments */
      if llof > ibuf then                     '/* so we don't divide by zero */
         cmsg = ltrim$(str$(lbyt \ (llof \ 100))) '/* convert pct. to string */
         cmsg = cmsg + "%"                  '/* append '%' symbol to message */
         i = ifn.msgs("    ", -25, 24, 79, 0, 0)'/* erase prev.complete msg. */
         i = ifn.msgs(cmsg, -25, 24, 79, 0, 0)  '/* show pct. completed msg. */
      end if
      if lbyt + ibuf > llof then        '/* curr.file pointer+ibuf spans EOF */
         i = ifn.setm(cbuf, llof, lbyt, ibuf)   '/* reset file buffer length */
      end if
      get ifil, lbyt + 1, cbuf            '/* read data into the file buffer */
      for ibuffbyt = 0 to ibuf - 1                     '/* proc. file buffer */
         ichr1 = 0                     '/* initialize byte accumulator value */
         iexp = 1                     '/* initialize the exponent of 2 value */
         for ibuffbit = 0 to 7          '/* process each bit in current byte */
            l = lfn.rand(lrnd)           '/* get the next pseudorandom value */
            if lrnd < 10 then             '/* the pseudorandom value is <= 9 */
               ibit = lrnd mod 2            '/* odd/even value of only digit */
            else                         '/* the pseudorandom value is >= 10 */
               ibit = (lrnd \ 10) mod 2  '/* odd/even value of last -1 digit */
            end if
            ichr1 = ichr1 + ibit * iexp  '/* accumulate bits in current byte */
            iexp = iexp * 2                '/* increment exponent of 2 value */
         next
         ichr2 = midchar(cbuf, ibuffbyt + 1)   '/* current buffer byte value */
         mid$(cbuf, ibuffbyt + 1) = char(ichr1 xor ichr2) '/* XOR curr. byte */
      next
      put ifil, lbyt + 1, cbuf               '/* write data from file buffer */
   next
   cbuf = ""                                  '/* deallocate the file buffer */
end function

function ifn.sort(int1(), lnt2(), istk(), imax) '/* array Quicksort function */
   iex1 = 0                          '/* initialize the outer-loop exit flag */
   iex2 = 0                          '/* initialize the inner-loop exit flag */
   ilap = 0                             '/* initialize the low array pointer */
   ilsp = 0                             '/* initialize the low stack pointer */
   irdx = 0                                    '/* initialize the sort radix */
   itap = 0                             '/* initialize the top array pointer */
   itsp = 0                             '/* initialize the top stack pointer */
   iva1 = 0                '/* initialize array value from low stack pointer */
   lva2 = 0                '/* initialize array value from low stack pointer */

   istk(0) = 0                          '/* initialize the low array pointer */
   istk(1) = imax                       '/* initialize the top array pointer */
   while irdx >= 0                             '/* loop until sort radix < 0 */
      ilsp = istk(irdx + irdx)                 '/* set the low stack pointer */
      itsp = istk(irdx + irdx + 1)             '/* set the top stack pointer */
      irdx = irdx - 1                           '/* decrement the sort radix */
      iva1 = int1(ilsp)           '/* get array value from low stack pointer */
      lva2 = lnt2(ilsp)           '/* get array value from low stack pointer */
      ilap = ilsp                              '/* set the low array pointer */
      itap = itsp + 1                          '/* set the top array pointer */
      iex1 = 0                       '/* initialize the outer-loop exit flag */
      while not iex1                 '/* loop to sort within the radix limit */
         itap = itap - 1                 '/* decrement the top array pointer */
         if itap = ilap then        '/* top array pointer==low array pointer */
            iex1 = not 0                 '/* set the outer-loop exit flag ON */
         elseif lva2 > lnt2(itap) then   '/* value @low ptr > value @top ptr */
            int1(ilap) = int1(itap)        '/* swap low and top array values */
            lnt2(ilap) = lnt2(itap)        '/* swap low and top array values */
            iex2 = 0                 '/* initialize the inner-loop exit flag */
            while not iex2         '/* loop to compare and swap array values */
               ilap = ilap + 1           '/* increment the low array pointer */
               if itap = ilap then  '/* top array pointer==low array pointer */
                  iex1 = not 0           '/* set the outer-loop exit flag ON */
                  iex2 = not 0           '/* set the inner-loop exit flag ON */
               elseif lva2 < lnt2(ilap) then '/* value@low ptr<value@low ptr */
                  int1(itap) = int1(ilap)  '/* swap top and low array values */
                  lnt2(itap) = lnt2(ilap)  '/* swap top and low array values */
                  iex2 = not 0           '/* set the inner-loop exit flag ON */
               end if
            wend
         end if
      wend
      int1(ilap) = iva1           '/* put array value from low stack pointer */
      lnt2(ilap) = lva2           '/* put array value from low stack pointer */
      if itsp - ilap > 1 then                   '/* low segment-width is > 1 */
         irdx = irdx + 1                        '/* increment the sort radix */
         istk(irdx + irdx) = ilap + 1            '/* reset low array pointer */
         istk(irdx + irdx + 1) = itsp            '/* reset top array pointer */
      end if
      if itap - ilsp > 1 then                   '/* top segment-width is > 1 */
         irdx = irdx + 1                        '/* increment the sort radix */
         istk(irdx + irdx) = ilsp                '/* reset low array pointer */
         istk(irdx + irdx + 1) = itap - 1        '/* reset top array pointer */
      end if
   wend
end function

function ifn.msgs(cmsg, iofs, irow, icol, ibrp, iext)       '/* display msgs */
   if iofs >= 0 then                                  '/* OK to clear screen */
      cls                                               '/* clear the screen */
   end if
   locate 5, abs(iofs), 1                              '/* locate the cursor */
   print cmsg;                                  '/* display the user message */
   if ibrp then                            '/* OK to sound user-alert (beep) */
      beep                                          '/* sound the user-alert */
   end if
   if iext then                                   '/* OK to exit the program */
      locate 6, 1, 1                                 '/* relocate the cursor */
      close                                         '/* close all open files */
      system                                               '/* return to DOS */
   else                                          '/* do NOT exit the program */
      locate irow, icol, 0                             '/* 'hide' the cursor */
   end if
end function

function ifn.setm(cbuf, llof, lbyt, ibuf)'/* reallocate file buffer & length */
   ibuf = llof - lbyt                   '/* reset maximum file buffer length */
   cbuf = ""                                      '/* deallocate file buffer */
   cbuf = space$(ibuf)                            '/* reallocate file buffer */
end function
