'/* CASE.BAS  Uppercase/lowercase characters in a text file */
'/*           By: Dale Thorn                                */
'/*           Rev. 11.05.2000                               */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'scrnparm.bas'
'$include: 'string.bas'

ccmd = ucase$(rtrim$(command$))            'get the DOS command-line parameters
if ccmd = "" then                              'a command line was not supplied
   i = ifn.msgs("Usage:  CASE  filename  [/l /u]", iofs, irow, icol, 0, 1)
end if                              'display the usage message [above] and exit

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if len(cnam) = 0 or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") then
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)   'invalid filename
end if                       'display invalid-filename message [above] and exit

i = ifn.open(1, cfil, "b", llof)           'open the source file in binary mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)      'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", iofs, irow, icol, 1, 1)     'beep and exit
end if

if iprm <> 0 then             'no. of parameters was 0 (none) or > 1 (too many)
   i = ifn.msgs("Invalid number of parameters", iofs, irow, icol, 1, 1)
end if                      'display no.-of-parameters message [above] and exit

if cprm(0) <> "L" and cprm(0) <> "U" then    'an invalid parameter was supplied
   i = ifn.msgs("Invalid parameter", iofs, irow, icol, 1, 1)
end if                      'display invalid-parameter message [above] and exit

i = ifn.msgs("Please standby", iofs, irow, icol, 0, 0) 'hide cursor and proceed
iseg = (fre("") - 4096) \ 2           'maximum available memory for file buffer
if iseg > llof then                          'buffer length is > length of file
   iseg = llof                              'set buffer length = length of file
end if
cbuf = space$(iseg)                                 'initialize the file buffer
imod = llof mod iseg       'left-over bytes at end of buffer-size file segments
for lrcd = 1 to llof step iseg      'loop thru the file in buffer-size segments
   if lrcd + iseg > llof and imod > 0 then   'last file "record" and imod is ON
      cbuf = ""                                     'deallocate the file buffer
      cbuf = space$(imod)                         'reinitialize the file buffer
   end if
   get 1, lrcd, cbuf                            'load the file buffer with data
   if cprm(0) = "L" then                     'lowercase parameter was specified
      lset cbuf = lcase$(cbuf)                'lowercase the data in the buffer
   else                                      'uppercase parameter was specified
      lset cbuf = ucase$(cbuf)                'uppercase the data in the buffer
   end if
   put 1, lrcd, cbuf                              'write the buffer to the file
next

i = ifn.msgs("Case translation complete for: " + cfil, iofs, irow, icol, 0, 1)
close                                 'close all files in case not closed above
system                                   'exit program in case not exited above
