'/* DIR2NM5X.BAS Add path names to filenames in list */
'/*              By: Dale Thorn                      */
'/*              Rev. 06.07.2002                     */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'getdir.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr2.bas'
'$include: 'string.bas'

ccmd = ucase$(rtrim$(command$))         'get the user's command-line parameters
if ccmd = "" then                              'a command line was NOT supplied
   i = ifn.msgs("Usage:  DIR2NM5X  filename  [/N]", 5, 24, 79, 0, 1)
end if                              'display the usage message [above] and exit
ipos1 = instr(ccmd, "/N")               'don't display (except error) messages?
if ipos1 then                                 'user said don't display messages
   imsgdisp = 0                                'set message display flag to OFF
   ccmd = rtrim$(left$(ccmd, ipos1 - 1) + mid$(ccmd, ipos1 + 2))   'remove '/N'
else                                          'user said OK to display messages
   imsgdisp = not 0                             'set message display flag to ON
end if

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse the command-line params
if iprm >= 0 then                         'too many parameters (should be zero)
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)          'invalid filename
end if                       'display invalid-filename message [above] and exit

i = ifn.open(1, cfil, "S", llof)       'open the source file in sequential mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)            'beep and exit
end if

idot = istr.rcfn(len(cfil), cfil, ".")             'filename extension position
if idot = 0 then                                  'filename extension NOT found
   idot = len(cfil) + 1                        'set position to end of filename
end if
if mid$(cfil, idot + 1) = "out" then            'source file extension == "OUT"
   cdst = left$(cfil, idot - 1) + ".tmp"      'set dest.file extension to "TMP"
else                                            'source file extension != "OUT"
   cdst = left$(cfil, idot - 1) + ".out"      'set dest.file extension to "OUT"
end if

if imsgdisp then                              'user said OK to display messages
   i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)            'OK to proceed...
end if

imaxdirlen = 0                               'initialize max.length of dirnames
while not eof(1)                            'loop to find any directory headers
   line input #1, clin                      'get next line from the source file
   clin = ucase$(rtrim$(clin))                 'right-trim the source file line
   if clin <> "" then                          'possible valid header/file line
      chdr = clin                            'make copy of possible dirhdr line
      i = ifn.gdirhdr(chdr)                   'current line a directory header?
      if chdr <> "" then                    'current line IS a directory header
         if imaxdirlen < len(chdr) then    'dirname length > current max.length
            imaxdirlen = len(chdr)        'reset the current dirname max.length
         end if
      end if
   end if
wend
if imaxdirlen > 211 then                    'total buffer size > max. view size
   imaxdirlen = 211                          'adjust sizes to maximum view size
end if
cdirbuf = space$(imaxdirlen)               'allocate buffer for directory names
cfspbuf = space$(27)                        'allocate buffer for misc.filespecs

close 1                            'close source file to reset the file pointer
open cfil for input as 1             'reopen the source file in sequential mode
open cdst for output as 2             'open the destination file in output mode

while not eof(1)                                'loop to find directory headers
   line input #1, clin                         'get a line from the source file
   clin = ucase$(rtrim$(clin))                 'right-trim the source file line
   if clin <> "" then                          'possible valid header/file line
      chdr = clin                            'make copy of possible dirhdr line
      i = ifn.gdirhdr(chdr)                   'current line a directory header?
      if chdr <> "" then                    'current line IS a directory header
         lset cdirbuf = chdr                  'put directory header into buffer
         if len(chdr) > imaxdirlen then     'directory/path longer than maximum
            mid$(cdirbuf, imaxdirlen - 1) = "\\"   'insert error indicator here
         end if
      elseif instr(clin, "<DIR>") = 0 then 'current line NOT a directory header
         i = ifn.gdirfsp(clin)              'is test filespec a valid filespec?
         if clin <> "" then                  'test filespec IS a valid filespec
            print #2, cdirbuf; clin               'output dirname-plus-filename
         end if
      end if
   end if
wend

close                            'close all files prior to calling BROW program
if imsgdisp then                              'user said OK to display messages
   shell "brow " + cdst                   'browse the destination (output) file
end if
close                                 'close all files in case not closed above
system                                      'return control to operating system

function ifn.gdirfsp(cfsp)                           'return formatted filespec
   ipos3 = istr.rcfn(len(cfsp), cfsp, ":")    'position of ':' in filespec time
   ipos2 = istr.rcfn(ipos3 - 1, cfsp, "/")    'pos. of 2nd '/' in filespec date
   ipos1 = istr.rcfn(ipos2 - 1, cfsp, "/")    'pos. of 1st '/' in filespec date
   if not(ipos1 > 0 and ipos2 = ipos1 + 3 and ipos3 > ipos2) then 'invalid spec
      ipos2 = istr.rcfn(ipos3 - 1, cfsp, "-") 'pos. of 2nd '-' in filespec date
      ipos1 = istr.rcfn(ipos2 - 1, cfsp, "-") 'pos. of 1st '-' in filespec date
   end if
   if not(ipos1 > 0 and ipos2 = ipos1 + 3 and ipos3 > ipos2) then 'invalid spec
      ipos2 = istr.rcfn(ipos3 - 1, cfsp, ".") 'pos. of 2nd '.' in filespec date
      ipos1 = istr.rcfn(ipos2 - 1, cfsp, ".") 'pos. of 1st '.' in filespec date
   end if
   if ipos1 > 0 and ipos2 = ipos1 + 3 and ipos3 > ipos2 then   'valid filespec!
      iapm = midchar(cfsp, istr.lcsp(ipos3 + 3, cfsp, " "))'filespec time AM/PM
      ihrs = pdqvali(mid$(cfsp, ipos3 - 2, 2))   'get hours value from filespec
      ipos4 = istr.rcfn(ipos1 - 3, cfsp, ",")    'position of comma in filesize
      while ipos4 >= 13                    'loop to remove commas from filesize
         mid$(cfsp, 13) = " " + mid$(cfsp, 13, ipos4 - 13)    'remove the comma
         ipos4 = istr.rcfn(ipos4 - 1, cfsp, ",")        'next comma in filesize
      wend
      cfspsize = ltrim$(rtrim$(mid$(cfsp, 13, ipos1 - 16)))  'get filespec size
      cpadsize = space$(10 - len(cfspsize))              'pad size to length=10
      cfspyear = "  " + mid$(cfsp, ipos2 + 1, 2)        'make space for century
      if mid$(cfspyear, 3, 2) < "80" then                'year is '00' thru '79'
         mid$(cfspyear, 1) = "20"                     'set year to 21st century
      else                                               'year is '80' thru '99'
         mid$(cfspyear, 1) = "19"                     'set year to 20th century
      end if
      cfsp = left$(cfsp, 12) + _
             cpadsize + cfspsize + " " + _
             cfspyear + "-" + _
             mid$(cfsp, ipos1 - 2, 2) + "-" + _
             mid$(cfsp, ipos1 + 1, 2) + " " + _
             mid$(cfsp, ipos3 - 2, 5)             'format the returned filespec
      ilen = len(cfsp)                               'get the filespec's length
      if (iapm = 80 or iapm = 112) and ihrs <> 12 then    'filespec time is P.M.
         mid$(cfsp, ilen - 4) = ltrim$(str$(ihrs + 12))   'change to 24-hr time
      elseif (iapm = 65 or iapm = 97) then                'filespec time is A.M.
         if ihrs = 12 then                                  'time is < 0100 A.M.
            mid$(cfsp, ilen - 4) = " 0"                    'add poss.missing '0'
         elseif ihrs < 10 then                              'time is < 1000 A.M.
            mid$(cfsp, ilen - 4) = " "                    'blank redundant zero
         end if
      end if
   else                                       'NOT a valid WinNT/2k/XP filespec
      cfsp = ""                                         'return an empty string
   end if
end function                                         'return to calling routine

function ifn.gdirhdr(chdr)              'extract full DOS path from 'chdr' text
   ipos1 = instr(chdr, ":\")            'posn. of (example: 'c:\dir1\dir2\...')
   if ipos1 = 0 then                    'directory header n/a to this text line
      chdr = ""                         'no directory header; exit this process
      exit function                      'return control to the calling routine
   end if
   chdr = rtrim$(mid$(chdr, ipos1 - 1))            'extract the full DOS header
   if right$(chdr, 1) <> "\" then   'header returned by DOS does not contain...
      chdr = chdr + "\"             '..."\" unless (example) 'A:\', 'C:\', etc.
   end if
end function
