'/* FILEOPEN.BAS  18.06.1998 */

function ifn.open(ifno, cfil, cmod, llof)  'open a DOS file in binary/seq. mode
   if instr(cfil, "*") or instr(cfil, "?") then  'user entered a wildcard spec.
      llof = -1                               'return -1 length (invalid spec.)
   else                                       'no wildcards entered in filename
      lset cmod = ucase$(cmod)                  'uppercase the file-access mode
      if ifno = 0 then                          'a file number was NOT assigned
         ifno = freefile                        'get next available file number
      end if
      close ifno                                  'close file in case it's open
      open cfil for binary as ifno                'open file in binary R/W mode
      llof = lof(ifno)                          'get current length of the file
      if llof = 0 then                          'file is invalid, R/O, or empty
         close ifno                             'close the (possibly) open file
         open cfil for binary access read as ifno 'open file in binary R/O mode
         llof = lof(ifno)                       'get current length of the file
         if cmod = "B" then                       'binary-access mode specified
            lset cmod = "R"                     'set access mode to 'R'ead-only
         end if
      elseif cmod = "B" then                 'file was opened read/write binary
         lset cmod = "W"                       'set access mode to read/'W'rite
      end if
      if cmod = "S" and llof > 0 then         'sequential-access mode specified
         close ifno                         'close the successfully opened file
         open cfil for input as ifno       'open file in sequential-access mode
      end if
   end if
end function
