'/* ICOL.BAS Add column from string or file (make output file) */
'/*          By: Dale Thorn                                    */
'/*          Rev. 26.04.2001                                   */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'

ccmd = rtrim$(command$)                    'get the DOS command-line parameters
if ccmd = "" then                     'DOS command-line parameters NOT supplied
   i = ifn.msgs("Usage:  ICOL  sourcefile  " + char(34) + "inserttext" + _
                char(34) + "[insertfile]  offset  [length]", 5, 24, 79, 0, 1)
end if                                  'display usage message [above] and exit

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") then
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
end if                                  'display error message [above] and exit
if iprm < 1 or iprm > 2 then         'user input too few or too many parameters
   i = ifn.msgs("Invalid number of parameters", 5, 24, 79, 1, 1) 'beep and exit
end if                                  'display error message [above] and exit

isrcofs = pdqvali(cprm(1))                 'get the source (from) column offset
if iprm = 2 then                           'user specified a dest.column length
   idstlen = pdqvali(cprm(2))               'get destination (to) column length
   cdstcol = space$(idstlen)                'create insert-column format buffer
else                                        'user did NOT specify column length
   idstlen = -1                            'default the dest.(to) column length
end if

i = ifn.open(1, cfil, "S", llof)           'open source file in sequential mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
end if                                  'display error message [above] and exit
if llof = 0 then                              'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)            'beep and exit
end if                                  'display error message [above] and exit

i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)        'hide cursor and proceed

ilen = len(cprm(0))              'get the length of the text/textfile parameter
if midchar(cprm(0), 1) = 34 and midchar(cprm(0), ilen) = 34 and ilen >= 3 then
   ctxt = mid$(cprm(0), 2, ilen - 2)           'insert-text is quoted text only
   if idstlen = -1 then                     'user did NOT specify column length
      cdstcol = ctxt                        'create insert-column format buffer
      idstlen = len(cdstcol)                'set column length from text length
   else                                   'the user DID specify a column length
      lset cdstcol = ctxt                   'left-justify text in format buffer
   end if
   ifil = 0                                       'set textfile column flag OFF
else                                            'text is contained in text file
   ifil = not 0                                    'set textfile column flag ON
   i = ifn.open(3, cprm(0), "S", llof)       'open text file in sequential mode
   if llof < 0 then                             'user input a wildcard filespec
      i = ifn.msgs("Invalid textfile name", 5, 24, 79, 1, 1)       'beep & exit
   end if                               'display error message [above] and exit
   if llof = 0 then                             'text file nonexistent or empty
      i = ifn.kill(3, cprm(0))                       'kill the zero-length file
      i = ifn.msgs(cprm(0) + " not found", 5, 24, 79, 1, 1)        'beep & exit
   end if                               'display error message [above] and exit
   if idstlen = -1 then                   'user did NOT specify a column length
      idstlen = 0                       'initialize max.insert-file line length
      while not eof(3)                    'begin loop to read insert-file lines
         line input #3, clin                  'read a line from the insert file
         ilen = len(rtrim$(clin))           'get the length of the current line
         if idstlen < ilen then             'maximum length is < current length
            idstlen = ilen                 'set maximum length = current length
         end if
      wend
      if idstlen = 0 then                  'user-specified insert-file is empty
         i = ifn.msgs("Insertfile contains no text", 5, 24, 79, 1, 1)'beep&exit
      end if                            'display error message [above] and exit
      close 3                                            'close the insert file
      open cprm(0) for input as 3                       'reopen the insert file
      cdstcol = space$(idstlen)             'create insert-column format buffer
   end if
end if

if cext = "out" then                       'source filename extension is ".out"
   if cprm(0) = cnam + ".tmp" then             '.tmp' extension is already used
      cdst = cnam + ".wrk"                       'set dest. extension to ".wrk"
   else                                       '.tmp' extension NOT already used
      cdst = cnam + ".tmp"                       'set dest. extension to ".tmp"
   end if
elseif cext = "tmp" then                   'source filename extension is ".tmp"
   if cprm(0) = cnam + ".out" then             '.out' extension is already used
      cdst = cnam + ".wrk"                       'set dest. extension to ".wrk"
   else                                       '.out' extension NOT already used
      cdst = cnam + ".out"                       'set dest. extension to ".out"
   end if
else                                         'source extn. NOT ".out" or ".tmp"
   if cprm(0) = cnam + ".out" then             '.out' extension is already used
      cdst = cnam + ".tmp"                       'set dest. extension to ".tmp"
   else                                       '.out' extension NOT already used
      cdst = cnam + ".out"                       'set dest. extension to ".out"
   end if
end if
open cdst for output as 2                     'open the output destination file

ieof3 = 0                                  'initialize the insert-file EOF flag
coffset = space$(isrcofs)                   'source-file "offset" format buffer
while not eof(1)                          'begin loop to read source-file lines
   line input #1, clin                        'read a line from the source file
   if ifil then                                 'text is contained in text file
      if ieof3 then                               'text file is completely read
         ctxt = ""                                'clear any existing text line
      else                                       'text file NOT completely read
         line input #3, ctxt                    'read a line from the text file
         ieof3 = eof(3)                          'is text file completely read?
      end if
      lset cdstcol = ctxt                   'left-justify text in format buffer
   end if
   if isrcofs then                      'user specified an insert-column offset
      lset coffset = left$(clin, isrcofs)   'put source text into offset buffer
   end if
   clin = coffset + cdstcol + mid$(clin, isrcofs + 1)   'build output text line
   print #2, rtrim$(clin)                             'output the new text line
wend

close                                 'close all files in case not closed above
shell "brow " + cdst                                    'browse the output file
system                                                'exit to operating system
