'/* LTOT.BAS Display the total no. of lines in a text file */
'/*          By: Dale Thorn                                */
'/*          Rev. 30.07.2002                               */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'tfind.h'

declare function ifn.pgsz(ccpi(), clpi(), ipsz(), ltot, ilen, ilgl)

'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'
'$include: 'tfind.bas'

dim ccpi(2)                                      'allocate chars-per-inch array
dim clpi(1)                                      'allocate lines-per-inch array
dim ipsz(1)                                       'allocate the page-size array

ccmd = ucase$(rtrim$(command$))            'get the DOS command-line parameters
if ccmd = "" then                              'a command line was not supplied
   i = ifn.msgs("Usage:  LTOT  filename", 5, 24, 79, 0, 1)
end if                              'display the usage message [above] and exit

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if len(cnam) = 0 or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") _
or iprm >= 0 then        'user gave an invalid filename or supplied a parameter
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)
end if                       'display invalid-filename message [above] and exit

tf.fnum = freefile               'file channel/unit number for binary-mode file
i = ifn.open(tf.fnum, cfil, "b", tf.llof)  'open the source file in binary mode
if tf.llof < 0 then                             'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
elseif tf.llof = 0 then                       'source file nonexistent or empty
   i = ifn.kill(tf.fnum, cfil)                       'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)            'beep and exit
end if

if tf.llof > 5000 then                               'file size is > 5000 bytes
   ilen = 5000                                    'set buffer size = 5000 bytes
else                                                'file size is <= 5000 bytes
   ilen = tf.llof                                  'set buffer size = file size
end if
cbuf = space$(ilen)                                   'allocate the test buffer
get tf.fnum, tf.llof - ilen + 1, cbuf               'load test buffer from file
ipos = 0                                    'initialize the text char. position
for i = ilen to 1 step -1                   'loop to find text byte or char(13)
   ichr = midchar(cbuf, i)                 'extract the current character value
   if ichr = 13 then                         'current char.is a carriage return
      if i < ilen then                      'line-count pointer < end of buffer
         if midchar(cbuf, i + 1) = 10 then   'c/r-l/f pair found this position!
            i = i + 1                          'advance pointer to l/f position
         end if
      end if
      exit for                                'carriage return found; exit loop
   elseif ichr > 32 and ipos = 0 then        'current char. is a text character
      ipos = i                              'text character found; set position
   end if
next
cbuf = ""                                 'deallocate the temporary/test buffer
if ipos then                            'text byte found AFTER last c/r in file
   tf.llen = ipos - i                    'set maximum line length to line found
   iadd = 1                           'add one (1) to total of file's linecount
else                                'text byte NOT found after last c/r in file
   iadd = 0                          'add zero (0) to total of file's linecount
end if

i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)        'display standby message

tf.bbeg = 1                           'initialize begin search position in cbuf
tf.fbeg = 1                           'initialize begin search position in file
tf.ltot = iadd                        'initialize total no.of lines in the file
tf.csen = not 0                               'set the case-sensitivity flag ON
tf.lcnt = not 0                           'set the flag to count the text lines
tf.load = not 0                      'OK to load initial buffer inside function
cbuf = space$((fre("") - 4096) \ 2)              'allocate the main file buffer
if ifn.tfnd(tf, cbuf, "qqz" + "qq" + "zqq") = 27 then 'User pressed the ESC key
   i = ifn.msgs("Esc pressed - Program aborted", 5, 24, 79, 0, 1)
end if                     'ESC pressed; display abort message [above] and exit
cq = char(34)                            'initialize the double-quote character

i = ifn.pgsz(ccpi(), clpi(), ipsz(), tf.ltot, tf.llen, 1) 'get CPI/LPI/pagesize
ipg4 = tf.ltot \ ipsz(0) + abs(tf.ltot mod ipsz(0) > 0) 'no. pages 14" portrait
ips4 = ipsz(0)                                     'lines per page 14" portrait
clp4 = clpi(0)                                     'lines per inch 14" portrait
i = ifn.pgsz(ccpi(), clpi(), ipsz(), tf.ltot, tf.llen, 0) 'get CPI/LPI/pagesize
ipgp = tf.ltot \ ipsz(0) + abs(tf.ltot mod ipsz(0) > 0)   'total pages portrait
ipgl = tf.ltot \ ipsz(1) + abs(tf.ltot mod ipsz(1) > 0)  'total pages landscape
cls                                               'clear the user's text screen
locate 3, 1, 1                                      'locate cursor for messages
print "    Total lines in file: "; ltrim$(str$(tf.ltot))   'display total lines
print                                                 'display a separator line
print "    Maximum line length: "; ltrim$(str$(tf.llen))  'display max. linelen
print                                                 'display a separator line
print "    Page size portrait 11"; cq; " : "; ltrim$(str$(ipsz(0)))'pgsz(port.)
print "    Total no. of pages 11"; cq; " : "; ltrim$(str$(ipgp)) '#pages(port.)
print "    Lines per inch     11"; cq; " : "; clpi(0)   'lines per inch (port.)
print "    Characters per inch    : "; ccpi(0)          'chars per inch (port.)
print                                                 'display a separator line
print "    Page size portrait 14"; cq; " : "; ltrim$(str$(ips4))'pgsz.(portrait)
print "    Total no. of pages 14"; cq; " : "; ltrim$(str$(ipg4))'#pgs.(portrait)
print "    Lines per inch     14"; cq; " : "; clp4   'lines per inch (portrait)
print "    Characters per inch    : "; ccpi(0)       'chars per inch (portrait)
print                                                 'display a separator line
print "    Page size landscape    : "; ltrim$(str$(ipsz(1)))  'pgsz.(landscape)
print "    Total no. of pages     : "; ltrim$(str$(ipgl))  '# pages (landscape)
print "    Lines per inch         : "; clpi(1)      'lines per inch (landscape)
print "    Characters per inch 11"; cq; ": "; ccpi(1)'chars.per inch(lands.11")
print "    Characters per inch 14"; cq; ": "; ccpi(2)'chars.per inch(lands.14")

close                                 'close all files in case not closed above
system                                   'exit program in case not exited above

function ifn.pgsz(ccpi(), clpi(), ipsz(), ltot, ilen, ilgl)'get CPI/LPI/pagesize
   dim ilin(1, 2)                                'allocate lines-per-page array
   dim ipgs(1, 2)                                'allocate total no.pages array
   dim isiz(1, 2)                                'allocate the page sizes array
   if ilgl then                            'user said to use legal paper format
      isiz(0, 0) = 73                         'set minimum page size (portrait)
      isiz(0, 1) = 104                       'set standard page size (portrait)
      isiz(0, 2) = 130                        'set maximum page size (portrait)
   else                                'user said to NOT use legal paper format
      isiz(0, 0) = 56                         'set minimum page size (portrait)
      isiz(0, 1) = 80                        'set standard page size (portrait)
      isiz(0, 2) = 100                        'set maximum page size (portrait)
   end if
   isiz(1, 0) = 42                           'set minimum page size (landscape)
   isiz(1, 1) = 60                          'set standard page size (landscape)
   isiz(1, 2) = 75                           'set maximum page size (landscape)
   for i0 = 0 to 1                       'loop thru portrait/landscape settings
      for i1 = 0 to 2                 'loop thru minimum/standard/maximum sizes
         ipgs(i0, i1) = ltot \ isiz(i0, i1)'init.total pages to #lines/currsize
         if ltot mod isiz(i0, i1) then     'no.of lines/currsize has a leftover
            ipgs(i0, i1) = ipgs(i0, i1) + 1   'increment the total no. of pages
         end if
         ilin(i0, i1) = ltot \ ipgs(i0, i1)    'set pagesize to #lines/currsize
         if ltot mod ipgs(i0, i1) then        'no.lines/currsize has a leftover
            ilin(i0, i1) = ilin(i0, i1) + 1  'increment new calculated pagesize
         end if
      next
      for i1 = 0 to 1                      'outer loop to bubble sort pagesizes
         for i2 = 1 to 2                   'inner loop to bubble sort pagesizes
            if ilin(i0, i1) > ilin(i0, i2) then  'lower-rank size > higher rank
               swap ilin(i0, i1), ilin(i0, i2)    'swap lower-rank, higher rank
            end if
         next
      next
      if ilin(i0, 1) < isiz(i0, 0) then      'middle size is < minimum pagesize
         ilin(i0, 1) = ilin(i0, 2)            'set pagesize to highest pagesize
      end if
      if ilin(i0, 1) < isiz(i0, 0) then      'pagesize still < minimum pagesize
         ilin(i0, 1) = isiz(i0, 0)            'set pagesize to minimum pagesize
      end if
      ipsz(i0) = ilin(i0, 1)            'set pagesize for portrait or landscape
   next
   if ilgl then                            'user said to use legal paper format
      clpi(0) = ltrim$(str$(cint(7.7# * ipsz(0))))  'LPI * 7.7 (portrait/legal)
   else                                'user said to NOT use legal paper format
      clpi(0) = ltrim$(str$(cint(10# * ipsz(0))))   'LPI * 10 (portrait/letter)
   end if
   clpi(0) = left$(clpi(0), len(clpi(0)) - 2) + "." + right$(clpi(0), 2)
   isizmod = ipsz(1) mod 3                 'lines-per-inch leftover (landscape)
   isizint = ((ipsz(1) \ 3) * 4 + isizmod) * 10'lines-per-inch * 10 (landscape)
   if isizmod = 1 then                          'leftover lines = 1 (landscape)
      clpi(1) = ltrim$(str$(isizint + 3))      'lines-per-inch * 10 (landscape)
   elseif isizmod = 2 then                      'leftover lines = 2 (landscape)
      clpi(1) = ltrim$(str$(isizint + 7))      'lines-per-inch * 10 (landscape)
   else                                         'leftover lines = 0 (landscape)
      clpi(1) = ltrim$(str$(isizint))          'lines-per-inch * 10 (landscape)
   end if                             'format lines-per-inch (landscape, below)
   clpi(1) = left$(clpi(1), len(clpi(1)) - 2) + "." + right$(clpi(1), 2)
   for i = 0 to 2           'loop thru the calculated characters-per-inch array
      if i = 0 then            'calculation=chars-per-inch portrait orientation
         dcpi = ilen / .8#       'calculate chars-per-inch portrait orientation
      elseif i = 1 then       'calculation=chars-per-inch landscape page=8.5x11
         dcpi = ilen / 1.06#    'calculate chars-per-inch landscape page=8.5x11
      else                    'calculation=chars-per-inch landscape page=8.5x14
         dcpi = ilen / 1.36#    'calculate chars-per-inch landscape page=8.5x14
      end if
      if dcpi < 120 then        'calculated characters-per-inch is less than 12
         dcpi = 120             'set calculated characters-per-inch equal to 12
      elseif dcpi > 299 then   'calculated characters-per-inch is greater> 29.9
         dcpi = 299           'set calculated characters-per-inch equal to 29.9
      end if
      ccpi(i) = ltrim$(str$(cint(dcpi)))   'calc'd chars-per-inch (string form)
      ccpi(i) = left$(ccpi(i), 2) + "." + right$(ccpi(i), 1)
   next              'format characters-per-inch portrait and landscape [above]
end function
