'/* PNAM.BAS Uppercase first character of words in column of text */
'/*          By: Dale Thorn                                       */
'/*          Rev. 02.10.2002                                      */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'

ccmd = ucase$(rtrim$(command$))            'get the DOS command-line parameters
if ccmd = "" then                     'DOS command-line parameters NOT supplied
   cls                                 'clear DOS screen before message display
   locate 5, 1, 1                          'position cursor for message display
   print "    Usage:  PNAM  filename  offset  length  [/a]"
   print
   print "    If '/a' specified, do not redo substring cases"
   print "    if the entire substring is uppercase (acronyms)"
   system
end if                                  'display usage message [above] and exit

ipos1 = instr(ccmd, "/A")              'check selection to NOT re-case acronyms
if ipos1 then                            'user selected to NOT re-case acronyms
   ccmd = rtrim$(left$(ccmd, ipos1 - 1) + mid$(ccmd, ipos1 + 2))   'remove '/A'
   inym = not 0                          'set don't re-case acronyms flag to ON
else                                      'user selected OK to re-case acronyms
   inym = 0                             'set don't re-case acronyms flag to OFF
end if

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") then
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
end if                                  'display error message [above] and exit
if iprm < 0 or iprm > 1 then         'user input too few or too many parameters
   i = ifn.msgs("Invalid number of parameters", 5, 24, 79, 1, 1) 'beep and exit
end if                                  'display error message [above] and exit

isrcofs = pdqvali(cprm(0))                 'get the source (from) column offset
if iprm = 1 then                           'user specified a dest.column length
   idstlen = pdqvali(cprm(1))               'get destination (to) column length
else                                        'user did NOT specify column length
   idstlen = 9999                          'default the dest.(to) column length
end if

if cext = "out" then                       'source filename extension is ".out"
   cdst = cnam + ".tmp"                    'set destination extension to ".tmp"
else                                      'source filename extension NOT ".out"
   cdst = cnam + ".out"                    'set destination extension to ".out"
end if
clog = cnam + ".log"                       'set non-recased lines log file name

i = ifn.open(1, cfil, "S", llof)           'open source file in sequential mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
end if                                  'display error message [above] and exit
if llof = 0 then                              'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)            'beep and exit
end if                                  'display error message [above] and exit
open cdst for output as 2                     'open the output destination file
open clog for output as 3                        'open the non-recased log file

i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)        'hide cursor and proceed

ilog = 0                                  'initialize the log file written flag
while not eof(1)                          'begin loop to read source-file lines
   line input #1, clin                        'read a line from the source file
   ilen = len(rtrim$(clin))                     'get length of the current line
   ispc = not 0                                 'set TRUE to uppercase 1st char.
   csav = clin                                  'save copy of current text line
   iupper = 0                                      'initialize uppercase totals
   ilower = 0                                      'initialize lowercase totals
   for ipos = isrcofs + 1 to isrcofs + idstlen    'process selected column only
      if ipos > ilen then                       'current position > line length
         exit for                           'current position > end - exit loop
      end if
      iupc = 0                                   'initialize uppercase is false
      ilwc = 0                                   'initialize lowercase is false
      ichr = midchar(clin, ipos)                 'character at current position
      if ichr >= 65 and ichr <= 90 then         'current character is uppercase
         iupc = not 0                           'set uppercase char.flag = true
         iupper = iupper + 1                    'increment uppercase char.total
      elseif ichr >= 97 and ichr <= 122 then    'current character is lowercase
         ilwc = not 0                           'set lowercase char.flag = true
         ilower = ilower + 1                    'increment lowercase char.total
      end if
      if ichr = 32 or ichr = 92 then              'current character is a space
         ispc = not 0                          'set TRUE to uppercase next char.
      else                                    'current character is NOT a space
         if ispc then                           'previous character WAS a space
            ispc = 0                           'set FALSE to NOT uprc.next char.
            if ilwc then                        'current character is lowercase
               mid$(clin, ipos) = char(ichr - 32)  'uppercase current character
            end if
         else                                   'previous character NOT a space
            if iupc then                        'current character is uppercase
               mid$(clin, ipos) = char(ichr + 32)  'lowercase current character
            end if
         end if
      end if
   next
   if (iupper > 0) and (ilower = 0) and inym then  'line should NOT be re-cased
      print #2, csav                           'write unmodified line to output
      if not ilog then                        'this is the first log file entry
         ilog = not 0                         'set the log file written flag ON
         print #3, "Lines NOT re-cased"
         print #3, "------------------"
         print #3, ""
      end if
      print #3, csav                         'write unmodified line to log file
   else                                    'OK to write modified line to output
      print #2, clin                   'write modified line to destination file
   end if
wend

close                                 'close all files in case not closed above
shell "brow " + cdst                   'view the modified (output) file version
if ilog then                              'line(s) were written to the log file
   shell "brow " + clog                    'view the non-recased lines log file
end if
system                                      'return control to operating system
