'/* PROC.BAS Process a DOS command against a file listing */
'/*          By: Dale Thorn                               */
'/*          Rev. 11.02.2003                              */

'$include: 'basdef.h'
'$include: 'basio.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'

declare function ifn.getname(cfsp, cfnm)
declare function ifn.pnam(cnam)
declare function ifn.scrl(cdat, icnt, ibeg, ilen, irow, icol, isiz, iclr)
declare function io.kbuf(inop)
declare function io.kget(inop)

'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'scrnparm.bas'
'$include: 'string.bas'

ccmd = ucase$(rtrim$(command$))            'get the DOS command-line parameters
if ccmd = "" then                              'a command line was not supplied
   i = ifn.msgs("Usage:  PROC  inputfile  [destspec]  [/~dup]", _
                iofs, irow, icol, 0, 1) 'display usage message [above] and exit
end if

if right$(ccmd, 5) = "/~DUP" then        'dest.filename same as source filename
   ccmd = rtrim$(left$(ccmd, len(ccmd) - 5))   'remove switch from command line
   idupnam = not 0                  'set flag to add filename to dest.parameter
else                                  'destination filenames were NOT specified
   idupnam = 0                           'do NOT add filename to dest.parameter
end if
cmnd = ccmd                'save command line after possible removal of '/~DUP'

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") then
   i = ifn.msgs("Invalid inputfile name", iofs, irow, icol, 1, 1)'error message
end if                       'display invalid-filename message [above] and exit

if iprm >= 0 then                         'additional parameter(s) were entered
   ipos1 = instr(cmnd, " ")                  'position of ' ' in command params
   ipos2 = instr(cmnd, "/")                  'position of '/' in command params
   if ipos1 = 0 or ipos1 > ipos2 and ipos2 > 0 then'possible '/' posn.in params
      ipos1 = ipos2                         'set parse position to '/' position
   end if
   if ipos1 = 0 then                        'neither '/' or ' ' found in params
      ipos1 = len(cmnd) + 1                'set parse position to end of params
   end if
   cmnd = ltrim$(mid$(cmnd, ipos1))    'extract the original command parameters
else                                  'additional parameter(s) were NOT entered
   cmnd = ""                            'set original parameters string to NULL
end if

i = ifn.open(1, cfil, "b", llof)           'open the source file in binary mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)      'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", iofs, irow, icol, 1, 1)     'beep and exit
end if
close 1                                             'close the source file list

open cfil for input as 1                           'reopen the source file list
line input #1, clin                                'get the DOS process command
ilen = 0                                         'initialize the segment length
while not eof(1)                                  'process names in source file
   line input #1, clin                              'get the next filename line
   i = ifn.getname(clin, cfnm)                      'get filename from filespec
   if ilen < len(cfnm) then                         'current max. length < line
      ilen = len(cfnm)                              'set max.length=line length
   end if
wend
close 1                                             'close the source file list

open cfil for input as 1                           'reopen the source file list
line input #1, clin                                'get the DOS process command
ccmd = ucase$(ltrim$(rtrim$(clin)))               'trim the DOS process command
if ccmd = "" or instr(ccmd, " ") or instr(ccmd, ".") then
   i = ifn.msgs("Invalid DOS process command in " + cfil, _    'invalid command
   iofs, irow, icol, 1, 1)              'display error message [above] and exit
end if

iclr = 112                               'set DOS color to black fg on white bg
lmem = fre("") - 5000                    'get the maximum available free memory
if lmem > 32640 then                     'free memory exceeds max.buffer length
   lmem = 32640                             'set buffer length to maximum value
end if
cbuf = space$(lmem)                          'create buffer for inputfile names
icnt = 0                                       'initialize the filename counter
do while not eof(1)                           'process all names in source file
   line input #1, clin                          'read the next process filename
   i = ifn.getname(clin, cfnm)                  'get DOS filename from filespec
   if cfnm <> "" then                            'valid (non-blank) name found!
      ipos = icnt * ilen + 1                     'next write-to posn. in buffer
      if ipos + ilen > lmem then                'buffer full - abort processing
         i = ifn.msgs("Too many entries: limit=32640 chars", iofs, irow, icol, 1, 1)
      end if                            'display error message [above] and exit
      i = ifn.pnam(cfnm)                     'set upper/lower case for filespec
      mid$(cbuf, ipos) = cfnm                   'put process filename to buffer
      icnt = icnt + 1                           'increment the filename counter
   end if
loop
close 1                                             'close the source file list

if instr("BROW|BR25|EDIT|LIST|LXPIC|Q3|VIEW", ccmd) then'process block list box
   if ccmd = "BROW" then                              'browse utility specified
      if iprm >= 0 then                                'search text was entered
         cmnd = "/~T" + cmnd + "/~T"      'add BROW parameters to original text
      end if
   end if
   cmsg = "Use arrow keys to choose a file; Enter to select; Esc to exit"
   ibeg = 1                                'set beginning data position in cbuf
   do                                     'process all names in filename buffer
      if ccmd = "LXPIC" then                         'picture browser specified
         screen 12                                    'set graphic display mode
      end if
      shell ccmd + " " + mid$(cbuf, ibeg, ilen) + " " + cmnd   'execute command
      if ccmd = "LXPIC" then                         'picture browser specified
         shell "mode co80,25"                          'reset text display mode
      else                                           'pic browser NOT specified
         cls                                                  'clear the screen
      end if
      locate 2, iofs, 1                                      'locate the cursor
      print cmsg;                                'display continue/exit message
      locate irow, icol, 0                                    'hide' the cursor
      if ifn.scrl(cbuf, icnt, ibeg, ilen, 4, iofs, 21, iclr) = KEY.ESC then
         exit do                           'user hit ESC; terminate the program
      end if
   loop
else                       'process block for non-Browse commands and utilities
   if ccmd = "MOVE" then                 'user specified the DOS "move" command
      cnam = rtrim$(left$(cbuf, ilen))    'get the first filename from the list
      cnam = mid$(cnam, istr.rcfn(len(cnam), cnam, "\") + 1)   'remove the path
      ifl1 = freefile                      'get the first available file handle
      i = ifn.open(ifl1, cmnd + "\" + cnam, "b", llof)   'open destination file
      if llof < 0 then                          'user input a wildcard filespec
         i = ifn.msgs("Invalid filename in list", iofs, irow, icol, 1, 1) 'exit
      elseif llof > 0 then                          'dest. file already exists!
         i = ifn.msgs("File(s) already exist in dest. directory", _
                      iofs, irow, icol, 1, 1)      'display error msg. and exit
      else                                        'file is nonexistent or empty
         ifl2 = freefile                        'get next available file handle
         if ifl2 = ifl1 then                  'the destination file is NOT open
            i = ifn.msgs("Invalid dest. directory", iofs, irow, icol, 1, 1)
         end if                         'display error message [above] and exit
      end if
      close ifl1                               'close the test destination file
   end if
   for ifil = 0 to icnt - 1               'process all names in filename buffer
      cnam = rtrim$(mid$(cbuf, ifil * ilen + 1, ilen)) 'name in current segment
      if idupnam then                     'OK to add filename to dest.parameter
         cdst = "\" + cnam               'set filename to add to dest.parameter
      else                               'do NOT add filename to dest.parameter
         cdst = ""                          'clear filename from dest.parameter
      end if
      shell ccmd + " " + cnam + " " + cmnd + cdst 'DOS shell to execute command
   next
end if

if instr("BROW|BR25|EDIT|LIST|LXPIC|Q3|VIEW", ccmd) then 'special exit list box
   i = ifn.msgs("", iofs, irow, icol, 0, 1)   'clear screen & terminate program
end if

close                         'close all files in case not closed in exit above
system                                   'exit program in case not exited above

function ifn.getname(cfsp, cfnm)                 'get path & name from filespec
   cfnm = ltrim$(rtrim$(cfsp))                  'right/left-trim & the filename
   if cfnm <> "" then                            'valid (non-blank) name found!
      if instr(cfnm, "\") = 0 then               'path NOT included in filespec
         ilen1 = len(cfnm)                       'total trimmed filename length
         ilen2 = len(rtrim$(left$(cfnm, 9)))     'length of name-less-extension
         ilen3 = len(rtrim$(left$(cfnm, 10)))    'length w/1 char. of extension
         if instr(cfnm, ":") or instr(cfnm, "<dir>") then'probable DOS filespec
            cfnm = rtrim$(left$(cfnm, 12))       'trim off data beyond filename
            ilen1 = len(cfnm)                    'total trimmed filename length
         end if
         if ilen1 <= 12 and ilen2 <= 8 and instr(cfnm, ".") = 0 then  'DOS name
            if ilen3 = 10 then                       'filename has an extension
               cfnm = left$(cfnm, ilen2) + "." + mid$(cfnm, 10, 3)  'parse name
            else                                     'filename has NO extension
               cfnm = left$(cfnm, ilen2)              'filename <= 8 characters
            end if
         end if
      end if
   end if
end function

function ifn.pnam(cnam)                      'set upper/lower case for filespec
   ilen = len(rtrim$(cnam))                     'get length of the current line
   ispc = not 0                                 'set TRUE to uppercase 1st char.
   for ipos = 1 to ilen                          'process the selected filespec
      if ipos > ilen then                       'current position > line length
         exit for                           'current position > end - exit loop
      end if
      iupc = 0                                   'initialize uppercase is false
      ilwc = 0                                   'initialize lowercase is false
      ichr = midchar(cnam, ipos)                 'character at current position
      if ichr >= 65 and ichr <= 90 then         'current character is uppercase
         iupc = not 0                           'set uppercase char.flag = true
      elseif ichr >= 97 and ichr <= 122 then    'current character is lowercase
         ilwc = not 0                           'set lowercase char.flag = true
      end if
      if ichr = 32 or ichr = 92 then              'current character is a space
         ispc = not 0                          'set TRUE to uppercase next char.
      else                                    'current character is NOT a space
         if ispc then                           'previous character WAS a space
            ispc = 0                           'set FALSE to NOT uprc.next char.
            if ilwc then                        'current character is lowercase
               mid$(cnam, ipos) = char(ichr - 32)  'uppercase current character
            end if
         else                                   'previous character NOT a space
            if iupc then                        'current character is uppercase
               mid$(cnam, ipos) = char(ichr + 32)  'lowercase current character
            end if
         end if
      end if
   next
end function

function ifn.scrl(cdat, icnt, ibeg, ilen, irow, icol, isiz, iclr)
   cbuf = space$(ilen + 2)                  'single data segment display buffer
   iend = (icnt - 1) * ilen + 1                  'set end data position in cdat
   do                                       'loop until Enter or Escape pressed
      ipos1 = ibeg                             'beginning data position in cdat
      for iptr = irow to irow + isiz - 1            'loop thru the display rows
         if iptr = irow then                  'current display row is first row
            iclx = 15                             'set display color to inverse
         else                               'current display row is > first row
            iclx = iclr                            'set display color to normal
         end if
         lset cbuf = " " + mid$(cdat, ipos1, ilen)  'put data segment to buffer
         call pdqprint(cbuf, iptr, icol, iclx)'display the current data segment
         ipos1 = ipos1 + ilen          'increment the offset adjustment in cdat
      next
      ikey = io.kget(0)                               'get the user-entered key
      select case ikey                                 'select user-entered key
         case KEY.CSRDN                                'case is cursor-down key
            if ibeg < iend then                       'buffer position is < end
               ibeg = ibeg + ilen                'increment the buffer position
            end if
         case KEY.CSRUP                                  'case is cursor-up key
            if ibeg > 1 then                    'buffer position is > beginning
               ibeg = ibeg - ilen                'decrement the buffer position
            end if
         case KEY.END                                          'case is End key
            ibeg = iend                             'set buffer position to end
         case KEY.ENTER, _                                   'case is Enter key
              KEY.ESC                                       'case is Escape key
            exit do                  'exit processing and terminate the program
         case KEY.HOME                                        'case is Home key
            ibeg = 1                               'set buffer position to home
         case KEY.PGDN                                   'case is Page-down key
            if ibeg < iend - isiz * ilen then  'buffer pos. is < end - pagesize
               ibeg = ibeg + isiz * ilen     'increment buffer pos. by pagesize
            else                           'buffer position is > end - pagesize
               ibeg = iend                          'set buffer position to end
            end if
         case KEY.PGUP                                     'case is Page-up key
            if ibeg > isiz * ilen then           'buffer position is > pagesize
               ibeg = ibeg - isiz * ilen     'decrement buffer pos. by pagesize
            else                                 'buffer position is < pagesize
               ibeg = 1                            'set buffer position to home
            end if
         case else                                    'case is (possibly) alpha
            if ikey >= 97 and ikey <= 122 then          'user key is 'a' to 'z'
               ikey = ikey - 32                     'set user key to 'A' to 'Z'
            end if
            if ikey >= 33 and ikey <= 122 then          'user key is 'a' to 'z'
               ipos1 = ibeg                    'beginning data position in cdat
               do                             'loop to find next filename match
                  ipos1 = ipos1 + ilen        'increment to next match-position
                  if ipos1 > iend then       'current position past end of list
                     ipos1 = 1       'set current position to beginning of list
                  end if        'get position of 1st filename character [below]
                  ipos2 = istr.rcfn(ipos1 + ilen - 1, cdat, "\") + 1
                  if midchar(cdat, ipos2) = ikey or ipos1 = ibeg then   'match!
                     ibeg = ipos1        'set buffer position to filename match
                     exit do                           'match found - exit loop
                  end if
               loop
            end if
      end select                                    'end of user key selections
   loop                                'loop until user presses Enter or Escape
   ifn.scrl = ikey                  'return user-pressed key to calling program
end function

function io.kbuf(inop)            '/* get key value (don't strip key buffer) */
   do                                                         '/* begin loop */
      key$ = inkey$                              '/* get key from key buffer */
   loop while len(key$) = 0                      '/* loop until a key is hit */
   if asc(key$) then                             '/* key value in first byte */
      io.kbuf = asc(key$)            '/* return key value to calling program */
   else                                      '/* zero value ("extended" key) */
      io.kbuf = asc(mid$(key$, 2)) + 128      '/* add 128 to 2nd byte of key */
   end if
end function                                   '/* return to calling program */

function io.kget(inop)                 '/* strip key buffer and wait for key */
   do                                     '/* begin loop to strip key buffer */
   loop while len(inkey$)           '/* loop while key buffer contains a key */
   io.kget = io.kbuf(0)              '/* return key value to calling program */
end function                                   '/* return to calling program */
