'/* PSET.BAS Send text with control codes to LaserJet */
'/*          By: Dale Thorn                           */
'/*          Rev. 03.04.2003                          */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'string.h'
'$include: 'tfind.h'

declare function ifn.chrx(chr1, chr2, dchr)
declare function ifn.pgsz(ccpi(), clpi(), ipsz(), ltot, ilen, ilgl)

'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'string.bas'
'$include: 'tfind.bas'

dim ccpi(2)                                      'allocate chars-per-inch array
dim clpi(1)                                      'allocate lines-per-inch array
dim ipsz(1)                                       'allocate the page-size array

ccmd = ucase$(rtrim$(command$))         'get the user's command-line parameters
if ccmd = "" then                    'command-line parameters were NOT supplied
   cls                                                        'clear the screen
   print "    Usage:  PSET  filename  [Cn Fn Ln On Pn Bn Mn D]  [/L]  [/P]"
   print                                           'blank line between messages
   print "            C=Character Size (n=12, n=15.5, etc.; default=12 [portrait]"
   print "                                          maximum default=25 [landscape])"
   print                                           'blank line between messages
   print "            F=Font Size (n=1 = 1 inch, etc.; default reverts to 'C' above"
   print                                           'blank line between messages
   print "            L=Lines Per Inch (n=6, n=8.5, etc.; minimum default=5.6"
   print "                                                maximum default=10.0)"
   print                                           'blank line between messages
   print "            O=Orientation (n=1 for landscape; default=portrait)"
   print                                           'blank line between messages
   print "            P=Page Feed (n=1 for manual feed; default=tray feed)"
   print                                           'blank line between messages
   print "            B=Bold Printing (n=3 for maximum bold; default=bold OFF)"
   print                                           'blank line between messages
   print "            M=Margin at Left (n=3, n=10, etc.; default=0 [no margin])"
   print                                           'blank line between messages
   print "            D=Disk File Settings (codes are contained in '\pset.dat')"
   print                                           'blank line between messages
   print "    If 'F' (font size) specified, 'L' specification is ignored"
   print "    If '/L' specified, use legal paper (14 inch) output format"
   print "    If '/P' specified, print filename/date/time header on page"
   close                                       'close all (possibly) open files
   system                                   'return control to operating system
end if

ipos = instr(ccmd, "/L")    'user selected to use legal paper (14 inch) format?
if ipos then                'user selected to use legal paper (14 inch) format!
   ccmd = rtrim$(left$(ccmd, ipos - 1)) + ltrim$(mid$(ccmd, ipos + 2))'rem.'/L'
   ilgl = not 0                                 'set legal paper format flag ON
else                                   'user said to NOT use legal paper format
   ilgl = 0                                    'set legal paper format flag OFF
end if

ipos = instr(ccmd, "/P")   'user selected to show filename/date/time on output?
if ipos then               'user selected to show filename/date/time on output!
   ccmd = rtrim$(left$(ccmd, ipos - 1)) + ltrim$(mid$(ccmd, ipos + 2))'rem.'/P'
   isho = not 0                                 'set filename/date/time flag ON
else                        'user said to NOT show filename/date/time on output
   isho = 0                                    'set filename/date/time flag OFF
end if

ipos = instr(ccmd, " ")              'separator between filename and parameters
if ipos = 0 then                    'parameters were NOT entered after filename
   ipos = len(ccmd) + 1              'set separator position to end of filename
end if
cfil = rtrim$(left$(ccmd, ipos - 1))              'get the source text filename
cnam = mid$(cfil, istr.rcfn(len(cfil), cfil, "\") + 1)  'get filename less path
cprm = ltrim$(mid$(ccmd, ipos + 1))            'get the command-line parameters
ceof = char(26)                               'initialize the DOS EOF character
cesc = char(27)                               'initialize the DOS ESC character

ipos = instr(cprm, "P")                         'manual page feed specification
if ipos or ilgl then                           'manual page feed or legal paper
   if ipos then                                'user specified manual page feed
      imfd = val(mid$(cprm, ipos + 1))         'manual paper size specification
   else                                       'user said use legal paper format
      imfd = 1                                'set specifier to 8.5 x 14" paper
   end if
   if imfd = 1 then                             'user specified 8.5 x 14" paper
      cmfd = cesc + "&l84p2H"                 'initialize manual page feed spec
   else                                         'user specified 8.5 x 11" paper
      cmfd = cesc + "&l66p2H"                 'initialize manual page feed spec
   end if
else                                     'user did NOT specify manual page feed
   imfd = 0                              'clear manual paper size specification
   cmfd = ""                             'clear manual paper size specification
end if

ipos = instr(cprm, "D")                        'get the code file specification
if ipos then                               'user said to use codes in code file
   ifil = not 0                                   'set the code file flag to ON
else                                'user did NOT say to use codes in code file
   ifil = 0                                      'set the code file flag to OFF

   tf.fnum = freefile            'file channel/unit number for binary-mode file
   i = ifn.open(tf.fnum, cfil, "b", tf.llof)   'open source file in binary mode
   if tf.llof < 0 then                          'user input a wildcard filespec
      i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)          'beep and exit
   elseif tf.llof = 0 then                    'source file nonexistent or empty
      i = ifn.kill(tf.fnum, cfil)                    'kill the zero-length file
      i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)         'beep and exit
   end if
   if tf.llof > 5000 then                            'file size is > 5000 bytes
      ilen = 5000                                 'set buffer size = 5000 bytes
   else                                             'file size is <= 5000 bytes
      ilen = tf.llof                               'set buffer size = file size
   end if
   cbuf = space$(ilen)                                'allocate the test buffer
   get tf.fnum, tf.llof - ilen + 1, cbuf            'load test buffer from file
   ipos = 0                                 'initialize the text char. position
   for i = ilen to 1 step -1                'loop to find text byte or char(13)
      ichr = midchar(cbuf, i)              'extract the current character value
      if ichr = 13 then                      'current char.is a carriage return
         if i < ilen then                   'line-count pointer < end of buffer
            if midchar(cbuf, i + 1) = 10 then'c/r-l/f pair found this position!
               i = i + 1                       'advance pointer to l/f position
            end if
         end if
         exit for                             'carriage return found; exit loop
      elseif ichr > 32 and ipos = 0 then     'current char. is a text character
         ipos = i                           'text character found; set position
      end if
   next
   cbuf = ""                              'deallocate the temporary/test buffer
   if ipos then                         'text byte found AFTER last c/r in file
      tf.llen = ipos - i                 'set maximum line length to line found
      iadd = 1                        'add one (1) to total of file's linecount
   else                             'text byte NOT found after last c/r in file
      iadd = 0                       'add zero (0) to total of file's linecount
   end if
   tf.bbeg = 1                        'initialize begin search position in cbuf
   tf.fbeg = 1                        'initialize begin search position in file
   tf.ltot = iadd                     'initialize total no.of lines in the file
   tf.csen = not 0                            'set the case-sensitivity flag ON
   tf.lcnt = not 0                        'set the flag to count the text lines
   tf.load = not 0                   'OK to load initial buffer inside function
   cbuf = space$((fre("") - 4096) \ 2)           'allocate the main file buffer
   if ifn.tfnd(tf, cbuf, "qqz" + "qq" + "zqq") = 27 then      'User pressed ESC
      i = ifn.msgs("Esc pressed - Program aborted", 5, 24, 79, 0, 1)
   end if                  'ESC pressed; display abort message [above] and exit
   if isho then             'user selected to show filename/date/time on output
      tf.ltot = tf.ltot + 2              'increment the text lines count by two
   end if
   close tf.fnum            'close the text file we opened to count lines above

   ipos = instr(cprm, "B")                            'bold print specification
   if ipos then                                   'user specified bold printing
      ibld = val(mid$(cprm, ipos + 1))       'get bold spec. [0=normal; 1=bold]
   else                                     'user did NOT specify bold printing
      ibld = 0                             'default bold spec. to zero [normal]
   end if
   cbld = ltrim$(str$(ibld))           'string form of bold print specification

   ipos = instr(cprm, "M")                           'left margin specification
   if ipos then                                   'user specified a left margin
      dmrg = val(mid$(cprm, ipos + 1))            'get user's left margin value
   else                                     'user did NOT specify a left margin
      dmrg = 0                                 'default the left margin to zero
   end if
   cmrg = ltrim$(rtrim$(str$(dmrg)))      'string form of left margin specifier

   ipos = instr(cprm, "O")                     'print orientation specification
   if ipos then                             'user specified a print orientation
      ilds = val(mid$(cprm, ipos + 1))    'get the orientation [0=Port; 1=Land]
   else                               'user did NOT specify a print orientation
      ilds = 0                       'default the print orientation to portrait
   end if

   ipos1 = instr(cprm, "C")                  'character pitch/HMI specification
   ipos2 = instr(cprm, "F")                  'character Font size specification
   dlin = 0                                'initialize lines per inch/VMI value
   if ipos1 then                          'user specified a character pitch/HMI
      dchr = val(mid$(cprm, ipos1 + 1))   'get user's character pitch/HMI value
      ichrset = not 0                      'set flag to indicate dchr specified
   elseif ipos2 then                        'user specified a font size instead
      dchr = 1# / val(mid$(cprm, ipos2 + 1))    'get the user's font size value
      ichrset = not 0                      'set flag to indicate dchr specified
      ipos1 = instr(cprm, "L")                'lines per inch/VMI specification
      if ipos1 then                        'user specified a lines per inch/VMI
         dlin = 1# / val(mid$(cprm, ipos1 + 1))  'get user's lines per inch/VMI
      else                              'user didn't specify lines per inch/VMI
         dlin = dchr * .67#             'default the LPI spec from the CPI spec
      end if
   else                               'user did NOT specify char. pitch or font
      dchr = 0                     'default character pitch to zero (see below)
      ichrset = 0                      'set flag to indicate dchr NOT specified
   end if
   if dchr = 0 then            'user did NOT input chars-per-inch specification
      if tf.llen > 104 then    'max.length text line won't fit in portrait mode
         ilds = 1                         'set landscape print orientation mode
         if tf.llen <= 127 or tf.llen <= 163 and ilgl then    'text OK @ 12 cpi
            dchr = 12               'set the chars-per-inch specification to 12
         elseif tf.llen <= 138 or tf.llen <= 177 and ilgl then'text OK @ 13 cpi
            dchr = 13               'set the chars-per-inch specification to 13
         else                       'max.length text line will NOT fit @ 13 cpi
            if ilgl then                   'user said to use legal paper format
               dchr = cdbl(tf.llen) / 13.6#   'get chars-per-inch specification
            else                       'user said to NOT use legal paper format
               dchr = cdbl(tf.llen) / 10.6#   'get chars-per-inch specification
            end if
            if dchr > 25 then       'text @ cpi specification won't be readable
               dchr = 25           'set the highest cpi spec for readable print
            end if
         end if
      elseif tf.llen > 96 and ilds = 0 then'max.length line won't fit at 12 cpi
         dchr = 13                  'set the chars-per-inch specification to 13
      else                        'max.length text line will fit in either mode
         dchr = 12                  'set the chars-per-inch specification to 12
      end if
   end if

   clds = ltrim$(str$(ilds))        'string form of print orientation specifier

   if dlin = 0 then                       'user did NOT specify font size above
      ipos = instr(cprm, "L")                 'lines per inch/VMI specification
      if ipos then                         'user specified a lines per inch/VMI
         dlin = val(mid$(cprm, ipos + 1))  'get user's lines per inch/VMI value
      end if
   end if
   if dlin = 0 then                   'user did NOT input a lines-per-inch spec
      i = ifn.pgsz(ccpi(), clpi(), ipsz(), tf.ltot, tf.llen, ilgl)'get CPI, LPI
      if ilds then                        'user specified landscape orientation
         dlin = val(clpi(1))              'set lines-per-inch to landscape spec.
         if not ichrset then              'character size NOT specified by user
            if ilgl then                   'user said to use legal paper format
               dchr = val(ccpi(2))        'set chars-per-inch to landscape 8x14
            else                            'user said to use 8x11 paper format
               dchr = val(ccpi(1))        'set chars-per-inch to landscape 8x11
            end if
         end if
      else                                 'user specified portrait orientation
         dlin = val(clpi(0))               'set lines-per-inch to portrait spec.
         if not ichrset then              'character size NOT specified by user
            dchr = val(ccpi(0))            'set chars-per-inch to portrait spec.
         end if
      end if
   end if
   i = ifn.chrx(chr1, chr2, dchr)          'create CPI spec.1 & 2 print strings
   clin = ltrim$(rtrim$(str$(48 / dlin)))   'initialize the lines per inch spec
   ipos = instr(clin, ".")               'position of decimal point in VMI spec
   if ipos then                            'decimal point was found in VMI spec
      if len(clin) - ipos > 2 then        'more than 2 decimal places specified
         clin = left$(clin, ipos + 2)           'truncate excess decimal places
      end if
   end if
end if

open "pset.001" for output as 1           'open the setup codes file for output
print #1, cesc; "E";                     'print the LaserJet printer-reset code
if ifil then                          'user specified to use codes in code file
   open "\pset.dat" for input as 2    'open the code file for input [read only]
   do while not eof(2)                'loop until all lines read from code file
      line input #2, cstr1                      'read a line from the code file
      cstr1 = ltrim$(rtrim$(cstr1))           'trim the line from the code file
      if cstr1 <> "" then                         'line from code file is valid
         print #1, cstr1;                    'print the line from the code file
      end if
   loop
else                                  'user specified to use command-line codes
   print #1, cmfd;                             'print the manual page feed spec
   print #1, cesc; "&l"; clds; "o"; clin; "C";   'print orientation and LPI/VMI
   print #1, cesc; "(s"; cbld; "B"; cesc; chr1; chr2; "H";  'print CPI/HMI/bold
   print #1, cesc; "&a"; cmrg; "l399M";                'print specified margins
end if                                                 'close all files [below]
if isho then                'user selected to show filename/date/time on output
   print #1, "PRINTED:  "; cnam; "  "; date$; "  "; time$'print filename/dt/time
   print #1, string$(len(cnam) + 32, "-")   'print separator line under dt/time
end if
close                   'copy setup codes plus text to print-image file [below]
shell "copy /A pset.001+" + cfil + " pset.002"

open "pset.002" for binary as 1           'open print-image file in binary mode
cbuf = space$(1)                         'create buffer for printer-reset codes
llof = lof(1)                           'get the length of the print-image file
get 1, llof, cbuf                    'get the last byte in the print-image file
if cbuf = ceof then                  'last byte in print-image file is EOF byte
   llof = llof - 1                  'move to length of print-image file minus 1
end if
lset cbuf = cesc                      'set the code buffer to the ESC character
put 1, llof + 1, cbuf                'write code buffer to the print-image file
lset cbuf = "E"                       'set the code buffer to the 'E' character
put 1, llof + 2, cbuf                'write code buffer to the print-image file
close                                                          'close all files
shell "copy /B pset.002 lpt1"  'copy print-image file to printer in binary mode

kill "pset.002"                                     'erase the print-image file
kill "pset.001"                                     'erase the setup codes file
close                                 'close all files in case not closed above
system                                  'return control to the operating system

function ifn.chrx(chr1, chr2, dchr)             'create CPI spec. print strings
   chr1 = "(s" + ltrim$(rtrim$(str$(dchr)))       'set the character/font pitch
   ipos = instr(chr1, ".")               'position of decimal point in CPI spec
   if ipos then                            'decimal point was found in CPI spec
      if len(chr1) - ipos > 2 then        'more than 2 decimal places specified
         chr1 = left$(chr1, ipos + 2)           'truncate excess decimal places
      end if
   end if
   chr2 = "H" + char(27) + "&k" + ltrim$(rtrim$(str$(120 / dchr)))'set HMI spec
   ipos = instr(chr2, ".")               'position of decimal point in HMI spec
   if ipos then                            'decimal point was found in HMI spec
      if len(chr2) - ipos > 2 then        'more than 2 decimal places specified
         chr2 = left$(chr2, ipos + 2)           'truncate excess decimal places
      end if
   end if
end function

function ifn.pgsz(ccpi(), clpi(), ipsz(), ltot, ilen, ilgl)'get CPI/LPI/pagesize
   dim ilin(1, 2)                                'allocate lines-per-page array
   dim ipgs(1, 2)                                'allocate total no.pages array
   dim isiz(1, 2)                                'allocate the page sizes array
   if ilgl then                               'user said use legal paper format
      isiz(0, 0) = 73                         'set minimum page size (portrait)
      isiz(0, 1) = 104                       'set standard page size (portrait)
      isiz(0, 2) = 130                        'set maximum page size (portrait)
   else                                        'user said use 8x11 paper format
      isiz(0, 0) = 56                         'set minimum page size (portrait)
      isiz(0, 1) = 80                        'set standard page size (portrait)
      isiz(0, 2) = 100                        'set maximum page size (portrait)
   end if
   isiz(1, 0) = 42                           'set minimum page size (landscape)
   isiz(1, 1) = 60                          'set standard page size (landscape)
   isiz(1, 2) = 75                           'set maximum page size (landscape)
   for i0 = 0 to 1                       'loop thru portrait/landscape settings
      for i1 = 0 to 2                 'loop thru minimum/standard/maximum sizes
         ipgs(i0, i1) = ltot \ isiz(i0, i1)'init.total pages to #lines/currsize
         if ltot mod isiz(i0, i1) then     'no.of lines/currsize has a leftover
            ipgs(i0, i1) = ipgs(i0, i1) + 1   'increment the total no. of pages
         end if
         ilin(i0, i1) = ltot \ ipgs(i0, i1)    'set pagesize to #lines/currsize
         if ltot mod ipgs(i0, i1) then        'no.lines/currsize has a leftover
            ilin(i0, i1) = ilin(i0, i1) + 1  'increment new calculated pagesize
         end if
      next
      for i1 = 0 to 1                      'outer loop to bubble sort pagesizes
         for i2 = 1 to 2                   'inner loop to bubble sort pagesizes
            if ilin(i0, i1) > ilin(i0, i2) then  'lower-rank size > higher rank
               swap ilin(i0, i1), ilin(i0, i2)    'swap lower-rank, higher rank
            end if
         next
      next
      if ilin(i0, 1) < isiz(i0, 0) then      'middle size is < minimum pagesize
         ilin(i0, 1) = ilin(i0, 2)            'set pagesize to highest pagesize
      end if
      if ilin(i0, 1) < isiz(i0, 0) then      'pagesize still < minimum pagesize
         ilin(i0, 1) = isiz(i0, 0)            'set pagesize to minimum pagesize
      end if
      ipsz(i0) = ilin(i0, 1)            'set pagesize for portrait or landscape
   next
   if ilgl then                            'user said to use legal paper format
      clpi(0) = ltrim$(str$(cint(7.7# * ipsz(0))))  'LPI * 7.7 (portrait/legal)
   else                                'user said to NOT use legal paper format
      clpi(0) = ltrim$(str$(cint(10# * ipsz(0))))   'LPI * 10 (portrait/letter)
   end if
   clpi(0) = left$(clpi(0), len(clpi(0)) - 2) + "." + right$(clpi(0), 2)
   isizmod = ipsz(1) mod 3                 'lines-per-inch leftover (landscape)
   isizint = ((ipsz(1) \ 3) * 4 + isizmod) * 10'lines-per-inch * 10 (landscape)
   if isizmod = 1 then                          'leftover lines = 1 (landscape)
      clpi(1) = ltrim$(str$(isizint + 3))      'lines-per-inch * 10 (landscape)
   elseif isizmod = 2 then                      'leftover lines = 2 (landscape)
      clpi(1) = ltrim$(str$(isizint + 7))      'lines-per-inch * 10 (landscape)
   else                                         'leftover lines = 0 (landscape)
      clpi(1) = ltrim$(str$(isizint))          'lines-per-inch * 10 (landscape)
   end if                             'format lines-per-inch (landscape, below)
   clpi(1) = left$(clpi(1), len(clpi(1)) - 2) + "." + right$(clpi(1), 2)
   for i = 0 to 2           'loop thru the calculated characters-per-inch array
      if i = 0 then            'calculation=chars-per-inch portrait orientation
         dcpi = ilen / .8#       'calculate chars-per-inch portrait orientation
      elseif i = 1 then       'calculation=chars-per-inch landscape page=8.5x11
         dcpi = ilen / 1.06#    'calculate chars-per-inch landscape page=8.5x11
      else                    'calculation=chars-per-inch landscape page=8.5x14
         dcpi = ilen / 1.36#    'calculate chars-per-inch landscape page=8.5x14
      end if
      if dcpi < 120 then        'calculated characters-per-inch is less than 12
         dcpi = 120             'set calculated characters-per-inch equal to 12
      elseif dcpi > 299 then   'calculated characters-per-inch is greater> 29.9
         dcpi = 299           'set calculated characters-per-inch equal to 29.9
      end if
      if i = 2 then                                    'landscape page = 8.5x14
         indx = 1                                    'set index for clpi() test
      else                                          'landscape 8x11 or portrait
         indx = i                                    'set index for clpi() test
      end if
      if dcpi >= 130 or val(clpi(indx)) <= 8 then   'CPI not problem w/LPI spec
         ccpi(i) = ltrim$(str$(cint(dcpi)))'calc'd chars-per-inch (string form)
         ccpi(i) = left$(ccpi(i), 2) + "." + right$(ccpi(i), 1)
      else                                   'LPI spec too cramped for CPI spec
         ccpi(i) = "13.0"     'reset font to be more readable with line spacing
      end if
   next              'format characters-per-inch portrait and landscape [above]
end function
