'/* REPL.BAS Search and replace text strings in text file */
'/*          By: Dale Thorn                               */
'/*          Rev. 10.04.2000                              */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'

cls                                                       'clear the DOS screen
ccmd = rtrim$(command$)                         'right-trim user's command line
if ccmd = "" then                            'user did NOT enter a command line
   cmsg = "Usage:  REPL  filename  searchtext  replacetext"   'set message text
   ctmp = space$(4)                                     'set left margin spaces
   locate 5, 1, 1                                   'locate cursor for messages
   print ctmp; cmsg                                 'display first user message
   print                                           'blank line between messages
   print ctmp; "If 'searchtext' or 'replacetext' contains one or"  '2nd message
   print ctmp; "more blank spaces, place quotes around the text."  '2nd message
   print                                           'blank line between messages
   print ctmp; "If '/C' specified, use case sensitive search."   'third message
   print ctmp; "If '/Q' specified, remove quotes around text."  'fourth message
   close                                                  'close all open files
   system                                           'return to operating system
end if

icas = 0                                      'initialize case-sensitivity flag
iqot = 0                                     'initialize the remove-quotes flag
do                                 'begin loop to process command-line switches
   select case ucase$(right$(ccmd, 2))        'select on a possible User switch
      case "/C"                                'case-sensitive switch specified
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/C' parameter
         icas = not 0                           'set the case-sensitive flag ON
      case "/Q"                                 'remove-quotes switch specified
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/Q' parameter
         iqot = not 0                            'set the remove-quotes flag ON
      case else                              'no (more) User switches specified
         exit do                            'no (more) User switches; exit loop
   end select
loop

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())      'parse the user parameters
if iprm <> 1 then                                  'user input wrong parameters
   i = ifn.msgs("Invalid number of parameters", 5, 24, 79, 1, 1)
end if                              'display the error message [above] and exit
if cext = "out" then                           'source file extension is '.OUT'
   cdst = cnam + ".tmp"                      'set temp-file extension to '.TMP'
else                                       'source file extension is NOT '.OUT'
   cdst = cnam + ".out"                      'set temp-file extension to '.OUT'
end if
if not icas then                                'the case-sensitive flag is OFF
   lset cprm(0) = ucase$(cprm(0))                    'uppercase the search text
end if

if iqot then                                      'the remove-quotes flag is ON
   for i = 0 to iprm                               'loop thru user's parameters
      ilen = len(cprm(i))                          'length of current parameter
      if  midchar(cprm(i), 1) = 34 _               'leftmost character is quote
      and midchar(cprm(i), ilen) = 34 then        'rightmost character is quote
         if i = 0 and ilen = 2 then              'error: no search text entered
            i = ifn.msgs("No search string specified", 5, 24, 79, 1, 1)
         end if                     'display the error message [above] and exit
         cprm(i) = mid$(cprm(i), 2, ilen - 2)     'remove quotes from parameter
      end if
   next
end if

i = ifn.open(1, cfil, "B", llof)           'open the source file in binary mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)            'beep and exit
end if
close 1                                             'close the open source file

i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)        'hide cursor and proceed

open cfil for input as 1                    'open the source file in input mode
open cdst for output as 2                   'open the dest. file in output mode

ilen = len(cprm(0))                               'length of user's search text
while not eof(1)                                 'loop until end of source file
   line input #1, clin                          'get text line from source file
   do                                        'begin loop to search/replace text
      if icas then                               'the case-sensitive flag is ON
         ipos = instr(clin, cprm(0))            'search for text in actual case
      else                                      'the case-sensitive flag is OFF
         ipos = instr(ucase$(clin), cprm(0))      'search for text in uppercase
      end if
      if ipos then                            'searchtext found in current line
         clin = left$(clin, ipos - 1) + cprm(1) + mid$(clin, ipos + ilen)'repl.
      else                                'searchtext NOT found in current line
         exit do                          'searchtext NOT found; exit this loop
      end if
   loop
   print #2, clin                 'output (possibly changed) line to dest. file
wend

close                                                     'close all open files
i = ifn.kill(1, cfil)                          'kill the original (source) file
name cdst as cfil                      'rename output file to original filename
i = ifn.msgs("Process completed", 5, 24, 79, 0, 1)    'display message and exit

close                                                     'close all open files
system                                              'return to operating system
