'/* SPLF.BAS Split binary or text file into multiple segments */
'/*          By: Dale Thorn                                   */
'/*          Rev. 08.08.2000                                  */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'
'$include: 'scrnparm.bas'

ccmd = ucase$(rtrim$(command$))                'get DOS command-line parameters
if ccmd = "" then                              'a command line was NOT supplied
   cls                                                'clear the display screen
   cmsg = "Usage:  SPLF  filename  maxsize    "        'set the initial message
   ctmp = space$(4)                        'initialize the messages left margin
   locate 5, 1, 1                           'move display cursor to scrn row #1
   print ctmp; cmsg                            'display the first usage message
   mid$(cmsg, 1) = "      "                    'blank 'Usage:' in usage message
   ipos1 = len(cmsg) - 1                      'display posn. for '/' parameters
   mid$(cmsg, ipos1) = "/B"                     'add '/B' spec to usage message
   print ctmp; cmsg                               'display second usage message
   print                                           'blank line between messages
   print ctmp; "If '/B' (binary mode) specified, each file segment will be 'maxsize'"
   print ctmp; "bytes in length, else (text mode) each file segment will be split at"
   print ctmp; "the end of the text line that doesn't exceed 'maxsize' no. of bytes."
   print                                           'blank line between messages
   print ctmp; "If '/B' not specified and 'maxsize' not specified, each file segment"
   print ctmp; "will be split at the text line which does not exceed 900,000 bytes."
   close                              'close all files in case not closed above
   system                                   'return control to operating system
end if

ipos1 = instr(ccmd, "/B")                   '/B' switch posn. in command params
if ipos1 then                               '/B' switch found in command params
   ccmd = left$(ccmd, ipos1 - 1) + mid$(ccmd, ipos1 + 2)'remove the '/B' switch
   ibinary = not 0                             'set binary processing option ON
   cfilmod = "B"                               'set file process to binary mode
else                                           '/B' NOT found in command params
   ibinary = 0                                'set binary processing option OFF
   cfilmod = "S"                              'set file processing to text mode
end if

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") then
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)   'invalid filename
end if                              'display the error message [above] and exit
if iprm > 0 then                      'parameter count must be <= one parameter
   i = ifn.msgs("Invalid number of parameters", iofs, irow, icol, 1, 1)
end if                              'display the error message [above] and exit

if iprm = 0 then                      'user entered a maximum file segment size
   lmaxsiz = pdqvall&(cprm(0))        'get the max. file segment size (numform)
   if lmaxsiz < 1 then                'error: maximum segment size must be >= 1
      i = ifn.msgs("Invalid maximum segment size", iofs, irow, icol, 1, 1)
   end if                           'display the error message [above] and exit
elseif ibinary then                'user specified binary mode w/o max.seg.size
   i = ifn.msgs("Invalid number of parameters", iofs, irow, icol, 1, 1)
else                                 'user specified text mode w/o max.seg.size
   lmaxsiz = 900000&                'default the maximum text-mode segment size
end if

i = ifn.open(1, cfil, cfilmod, llof)           'open source file as binary/text
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", iofs, irow, icol, 1, 1)      'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", iofs, irow, icol, 1, 1)     'beep and exit
end if

i = ifn.msgs("Processing: " + cfil, iofs, irow, icol, 0, 0)'continue processing

ifilcnt = 0                          'initialize the output file number counter
lfilsiz = 0                           'initialize the current filesize variable
cdst = cnam + ".000"                    'initialize the current output filename
if ibinary then                          'user specified binary mode processing
   if lmaxsiz > llof then                 'max. segment size > source file size
      lmaxsiz = llof                      'set segment size to source file size
   end if
   iseglen = 8192                          'initialize the output buffer length
   if iseglen > lmaxsiz then              'default segment length > file length
      iseglen = lmaxsiz                   'set segment length == to file length
   end if
   lmodlen = llof mod lmaxsiz                'leftover bytes from file segments
   imodlen = lmaxsiz mod iseglen           'leftover bytes in each file segment
   cbuf = space$(iseglen)                  'pre-allocate the output file buffer
   cmod = space$(imodlen)                  'pre-allocate the modulo file buffer
   open cdst for binary as 2               'open the output file in binary mode
   lsrcptr = 1                              'initialize the source file pointer
   ldstptr = 1                              'initialize the output file pointer
   while lsrcptr <= llof                    'loop thru the source file segments
      lfilsiz = lfilsiz + iseglen            'update current file size variable
      if lsrcptr + iseglen > llof then        'current file segment is g.e. EOF
         imodlen = llof - lsrcptr + 1         'leftover bytes this file segment
         cmod = ""                           'deallocate the modulo file buffer
         cmod = space$(imodlen)              'reallocate the modulo file buffer
         get 1, lsrcptr, cmod               'load buffer from curr.file segment
         put 2, ldstptr, cmod                'put buffer from curr.file segment
         lsrcptr = lsrcptr + imodlen          'move file pointer beyond the EOF
         lfilsiz = 0                          'clear current file size variable
      elseif lfilsiz > lmaxsiz then         'current filesize is > maximum size
         get 1, lsrcptr, cmod               'load buffer from curr.file segment
         put 2, ldstptr, cmod                'put buffer from curr.file segment
         lsrcptr = lsrcptr + imodlen         'move file pointer to next segment
      else                                   'current file size <= maximum size
         get 1, lsrcptr, cbuf               'load buffer from curr.file segment
         put 2, ldstptr, cbuf                'put buffer from curr.file segment
         lsrcptr = lsrcptr + iseglen         'move file pointer to next segment
      end if
      if lfilsiz < lmaxsiz then                'current filesize < maximum size
         ldstptr = ldstptr + iseglen           'move output ptr.to next segment
      else                                       'current filesize >= max. size
         close 2                                 'close the current output file
         ifilcnt = ifilcnt + 1                   'increment output file counter
         lfilsiz = 0                           'reset current filesize variable
         cfilcnt = right$("00" + ltrim$(str$(ifilcnt)), 3) 'next file extension
         cdst = cnam + "." + cfilcnt         'reset the current output filename
         open cdst for binary as 2         'open the output file in binary mode
         ldstptr = 1                      'reinitialize the output file pointer
      end if
   wend
else                                       'user specified text mode processing
   open cdst for output as 2               'open the output file in output mode
   while not eof(1)                        'loop until source file is completed
      line input #1, clin                   'get next line from the source file
      lfilsiz = lfilsiz + len(clin) + 2       'update current filesize variable
      if lfilsiz > lmaxsiz then                'current filesize > maximum size
         close 2                                 'close the current output file
         ifilcnt = ifilcnt + 1                   'increment output file counter
         lfilsiz = len(clin) + 2               'reset current filesize variable
         cfilcnt = right$("00" + ltrim$(str$(ifilcnt)), 3) 'next file extension
         cdst = cnam + "." + cfilcnt         'reset the current output filename
         open cdst for output as 2         'open the output file in output mode
      end if
      print #2, clin                         'write current line to output file
   wend
end if

i = ifn.msgs("Process completed for: " + cfil, iofs, irow, icol, 0, 1)
close                                 'close all files in case not closed above
system                                  'return control to the operating system
