'/* UNHIDE9X.BAS  Unhide files in current directory and below */
'/*               By: Dale Thorn                              */
'/*               Rev. 13.07.2002                             */

'$include: 'basdef.h'
'$include: 'getdir.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'getdir9x.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'string.bas'

dim cdir(24)                      'temp/work filename used by ifn.gdir function
dim cfil(24)                      'filenames-only returned by ifn.gdir function
dim cfsp(24)                       'DOS filespecs returned by ifn.gdir function
dim chdr(24)                       'DOS pathnames returned by ifn.gdir function
dim cout(24)                       'temp. copies of cdir() values after sorting
dim cprm(24)                       'filespec params passed to ifn.gdir function
dim ifno(24)                       'file-open "handle" set by ifn.gdir function
dim lsiz(24)                       'size of files returned by ifn.gdir function

i = ifn.msgs("Unhiding files - please standby", 5, 24, 79, 0, 0)

csys = "|Classes.dat|System.dat|User.dat|Classes.da0|System.da0|User.da0"
cdir(ihid) = "dsrc00.dir"              'initialize the first temp/work filename
cout(ihid) = "dsrc00.out"              'initialize the first temp/copy filename
cprm(ihid) = "*.*"                    'initialize the first filespec parameters
cqot = char(34)                      'initialize the double-quote (") character
idir = not 0                         'flag ifn.gdir function to return dirnames
iclr = 112                            'set DOS color for user's screen displays
ihid = 0                              'initialize current recursion level index

shell "dir *.* /ad >  " + cdir(ihid)       'subdirectories in current directory
shell "dir *.* /ah >> " + cdir(ihid)         'hidden files in current directory
shell "dir *.* /as >> " + cdir(ihid)         'system files in current directory
shell "srtf " + cdir(ihid) + "/NO > nul"       'sort files in current directory
shell "del " + cdir(ihid) + " > nul"             'delete the unsorted work file
shell "ren " + cout(ihid) + " " + cdir(ihid) + " > nul"  'name out-file to orig
shell "rdup " + cdir(ihid) + " 0 20 /N > nul"   'remove dupl's from sorted file
shell "del " + cdir(ihid) + " > nul"             'delete file containing dupl's
shell "ren " + cout(ihid) + " " + cdir(ihid) + " > nul"  'name out-file to orig

ilog = freefile                             'get DOS handle for output log file
open "unhide.log" for output as ilog          'open output log file for writing
do                                             'loop until all levels processed
   i = ifn.gdir(cdir(ihid), cfil(ihid), cfsp(ihid), chdr(ihid), _
                cprm(ihid), ifno(ihid), lsiz(ihid), idir)'get 1st/next filespec
   if cfil(ihid) <> "" then                     'a valid file or DIR was found!
      if instr(cfsp(ihid), "<dir>") then         'the file found is a directory
         shell "attrib -a -r -s -h " + cqot + chdr(ihid) + _
               cfil(ihid) + cqot + " > nul"       'unhide the (poss.hidden) DIR
         print #ilog, " dir: "; chdr(ihid); cfil(ihid)            'write log...
         ihid = ihid + 1                         'increment the recursion level
         if ihid > 24 then                       'max. directory depth exceeded
            cls                                    'clear the user's DOS screen
            locate 5, 1, 1                          'locate cursor for messages
            print "    *****ERROR*****"             'display first user message
            print                                  'blank line between messages
            print "    Maximum no. of nested directory levels has been"
            print "    exceeded.  Contact program supplier for upgrade."
            close                        'close all of the currently open files
            system                      'return control to the operating system
         end if
         chid = right$("0" + ltrim$(str$(ihid)), 2) 'recursion level (num.form)
         cdir(ihid) = "dsrc" + chid + ".dir"       'set next temp/work filename
         cout(ihid) = "dsrc" + chid + ".out"       'set next temp/copy filename
         cprm(ihid) = "*.*"                        'set the filespec parameters
         shell "dir " + cqot + chdr(ihid - 1) + cfil(ihid - 1) + _
               "\*.*" + cqot + " /ad > " + cdir(ihid)   'DIR's in new directory
         shell "dir " + cqot + chdr(ihid - 1) + cfil(ihid - 1) + _
               "\*.*" + cqot + " /ah >> " + cdir(ihid)  'hidden files in newdir
         shell "dir " + cqot + chdr(ihid - 1) + cfil(ihid - 1) + _
               "\*.*" + cqot + " /as >> " + cdir(ihid)  'system files in newdir
         shell "srtf " + cdir(ihid) + "/NO > nul"  'sort files in new directory
         shell "del " + cdir(ihid) + " > nul"        'delete unsorted work file
         shell "ren " + cout(ihid) + " " + cdir(ihid) + " > nul"'rename out-file
         shell "rdup " + cdir(ihid) + " 0 20 /N > nul"'remove dups.from sortfile
         shell "del " + cdir(ihid) + " > nul"      'delete file containing dups.
         shell "ren " + cout(ihid) + " " + cdir(ihid) + " > nul"'rename out-file
         for irow = 0 to 24               'loop thru user's screen display rows
            if irow = ihid then              'row is at current directory level
               lset cdsp = chdr(irow - 1) + cfil(irow - 1)'set to show curr.dir.
            elseif irow < ihid then      'row is within current directory level
               ilen = len(chdr(irow))   'get length of header with trailing '\'
               lset cdsp = chdr(irow)   'set display to show directory at level
               mid$(cdsp, ilen) = " "    'blank out trailing '\' in dir. header
            else                        'row NOT within current directory level
               lset cdsp = ""            'clear display to show blank directory
            end if
            call pdqprint(cdsp, irow + 1, 1, iclr)  'display current screen row
         next
         if ihid < 23 then                  'directory listing is < full screen
            locate ihid + 3, 1, 0         'locate cursor for DOS error messages
         end if
      else                                   'the file found is NOT a directory
         if instr(csys, cfil(ihid)) > 1 then      'Windows Registry file found!
            print #ilog, "FILE (NOT unhidden): "; chdr(ihid); cfil(ihid)
         else              'file found is a regular file (NOT Windows Registry)
            shell "attrib -a -r -s -h " + cqot + chdr(ihid) + _
                  cfil(ihid) + cqot + " > nul"   'unhide the hidden/system file
            print #ilog, "FILE: "; chdr(ihid); cfil(ihid)         'write log...
         end if
      end if           'get next file [above] if available in current directory
   else                 'no more files/DIR's are available in current directory
      close ifno(ihid)     'close the DOS file handle for the current directory
      ihid = ihid - 1      'decrement to the next lower process/recursion level
      if ihid < 0 then    'all directory and subdirectory entries are processed
         exit do          'processing of all levels is complete - exit the loop
      end if
   end if              'get next file [above] if available in current directory
   if inkey$ = char(27) then               'user pressed ESC; terminate program
      i = ifn.msgs("Abort selected - Program terminated", 5, 24, 79, 0, 1)
   end if                               'display abort message [above] and exit
loop

close                                'close all files prior to viewing log file
shell "del dsrc*.dir > nul"          'delete temp. files for all process levels
shell "brow unhide.log"                               'view the output log file
i = ifn.msgs("Unhide files complete", 5, 24, 79, 0, 1)   'show message and exit
close                                 'close all files in case not closed above
system                                  'return control to the operating system
