'/* XCOLB.BAS Extract column from binary file (make output file) */
'/*           By: Dale Thorn                                     */
'/*           Rev. 02.08.2002                                    */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'

ccmd = rtrim$(command$)                    'get the DOS command-line parameters
if ccmd = "" then                     'DOS command-line parameters NOT supplied
   i = ifn.msgs("Usage:  XCOLB  filename  recordlen  offset  length", _
                5, 24, 79, 0, 1)                'display usage message and exit
end if

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") then
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
end if                                  'display error message [above] and exit
if iprm < 1 or iprm > 2 then         'user input too few or too many parameters
   i = ifn.msgs("Invalid number of parameters", 5, 24, 79, 1, 1) 'beep and exit
end if                                  'display error message [above] and exit

ircdlen = pdqvali(cprm(0))                        'get the source record length
if ircdlen < 2 or ircdlen > 9999 then             'invalid source record length
   i = ifn.msgs("Invalid recordlen", 5, 24, 79, 1, 1)            'beep and exit
end if

ioffset = pdqvali(cprm(1))                        'get the source column offset
if ioffset < 0 or ioffset > 9998 then             'invalid source column offset
   i = ifn.msgs("Invalid offset", 5, 24, 79, 1, 1)               'beep and exit
end if

if iprm = 2 then                           'user specified a dest.column length
   idstlen = pdqvali(cprm(2))               'get destination (to) column length
   if idstlen < 1 or idstlen > 9999 then           'invalid dest. record length
      i = ifn.msgs("Invalid length", 5, 24, 79, 1, 1)            'beep and exit
   end if
else                                        'user did NOT specify column length
   idstlen = ircdlen                       'default the dest.(to) column length
end if

if cext = "out" then                       'source filename extension is ".out"
   cdst = cnam + ".tmp"                    'set destination extension to ".tmp"
else                                      'source filename extension NOT ".out"
   cdst = cnam + ".out"                    'set destination extension to ".out"
end if

i = ifn.open(1, cfil, "B", llof)               'open source file in binary mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
end if                                  'display error message [above] and exit
if llof = 0 then                              'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)            'beep and exit
end if                                  'display error message [above] and exit
open cdst for output as 2                     'open the output destination file

i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)        'hide cursor and proceed

lrecords = llof \ ircdlen                   'get total number of source records
cbuf = space$(ircdlen)                     'initialize the source record buffer
cout = space$(idstlen)                      'initialize the dest. record buffer
lfileptr = 1                              'initialize the source record pointer
while (lfileptr + ircdlen - 1) <= llof     'begin loop to read source-file data
   get 1, lfileptr, cbuf                    'load a record from the source file
   lset cout = mid$(cbuf, ioffset + 1, idstlen) 'put source data to dest.buffer
   for i = 1 to idstlen                        'loop thru the dest.buffer bytes
      if midchar(cout, i) < 32 then            'current character is < 32 ASCII
         mid$(cout, i) = "."                     'replace current non-view char.
      end if
   next
   print #2, cout                                 'write the output data record
   lfileptr = lfileptr + ircdlen                   'move pointer to next record
wend

close                                 'close all files in case not closed above
shell "brow " + cdst                                    'browse the output file
system                                                'exit to operating system
