
/*////////////////////////////////////////////////////////////////////////
//
// CM17A - Control program for X10's FireCracker Module
//
// Copyright (C) 1999,2000,2001 Curtis Brown, mrbrown8@juno.com
//
//////////////////////////////////////////////////////////////////////////
// http://mlug.missouri.edu/~tymm/
// http://www.x10.com/manuals/cm17a_proto.txt
// http://freshmeat.net/news/1999/07/10/931665599.html
// http://www.x10.com/home/offer.cgi?!FM2,../1index803.htm           */

#include <stdio.h>
#include <stdlib.h>
#include "async.h"

/*---== CONSTANTS ==---------------------------------------------------*/
const char szHouseCode[16] = {  /* for unit codes 1-8   */

/* A    B     C     D     E     F     G     H       */
 0x60, 0x70, 0x40, 0x50, 0x80, 0x90, 0xA0, 0xB0,

/* I    J     K     L     M     N     O     P       */
 0xE0, 0xF0, 0xC0, 0xD0, 0x00, 0x10, 0x20, 0x30 };

/* For unit codes 9-16, 0x04 is added to the house code.   */


const char szUnitCode[10] = {

/*  1/9  2/10  3/11  4/12  5/13  6/14  7/15  8/16  dim   bright   */
   0x00, 0x10, 0x08, 0x18, 0x40, 0x50, 0x48, 0x58, 0x98, 0x88 };

/* These are ON commands. For OFF commands, add 0x20 to the unit code EXCEPT
// for the DIM/BRIGHT commands, they are given literally.    */

/* Do not add 0x04 to the house code for the DIM/BRIGHT commands.  */


const char szHeader[2] = {0xD5, 0xAA};    /*"ժ"*/
const char szFooter    =  0xAD;           /*""*/
const unsigned int cg_uiWaitState = 1;  /* wait between bits in ms*/

/*-----== GLOBALS ==---------------------------------------------------*/
unsigned short g_usUnitCode;               /* unit code entered by user*/


/*-----== PROTOCOLS ==-------------------------------------------------*/   
void usage();
int send_code(char *);
int check_args(int, char**);
/*int main()   do I do a proto on main?   */


/*-----== SOURCE ==----------------------------------------------------*/
int main(int argc, char *argv[])
{
    int iReturnCode = 0;
    char szCommandStream[5] = {0};
    
    /* error checking */
    iReturnCode = check_args(argc, argv);
    if (iReturnCode >= 0)
    {
        return (iReturnCode);
    }

    /* Assume args are OK and are in lower case */

    szCommandStream[0] = szHeader[0];
    szCommandStream[1] = szHeader[1];
    szCommandStream[4] = szFooter;

    /* There are 2 bytes to send, with the first being easier to determine
    // than the second.     */

    /* The first is based on house and unit code
    // For unit codes 9-16, 0x04 is added to the house code.    */

    szCommandStream[2] = szHouseCode[ argv[1][0] - 0x61 ];
    if (atoi(&argv[1][1]) > 8)
    {
        g_usUnitCode -= 8; /* to get it into the lower half   */
    }


    /* The second is based on command and unit code. */

    if (!strcmp(argv[2], "dim"))
    {
        szCommandStream[3] = szUnitCode[8];
    }
    else if (!strcmp(argv[2], "bright"))
    {
        szCommandStream[3] = szUnitCode[9];
    }
    else if (!strcmp(argv[2], "on"))
    {
        szCommandStream[3] = szUnitCode[g_usUnitCode-1];
    }
    else if (!strcmp(argv[2], "off"))
    {
        szCommandStream[3] = szUnitCode[g_usUnitCode-1] + 0x20;
    }

    if (atoi(&argv[1][1]) > 8)
    {
        szCommandStream[2] += 4;
    }

    send_code(szCommandStream);

    return 0;
}

int check_args(int argc, char** argv)
{

    /* "I just wanna know how to run this damn thing!" */
    if (!strcmp(argv[1], "?") || !strcmp(argv[1], "/?") || !strcmp(argv[1], "-?") ||
        !strcmp(argv[1], "/h") || !strcmp(argv[1], "-h"))
    {
        usage();
        return(0);
    }

    /* just 3 arguments: program name, house/unit code, command */
    if (argc !=3)
    {
        printf("\nThere can only be 2 arguments, a house/unit code and a command.\n");
        printf("Use -h for usage.\n");
        return 0;
    }

    /* for the house/unit code, there's 1 char for
       the house, 1 or 2 chars for the unit */
    if (strlen(argv[1]) != 2 && strlen(argv[1]) != 3)
    {
        printf("\nThe 1st argument should only be 2 or 3 characters, a house code and a unit code\n");
        printf("Use -h for usage.\n");
        return 0;
    }

    /* check for valid house code */
    strlwr(argv[1][0]);
    if (argv[1][0] < 0x61 || argv[1][0] > 0x70)    /* "a" == 0x61, "p" == 0x70 */
    {
        printf("\nNot a valid house code. House codes are letters A through P.\n");
        return 0;
    }

    /* check for valid unit code */
    if (atoi(&argv[1][1]) < 1 || atoi(&argv[1][1]) > 16)
    {
        printf("\nNot a valid unit code. Unit codes are numbers 1 through 16.\n");
        return 0;
    }

    g_usUnitCode = atoi(&argv[1][1]);

    /* check for valid command */
    strlwr(argv[2]);
    if (!strcmp(argv[2], "on") && !strcmp(argv[2], "off") &&
    !strcmp(argv[2], "bright") && !strcmp(argv[2], "dim"))
    {
        printf("\nBad command. Valid commands are ON, OFF, DIM, or BRIGHT.\n");
        return 0;
    }


    return(-1);
}

void usage()
{
    printf("\n");
    printf("CM17A  v1.0     -Curtis Brown <mrbrown8@juno.com>\n");
    printf("X10 Firecracker Module Control software\n");
    printf("\n");
    printf("Usage:\n");
    printf("     CM17A (house code)(unit code) (command)\n\n");
    printf("Example:\n\n");
    printf("     CM17A A3 ON\n");
    printf("     CM17A C12 DIM\n\n\n");
    printf("House codes are A through P and unit codes are 1 thorugh 16.\n");
    printf("Commands are ON, OFF, DIM, and BRIGHT\n");
    printf("Parameters are NOT case sensetive.\n");
    printf("\n");

    return;
}

int send_code(char *szCommand)
{

    int i, j;
    unsigned short cCounter;

    AsyncInit(COM1);        /* init com port 1 */
    AsyncClear();
    AsyncHand( DTR | RTS);

    for (i=0; i<5; i++)  /* there are only 5 bytes in the sequence */
    {
        cCounter = 0x80;
        for (j=0; j<8; j++)    /* there's 8 bits to a byte */
        {
            /*sleep(cg_uiWaitState);*/
            if ( szCommand[i] & cCounter )
            {
                AsyncHand(RTS);     /* 1 bit, drop DTR  */
            }
            else
            {
                AsyncHand(DTR);     /* 0 bit, drop RTS   */
            }

            /*sleep(cg_uiWaitState);*/
            AsyncHand( DTR | RTS);

            cCounter >>= 1;
            /*cCounter /= 2;*/

        }
    }

    AsyncStop();
    return 0;
}
