/*
 *  $Id: xfsapi.h,v 1.77 1994/07/10 17:33:25 xfs Exp $
 *  $Source: /home/xfs/project/win/RCS/xfsapi.h,v $
 *
 *  XFSAPI.H - Interface to XFSLIB.DLL & XFSFMX.DLL
 *  Borland C++ Version
 *
 *  Copyright (C) 1994 Robert Juhasz
 */

#ifndef _XFSAPI_H
#define _XFSAPI_H
#include <windows.h>

// Mount defaults
#define  MOUNT_MAX_RSIZE  1280
#define  MOUNT_MAX_WSIZE  1280
#define  MOUNT_MAX_FWSIZE 8192     // for XFS IPF
#define  MOUNT_DEF_RETRY  4

// MOUNT flags
#define  MOUNT_OPT_RO      1       // read-only
#define  MOUNT_OPT_MAP     2       // 8+3 mapping
#define  MOUNT_OPT_UPPER   4       // uppercase mapping (for CD-ROMS's)

#define  MOUNT_DEF_OPT     MOUNT_OPT_MAP        // my default option

// XfsFMXCall calls
#define  CM_MOUNT          1       // FMX mount
#define  CM_UMOUNT         2       // FMX umount
#define  CM_LOGIN          3       // FMX login
#define  CM_LOGOUT         4       // FMX logout
#define  CM_INFO           5       // FMX info

// Error codes
// inet
#define  ECONN          (-1)             // can't connect (generic)
#define  ENETUNREACH    (-2)             // network unreachable
#define  EHOSTUNREACH   (-3)             // host unreachable
#define  EPROTUNREACH   (-4)             // unknown protocol
#define  EPORTUNREACH   (-5)             // unknown port
#define  ESOCK          (-10)            // bad socket descriptor
#define  ENOSOCK        (-11)            // out of socket descriptors
#define  ETIMEO         (-12)            // connection timeout

// arp
#define  EARPTIMEO      (-51)           // ARP timeout
#define  EARPUNREACH    (-52)           // local host not responding

// host
#define  EHOSTIO        (-200)          // 'hosts' file not found
#define  EHOSTNOENT     (-201)          // host not found

// (u)mount
#define  EMOUNT         (-300)          // can't mount/umount(given by server)

// pcnfsd
#define  EPCACCES       (-400)          // authentication failure
#define  EPCNOPRN       (-401)          // unknow printer
#define  EPCFAIL        (-402)          // failed initialization

// portmap
#define  EPMPORT        (-500)          // port not found

// DPMI
#define  EDOSMEM        (-600)          // can't allocate lower DOS mem

// Redirector (positive values)
#define  EDUP            0x55         // Duplicate redirections
#define  EDRIVE          0x0f         // Drive/device invalid
#define  EMEM            0x08         // insuficient memory in redirector
#define  EFUNC           0x01         // invalid operation


// Mount options struct
typedef struct tagTMOUNTOPT
{
  UINT rsize;
  UINT wsize;
  UINT retry;
  UINT flags;
} MOUNTOPT;
typedef MOUNTOPT FAR* LPMOUNTOPT;

// XFS Host info
typedef struct tagTXFSINFO
{
  WORD version;           // XFS version, eg. 0x0177 for 1.77 or 0x8177 for 1.77IPF
  char hostname[64];      // Host name
  LONG ip_addr;           // Hostname's IP address
  LONG sm_addr;           // Subnet mask
  LONG gw_addr;           // Gateway IP address
  LONG pc_addr;           // PCNFSD IP address
  char username[64];      // User name
  WORD uid;               // User ID
  WORD gid;               // Group ID
  WORD umask;             // File creation mask
} XFSINFO;
typedef XFSINFO FAR* LPXFSINFO;


#ifdef __cplusplus
extern "C" {
#endif

// XFSLIB

BOOL WINAPI XfsInstalled(VOID);
int  WINAPI XfsMountDrive(LPSTR localdrive, LPSTR host, LPSTR filesystem, LPMOUNTOPT options);
int  WINAPI XfsMountPrinter(LPSTR localdrive, LPSTR host, LPSTR printer);
int  WINAPI XfsUmount(LPSTR localdrive);
int  WINAPI XfsFlush(LPSTR printer);
int  WINAPI XfsLogin(LPSTR localdrive, LPSTR host, LPSTR name, LPSTR password);
VOID WINAPI XfsLogout(LPSTR localdrive);
VOID WINAPI XfsNetStat(LPXFSINFO info);
WORD WINAPI XfsUmask(WORD mask);
UINT WINAPI WGetRedirection(UINT index, LPSTR device, LPSTR resource );

// XFSFMX

LONG WINAPI InitFMX(VOID);
LONG WINAPI XfsFMXCall( HWND Handle, WORD call);
VOID WINAPI DoneFMX(VOID);

#ifdef __cplusplus
}
#endif	/* __cplusplus */

#endif
