/*
 * rmdp.c --  packet assembly/disassembly functions
 * and parsing utilities
 *
 * This file is part of
 * 
 * rmdp -- Reliable Multicast data Distribution Protocol
 * 
 * (C) 1996-1998 Luigi Rizzo and Lorenzo Vicisano
 *     (luigi@iet.unipi.it, vicisano@cs.ucl.ac.uk)
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Luigi Rizzo,
 *      Lorenzo Vicisano and other contributors.
 * 4. Neither the name of the Authors nor the names of other contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

#include "rmdp.h"
/* #include <sys/time.h> */
#ifdef SunOS
#include<netinet/in.h>
#endif


/*
 * compute hopefully unique id
 */
ui32 compute_id()
{
  short seed[3];
  struct timeval getime;

    gettimeofday(&getime, NULL);
    seed[0] = (short)getime.tv_usec; seed[1] = (short)(getime.tv_usec*0xffff);
    seed[2] = (short)getime.tv_sec;
    return(nrand48(seed));      
}

n32
url_addr(char *s)
{
     char *p1, *p2;
     struct hostent *hp;

     p1=strstr(s,"//");
     if (p1 == NULL) return 0;
     p2 = strstr(p1+2,"/");
     if (p2 == NULL) return 0;
     *p2 = '\0';
     hp = gethostbyname(p1+2);
     if (hp == NULL) {
	 fprintf(stderr,"gethostbyname failed\n");
	 return 0;
     }
     *p2 = '/' ;
     return ((struct in_addr *)hp->h_addr)->s_addr ;
}

char *
validpath(char *path)
{
    n32 pa;
    static char myhn[256];
    static n32 myha[10];
    static int n_myha =0;
    int i;
    char *p;

    if (strncmp(path,"rmdp://",7) ) {
	fprintf(stderr,"can only serve rmdp!\n");
	return NULL ;
    }
    pa = url_addr(path);

    if (n_myha == 0) {
	struct hostent *hp;
	if (gethostname(myhn, sizeof(myhn)) >= 0) {
	    if ((hp = gethostbyname(myhn)) >= 0) {
#ifdef __FreeBSD__
		while( ((struct in_addr *)hp->h_addr_list[n_myha]) != NULL) {
		    myha[n_myha] = ((struct in_addr *)hp->h_addr_list[n_myha])->s_addr;
		    fprintf(stderr,"local addr %s\n",
			inet_ntoa(*(struct in_addr *)&(myha[n_myha]) ) );
		    if (++n_myha == 10) break;
		}
#else
		myha[0] = ((struct in_addr *)hp->h_addr)->s_addr;
		n_myha = 1 ;
#endif
	    }
	}
    }
    for (i=0; i< n_myha; i++) {
	if (pa == myha[i]) {
	    p = strstr(path+7,"/");
	    while (p && *p =='/') p++;
	    return p;
	}
    }
    DDB(fprintf(stderr, "sorry req does not match any local addr\n"));
    return NULL;
}
/*** parameter parsing ***/
int     
set_link_addr(char *s, char *a, int addrlen, n16 *p, char *msg)
{       
    char *s1, *q = a ;
    strncpy(q, s, addrlen);
    s1=strchr(q,'/');
    if (s1) {
        *p=htons(atoi(s1+1));
        *s1='\0'; 
        printf("%s session [%s] [%d]\n", msg, q, ntohs(*p));
    } else  
        return -1;
    return 0;
}

/**** packet building utilities ***/
u_char *
add_magic(u_char *p)
{
    *(n32 *)p = htonl(RMDP_V0_MAGIC) ;
    return p+4;
}

u_char *
add_opt1(u_char *p, RMDP_TAG tag)
{
    *p++ = tag;
    return p;
}

u_char *    
add_opt2(u_char *p, RMDP_TAG tag, n16 value)
{
    *p++ = tag;
    *p++ = 4;
    bcopy(&value, p, 2);
    return p+2;
}

u_char *    
add_opt4(u_char *p, RMDP_TAG tag, n32 value)
{
    *p++ = tag;
    *p++ = 6;
    bcopy(&value, p, 4);
    return p+4;
}

u_char *    
add_opts(u_char *p, RMDP_TAG tag, char *value)
{
    n16 n = htons(strlen(value) + 1 + 3 /* tag + len */);
    *p++ = tag;
    bcopy(&n, p, 2);
    n = ntohs(n) - 3 ;
    bcopy(value, p+2, n);
    return p+2+n;
}

/*** packet decoding utilities ***/

int
check_magic(u_char *p, int len)
{
    n32 l;
    if (len < 4 )       /* at least the magic... */
        return 0;
    bcopy(p, &l, 4);  
    if (l != ntohl(RMDP_V0_MAGIC) ) {
        DEB(fprintf(stderr, "bad magic number 0x%08x...\n",
                (int)ntohl(l) )); 
        return 0;
    }       
    return 1;
}

int
getoptlen(u_char *p, int len)
{
    i16 l;
    u_char opt = *p;

    if (opt >= 0x80) { /* variable len, 16 bit field */
	if (len < 3) {
	    fprintf(stderr, "opt 0x%02x missing length\n", opt);
	    return 0;
	}
	bcopy(p+1, &l, 2);
	l = ntohs(l);
    } else if (opt >= 0x10) {
	if (len < 2) {
	    fprintf(stderr, "opt 0x%02x missing length\n", opt);
	    return 0;
	}
	l = p[1];
    } else
	l = 1;
    if (l > len) {
	fprintf(stderr, "opt 0x%02x len %d (%d) missing data\n",
	    opt, l, len);
	return 0;
    }
    return l;
}
