/*
 * header file for rmdp
 * 
 * This file is part of
 *
 * rmdp -- Reliable Multicast data Distribution Protocol
 * 
 * (C) 1996-1998 Luigi Rizzo and Lorenzo Vicisano
 *     (luigi@iet.unipi.it, vicisano@cs.ucl.ac.uk)
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Luigi Rizzo,
 *      Lorenzo Vicisano and other contributors.
 * 4. Neither the name of the Authors nor the names of other contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

#ifndef RMDP_H
#define RMDP_H
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>	/* for send/receive... */

/*
 * these ought to go in fec.h ...
 * Remember, this only work for GF_BITS=8
 */
void *fec_new(int k, int n);
void fec_free(void *code);
void fec_encode(void *code, void *data[], void *dst, int i, int sz);
void fec_decode(void *code, void *data[], int i[], int sz);

#define TTL       16
#define	DATA_SIZE	1024	/* default ... */

typedef	int (*CALLBACK)(void *);

typedef char		i8;		/*  8 bit signed int */
typedef short		i16;		/* 16 bit signed int */
typedef int		i32;		/* 32 bit signed int */
#if defined(__alpha)
typedef long		i64;		/* 64 bit signed int */
#endif

typedef unsigned char	ui8;		/*  8 bit unsigned int */
typedef unsigned short	ui16;		/* 16 bit unsigned int */
typedef unsigned short	n16;		/* 16 bit net format */
typedef unsigned int	ui32;		/* 32 bit unsigned int */
typedef unsigned int	n32;		/* 32 bit net format */
#if defined(__alpha)
typedef unsigned long	ui64;		/* 64 bit unsigned int */
#endif
typedef unsigned long	ui64;		/* 64 bit unsigned int */

#include "compat.h"
#include "event.h"
#include "net.h"


/***
 *** make port number for CPORT & DPORT different, so that
 *** the sender does not listen for its own data
 ***/
#define DEFAULT_CPORT	"224.5.5.5/5656"
#define DEFAULT_DPORT	"224.5.5.6/5657"

#define DDB(x) {x; fflush(stderr);}
#define DEB(x)

#ifdef BYTE_ORDER
#if (BYTE_ORDER == LITTLE_ENDIAN)
#define _LITTLE_ENDIAN
#elif BYTE_ORDER == BIG_ENDIAN
#define  _BIG_ENDIAN
#endif
#else /* BYTE_ORDER */
#if ( !defined(_LITTLE_ENDIAN) && !defined(_BIG_ENDIAN) )
#error	endianness not defined! check compat.h
#endif
#endif /* BYTE_ORDER */

ui32 compute_id(void);

int set_link_addr(char *s, char *a, int addrlen, n16 *p, char *msg);
n32 url_addr(char *);
char *validpath(char *);

/***
 ***   Control packets carry a version number, then a sequence of tags
 ***   similar to TCP/BOOTP options. Tags are followed by a length
 ***   (byte/2bytes) and the data item. The length includes both headers
 ***
 ***/

typedef u_char RMDP_TAG;

#define	RMDP_V0_MAGIC	0xa1e55ad0

	/*** 1 byte, fixed length ***/
#define	RMDP_T_PAD	0x0	/* len 1 */
#define	RMDP_T_END	0x1	/* len 1 */
#define	RMDP_T_NEW_REQ	0x2	/* len 1. New request */
#define	RMDP_T_R_CONT	0x3	/* len 1. Continue sending */
#define	RMDP_T_R_RESUME	0x4	/* len 1. Resume sending */
#define	RMDP_T_R_UNICAST	0x5	/* len 1. unicast data */
#define	RMDP_T_RESP	0x8	/* len 1. Response */

    /*** n bytes, n=0..255 ***/
#define	RMDP_T_S_ID	0x41	/* len 1+1+4. Session ID */
#define	RMDP_T_C_ID	0x42	/* len 1+1+4. Client ID */
#define	RMDP_T_R_ID	0x43	/* len 1+1+4. Request ID */
#define	RMDP_T_R_ADDR	0x44	/* len 1+1+4. Reply addr  */
#define	RMDP_T_D_ADDR	0x45	/* len 1+1+4. Data (multicast) addr  */
#define	RMDP_T_R_RATE	0x46	/* len 1+1+4. request rate, bytes/s */
#define	RMDP_T_R_PORT	0x50	/* len 1+1+2. Reply port */
#define	RMDP_T_D_PORT	0x51	/* len 1+1+2. Data (multicast) port */
#define	RMDP_T_R_LASTK	0x58	/* len 1+1+2. Last k seen (cont/resume) */
#define	RMDP_T_R_LASTB	0x59	/* len 1+1+2. Last B seen (cont/resume) */

    /*** n bytes, n = 0..64k-1 ***/
#define	RMDP_T_R_FILE	0x81	/* len 1+2+s. File name */
#define	RMDP_T_ERRMSG	0x82	/* len 1+2+s. Error message */

int check_magic(u_char *p, int len);
u_char *add_magic(u_char *p);
u_char *add_opt1(u_char *p, RMDP_TAG tag);
u_char *add_opt2(u_char *p, RMDP_TAG tag, n16 value);
u_char *add_opt4(u_char *p, RMDP_TAG tag, n32 value);
u_char *add_opts(u_char *p, RMDP_TAG tag, char *value);
int getoptlen(u_char *p, int len);


#define RMDP_VERSION	0


/* packet types */

#define RMDP_DATA_T	0	/* data packet (down-link) */
#define RMDP_TREQ_T	1	/* tx request packet (up-link) */
#define RMDP_TRES_T	2	/* tx response paket (down-link) */

/**
 ** data packet
 **
 
  0                   1                   2                   3
  0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 |  V=0  |  T  |      flags      |        sequence #             |
 +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 |                           source id                           |
 +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 |                           session id                          |
 +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 |    packet size (data only)    |               N               |
 +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 |         pkt idx               |         blk idx               |
 +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 |                         data size                             |
 +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 |                              data                             |
 |                              ....                             |
 +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

 **
 **
 **/

extern void *fec_code ;

#define MAX_DATA_PKT_LEN	4096

#define DATA_P	struct data_p

DATA_P {
#ifdef _LITTLE_ENDIAN
    ui8   pad:1,
	  type:3,	/* packet type */
    	  vers:4;	/* version */
#endif
#ifdef _BIG_ENDIAN
    ui8   vers:4,	/* version */
    	  type:3,	/* packet type */
	  pad:1;
#endif
/* #define RMDP_F_LAST_ROUND	htons(1) */
#define RMDP_F_LAST_ROUND	'\1'
    ui8   flags;	/* various flags, net order */
    ui16  sn;		/* sequence number */
    ui32  suid;		/* source ID */
    ui32  seid;		/* session ID */
    ui16  packetsize;	/* packet size (data only) */
    ui16  the_N;	/* value of N used at the source */
    ui16  pkt_ix;	/* packet # */
    ui16  blk_ix;	/* block # */
#ifdef DO_TIMING
    ui32  timestamp;
#endif
    ui32  datasize;	/* total data size */
    char  data[MAX_DATA_PKT_LEN];
};

#define FILL_D_H(p,t_sn,t_suid,se_id,pktn,blkn,dsz,n,f,pkts)	{	\
	(p).vers=RMDP_VERSION;			\
	(p).type=RMDP_DATA_T;			\
	(p).sn=(t_sn);				\
	(p).suid=(t_suid);			\
	(p).seid=(se_id);			\
	(p).pkt_ix=(pktn);			\
	(p).blk_ix=(blkn);			\
	(p).datasize=(dsz);			\
	(p).the_N=(n);				\
	(p).flags=(f);				\
	(p).packetsize=(pkts);			\
    }
    

#define PKT_LEN	sizeof(DATA_P)

#endif  /* RMDP_H */
