/* Script for -n: mix text and data on same page */
/* Copyright (C) 2014-2015 Free Software Foundation, Inc.
	 Copying and distribution of this script, with or without modification,
	 are permitted in any medium without royalty provided the copyright
	 notice and this notice are preserved.	*/
 
OUTPUT_FORMAT("elf32-avr","elf32-avr","elf32-avr")
OUTPUT_ARCH(avr:103)

ENTRY(__bootloader_entry)

MEMORY
{
	text		(rx)	:	ORIGIN = 0x000000,	LENGTH = 0x0800
	data		(rw!x)	:	ORIGIN = 0x803f00,	LENGTH = 256
	
	flash				:	ORIGIN = 0x008000,	LENGTH = 4096
}

SECTIONS
{
	.bootload :
	{
		*(.bootload)
		KEEP(*(.bootload))
		
		/* now the crt */
		. = ALIGN(256);
	}	> text
	
	.text :
	{
		*(.vecs)
		KEEP(*(.vecs))
		
		/* now the crt */
		. = ALIGN(256);
		
		*(.crt)
		KEEP(*(.crt))
		
		. = ALIGN(2);
		
		 *(.progmem.gcc*)
		 *(.progmem*)
		. = ALIGN(2);
		
		*(.jumptables)
		 *(.jumptables*)
		 
		*(.lowtext)
		 *(.lowtext*)
		. = ALIGN(2);
		
		*(.text)
		 *(.text.*)
		 _etext = . ;
		. = ALIGN(2);
	}	> text
	
	.rodata ADDR(.text) + SIZEOF (.text) + 0x8000:
	{
		*(.rodata)
		 *(.rodata*)
		*(.gnu.linkonce.r*)
	} > flash AT >text
	
	.data :
	{
		PROVIDE (__data_start = .) ;
		*(.data)
		 *(.data*)
		*(.gnu.linkonce.d*)
		. = ALIGN(2);
		 _edata = . ;
		 PROVIDE (__data_end = .) ;
	}	> data AT> text
	
	.bss ADDR(.data) + SIZEOF (.data) : AT (ADDR (.bss))
	{
		 PROVIDE (__bss_start = .) ;
		*(.bss)
		 *(.bss*)
		*(COMMON)
		 PROVIDE (__bss_end = .) ;
	}	> data
}

__data_data = LOADADDR(.data);

/* need buses set as: BOOTEND = 1, APPEND = 8, else app cannot write to update */
__bl_start = 0x8000;
__bl_size = 0x0100;

__app_start = 0x8100;
__app_size = 0x0700;
__app_pages = __app_size / 64;

__update_start = 0x8800;
__update_end = __update_start + __app_size;
/* lasy 256 bytes not yet used */
