#include <htc.h>

__CONFIG(FOSC_INTOSCIO & WDTE_OFF & PWRTE_ON & MCLRE_OFF & CP_OFF & IOSCFS_8MHZ & BOREN_OFF & WRT_OFF);
__IDLOC(0000);

typedef signed long Int32;
typedef unsigned long UInt32;
typedef unsigned short UInt16;
typedef unsigned short long UInt24;
typedef unsigned char UInt8;
typedef unsigned char Boolean;
typedef signed short Int16;

#define true 			1
#define false			0
#define NULL			((void*)0)
#define _XTAL_FREQ		8000000

#define _clrwdt()	asm("clrwdt")
#define _sleep()	asm("sleep")

#define	MIN_BRI		16

//input data
	static UInt8 gRxData[32];
	static UInt8 gRxPos;
	static UInt8 gRxMask;
	static bit gRxDone;

//data for int
	static UInt16 gIntCapturedTime;
	static bit gIntFirstEdgeSeen;

//brightness
	static volatile UInt8 gBri = 32;


#define PWM		do{ RA5 = (TMR0 < gBri); } while(0)



static void rxStart(void){

	UInt8 i;

	for(i = 0; i < sizeof(gRxData); i++) gRxData[i] = 0;

	PWM;

	gRxPos = 0;
	gRxMask = 0x80;
	gRxDone = 0;

	gIntFirstEdgeSeen = 0;
	
	CCP1IF = 0;
	CCP1IE = 1;
	TMR2ON = 0;
	TMR2IE = 1;
	TMR2IF = 0;
	CCP1CON = 0b00000100;	//catch falling edge (IR turns on)
}

static UInt8 rxDecode(void){		//0 if success, else error

	UInt8 i, j, t, k;


	if(gRxPos != 9) return 1;			//size error
	if(gRxData[0] != 0xFF) return 2;	//preamble error
	if(gRxData[1] != 0x06) return 3;	//header error

	//check crc
	for(k = 0, i = 0; i < gRxPos - 3; i++){
		
		t = gRxData[i + 2];
		for(j = 0; j < 8; j++, t <<= 1){

			PWM;

			k = (k << 1) ^ (((t ^ k) & 0x80) ? 0x83 : 0);
		}
	}

	if(k != gRxData[gRxPos - 1]) return 4;	//crc error

	return 0;
}


void main(void){

	OPTION_REG	= 0b10000010;	//Tmr0 @ Fosc/64, overflowing at 488.28Hz
	ANSEL		= 0b01100000;	//All pins digital
	PORTA		= 0b00000000;	//all low
	TRISA		= 0b11011111;	//RA5 out
	CMCON0		= 0b00000000;	//free up T1G pin

	PIR1		= 0b00000000;	//PIR clear
	PIE1		= 0b00000000;	//all ints off
	INTCON		= 0b11000000;	//ints on, periph ints unmasked

	T1CON		= 0b00010001;	// TMR1 at Fosc/8 = 1 MHz
	T2CON		= 0b00001011;	// TMR2 at Fosc/256 = 125 KHz, overflow interrupts dithered by 2, so overflowing at 244.14 Hz (every 4 ms or so)



	rxStart();

	while(1){

		UInt16 v;
		UInt8 t;

		PWM;

		if(gRxDone){

			t = rxDecode();
			PWM;

			if(t == 0 &&										//decoded packet successfully
				gRxData[2] == 'A' && gRxData[3] == 'B' &&		//model number matches
				gRxData[4] == 'L' && gRxData[5] == '1' &&
				gRxData[6] == 0){								//button < 256

				PWM;

				switch(gRxData[7]){

					case 0:		//power button

						gBri = gBri ? 0 : 128;
						break;

					case 1:		//up

						v = gBri;
						v *= 147;
						v += 64;
						v >>= 7;
						if(v == gBri) v++;
						if(v < MIN_BRI) v = MIN_BRI;
						gBri = (v >= 0xFF) ? 0xFF : v;
						break;

					case 2:		//down

						v = gBri;
						v *= 223;
						v += 128;
						v >>= 8;
						if(v < MIN_BRI) v = 0;
						gBri = v;
						break;
				}

			}
			rxStart();
		}
	}
}

static void interrupt isr(void){

	static bit v = 0;

	if(TMR2IF){		//timeout

		TMR2IF	= 0;

		TMR2ON = 0;
		gRxDone = 1;
		CCP1CON = 0;
		CCP1IF = 0;
	}
	else if(CCP1IF){
	
		CCP1IF	= 0;	//clear this flag
	
		if(gIntFirstEdgeSeen){		//rx going on

			TMR2 = 0;
			if(CCP1CON & 1){	//begin timed period

				gIntCapturedTime = CCPR1;
			}
			else{				//end timed perioud

				gIntCapturedTime = CCPR1 - gIntCapturedTime;

				if(gIntCapturedTime > 1000ul) gRxData[gRxPos] |= gRxMask;	//one
				gRxMask >>= 1;
				if(!gRxMask){
					gRxMask = 0x80;
					gRxPos++;
		
					if(gRxPos == sizeof(gRxData)){
						CCP1CON = 0;
						gRxDone = 1;
					}
				}
			}
		}
		else{						//rx just stared

			gIntFirstEdgeSeen = 1;
			TMR2ON = 1;
			TMR2 = 0;
			TMR2IE = 1;
			TMR2IF = 0;
		}
		if(!gRxDone) CCP1CON ^= 1;		//catch other edge
	}
}