#ifndef _LOAD_H_
#define _LOAD_H_


#include <stdint.h>
#include "vfs.h"

//linker provided
extern uint32_t stack_start[];
#define MIN_SAFE_ADDR		((uintptr_t)stack_start)	//based on our linker script


struct DecPromVectors;
typedef void (*KernelEntry)(int argc, const char **argv, uint32_t magic, const struct DecPromVectors *vecs);


void loadOS(struct VfsFile *f, uint32_t fileSize, const struct DecPromVectors *vecs);		//does not return on success
bool isValidKernelName(const char *name);


#endif
