/*
#include "app.h"

//fire[r][c] = (fire[r-1][c]+file[r-2][c]+fire[r-1][c-1]+fire[r-1][c+1])*32 / 129
//bottom2 rows randomized


#define BPP			4	//powers of 2 only please
#define MINIMUM		5	//min brightness to count to be on in LED matrix

UInt8 fire[10*11*BPP/8];



static UInt8 getPixel(UInt8 r, UInt8 c){

	UInt8 pixel = r * WIDTH + c;
	UInt8 bits = pixel * BPP;
	UInt8 byte = bits >> 3;
	UInt8 off = bits & 7;
	UInt8 val;
	
	val = fire[byte] >> off;

	return val & ((1 << BPP) - 1);
}

static void setPixel(UInt8 r, UInt8 c, UInt8 v){

	UInt8 pixel = r * WIDTH + c;
	
	UInt8* fb = appBufGet(1);
	UInt8 fbByte = pixel >> 3;
	UInt8 fbBit = 1 << (pixel & 7); 

	UInt8 bits = pixel * BPP;
	UInt8 byte = bits >> 3;
	UInt8 off = bits & 7;
	UInt8 mask = ((1 << BPP) - 1) << off;
	
	fire[byte] = (fire[byte] &~ mask) | (v << off);

	if(v >= MINIMUM){
		fb[fbByte] |= fbBit;
	}
	else{
		fb[fbByte] &=~ fbBit;
	}
}

void appFire(void){

	UInt8 r, c, t;
	UInt16 v;

	while(1){
		for(r = 0; r < HEIGHT - 2; r++){
			for(c = 0; c < WIDTH; c++){
	
				v = 0;
	
				t = c ? (c - 1) : WIDTH - 1;
				v += getPixel(r + 1, t);
	
				t = (c == (WIDTH - 1)) ? 0 : c + 1;
				v += getPixel(r + 1, t);
	
				v += getPixel(r + 1, c);
				v += getPixel(r + 2, c);
	
				v *= 32;
				v /= 140;
	
				setPixel(r, c, v);
			}
		}
	
		for(; r < HEIGHT; r++){
			for(c = 0; c < WIDTH; c++){
	
				t = appGetRand();
				t &= ((1 << BPP) - 1);
				setPixel(r, c, t);
			}
		}

		appBufFlip();
	}
}


*/