#include "app.h"

#define TOROIDAL
#define GENERATIONS_OF_2_CYCLES_TO_SHOW		30


Boolean pixGet(Boolean back, UInt8 r, UInt8 c){	//read framebuffer/backcuffer

	UInt8 pixNum = (r * WIDTH) + c;
	UInt8 byteNum = pixNum >> 3;
	UInt8 bitMask = 1 << (pixNum & 7);

	return (appBufGet(back)[byteNum] & bitMask) != 0;
}

void pixSet(UInt8 r, UInt8 c, Boolean on){	//write backbuffer

	UInt8 pixNum = (r * WIDTH) + c;
	UInt8 byteNum = pixNum >> 3;
	UInt8 bitMask = 1 << (pixNum & 7);

	if(on)
		appBufGet(true)[byteNum] |= bitMask;
	else
		appBufGet(true)[byteNum] &=~ bitMask;
}

void wait(void){

	UInt8 f, cnt;

	for(cnt = 0; cnt < 6; cnt++){
	
		f = appGetFrameNo();
		while(f == appGetFrameNo());	//wait till ed of this frame
		f++;
		while(f == appGetFrameNo());	//wait till end of next frame
	}
}

Boolean pixHasLife(Int8 r, Int8 c){

	if(r == -1){
		#ifdef TOROIDAL
			r = HEIGHT - 1;
		#else
			return false;
		#endif
	}	
	if(c == -1){
		#ifdef TOROIDAL
			c = WIDTH - 1;
		#else
			return false;
		#endif
	}
	if(r == HEIGHT)	{
		#ifdef TOROIDAL
			r = 0;
		#else
			return false;
		#endif
	}	
	if(c == WIDTH)	{
		#ifdef TOROIDAL
			c = 0;
		#else
			return false;
		#endif
	}	

	return pixGet(false, r, c);

}

static void clr(void){
	UInt8 r, c;
	for(r = 0; r < HEIGHT; r++){
		for(c = 0; c < WIDTH; c++){
			pixSet(r, c, 0); 
		}
	}
}

void appLife(UInt16* startedP, UInt16* bornP, UInt16* diedP, UInt16* generationsP, UInt32* livedTimeP){

	UInt8 r, c, numCycleRounds;
	Boolean cycleFound;
	UInt16 started = 0, born = 0, died = 0, generations = 0;
	UInt32 livedTime = 0;

	//generate a random playing field (each cell has 2/8 chance of being pupulated)
	clr();
	appBufCopy();
	wait();
	for(r = 0; r < HEIGHT; r++){

		for(c = 0; c < WIDTH; c++){

			if((appGetRand() & 7) < 3){

				started++;
				pixSet(r, c, 1);
			}
		}
		appBufCopy();
		wait();
	}
	numCycleRounds = 0;
	livedTime += started;

	//play game while field isnt empty or stationary
	while(1){

		//display backbuffer
		appBufFlip();
		wait();
		

		//check if currently displayed field is empty
		for(r = 0; r < HEIGHT; r++){
			for(c = 0; c < WIDTH; c++){

				if(pixGet(false, r, c)) goto lifeFound;
			}
		}
		//life not found
		break;

	lifeFound:
		
		//generate next generation (also check for 2-cycles)
		cycleFound = true;
		for(r = 0; r < HEIGHT; r++){

			for(c = 0; c < WIDTH; c++){

				UInt8 nn = 0;

				if(pixHasLife(r - 1, c - 1)) nn++;
				if(pixHasLife(r - 1, c    )) nn++;
				if(pixHasLife(r - 1, c + 1)) nn++;
				if(pixHasLife(r    , c - 1)) nn++;
				if(pixHasLife(r    , c + 1)) nn++;
				if(pixHasLife(r + 1, c - 1)) nn++;
				if(pixHasLife(r + 1, c    )) nn++;
				if(pixHasLife(r + 1, c + 1)) nn++;

				nn = (nn == 3) || (nn == 2 && pixHasLife(r, c));	//reuse nn as boolean :)
				if(pixGet(true, r, c) != nn) cycleFound = false;
				pixSet(r, c, nn);

				if(pixHasLife(r, c) && !nn) died++;
				else if(!pixHasLife(r, c) && nn) born++;
				if(nn) livedTime++;
			}
		}
		if(cycleFound) numCycleRounds++; 

		//see if it is the same as current generation
		for(r = 0; r < HEIGHT; r++){

			for(c = 0; c < WIDTH; c++){

				if(pixGet(true, r, c) != pixGet(false, r, c)) goto lifeEvolved;
			}
		}
		//life evolution stalled
		break;

	lifeEvolved:

		generations++;

		//check cycle counter
		#ifdef GENERATIONS_OF_2_CYCLES_TO_SHOW

			if(numCycleRounds == GENERATIONS_OF_2_CYCLES_TO_SHOW) break;
		#else

			continue;
		#endif
	}
	//we're here because life stopped. wait a bit before quitting
	for(r = 0; r < 10; r++) wait();
	clr();

	if(startedP) *startedP = started;
	if(bornP) *bornP = born;
	if(diedP) *diedP = died;
	if(generationsP) *generationsP = generations;
	if(livedTimeP) *livedTimeP = livedTime;
}