/* Copyright 2013 dmitry Grinberg (http://dmitry.gr)

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

#include "common.h"
#include "LCD.h"
#include <htc.h>


void lcdInit(void)
{
	LCDCON	= 0b11010011;	//1:4 mux using Fosc/8192, off in sleep, off now, external bias
	LCDPS	= 0b00010000;	//TypeA, 1/3 bias, 1:1 clock prescaler
	LCDSE0	= 0b11111111;	//SEG0..SEG7 on
	LCDSE1	= 0b00001111;	//SEG8..SEG11 on

	//power up the bias network
	TRISA &=~ (1 << 6);
	PORTA |= (1 << 6);
}

void lcdPowerOff(void)
{
	LCDCON = 0x00;

	//power down the bias network
	PORTA &=~ (1 << 6);
}

void lcdSegSet(UInt8 seg, Boolean on)
{
	volatile UInt8* reg;
	UInt8 mask;

	switch (seg >> 2) {
		case 0:
		case 1:
			reg = &LCDDATA0;
			mask = seg;
			break;
		case 2:
			reg = &LCDDATA1;
			mask = seg - 8;
			break;
		case 3:
		case 4:
			reg = &LCDDATA3;
			mask = seg - 12;
			break;
		case 5:
			reg = &LCDDATA4;
			mask = seg - 20;
			break;
		case 6:
		case 7:
			reg = &LCDDATA6;
			mask = seg - 24;
			break;
		case 8:
			reg = &LCDDATA7;
			mask = seg - 32;
			break;
		case 9:
		case 10:
			reg = &LCDDATA9;
			mask = seg - 36;
			break;
		case 11:
			reg = &LCDDATA10;
			mask = seg - 44;
			break;
		default:
			return;
	}
	mask = 1 << mask;

	if (on) {
		*reg |= mask;
	} else {
		*reg &=~ mask;
	}
}

void lcd7segSet(UInt8 digit, UInt8 bits)
{
	digit <<= 1;

	lcdSegSet( 0 + digit + 0, (bits & 0x01) ? 1 : 0);
	lcdSegSet(12 + digit + 1, (bits & 0x02) ? 1 : 0);
	lcdSegSet(24 + digit + 1, (bits & 0x04) ? 1 : 0);
	lcdSegSet(36 + digit + 1, (bits & 0x08) ? 1 : 0);
	lcdSegSet(36 + digit + 0, (bits & 0x10) ? 1 : 0);
	lcdSegSet(12 + digit + 0, (bits & 0x20) ? 1 : 0);
	lcdSegSet(24 + digit + 0, (bits & 0x40) ? 1 : 0);
}

void lcd7segHexch(UInt8 digit, UInt8 val)
{
	static const UInt8 chars[] = {0x3F, 0x06, 0x5B, 0x4F, 0x66, 0x6D, 0x7D, 0x07, 0x7F, 0x6F, 0x77, 0x7C, 0x58, 0x5E, 0x79, 0x71};

	lcd7segSet(digit, chars[val & 0x0F]);
}
