/* Copyright 2013 dmitry Grinberg (http://dmitry.gr)

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

#define _XTAL_FREQ 	1000000	//1MHz (we'd do less, but then LCD looks funky)
#include <htc.h>
#include "common.h"
#include "LCD.h"

__CONFIG(FOSC_INTOSCIO & WDTE_OFF & PWRTE_OFF & MCLRE_ON & CP_OFF & CPD_OFF & BOREN_OFF & IESO_OFF & FCMEN_OFF & DEBUG_OFF);

static volatile UInt8 gH = 18, gM = 35, gS = 0, gT = 0;
static volatile UInt8 gBtn = 0;


static void init(void)
{
	OSCCON = 0b01000001;	//1MHz
	ANSEL = 0b00000000;		//all digital pins

	//configure button sensor (B7 is low whenbutton is down
	OPTION_REG = 0b00000110;	//pullups on, prescaler for Tmr0 at 1:128 (overflowing at Fosc/131072)
	TRISB |= 0x80;
	WPUB = 0x80;
	IOCB = 0x80;			//interrupt on change for B7
	(void)PORTB;			//read PORTB

	//configure RTC timer
	PR2 = 249;
	T2CON = 0b01001101;	//1:4 prescale, 1:10 postscale (interrupts at 25Hz)
	
	//enable RTC and button
	PIE1 = 0;
	PIE2 = 0;
	PIR1 = 0;
	PIR2 = 0;
	INTCON = 0b11101000;	//ints on: pinchange, periph, Tmr0
}

void interrupt isr(void){
	if (TMR2IF && TMR2IE){
		if(++gT == 25){
			gT = 0;
			if(++gS == 60){
				gS = 0;
				if (++gM == 60){
					gM = 0;
					if(++gH == 24) gH = 0;
				}
			}
		}
		TMR2IF = 0;
	}
	if (RBIE && RBIF){

		if (PORTB & 0x80){	//button released

			if (!T0IE)
				gBtn = 1;
			TMR0 = 0;
			T0IF = 0;
			T0IE = 1;
		}

		RBIF = 0;
	}
	if (T0IE && T0IF){
		T0IE = 0;
	}
}

static void showTime()
{
	UInt8 h, m, s;

	do{
		s = gS;
		m = gM;
		h = gH;
	} while(gS != s);

	lcd7segHexch(0, h / 10);
	lcd7segHexch(1, h % 10);
	lcd7segHexch(2, m / 10);
	lcd7segHexch(3, m % 10);
	lcd7segHexch(4, s / 10);
	lcd7segHexch(5, s % 10);
}

static void startClock(void)	//clock starts after this call
{
	TMR2IE = 0;
	gH = 0;
	gM = 0;
	gS = 0;
	gT = 0;
	TMR2IE = 1;
}

void main(void)
{
	init();


	while(1){

		lcdInit();
		//we start on and not counting (visibly)
		startClock();
		showTime();			//this will show all zeros like we want since it is right here and we have no other real ints... (kind of a race, but fuck it)
		gBtn = 0;
		while(gS < 10 && !gBtn){	//wait for timeout or button
			lcdPowerOff();
			__delay_ms(200);
			lcdInit();
			__delay_ms(200);
		}
		if (gBtn){					//timer mode
			gBtn = 0;
			startClock();
			while(!gBtn) showTime();
			gBtn = 0;
			startClock();
			while(gS < 30 && !gBtn){	//wait for timeout or button
				lcdPowerOff();
				__delay_ms(100);
				lcdInit();
				__delay_ms(300);
			}
			gBtn = 0;
		}
		
		//time to sleep
		gBtn = 0;
		lcdPowerOff();
		asm("sleep");
		__delay_ms(300);
	}
}