#ifndef _FLASHOPS_H_
#define _FLASHOPS_H_

#include <stdbool.h>
#include <stdint.h>

#define SUPPORT_FULL_CHIP_ERASE		//makes code alwyas bigger even if you do not use it. Yes, even with LTO


void flashOpsInit(void);	//necessary before any flashops calls are made

void flashWriteLatches(uint32_t offset, uint32_t len, const uint8_t *data);
void flashReadLatches(uint32_t offset, uint32_t len, uint8_t *data);
void flashEraseRow(uint32_t addr);
void flashWriteRow(uint32_t addr);

#ifdef SUPPORT_FULL_CHIP_ERASE

	void flashFullErase(void);

#endif




#endif
