#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QEvent>
#include <QKeyEvent>
#include <QSignalMapper>
#include <QComboBox>
#include <QTimer>
#include <QIcon>
#include <QMenu>
#include <QSystemTrayIcon>
#include <QSettings>
#include <QDir>

#include "qxtglobalshortcut.h"
#include "chordinterpreter.h"
#include "chord.h"
#include "editorwindow.h"


MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    this->setWindowTitle("Keypad");

    QList<chord> aa;
    this->interpreter = new chordInterpreter(aa,ui->Log);

 //   this->interpreter->setDebugLevel(2);

    dbgCombo = new QComboBox;
    dbgCombo->addItem("Log: Normal");
    dbgCombo->addItem("Log: Programs executed");
    dbgCombo->addItem("Log: Debug");
    connect(dbgCombo,SIGNAL(currentIndexChanged(int)),this,SLOT(on_debug_changed(int)));
    ui->toolBar->addWidget(dbgCombo);
    ui->actionKeyActivation->setText("Keys active");

    //Default values for plain new settings
    this->key1down="ALT+SHIFT+META+A";
    this->key1up="ALT+SHIFT+META+B";
    this->key2down="ALT+SHIFT+META+C";
    this->key2up="ALT+SHIFT+META+D";
    this->key3down="ALT+SHIFT+META+E";
    this->key3up="ALT+SHIFT+META+F";
    this->key4down="ALT+SHIFT+META+G";
    this->key4up="ALT+SHIFT+META+H";
    this->key5down="ALT+SHIFT+META+I";
    this->key5up="ALT+SHIFT+META+J";
    //Please port lines below
    settingsFile=QDir::homePath()+"/.chordsettings.rc";
    this->buttonsFile=QDir::homePath()+"/.chordkeypad.rc";

    QSettings settings(settingsFile,QSettings::IniFormat);
    settings.beginGroup("keys");
    this->key1up=settings.value("key1up",this->key1up).toString();
    this->key2up=settings.value("key2up",this->key2up).toString();
    this->key3up=settings.value("key3up",this->key3up).toString();
    this->key4up=settings.value("key4up",this->key4up).toString();
    this->key5up=settings.value("key5up",this->key5up).toString();
    this->key1down=settings.value("key1down",this->key1down).toString();
    this->key2down=settings.value("key2down",this->key2down).toString();
    this->key3down=settings.value("key3down",this->key3down).toString();
    this->key4down=settings.value("key4down",this->key4down).toString();
    this->key5down=settings.value("key5down",this->key5down).toString();
    settings.endGroup();
    settings.beginGroup("mainset");
    this->buttonsFile=settings.value("buttonsFile",this->buttonsFile).toString();
    if (settings.value("flip",0).toBool()==1)
    {
        ui->actionFlip->setChecked(1);
    }
    dbgCombo->setCurrentIndex(settings.value("debugLevel",0).toInt());
    settings.endGroup();

    this->interpreter->loadFromFile(this->buttonsFile);
    //prepare shortcuts
    this->on_actionKeyActivation_triggered(1);

    //Tray icon
    menu = new QMenu(this);
    menu->addAction(ui->actionShow_Window);
    menu->addAction(ui->actionKeyActivation);
    menu->addAction(ui->actionExit);
    trayIcon = new QSystemTrayIcon(this);
    trayIcon->setIcon(QIcon(":/icons/main.png"));
    trayIcon->setToolTip("Chord Keypad Driver");
    trayIcon->setContextMenu(menu);
    connect(trayIcon,SIGNAL(activated(QSystemTrayIcon::ActivationReason)),this,SLOT(on_tray_activated(QSystemTrayIcon::ActivationReason)));
    trayIcon->show();
    ui->Log->appendPlainText("Keypad driver, version 20160310 - Program Started\n");

}

MainWindow::~MainWindow()
{
    this->saveSettings();
    delete ui;
}

void MainWindow::on_tray_activated(QSystemTrayIcon::ActivationReason re)
{
    if (re==QSystemTrayIcon::DoubleClick)
    {
        this->on_actionShow_Window_triggered();
    }
}

void MainWindow::saveSettings()
{
    QSettings settings(settingsFile,QSettings::IniFormat);
    settings.beginGroup("keys");
    settings.setValue("key1up",this->key1up);
    settings.setValue("key2up",this->key2up);
    settings.setValue("key3up",this->key3up);
    settings.setValue("key4up",this->key4up);
    settings.setValue("key5up",this->key5up);

    settings.setValue("key1down",this->key1down);
    settings.setValue("key2down",this->key2down);
    settings.setValue("key3down",this->key3down);
    settings.setValue("key4down",this->key4down);
    settings.setValue("key5down",this->key5down);
    settings.endGroup();
    settings.beginGroup("mainset");
    settings.setValue("buttonsFile",this->buttonsFile);
    settings.setValue("flip",ui->actionFlip->isChecked());
    settings.setValue("debugLevel",this->dbgCombo->currentIndex());
    settings.endGroup();
}

//this fires every time a button is pressed or released.
//It transfers key presses to interpreter.
void MainWindow::runButton(QString button)
{
    if (ui->actionFlip->isChecked())    //implementation of flip option
    {
        if (button=="a")
            this->interpreter->stuffKey("e");
        if (button=="b")
            this->interpreter->stuffKey("d");
        if (button=="d")
            this->interpreter->stuffKey("b");
        if (button=="e")
            this->interpreter->stuffKey("a");
        if (button=="A")
            this->interpreter->stuffKey("E");
        if (button=="B")
            this->interpreter->stuffKey("D");
        if (button=="D")
            this->interpreter->stuffKey("B");
        if (button=="E")
            this->interpreter->stuffKey("A");
    }
    else
    {
        this->interpreter->stuffKey(button);
    }
}

//DON'T USE "SETENABLE" HERE!!!
//This will preserve key assosiation to root window, making the system not
//free the key shortcut. We don't want it.
void MainWindow::on_actionKeyActivation_triggered(bool checked)
{
    if (!checked)
    {
        delete this->shortcut1d;
        delete this->shortcut1u;
        delete this->shortcut2d;
        delete this->shortcut2u;
        delete this->shortcut3d;
        delete this->shortcut3u;
        delete this->shortcut4d;
        delete this->shortcut4u;
        delete this->shortcut5d;
        delete this->shortcut5u;
        ui->actionEditor->setEnabled(0);
    }
    else
    {
        signalMapper = new QSignalMapper (this) ;

        shortcut1d = new QxtGlobalShortcut(this);
        shortcut1d->setShortcut(QKeySequence::fromString(this->key1down));
        connect(shortcut1d,SIGNAL(activated()),signalMapper,SLOT(map()));

        shortcut1u = new QxtGlobalShortcut(this);
        shortcut1u->setShortcut(QKeySequence::fromString(this->key1up));
        connect(shortcut1u,SIGNAL(activated()),signalMapper,SLOT(map()));

        shortcut2d = new QxtGlobalShortcut(this);
        shortcut2d->setShortcut(QKeySequence::fromString(this->key2down));
        connect(shortcut2d,SIGNAL(activated()),signalMapper,SLOT(map()));

        shortcut2u = new QxtGlobalShortcut(this);
        shortcut2u->setShortcut(QKeySequence::fromString(this->key2up));
        connect(shortcut2u,SIGNAL(activated()),signalMapper,SLOT(map()));

        shortcut3d = new QxtGlobalShortcut(this);
        shortcut3d->setShortcut(QKeySequence::fromString(this->key3down));
        connect(shortcut3d,SIGNAL(activated()),signalMapper,SLOT(map()));

        shortcut3u = new QxtGlobalShortcut(this);
        shortcut3u->setShortcut(QKeySequence::fromString(this->key3up));
        connect(shortcut3u,SIGNAL(activated()),signalMapper,SLOT(map()));

        shortcut4d = new QxtGlobalShortcut(this);
        shortcut4d->setShortcut(QKeySequence::fromString(this->key4down));
        connect(shortcut4d,SIGNAL(activated()),signalMapper,SLOT(map()));

        shortcut4u = new QxtGlobalShortcut(this);
        shortcut4u->setShortcut(QKeySequence::fromString(this->key4up));
        connect(shortcut4u,SIGNAL(activated()),signalMapper,SLOT(map()));

        shortcut5d = new QxtGlobalShortcut(this);
        shortcut5d->setShortcut(QKeySequence::fromString(this->key5down));
        connect(shortcut5d,SIGNAL(activated()),signalMapper,SLOT(map()));

        shortcut5u = new QxtGlobalShortcut(this);
        shortcut5u->setShortcut(QKeySequence::fromString(this->key5up));
        connect(shortcut5u,SIGNAL(activated()),signalMapper,SLOT(map()));

        signalMapper->setMapping(shortcut1d,"a");
        signalMapper->setMapping(shortcut1u,"A");
        signalMapper->setMapping(shortcut2d,"b");
        signalMapper->setMapping(shortcut2u,"B");
        signalMapper->setMapping(shortcut3d,"c");
        signalMapper->setMapping(shortcut3u,"C");
        signalMapper->setMapping(shortcut4d,"d");
        signalMapper->setMapping(shortcut4u,"D");
        signalMapper->setMapping(shortcut5d,"e");
        signalMapper->setMapping(shortcut5u,"E");
        connect(signalMapper,SIGNAL(mapped(QString)),this,SLOT(runButton(QString)));
        ui->actionEditor->setEnabled(1);
    }
}

//training mode does not execute the commands, but notifies about them in log
void MainWindow::on_actionTrainingMode_triggered(bool checked)
{
    this->interpreter->setTrainingMode(checked);
}

//change debug level
void MainWindow::on_debug_changed(int index)
{
    this->interpreter->setDebugLevel(index);
}

//change "flip"
void MainWindow::on_actionFlip_triggered()
{
    this->saveSettings();
}

void MainWindow::on_actionClearLog_triggered()
{
    ui->Log->clear();
}

void MainWindow::on_actionExit_triggered()
{
    this->close();
}

void MainWindow::on_actionEditor_triggered()
{
    ui->Log->appendPlainText("Starting editor");
    EditorWindow * a = new EditorWindow(this->interpreter,this);
    a->exec();
//    this->interpreter->loadFromFile(this->buttonsFile);
}

void MainWindow::changeEvent(QEvent *event)
{
QMainWindow::changeEvent(event);
    if(event->type() == QEvent::WindowStateChange)
        if(isMinimized())
            this->hide();
}

void MainWindow::on_actionShow_Window_triggered()
{
//    this->show();
    this->showNormal();
}
