#!/bin/bash
#Ask for connecting cameras
echo "OPERATE v. 1.2    2015 MCbx"
echo "Please connect configured cameras."
echo "and press button."
read
#display info
gphoto2 --list-ports
echo "Enter port no of 1st cam"
read CAM1
echo "Enter port no of 2nd cam"
read CAM2
CAM1="usb:001,"$CAM1
CAM2="usb:001,"$CAM2
echo "Configured camera 1: "$CAM1
echo "Configured camera 2: "$CAM2
i="1"
while [ $i -lt 65535 ]
do
k=""
echo TAKING PHOTO: $i
echo Press the button or insert a to download images
read k
if [ "$k" == "a" ];
then
  break; 
  #go to retrieving
fi
echo "..."
gphoto2 --quiet --port "$CAM1" --capture-image &
gphoto2 --quiet --port "$CAM2" --capture-image &
wait
beep
i=$[$i+1]
done
echo "RETRIEVING"
while [ -d "cam1" ]
do
 echo "Delete or rename directory cam1, please"
 read
done
while [ -d "cam2" ]
do
 echo "Delete or rename directory cam2, please"
 read
done
mkdir cam1
mkdir cam2
cd cam1
gphoto2  --port "$CAM1" --get-all-files
cd ..
cd cam2
gphoto2  --port "$CAM2" --get-all-files
cd ..
echo "Please flush cameras before leaving"
echo "See you next scanning!"
