#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QtGui>
#include <QPalette>
#include <QFileDialog>
#include<QMessageBox>
#include "progbinary.h"
#include "cmath"

int progCount;
int osSize;
int charCount;
QList<progBinary> progBins;
QString RecentPath;

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    progCount=8;
    osSize=483;
    ui->setupUi(this);
    this->connect(ui->sysopSelect, SIGNAL(currentIndexChanged(int)), this,SLOT(sysopChanged(int)));
    this->connect(ui->cbborderColor, SIGNAL(currentIndexChanged(int)), this,SLOT(borderColorChanged(int)));
    this->connect(ui->cbScreenColor, SIGNAL(currentIndexChanged(int)), this,SLOT(screenColorChanged(int)));
    this->connect(ui->cbTextColor, SIGNAL(currentIndexChanged(int)), this,SLOT(textColorChanged(int)));
    this->connect(ui->menuEditor, SIGNAL(textChanged()),this,SLOT(menuTextModified()));
    QObject::connect(ui->btnSaveBin,SIGNAL(clicked()),this,SLOT(btnSaveBinPressed()));
    QObject::connect(ui->btnImportBin,SIGNAL(clicked()),this,SLOT(btnImportBinPressed()));
    QObject::connect(ui->btnPatchBin,SIGNAL(clicked()),this,SLOT(btnPatchBinPressed()));
    QObject::connect(ui->btnAdd,SIGNAL(clicked()),this,SLOT(addProgram0()));
    QObject::connect(ui->btnRemove,SIGNAL(clicked()),this,SLOT(btnRemoveClicked()));
    QObject::connect(ui->btnGenerateSingle,SIGNAL(clicked()),this,SLOT(btnGenerateSingleClicked()));
    QFontDatabase::addApplicationFont(":/fonts/cbm.ttf");
    ui->menuEditor->setFont(QFont("Commodore 64 Pixeled",8));
    QWidget *containerWidget = new QWidget;
    containerWidget->setLayout(ui->gridLayout);
    ui->scrollArea->setWidgetResizable(true);
    ui->scrollArea->setWidget(containerWidget);
    charCount=182;
    ui->label_45->setVisible(false);
    this->setFixedHeight(400);
    RecentPath="";
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::sysopChanged(int index)
{
    ui->cbbank8Key->setEnabled(false);
    ui->cbbank9Key->setEnabled(false);
    ui->cbbankAKey->setEnabled(false);
    ui->cbbankBKey->setEnabled(false);
    ui->cbbankCKey->setEnabled(false);
    ui->cbbankDKey->setEnabled(false);
    ui->cbbankEKey->setEnabled(false);
    ui->cbbankFKey->setEnabled(false);
    ui->label_45->setVisible(false);
    this->setFixedHeight(400);
    if (index==0)
    {
        progCount=1;
        osSize=184;
        ui->tab_2->setEnabled(false);
    }

    if (index==1)
    {
        progCount=8;
        osSize=483;
        ui->tab_2->setEnabled(true);
        charCount=182;
    }
    if (index==2)
    {
        progCount=16;
        osSize=640;
        ui->tab_2->setEnabled(true);
        charCount=256;
        ui->cbbank8Key->setEnabled(true);
        ui->cbbank9Key->setEnabled(true);
        ui->cbbankAKey->setEnabled(true);
        ui->cbbankBKey->setEnabled(true);
        ui->cbbankCKey->setEnabled(true);
        ui->cbbankDKey->setEnabled(true);
        ui->cbbankEKey->setEnabled(true);
        ui->cbbankFKey->setEnabled(true);
        ui->label_45->setVisible(true);
   this->setFixedHeight(450);
    }
    ui->Bank0->setValue(osSize);
    ui->Bank0->repaint();
    refreshContents();
    this->menuTextModified();
}


void MainWindow::refreshContents()
{
    ui->programy->clear();
    //pierdolnij liste
    int counter=0;
    foreach (progBinary p, progBins)
    {
        counter++;
        ui->programy->addItem(QString::number(counter)+". Off:"+QString::number(p.getOffset())+"B Len:"+QString::number(p.getData().length())+"B "+p.getFileName());
    }

    //odwie suwaki
    QProgressBar * pbars[16];
    pbars[0]=ui->Bank0;
    pbars[1]=ui->Bank1;
    pbars[2]=ui->Bank2;
    pbars[3]=ui->Bank3;
    pbars[4]=ui->Bank4;
    pbars[5]=ui->Bank5;
    pbars[6]=ui->Bank6;
    pbars[7]=ui->Bank7;
    pbars[8]=ui->Bank8;
    pbars[9]=ui->Bank9;
    pbars[10]=ui->BankA;
    pbars[11]=ui->BankB;
    pbars[12]=ui->BankC;
    pbars[13]=ui->BankD;
    pbars[14]=ui->BankE;
    pbars[15]=ui->BankF;

    QLabel * plabels[16];
    plabels[0]=ui->lBank0;
    plabels[1]=ui->lBank1;
    plabels[2]=ui->lBank2;
    plabels[3]=ui->lBank3;
    plabels[4]=ui->lBank4;
    plabels[5]=ui->lBank5;
    plabels[6]=ui->lBank6;
    plabels[7]=ui->lBank7;
    plabels[8]=ui->lBank8;
    plabels[9]=ui->lBank9;
    plabels[10]=ui->lBankA;
    plabels[11]=ui->lBankB;
    plabels[12]=ui->lBankC;
    plabels[13]=ui->lBankD;
    plabels[14]=ui->lBankE;
    plabels[15]=ui->lBankF;


    for (int i=0;i<16;i++)
    {
        pbars[i]->setValue(0);
        plabels[i]->setText("");
        pbars[i]->setStyleSheet("QProgressBar::chunk {background-color: rgb(85, 85, 127); border: 1px solid black;}");
    }
    pbars[0]->setValue(osSize);
    int ki=osSize;
    foreach (progBinary p, progBins)
    {
        int startBank = p.getOffset()/8192;
        plabels[startBank]->setText(" "+QFileInfo(p.getFileName()).fileName());
        int lenBanks = (ki+p.getData().length())/8192;
        int remainder = (ki+p.getData().length())%8192;
        ki=0;
        int k=startBank-1;
        for (int i=startBank;i<startBank+lenBanks;i++)
        {
            pbars[i]->setValue(8192);
            k=i;
        }
        pbars[k+1]->setValue(remainder);
        pbars[k+1]->setStyleSheet("QProgressBar { border: solid black; background-color: rgb(140, 140, 140);}\n QProgressBar::chunk {background-color: rgb(85, 85, 127); border: 1px solid black;}");

    }

    for (int i=0;i<16;i++)
    {
        if (ui->sysopSelect->currentIndex()==0) pbars[i]->setStyleSheet("QProgressBar { border: solid black; background-color: rgb(140, 140, 140);}\n QProgressBar::chunk {background-color: rgb(85, 85, 127); border: 1px solid black;}");
        pbars[i]->repaint();
    }
}

int roundUp(int numToRound, int multiple)
{
 if(multiple == 0)
 {
  return 0;
 }
 return ((numToRound - 1) / multiple + 1) * multiple;
}

void recompute()
{
    int sysinit=osSize;
    for (QList<progBinary>::iterator i = progBins.begin(); i!=progBins.end(); ++i)
    {
//        if (sysinit==osSize)
//        {
            (*i).setOffset(sysinit);
            sysinit=roundUp(sysinit+(*i).getData().length(),8192);
//        }
//        else
//        {
//            (*i).setOffset(sysinit);
//            sysinit=roundUp(sysinit+(*i).getData().length(),8192);
//        }
    }

}

void MainWindow::addProgram0()
{
    QString fileName = QFileDialog::getOpenFileName(this, tr("Open File"),
                                                     RecentPath,
                                                     tr("Programs (*.PRG)"));
    if (fileName=="") return;
    RecentPath=QFileInfo(fileName).path();
    progBinary tmp(fileName);

    if ((progBins.count()!=0)&&(roundUp(progBins.last().getOffset()+progBins.last().getData().length(),8192)+tmp.getData().length()>(8192*progCount)))
    {
        QMessageBox::warning(this,"Not adding!","Not adding! No free space! Move programs not to waste so much or compress!");
        return;
    }

    progBins.append(tmp);
    recompute();
    refreshContents();
    ui->btnRemove->setEnabled(true);
    ui->sysopSelect->setEnabled(false);
    if (progBins.count()==progCount)
    {
        ui->btnAdd->setEnabled(false);
    }
}

void MainWindow::btnRemoveClicked()
{
    if (ui->programy->selectedItems().count()==0)
    {
        return;
    }
    int j=ui->programy->currentIndex().row();
    progBins.removeAt(j);
    ui->btnAdd->setEnabled(true);
    if (progBins.count()==0) ui->sysopSelect->setEnabled(true);
    recompute();
    refreshContents();
}

void MainWindow::borderColorChanged(int index)
{
switch (index)
{
 case 0:
    ui->screen->setStyleSheet("background-color : #000000;");
     ui->screen2->setStyleSheet("background-color : #000000;");
    break;
case 1:
   ui->screen->setStyleSheet("background-color : #FFFFFF;");
   ui->screen2->setStyleSheet("background-color : #FFFFFF;");
   break;
case 2:
   ui->screen->setStyleSheet("background-color : #883932;");
   ui->screen2->setStyleSheet("background-color : #883932;");
   break;
case 3:
   ui->screen->setStyleSheet("background-color : #67b6bd;");
   ui->screen2->setStyleSheet("background-color : #67b6bd;");
   break;
case 4:
   ui->screen->setStyleSheet("background-color : #8b3f96;");
   ui->screen2->setStyleSheet("background-color : #8b3f96;");
   break;
case 5:
  ui->screen->setStyleSheet("background-color : #55a049;");
  ui->screen2->setStyleSheet("background-color : #55a049;");
  break;
case 6:
  ui->screen->setStyleSheet("background-color : #40318d;");
  ui->screen2->setStyleSheet("background-color : #40318d;");
  break;
case 7:
  ui->screen->setStyleSheet("background-color : #bfce72;");
  ui->screen2->setStyleSheet("background-color : #bfce72;");
  break;
case 8:
   ui->screen->setStyleSheet("background-color : #8b5429;");
   ui->screen2->setStyleSheet("background-color : #8b5429;");
   break;
case 9:
  ui->screen->setStyleSheet("background-color : #574200;");
  ui->screen2->setStyleSheet("background-color : #574200;");
  break;
case 10:
  ui->screen->setStyleSheet("background-color : #b86962;");
  ui->screen2->setStyleSheet("background-color : #b86962;");
  break;
case 11:
  ui->screen->setStyleSheet("background-color : #505050;");
  ui->screen2->setStyleSheet("background-color : #505050;");
  break;
case 12:
   ui->screen->setStyleSheet("background-color : #787878;");
   ui->screen2->setStyleSheet("background-color : #787878;");
   break;
case 13:
  ui->screen->setStyleSheet("background-color : #94e089;");
  ui->screen2->setStyleSheet("background-color : #94e089;");
  break;
case 14:
  ui->screen->setStyleSheet("background-color : #7869c4;");
  ui->screen2->setStyleSheet("background-color : #7869c4;");
  break;
case 15:
  ui->screen->setStyleSheet("background-color : #9f9f9f;");
  ui->screen2->setStyleSheet("background-color : #9f9f9f;");
  break;
}
}

void MainWindow::screenColorChanged(int index)
{
    QPalette p = ui->menuEditor->palette();
   switch (index)
{
    case 0:
       p.setColor(QPalette::Base,QColor::fromRgb(0x000000));
       break;
   case 1:
       p.setColor(QPalette::Base,QColor::fromRgb(0xFFFFFF));
      break;
   case 2:
        p.setColor(QPalette::Base,QColor::fromRgb(0x883932));
      break;
   case 3:
        p.setColor(QPalette::Base,QColor::fromRgb(0x67b6bd));
      break;
   case 4:
      p.setColor(QPalette::Base,QColor::fromRgb(0x8b3f96));
      break;
   case 5:
        p.setColor(QPalette::Base,QColor::fromRgb(0x55a049));
     break;
   case 6:
        p.setColor(QPalette::Base,QColor::fromRgb(0x40318d));
     break;
   case 7:
        p.setColor(QPalette::Base,QColor::fromRgb(0xbfce72));
     break;
   case 8:
        p.setColor(QPalette::Base,QColor::fromRgb(0x8b5429));
      break;
   case 9:
        p.setColor(QPalette::Base,QColor::fromRgb(0x574200));
     break;
   case 10:
        p.setColor(QPalette::Base,QColor::fromRgb(0xb86962));
     break;
   case 11:
        p.setColor(QPalette::Base,QColor::fromRgb(0x505050));
     break;
   case 12:
        p.setColor(QPalette::Base,QColor::fromRgb(0x787878));
      break;
   case 13:
        p.setColor(QPalette::Base,QColor::fromRgb(0x94e089));
     break;
   case 14:
        p.setColor(QPalette::Base,QColor::fromRgb(0x7869c4));
     break;
   case 15:
        p.setColor(QPalette::Base,QColor::fromRgb(0x9f9f9f));
     break;
   }
    ui->menuEditor->setPalette(p);
}

void MainWindow::textColorChanged(int index)
{
    QPalette p = ui->menuEditor->palette();
    switch (index)
    {
    case 0:
       p.setColor(QPalette::Text,QColor::fromRgb(0x000000));
       break;
   case 1:
       p.setColor(QPalette::Text,QColor::fromRgb(0xFFFFFF));
      break;
   case 2:
        p.setColor(QPalette::Text,QColor::fromRgb(0x883932));
      break;
   case 3:
        p.setColor(QPalette::Text,QColor::fromRgb(0x67b6bd));
      break;
   case 4:
      p.setColor(QPalette::Text,QColor::fromRgb(0x8b3f96));
      break;
   case 5:
        p.setColor(QPalette::Text,QColor::fromRgb(0x55a049));
     break;
   case 6:
        p.setColor(QPalette::Text,QColor::fromRgb(0x40318d));
     break;
   case 7:
        p.setColor(QPalette::Text,QColor::fromRgb(0xbfce72));
     break;
   case 8:
        p.setColor(QPalette::Text,QColor::fromRgb(0x8b5429));
      break;
   case 9:
        p.setColor(QPalette::Text,QColor::fromRgb(0x574200));
     break;
   case 10:
        p.setColor(QPalette::Text,QColor::fromRgb(0xb86962));
     break;
   case 11:
        p.setColor(QPalette::Text,QColor::fromRgb(0x505050));
     break;
   case 12:
        p.setColor(QPalette::Text,QColor::fromRgb(0x787878));
      break;
   case 13:
        p.setColor(QPalette::Text,QColor::fromRgb(0x94e089));
     break;
   case 14:
        p.setColor(QPalette::Text,QColor::fromRgb(0x7869c4));
     break;
   case 15:
        p.setColor(QPalette::Text,QColor::fromRgb(0x9f9f9f));
     break;
    }
    ui->menuEditor->setPalette(p);
}

void MainWindow::menuTextModified()
{
    int k= ui->menuEditor->document()->characterCount();
    ui->lbcharAvailable->setText(QString::number(charCount-k));
    if (charCount-k<0)
    {
        ui->lbcharAvailable->setStyleSheet("background-color: rgb(255, 0, 0);");
        ui->lbcharAvailable->setToolTip("Will be truncated!");
    }
    else
    {
        ui->lbcharAvailable->setStyleSheet("");
        ui->lbcharAvailable->setToolTip("Seems OK.");
    }
}

QByteArray MainWindow::GenerateSysOp216()
{
    QFile binary(":/os/sys216.bin");
    binary.open(QIODevice::ReadOnly);
    QByteArray os = binary.readAll();
    binary.close();
    os[88]=(char) ui->cbborderColor->currentIndex();
    os[93]=(char) ui->cbScreenColor->currentIndex() & 0xFF;
    os[105]=(char) ui->cbTextColor->currentIndex() & 0xFF;
    os[180]=(char) ui->cbbank0Key->currentIndex() & 0xFF;
    os[184]=(char) ui->cbbank1Key->currentIndex() & 0xFF;
    os[124]=(char) ui->cbbank2Key->currentIndex() & 0xFF;
    os[128]=(char) ui->cbbank3Key->currentIndex() & 0xFF;
    os[132]=(char) ui->cbbank4Key->currentIndex() & 0xFF;
    os[136]=(char) ui->cbbank5Key->currentIndex() & 0xFF;
    os[140]=(char) ui->cbbank6Key->currentIndex() & 0xFF;
    os[144]=(char) ui->cbbank7Key->currentIndex() & 0xFF;
    os[148]=(char) ui->cbbank8Key->currentIndex() & 0xFF;
    os[152]=(char) ui->cbbank9Key->currentIndex() & 0xFF;
    os[156]=(char) ui->cbbankAKey->currentIndex() & 0xFF;
    os[160]=(char) ui->cbbankBKey->currentIndex() & 0xFF;
    os[164]=(char) ui->cbbankCKey->currentIndex() & 0xFF;
    os[168]=(char) ui->cbbankDKey->currentIndex() & 0xFF;
    os[172]=(char) ui->cbbankEKey->currentIndex() & 0xFF;
    os[176]=(char) ui->cbbankFKey->currentIndex() & 0xFF;

    QString menuText = ui->menuEditor->toPlainText();
    menuText.truncate(255);
    menuText=menuText.leftJustified(255,' ');
    menuText=menuText.replace("\n",(QChar)0x0D);
    for (int i=0;i<255;i++)
    {
        os[384+i]=menuText[i].toAscii();
    }
    return os;
}


QByteArray MainWindow::GenerateSysOp28()
{
    QFile binary(":/os/sys28.bin");
    binary.open(QIODevice::ReadOnly);
    QByteArray os = binary.readAll();
    binary.close();
    os[88]=(char) ui->cbborderColor->currentIndex();
    os[93]=(char) ui->cbScreenColor->currentIndex() & 0xFF;
    os[105]=(char) ui->cbTextColor->currentIndex() & 0xFF;
    os[121]=(char) ui->cbbank0Key->currentIndex() & 0xFF;
    os[125]=(char) ui->cbbank1Key->currentIndex() & 0xFF;
    os[129]=(char) ui->cbbank2Key->currentIndex() & 0xFF;
    os[133]=(char) ui->cbbank3Key->currentIndex() & 0xFF;
    os[137]=(char) ui->cbbank4Key->currentIndex() & 0xFF;
    os[141]=(char) ui->cbbank5Key->currentIndex() & 0xFF;
    os[145]=(char) ui->cbbank6Key->currentIndex() & 0xFF;
    os[149]=(char) ui->cbbank7Key->currentIndex() & 0xFF;

    QString menuText = ui->menuEditor->toPlainText();
    menuText.truncate(181);
    menuText=menuText.leftJustified(181,' ');
    menuText=menuText.replace("\n",(QChar)0x0D);
    for (int i=0;i<181;i++)
    {
        os[301+i]=menuText[i].toAscii();
    }
    return os;
}

void MainWindow::btnSaveBinPressed()
{
    QString fileName = QFileDialog::getSaveFileName(this,"Save modified OS",RecentPath,"Binary (*.bin);;All files (*)");
    if (fileName=="") return;
    RecentPath=QFileInfo(fileName).path();
    QFile outfile(fileName);
    if (!outfile.open(QIODevice::WriteOnly))
    {
        QMessageBox::critical(this,"Cannot open!","Cannot open file for writing!",QMessageBox::Ok);
        return;
    }
    if (ui->sysopSelect->currentIndex()==2)
    {
        outfile.write(GenerateSysOp216());
    }
    if (ui->sysopSelect->currentIndex()==1)
    {
    outfile.write(GenerateSysOp28());
    }
    outfile.close();
}

void MainWindow::btnImportBinPressed()
{
    QString fileName = QFileDialog::getOpenFileName(this,"Load binary",RecentPath,"Binary (*.bin);;All files (*)");
    if (fileName=="") return;
    RecentPath=QFileInfo(fileName).path();
    QFile inFile (fileName);
    if (!inFile.open(QIODevice::ReadOnly))
    {
        QMessageBox::critical(this,"Cannot open!","Cannot open file for reading!",QMessageBox::Ok);
        return;
    }
    QString mText="";

    if (ui->sysopSelect->currentIndex()==1)
    {
        QByteArray acquired = inFile.read(483);
        inFile.close();

        if (acquired[72]!=(char)227)
        {
            if (QMessageBox::No == QMessageBox::question(this, "Warning", "It doesn't look like SysOp 2.8 image. Do you want to try to load it unconditionally?", QMessageBox::Yes|QMessageBox::No))
            {
                return;
            }
        }

    ui->cbborderColor->setCurrentIndex(acquired[88]);
    ui->cbScreenColor->setCurrentIndex(acquired[93]);
    ui->cbTextColor->setCurrentIndex(acquired[105]);
    ui->cbbank0Key->setCurrentIndex(acquired[121]);
    ui->cbbank1Key->setCurrentIndex(acquired[125]);
    ui->cbbank2Key->setCurrentIndex(acquired[129]);
    ui->cbbank3Key->setCurrentIndex(acquired[133]);
    ui->cbbank4Key->setCurrentIndex(acquired[137]);
    ui->cbbank5Key->setCurrentIndex(acquired[141]);
    ui->cbbank6Key->setCurrentIndex(acquired[145]);
    ui->cbbank7Key->setCurrentIndex(acquired[149]);
    for (int i=0;i<181;i++)
    {
        mText=mText+acquired[301+i];
    }
    mText=mText.replace((QChar)0x0D,"\n");
    //mText = mText.trimmed();
    while(mText.endsWith( ' ' )) mText.chop(1);
    }

    if (ui->sysopSelect->currentIndex()==2)
    {
        QByteArray acquired = inFile.read(640);
        inFile.close();

        if (acquired[72]!=(char)128)
        {
            if (QMessageBox::No == QMessageBox::question(this, "Warning", "It doesn't look like SysOp 2.16 image. Do you want to try to load it unconditionally?", QMessageBox::Yes|QMessageBox::No))
            {
                return;
            }
        }

    ui->cbborderColor->setCurrentIndex(acquired[88]);
    ui->cbScreenColor->setCurrentIndex(acquired[93]);
    ui->cbTextColor->setCurrentIndex(acquired[105]);
    ui->cbbank0Key->setCurrentIndex(acquired[180]);
    ui->cbbank1Key->setCurrentIndex(acquired[184]);
    ui->cbbank2Key->setCurrentIndex(acquired[124]);
    ui->cbbank3Key->setCurrentIndex(acquired[128]);
    ui->cbbank4Key->setCurrentIndex(acquired[132]);
    ui->cbbank5Key->setCurrentIndex(acquired[136]);
    ui->cbbank6Key->setCurrentIndex(acquired[140]);
    ui->cbbank7Key->setCurrentIndex(acquired[144]);
    ui->cbbank8Key->setCurrentIndex(acquired[148]);
    ui->cbbank9Key->setCurrentIndex(acquired[152]);
    ui->cbbankAKey->setCurrentIndex(acquired[156]);
    ui->cbbankBKey->setCurrentIndex(acquired[160]);
    ui->cbbankCKey->setCurrentIndex(acquired[164]);
    ui->cbbankDKey->setCurrentIndex(acquired[168]);
    ui->cbbankEKey->setCurrentIndex(acquired[172]);
    ui->cbbankFKey->setCurrentIndex(acquired[176]);
    for (int i=0;i<255;i++)
    {
        mText=mText+acquired[384+i];
    }
    mText=mText.replace((QChar)0x0D,"\n");
    //mText = mText.trimmed();
    while(mText.endsWith( ' ' )) mText.chop(1);
    }

    ui->menuEditor->clear();
    ui->menuEditor->insertPlainText(mText);
}

void MainWindow::btnPatchBinPressed()
{
    QString fileName = QFileDialog::getOpenFileName(this,"Load binary",RecentPath,"Binary (*.bin);;All files (*)");
    if (fileName=="") return;
    RecentPath=QFileInfo(fileName).path();
    QFile inFile (fileName);
    if (!inFile.open(QIODevice::ReadOnly))
    {
        QMessageBox::critical(this,"Cannot open!","Cannot open file for reading!",QMessageBox::Ok);
        return;
    }
    QByteArray os = inFile.readAll();
    inFile.close();

    if (ui->sysopSelect->currentIndex()==1)
    {

        if (os[72]!=(char)227)
        {
            if (QMessageBox::No == QMessageBox::question(this, "Warning", "It doesn't look like SysOp 2.8 image. Do you want to try to load it unconditionally?", QMessageBox::Yes|QMessageBox::No))
            {
                return;
            }
        }

    os[88]=(char) ui->cbborderColor->currentIndex();
    os[93]=(char) ui->cbScreenColor->currentIndex() & 0xFF;
    os[105]=(char) ui->cbTextColor->currentIndex() & 0xFF;
    os[121]=(char) ui->cbbank0Key->currentIndex() & 0xFF;
    os[125]=(char) ui->cbbank1Key->currentIndex() & 0xFF;
    os[129]=(char) ui->cbbank2Key->currentIndex() & 0xFF;
    os[133]=(char) ui->cbbank3Key->currentIndex() & 0xFF;
    os[137]=(char) ui->cbbank4Key->currentIndex() & 0xFF;
    os[141]=(char) ui->cbbank5Key->currentIndex() & 0xFF;
    os[145]=(char) ui->cbbank6Key->currentIndex() & 0xFF;
    os[149]=(char) ui->cbbank7Key->currentIndex() & 0xFF;
    QString menuText = ui->menuEditor->toPlainText();
    menuText.truncate(181);
    menuText=menuText.leftJustified(181,' ');
    menuText=menuText.replace("\n",(QChar)0x0D);
    for (int i=0;i<181;i++)
    {
        os[301+i]=menuText[i].toAscii();
    }
    }

    if (ui->sysopSelect->currentIndex()==2)
    {
        if (os[72]!=(char)128)
        {
            if (QMessageBox::No == QMessageBox::question(this, "Warning", "It doesn't look like SysOp 2.16 image. Do you want to try to load it unconditionally?", QMessageBox::Yes|QMessageBox::No))
            {
                return;
            }
        }

    os[88]=(char) ui->cbborderColor->currentIndex();
    os[93]=(char) ui->cbScreenColor->currentIndex() & 0xFF;
    os[105]=(char) ui->cbTextColor->currentIndex() & 0xFF;
    os[180]=(char) ui->cbbank0Key->currentIndex() & 0xFF;
    os[184]=(char) ui->cbbank1Key->currentIndex() & 0xFF;
    os[124]=(char) ui->cbbank2Key->currentIndex() & 0xFF;
    os[128]=(char) ui->cbbank3Key->currentIndex() & 0xFF;
    os[132]=(char) ui->cbbank4Key->currentIndex() & 0xFF;
    os[136]=(char) ui->cbbank5Key->currentIndex() & 0xFF;
    os[140]=(char) ui->cbbank6Key->currentIndex() & 0xFF;
    os[144]=(char) ui->cbbank7Key->currentIndex() & 0xFF;
    os[148]=(char) ui->cbbank8Key->currentIndex() & 0xFF;
    os[152]=(char) ui->cbbank9Key->currentIndex() & 0xFF;
    os[156]=(char) ui->cbbankAKey->currentIndex() & 0xFF;
    os[160]=(char) ui->cbbankBKey->currentIndex() & 0xFF;
    os[164]=(char) ui->cbbankCKey->currentIndex() & 0xFF;
    os[168]=(char) ui->cbbankDKey->currentIndex() & 0xFF;
    os[172]=(char) ui->cbbankEKey->currentIndex() & 0xFF;
    os[176]=(char) ui->cbbankFKey->currentIndex() & 0xFF;
    QString menuText = ui->menuEditor->toPlainText();
    menuText.truncate(255);
    menuText=menuText.leftJustified(255,' ');
    menuText=menuText.replace("\n",(QChar)0x0D);
    for (int i=0;i<255;i++)
    {
        os[384+i]=menuText[i].toAscii();
    }
    }


    fileName = QFileDialog::getSaveFileName(this,"Save patched OS","","Binary (*.bin);;All files (*)");
    if (fileName=="") return;
    QFile outfile(fileName);
    if (!outfile.open(QIODevice::WriteOnly))
    {
        QMessageBox::critical(this,"Cannot open!","Cannot open file for writing!",QMessageBox::Ok);
        return;
    }
    outfile.write(os);
    outfile.close();

}

void MainWindow::btnGenerateSingleClicked()
{
    QString    fileName = QFileDialog::getSaveFileName(this,"Save OS",RecentPath,"Binary (*.bin);;All files (*)");
    if (fileName=="") return;
    RecentPath=QFileInfo(fileName).path();
    QByteArray rom=GenerateSysOp28();
    if (ui->sysopSelect->currentIndex()==2)
    {
        rom=GenerateSysOp216();
    }
    if (ui->sysopSelect->currentIndex()==0)
    {
        QFile binary(":/os/wegi.bin");
        binary.open(QFile::ReadOnly);
        rom = binary.readAll();
        binary.close();
    }

    char padWith=(char)0x00;
    if (ui->cbPadFF->isChecked())
    {
        padWith=(char)0xFF;
    }

    foreach (progBinary p,progBins)
    {
        rom=rom+p.getData();
        while (rom.length()<roundUp(p.getOffset()+p.getData().length(),8192))
        {
            rom=rom+padWith;
        }
    }

    while (rom.length()<8192*progCount)
    {
        rom=rom+padWith;
    }
    QByteArray tmp=rom;
    for (int i=1;i<pow(2.0,ui->cbCompileRepeat->currentIndex());i++)
    {
    rom=rom+tmp;
    }

    if (ui->cbCompileParity->currentIndex()==1)
    {
     QByteArray even;
     QByteArray odd;
     for (int i=0;i<rom.length();i++)
     {
         if (i%2==0)
         {
             even+=rom[i];
         } else
         {
             odd+=rom[i];
         }
     }
     QFile plik(fileName+".odd");
     plik.open(QFile::WriteOnly);
     plik.write(odd);
     plik.close();
     QFile plik2(fileName+".even");
     plik2.open(QFile::WriteOnly);
     plik2.write(even);
     plik2.close();


    } else
    {
       QFile plik(fileName);
       plik.open(QFile::WriteOnly);
       plik.write(rom);
       plik.close();
    }

}
