#ifndef XFree86LOADER
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/sysmacros.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#endif

#include "galproto.h"
#include "galapi.h"

/*
 * Compile time constants
 */
#define FBDEV_NAME  "/dev/nscgal"

/*
 * Cool Macros to access the structures
 */
#define INIT_GAL(x) \
       ((GAL_BASE *)(x))->dwSignature = FBGAL_SIGNATURE;\
       ((GAL_BASE *)(x))->dwSize = sizeof(x);\
       ((GAL_BASE *)(x))->dwVersion = FBGAL_VERSION;


/*
 * Variables public for this file
 */

static int ifbdev_handle;

int create_devicenode()
{
#if 1
    FILE *pfdevices;
    char line[200], devname[200];
    int majdev;

      /* remove fails if device is open */
    remove("/dev/nscgal");
    
    if ((pfdevices = fopen("/proc/devices","r")))
    {
        while(fgets(line, sizeof(line), pfdevices))
        {
            if (sscanf(line, "%d%*[ \t]%s", &majdev, devname) == 2)
            {
                if (strstr(devname, "nscgal"))
                    mknod("/dev/nscgal", S_IFCHR|S_IRUSR|S_IWUSR, makedev(majdev,0));       
            }
        }
        fclose(pfdevices);
    }
    return 1;
#endif
}


BOOLEAN Gal_initialize_interface()
{
    create_devicenode();

    if ((ifbdev_handle = open(FBDEV_NAME, O_RDONLY)) == -1)
        return 0;
    return 1;
}

BOOLEAN Gal_cleanup_interface()
{
    if (ifbdev_handle != -1)
        close(ifbdev_handle);
    return 1;
}

BOOLEAN Gal_get_adapter_info(PGALAPP_ADAPTERINFO psInfo)
{
    GAL_GETADAPTERINFO sAdapterInfo;
    
    INIT_GAL(&sAdapterInfo);
    sAdapterInfo.dwSubfunction = GALFN_GETADAPTERINFO;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sAdapterInfo))
        return 0;
    else
    {
        *psInfo = sAdapterInfo.sAppInfo;
        return 1;
    }   
}

BOOLEAN Gal_set_softvga_state(BOOLEAN bEnable)
{
    GAL_SOFTVGASTATE sSoftVgaState;
    
    INIT_GAL(&sSoftVgaState);
    sSoftVgaState.dwSubfunction = GALFN_SETSOFTVGASTATE;
    sSoftVgaState.bSoftVgaEnable = bEnable;
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sSoftVgaState))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_is_display_mode_supported(int xres, int yres, int bpp, int hz,
                                  int *supported)
{
    GAL_DISPLAYMODE sDisplayMode;
    
    *supported = 0;

    INIT_GAL(&sDisplayMode);
    sDisplayMode.dwSubfunction = GALFN_ISDISPLAYMODESUPPORTED;
    sDisplayMode.wXres = xres;
    sDisplayMode.wYres = yres;
    sDisplayMode.wBpp = bpp;
    sDisplayMode.wRefresh = hz;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sDisplayMode))
        return 0;
    else
    {
        *supported = sDisplayMode.dwSupported;
        return 1;
    }
}

BOOLEAN Gal_set_display_mode(int xres, int yres, int bpp, int hz)
{
    GAL_DISPLAYMODE sDisplayMode;
    
    INIT_GAL(&sDisplayMode);
    sDisplayMode.dwSubfunction = GALFN_SETDISPLAYMODE;
    sDisplayMode.wXres = xres;
    sDisplayMode.wYres = yres;
    sDisplayMode.wBpp = bpp;
    sDisplayMode.wRefresh = hz;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sDisplayMode))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_get_display_mode(int *xres, int *yres, int *bpp, int *hz)
{
    GAL_DISPLAYMODE sDisplayMode;
    
    INIT_GAL(&sDisplayMode);
    sDisplayMode.dwSubfunction = GALFN_GETDISPLAYMODE;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sDisplayMode))
        return 0;
    else
    {
        *xres = sDisplayMode.wXres;   
        *yres = sDisplayMode.wYres;   
        *bpp = sDisplayMode.wBpp;    
        *hz = sDisplayMode.wRefresh;
        
        return 1;
    }
}

BOOLEAN Gal_set_display_bpp(unsigned short bpp)
{
    GAL_DISPLAYPARAMS sDisplayParams;
    
    INIT_GAL(&sDisplayParams);
    sDisplayParams.dwSubfunction = GALFN_SETDISPLAYBPP;
    sDisplayParams.wBpp = bpp;
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sDisplayParams))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_get_display_bpp(unsigned short *bpp)
{
    GAL_DISPLAYPARAMS sDisplayParams;
    
    INIT_GAL(&sDisplayParams);
    sDisplayParams.dwSubfunction = GALFN_GETDISPLAYBPP;

    if (ioctl(ifbdev_handle, FBIOGAL_API, &sDisplayParams))
        return 0;
    else
    {
        *bpp = sDisplayParams.wBpp;
        return 1;
    }
}

BOOLEAN Gal_set_display_pitch(unsigned short pitch)
{
    GAL_DISPLAYPARAMS sDisplayParams;
    
    INIT_GAL(&sDisplayParams);
    sDisplayParams.dwSubfunction = GALFN_SETDISPLAYPITCH;
    
    sDisplayParams.wPitch = pitch;
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sDisplayParams))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_get_display_pitch(unsigned short *pitch)
{
    GAL_DISPLAYPARAMS sDisplayParams;
    
    INIT_GAL(&sDisplayParams);
    sDisplayParams.dwSubfunction = GALFN_GETDISPLAYPITCH;

    if (ioctl(ifbdev_handle, FBIOGAL_API, &sDisplayParams))
        return 0;
    else
    {
        *pitch = sDisplayParams.wPitch;
        return 1;
    }
}

BOOLEAN Gal_set_display_offset(unsigned long offset)
{
    GAL_DISPLAYPARAMS sDisplayParams;
    
    INIT_GAL(&sDisplayParams);
    sDisplayParams.dwSubfunction = GALFN_SETDISPLAYOFFSET;
    
    sDisplayParams.dwOffset = offset;
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sDisplayParams))
        return 0;
    else
        return 1;    
}

BOOLEAN Gal_get_display_offset(unsigned long *offset)
{
    GAL_DISPLAYPARAMS sDisplayParams;
    
    INIT_GAL(&sDisplayParams);
    sDisplayParams.dwSubfunction = GALFN_GETDISPLAYOFFSET;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sDisplayParams))
        return 0;
    else
    {
        *offset = sDisplayParams.dwOffset;
        return 1;
    }
}

BOOLEAN Gal_get_refreshrate_from_dotclock(int xres, int yres, int bpp, 
                                       int *hz, unsigned long frequency)
{
    GAL_DOTCLKTOREFRESH sDclkToRefresh;
    
    INIT_GAL(&sDclkToRefresh);
    sDclkToRefresh.dwSubfunction = GALFN_DOTCLKTOREFRESH;
    sDclkToRefresh.wXres = xres;
    sDclkToRefresh.wYres = yres;
    sDclkToRefresh.wBpp = bpp;
    sDclkToRefresh.dwDotClock = frequency;
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sDclkToRefresh))
        return 0;
    else
    {
        *hz = sDclkToRefresh.wRefreshRate;
        return 1;
    }
}

BOOLEAN Gal_get_display_timing(PGALAPP_DISPLAYTIMING pTimings)
{
    GAL_DISPLAYTIMING sDisplayTiming;
    
    INIT_GAL(&sDisplayTiming);
    sDisplayTiming.dwSubfunction = GALFN_GETDISPLAYTIMINGS;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sDisplayTiming))
        return 0;
    else
    {
        *pTimings = sDisplayTiming.sAppTiming;
        return 1;
    }
}

BOOLEAN Gal_set_display_timing(PGALAPP_DISPLAYTIMING pTimings)
{
    GAL_DISPLAYTIMING sDisplayTiming;
    
    INIT_GAL(&sDisplayTiming);
    sDisplayTiming.dwSubfunction = GALFN_SETDISPLAYTIMINGS;
    sDisplayTiming.sAppTiming = *pTimings;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sDisplayTiming))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_set_display_palette(PGALAPP_PALETTE pPalette)
{
    GAL_PALETTE sPalette;
    
    INIT_GAL(&sPalette);
    sPalette.dwSubfunction = GALFN_SETPALETTE;
    sPalette.sAppData = *pPalette;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sPalette))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_wait_until_idle(void)
{
    GAL_WAITUNTILIDLE sWaitIdle;
    
    INIT_GAL(&sWaitIdle);
    sWaitIdle.dwSubfunction = GALFN_WAITUNTILIDLE;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sWaitIdle))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_wait_vertical_blank(void)
{
    GAL_WAITVERTICALBLANK sWaitVerticalBlank;
    
    INIT_GAL(&sWaitVerticalBlank);
    sWaitVerticalBlank.dwSubfunction = GALFN_WAITVERTICALBLANK;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sWaitVerticalBlank))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_set_cursor_enable(int enable)
{
    GAL_SETCURSORENABLE sCursorEnable;
    
    INIT_GAL(&sCursorEnable);
    sCursorEnable.dwSubfunction = GALFN_SETCURSORENABLE;
    sCursorEnable.bCursorEnable = enable ? 1 : 0;
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sCursorEnable))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_set_cursor_position(unsigned long memoffset, 
                             unsigned short xpos, unsigned short ypos, 
                             unsigned short xhotspot, unsigned short yhotspot)
{
    GAL_SETCURSORPOSITION sCursorPos;
    
    INIT_GAL(&sCursorPos);
    sCursorPos.dwSubfunction = GALFN_SETCURSORPOSITION;
    sCursorPos.dwMemOffset = memoffset;
    sCursorPos.wXPos = xpos;
    sCursorPos.wYPos = ypos;
    sCursorPos.wXHot = xhotspot;
    sCursorPos.wYHot = yhotspot;
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sCursorPos))
        return 0;
    else
        return 1;
}


BOOLEAN Gal_set_cursor_shape32(unsigned long memoffset, 
                            unsigned long *andmask, unsigned long *xormask)
{
    GAL_SETCURSORSHAPE sCursorShape;
    
    INIT_GAL(&sCursorShape);
    sCursorShape.dwSubfunction = GALFN_SETCURSORSHAPE;
    sCursorShape.dwMemOffset = memoffset;
    
    memcpy(sCursorShape.dwAndMask, andmask, 
           sizeof(sCursorShape.dwAndMask));

    memcpy(sCursorShape.dwXorMask, xormask, 
           sizeof(sCursorShape.dwXorMask));
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sCursorShape))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_set_cursor_colors(unsigned long bkcolor, unsigned long fgcolor)
{
    GAL_SETCURSORCOLORS sCursorColor;
    
    INIT_GAL(&sCursorColor);
    sCursorColor.dwSubfunction = GALFN_SETCURSORCOLORS;
    sCursorColor.dwBgColor = bkcolor;
    sCursorColor.dwFgColor = fgcolor;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sCursorColor))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_set_solid_pattern(unsigned long color)
{
    GAL_SETSOLIDPATTERN sSetSoildPat;
    
    INIT_GAL(&sSetSoildPat);
    sSetSoildPat.dwSubfunction = GALFN_SETSOLIDPATTERN;
    sSetSoildPat.dwColor = color;
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sSetSoildPat))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_set_solid_source(unsigned long color)
{
    GAL_SETSOLIDSOURCE sSetSolidSrc;

    INIT_GAL(&sSetSolidSrc);
    sSetSolidSrc.dwSubfunction = GALFN_SETSOLIDSOURCE;
    sSetSolidSrc.dwColor = color;
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sSetSolidSrc))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_set_mono_pattern(unsigned long bgcolor, unsigned long fgcolor, 
                          unsigned long data0, unsigned long data1, 
                          unsigned char transparency)
{
    GAL_SETMONOPATTERN sSetMonoPat;
    
    INIT_GAL(&sSetMonoPat);
    sSetMonoPat.dwSubfunction = GALFN_SETMONOPATTERN;
    sSetMonoPat.dwFgColor = fgcolor;
    sSetMonoPat.dwBgColor = bgcolor;
    sSetMonoPat.dwData0 = data0;
    sSetMonoPat.dwData1 = data1;
    sSetMonoPat.cTransparency = transparency;
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sSetMonoPat))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_set_raster_operation(unsigned char rop)
{
    GAL_SETRASTEROPERATION sSetRop;
        
    INIT_GAL(&sSetRop);
    sSetRop.dwSubfunction = GALFN_SETRASTEROPERATION;
    sSetRop.cRop = rop;
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sSetRop))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_pattern_fill(unsigned short x, unsigned short y, 
                      unsigned short width, unsigned short height)
{
    GAL_PATTERNFILL sPatternFill;
    
    INIT_GAL(&sPatternFill);
    sPatternFill.dwSubfunction = GALFN_PATTERNFILL;
    sPatternFill.wXPos = x;
    sPatternFill.wYPos = y;
    sPatternFill.wWidth = width;
    sPatternFill.wHeight = height;

    if (ioctl(ifbdev_handle, FBIOGAL_API, &sPatternFill))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_screen_to_screen_blt(unsigned short srcx, unsigned short srcy,
                              unsigned short dstx, unsigned short dsty, 
                              unsigned short width, unsigned short height)
{
    GAL_SCREENTOSCREENBLT sScreenBlt;
    
    INIT_GAL(&sScreenBlt);
    sScreenBlt.dwSubfunction = GALFN_SCREENTOSCREENBLT;
    sScreenBlt.wXStart = srcx;
    sScreenBlt.wYStart = srcy;
    sScreenBlt.wXEnd = dstx;
    sScreenBlt.wYEnd = dsty;
    sScreenBlt.wWidth = width;
    sScreenBlt.wHeight = height;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sScreenBlt))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_screen_to_screen_xblt(unsigned short srcx, unsigned short srcy,
                               unsigned short dstx, unsigned short dsty, 
                               unsigned short width, unsigned short height,
                               unsigned short color)
{
    GAL_SCREENTOSCREENXBLT sScreenXBlt;
    
    INIT_GAL(&sScreenXBlt);
    sScreenXBlt.dwSubfunction = GALFN_SCREENTOSCREENXBLT;
    sScreenXBlt.wXStart = srcx;
    sScreenXBlt.wYStart = srcy;
    sScreenXBlt.wXEnd = dstx;
    sScreenXBlt.wYEnd = dsty;
    sScreenXBlt.wWidth = width;
    sScreenXBlt.wHeight = height;
    sScreenXBlt.wColor = color;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sScreenXBlt))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_bresenham_line(unsigned short x, unsigned short y, 
                        unsigned short length, unsigned short initerr, 
                        unsigned short axialerr, unsigned short diagerr, 
                        unsigned short flags)
{
    GAL_BRESENHAMLINE sBresenhamLine;
    
    INIT_GAL(&sBresenhamLine);
    sBresenhamLine.dwSubfunction = GALFN_BRESENHAMLINE;
    sBresenhamLine.wX1 = x;
    sBresenhamLine.wY1 = y;
    sBresenhamLine.wLength = length;
    sBresenhamLine.wErr = initerr;
    sBresenhamLine.wE1 = axialerr;
    sBresenhamLine.wE2 = diagerr;
    sBresenhamLine.wFlags = flags;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sBresenhamLine))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_set_compression_state(BOOLEAN bCompressionState)
{
    GAL_SETCOMPRESSIONSTATE sCompState;
    
    INIT_GAL(&sCompState);
    sCompState.dwSubfunction = GALFN_SETCOMPRESSIONSTATE;
    sCompState.bCompressionState = bCompressionState;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sCompState))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_set_compression_parameters(unsigned long flags, unsigned long offset,
                                       unsigned long pitch, unsigned long size)
{
    GAL_SETCOMPRESSIONPARAMS sCompParams;
    
    INIT_GAL(&sCompParams);
    sCompParams.dwSubfunction = GALFN_SETCOMPRESSIONPARAMS;
    sCompParams.dwFlags = flags;
    sCompParams.dwCompOffset = offset;
    sCompParams.dwCompPitch = pitch;
    sCompParams.dwCompSize = size;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sCompParams))
        return 0;
    else
        return 1;
}


BOOLEAN Gal_vga_mode_switch(int active)
{
    GAL_VGAMODEDATA sVgaData;
    
    INIT_GAL(&sVgaData);
    sVgaData.dwSubfunction = GALFN_VGAMODESWITCH;
    sVgaData.dwFlags = active;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sVgaData))
        return 0;
    else
        return 1;    
}

BOOLEAN Gal_vga_clear_extended(void)
{
    GAL_VGAMODEDATA sVgaData;
    
    INIT_GAL(&sVgaData);
    sVgaData.dwSubfunction = GALFN_VGACLEARCRTEXT;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sVgaData))
        return 0;
    else
        return 1;
}

BOOLEAN Gal_vga_pitch(PGALAPP_VGAREGS pvregs, unsigned short pitch)
{
    GAL_VGAMODEDATA sVgaData;
    
    INIT_GAL(&sVgaData);
    sVgaData.dwSubfunction = GALFN_VGASETPITCH;
    sVgaData.sVgaRegs = *pvregs;
    sVgaData.dwFlags = pitch;
    
    if (ioctl(ifbdev_handle, FBIOGAL_API, &sVgaData))
        return 0;
    else
    {
        *pvregs = sVgaData.sVgaRegs;
        return 1;
    }
}

BOOLEAN Gal_vga_restore(PGALAPP_VGAREGS pvregs, int flags)
{
    GAL_VGAMODEDATA sVgaData;
    
    INIT_GAL(&sVgaData);
    sVgaData.dwSubfunction = GALFN_VGARESTORE;
    sVgaData.sVgaRegs = *pvregs;
    sVgaData.dwFlags = flags;

    if (ioctl(ifbdev_handle, FBIOGAL_API, &sVgaData))
        return 0;
    else
        return 1;    
}

BOOLEAN Gal_vga_save(PGALAPP_VGAREGS pvregs, int flags)
{
    GAL_VGAMODEDATA sVgaData;
    
    INIT_GAL(&sVgaData);
    sVgaData.dwSubfunction = GALFN_VGASAVE;
    sVgaData.dwFlags = flags;

    if (ioctl(ifbdev_handle, FBIOGAL_API, &sVgaData))
        return 0;
    else
    {
        *pvregs = sVgaData.sVgaRegs;
        return 1;
    }
}

BOOLEAN Gal_vga_mode(PGALAPP_VGAREGS pvregs, int xres, int yres, int bpp, int hz)
{
    GAL_VGAMODEDATA sVgaData;
    
    INIT_GAL(&sVgaData);
    sVgaData.dwSubfunction = GALFN_VGASETMODE;
    sVgaData.wXres = xres;
    sVgaData.wYres = yres;
    sVgaData.wBpp = bpp;
    sVgaData.wRefresh = hz;

    if (ioctl(ifbdev_handle, FBIOGAL_API, &sVgaData))
        return 0;
    else
    {
        *pvregs = sVgaData.sVgaRegs;
        return 1;
    }
}

