use warnings;
use strict;
use Tk;
use Text::Unidecode;
use Tk::Table;
use Cwd;

# VIEWDB
# The script shows a nice GUI which allows to quickly open CDs 
# and floppies from books.
# 
# Executed in current directory makes it an archive for disk image
# files and their metadata. 
# Metadata is stored in "database.csv"  (specified by $dataFile) file
# in human and machine readable plaintext form:
# ID, Author, Title,. Type, Count, Condition, Date Acquired, Comment
# All of these in "-quotes, separated by ; sign.
# Requires: Linux, ddrescue, Perl::Tk.
# MCbx 2016.

my $fileManager="konqueror";
my $dataFile="database.csv";


my $cols = 8;
my %cell;
my $thisRow=0;

my $mw = new MainWindow();

# Create Table Frame
my $tableFrame = $mw->Frame(
  -borderwidth => 2,
  -relief      => 'raised')->pack(
                               -expand => 'yes',
                               -fill => 'both');

my $table = $tableFrame->Table(
  -columns    => 10,
  -rows          => 6,
  -fixedrows   => 1,
  -scrollbars  => 'se',
  -relief     => 'raised');

# Create Column headers

  my $tmp = $table->Label(-text=>"ID", -width =>3, -relief=>'raised');
  $table->put( 0, 1, $tmp );
  
  $tmp = $table->Label(-text=>"Author", -width =>40, -relief=>'raised');
  $table->put( 0, 2, $tmp );
  
  $tmp = $table->Label(-text=>"Title", -width =>40, -relief=>'raised');
  $table->put( 0, 3, $tmp );

  $tmp = $table->Label(-text=>"Type", -width =>10, -relief=>'raised');
  $table->put( 0, 4, $tmp );
  
  $tmp = $table->Label(-text=>"Cnt", -width =>3, -relief=>'raised');
  $table->put( 0, 5, $tmp );
  
  $tmp = $table->Label(-text=>"Condition", -width =>10, -relief=>'raised');
  $table->put( 0, 6, $tmp );
  
  $tmp = $table->Label(-text=>"Acquired", -width =>12, -relief=>'raised');
  $table->put( 0, 7, $tmp );
  
  $tmp = $table->Label(-text=>"Comment", -width =>16, -relief=>'raised');
  $table->put( 0, 8, $tmp );

#Table filling
#prepare data
open(my $fh,'<:encoding(UTF-8)',$dataFile) or die "Can't load database file!";
my @data;
my $rows=0;
# During data parse, add it to table.
while (my $row = <$fh>) 
{
	my @recs=split("\";\"",$row);
	$rows++;
	foreach my $c (1..$cols)
	{
		$recs[$c-1]=~s/\R//g;  #remove newlines
		if ($c == 1)
		{
			$recs[$c-1]=substr($recs[$c-1],1);
		}
		if ($c == 8)
		{
			$recs[$c-1]=~s/\"//;
		}
		
		my $tmp = $table->Label(
			-text            => $recs[$c-1],
			-padx           => 2,
			-anchor        => 'w',
			-background => 'white',
			-relief           => 'groove',
			-height   => 1);

		$tmp->bind("<Double-1>", [ \&activateRow, $table ]);
		$tmp->bind("<Button-1>", [ \&toggleRow, $table ]);
		$table->put( $rows, $c, $tmp );
	}
}
close($fh);
$table->pack( -expand => 'yes', -fill => 'both');

# Create Button bar
my $buttonBar = $mw->Frame( -borderwidth => 4 )
                  ->pack(-fill => 'y');


my $findT = $buttonBar->Entry(
	-width=> 30
	);
	$findT->pack(
		-side => 'left',
		-padx => 0
		);

my $findB = $buttonBar->Button(
  -text          => "Search",
  -width        => 10,
  -command => \&findThing);
  
  $findB->pack(
    -side  => 'left',
    -padx => 3 );


my $exitB = $buttonBar->Button(
  -text          => "Exit",
  -width        => 10,
  -command => sub { exit });

  $exitB->pack(
    -side  => 'left',
    -padx => 6 );
    
MainLoop;


sub activateRow {
  my ($w, $t) = @_;
 
  my ($row, $col) = $t->Posn( $w );
    $cell{$row} = int($row);
    my $idLabel=$t->get($row,1);
    my $txt=$idLabel->cget('-text');
	my $commandment=$fileManager." \"".getcwd()."/".$txt."/\"";
    print "Row: $txt opened: ".$commandment."\n";
    system($commandment." &");
    #windows
    #system("start /b ".$commandment);
    
}

sub toggleRow {
  my ($w, $t) = @_;

  my ($row, $col) = $t->Posn( $w );

	foreach my $c (1 .. $rows) {
	 if (exists($cell{$c})) {
		delete($cell{$c});
		showUnselected( $t, $c );
		}
	}
    $cell{$row} = int($row);
    showSelected( $t, $row );
    $thisRow=$row;
    print "Row: $row selected\n";
}

sub showSelected {
  my ($t, $r) = @_;
  my $w;

  #print $row;
  foreach my $c (1 .. $cols) {
    $w = $t->get($r, $c);
    $w->configure(-background => 'grey');
  }
}

sub showUnselected {
  my ($t, $r) = @_;
  my $w;

  foreach my $c (1 .. $cols) {
    $w = $t->get($r, $c);
    $w->configure(-background => 'white');
  }
}


sub findThing {
	my $val=$findT->get();
	print "Find triggered for ".$val."\n";
	my $former=$thisRow;
	
	foreach my $d ($thisRow+1 .. $rows+$thisRow) {
	 my $c=$d%($rows+1);
	 my $idLabel=$table->get($c,2); #autor
	 my $txt=$idLabel->cget('-text');
	 $idLabel=$table->get($c,3); #tytul
	 my $txt2=$idLabel->cget('-text');
	 if ((index(uc($txt), uc($val))!=-1)||(index(uc($txt2), uc($val))!=-1))
	 {
		print("Found at ".$c."\n");
  	    foreach my $c (1 .. $rows) {
			if (exists($cell{$c})) {
				delete($cell{$c});
				showUnselected( $table, $c );
			}
		}
		$cell{$c} = int($c);
		showSelected( $table, $c );
		$thisRow=$c;
		print "Row: $c selected\n";
		$table->see($c,1);
		last;
	 }
	 
	}
}
