#include "toolkit.h"
#include <QString>
#include <QByteArray>
#include "algorithm"

void qSleep(int ms)
{
#ifdef Q_OS_WIN
    Sleep(uint(ms));
#else
    struct timespec ts = { ms / 1000, (ms % 1000) * 1000 * 1000 };
    nanosleep(&ts, NULL);
#endif
}


QString rev(QString src)
{
    QByteArray ba=src.toAscii();
    char *d=ba.data();
    std::reverse(d,d+src.length());
    return QString(d);
}
