/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  NetCentric Computing with Object Rexx                                   */
/*  Programming Example                                                     */
/*                                                                          */
/*    IBM Corporation 1998                                                  */
/*                                                                          */
/*  Chat_c.cmd  -  Session Client using TCP/IP Sockets                      */
/*                                                                          */
/*    Client program for the chat server. Ask the user for a string,        */ 
/*    send the string to the server and display the result strings.         */
/*                                                                          */
/*    Parameters:                                                           */
/*      Server:   name of the server                                        */
/*      alias:    alias name of the client                                  */
/*      nameSegs: Name segments (1 ... n number of name segments)           */
/*      Port:     server port number                                        */
/*                                                                          */
/*  Documentation: see chat.doc in directory docs                           */
/*                                                                          */
/*  History:                                                                */
/*    06/30/97  added client alias option for multiple clients per host     */
/*              added beep upon arrival of a message                        */
/*    07/22/97  added name segment option                                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/

Parse Arg Server Alias nameSegs Port          
if Port = '' then Port = 1924          /* Default server port               */
                                       /* create client with alias          */
client = .Client~new(Server, Port, Alias, nameSegs) 
if client~connected then do            /* Is client connected to server?    */
  client~listenConversation            /* display what is heard             */ 

  say "Use the input field to enter what you have to say!" 
  say
  do until client~Input~word(1)~translate = 'QUIT' 
    rc = client~promptInput()          /* get input from user               */
    if rc < 0 then do                  /* if error quit client session      */
      client~stopListening             /* Stop listening of the client      */
      leave
    end           
  end 
end

exit

/****************************************************************************/

::REQUIRES "clients.frm"               /* Use the clients framework         */   

/*--------------------------------------------------------------------------*/
/* Client Class definition                                                  */
/*--------------------------------------------------------------------------*/
::CLASS Client SUBCLASS tcpClient

/*--------------------------------------------------------------------------*/
::METHOD init
  use arg server, port, client, option                 

  self~init:super(server, port, client, option)/* Let the superclass do the init    */
  self~Listening = .FALSE              /* Indicate not being listening yet  */ 

/*--------------------------------------------------------------------------*/
::METHOD listenConversation UNGUARDED  /* Watch for any return data         */
  self~Listening = .TRUE               /* Indicate being listening now      */
  reply                                /* Return control and  continue      */
  
  do until substr(self~output, 1, 15) = "Server: Bye bye" 
    rc = self~receive                  /* receive the returned string       */
    if rc <= 0 then leave              /* if error terminate listening      */
    Say self~Output                    /* show what was received            */
    rc = Beep(1600, 50)                /* with a short beep                 */
  end

  self~Listening = .FALSE              /* Indicate not listening any more   */ 
  self~shutdown                        /* The client can be shutdown now    */

/*--------------------------------------------------------------------------*/
::METHOD Listening ATTRIBUTE           /* Set/Get the listening status      */

/*--------------------------------------------------------------------------*/
::METHOD stopListening                 /* Stop listening the conversation   */
  if self~Listening then               /* if still listening, force a quit  */
    self~sendInput('QUIT')             /* by sending the server 'quit'      */
      
/*--------------------------------------------------------------------------*/
::METHOD shutdown UNGUARDED            /* shutdown the client               */

  self~shutdown:super                  /* shutdown the tcpClient            */
  rc = Beep(800, 500)                  /* with a long beep                  */

