/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.tree;

import com.ibm.ivb.log.LogFile;
import com.ibm.ivb.log.Record;
import com.ibm.ivb.log.tree.Node;
import com.ibm.ivb.log.tree.ParentNode;
import com.ibm.ivb.log.tree.RecordFilterNode;
import com.ibm.ivb.log.tree.RecordNode;
import com.ibm.ivb.log.tree.Visitor;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class RootNode
extends ParentNode {
    private Hashtable filters = new Hashtable();
    private boolean analysisDone = false;
    private boolean advanceAnalysisDone = false;
    private String FilterName;

    public String toString() {
        if (this.FilterName == null) {
            return "";
        }
        if (this.FilterName.equals("none")) {
            return "Simple View (" + this.getChildCount() + ")";
        }
        return new String(String.valueOf(this.FilterName) + " View (" + this.getChildCount() + ")");
    }

    public Hashtable getFilters() {
        return this.filters;
    }

    public void setFilterName(String string) {
        this.FilterName = string;
    }

    public String getFilterName() {
        return this.FilterName;
    }

    public RecordFilterNode getRecordFilterNode(String string) {
        return (RecordFilterNode)this.filters.get(string);
    }

    public void addRecordNode(RecordNode recordNode) {
        this.addChild(recordNode);
    }

    public void insertRecordNode(RecordNode recordNode) {
        this.insertChild(recordNode);
    }

    public void addRecordFilterNode(RecordFilterNode recordFilterNode) {
        this.filters.put(recordFilterNode.getFilterValue(), recordFilterNode);
        this.addChild(recordFilterNode);
    }

    public void insertRecordFilterNode(RecordFilterNode recordFilterNode) {
        this.filters.put(recordFilterNode.getFilterValue(), recordFilterNode);
        this.insertChild(recordFilterNode);
    }

    public void reorderRecordFilterNodes() {
        this.removeChildren();
        Enumeration enumeration = this.filters.elements();
        while (enumeration.hasMoreElements()) {
            RecordFilterNode recordFilterNode = (RecordFilterNode)enumeration.nextElement();
            this.insertChild(recordFilterNode);
        }
        int n = 0;
        while (n < this.getChildCount()) {
            RecordFilterNode cfr_ignored_0 = (RecordFilterNode)this.getChild(n);
            ++n;
        }
    }

    public void addRecord(Record record) {
        String string = record.getFilterValue();
        RecordFilterNode recordFilterNode = (RecordFilterNode)this.filters.get(string);
        if (recordFilterNode == null) {
            recordFilterNode = new RecordFilterNode(string, record.getTimeStamp(), record.getTimeStampString());
            this.filters.put(string, recordFilterNode);
            this.addChild(recordFilterNode);
        }
        recordFilterNode.addRecord(record);
    }

    public boolean isSortLower(Node node) {
        return this.hashCode() < node.hashCode();
    }

    public void analyze() {
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            Node node = this.getChild(n2);
            node.analyze();
            ++n2;
        }
        this.analysisDone = true;
    }

    public void advanceAnalyze(String string, String string2) {
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            Node node = this.getChild(n2);
            node.advanceAnalyze(string, string2);
            ++n2;
        }
        this.advanceAnalysisDone = true;
    }

    public void resetAnalyze() {
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            Node node = this.getChild(n2);
            node.resetAnalyze();
            ++n2;
        }
        this.analysisDone = false;
    }

    public void resetAdvanceAnalyze() {
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            Node node = this.getChild(n2);
            node.resetAdvanceAnalyze();
            ++n2;
        }
        this.advanceAnalysisDone = false;
    }

    public boolean isAnalysisDone() {
        return this.analysisDone;
    }

    public boolean isAdvanceAnalysisDone() {
        return this.advanceAnalysisDone;
    }

    public String getAnalysisResult(String string) {
        return null;
    }

    public String getText() {
        return this.toString();
    }

    public void save(String string, String string2) throws IOException {
        LogFile logFile = new LogFile(this);
        if (string2.equals("xml")) {
            logFile.saveAsXML(string);
            return;
        }
        logFile.saveAsText(string);
    }

    public void visit(Visitor visitor) {
        visitor.visitRootNode(this);
    }
}

