/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.Application;
import com.ibm.ivb.jface.JFaceContext;
import com.ibm.ivb.jface.MenuComponentData;
import com.ibm.ivb.jface.MenuData;
import com.ibm.ivb.jface.Tool;
import com.ibm.ivb.jface.ToolBarContribution;
import com.ibm.ivb.log.ui.FocusSensitiveAction;
import com.ibm.ivb.log.ui.LBUtilities;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.ibm.ivb.log.ui.UIConstants;
import com.sun.java.swing.Icon;

public class EditMenu
extends MenuData
implements UIConstants,
TranslatableConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private FocusSensitiveAction actCut;
    private FocusSensitiveAction actCopy;
    private FocusSensitiveAction actPaste;
    private FocusSensitiveAction actFind;
    private FocusSensitiveAction actFindAgain;
    private FocusSensitiveAction actReplace;
    private FocusSensitiveAction actSelectAll;
    private static Icon icCut;
    private static Icon icCopy;
    private static Icon icPaste;
    private static Icon icFind;
    private static boolean iconsLoaded;

    public EditMenu() {
        EditMenu.loadIcons();
        this.createActions();
        Object[] objectArray = new Object[3];
        LogBrowser.getLBApplication().parseMenuResource("ComIbmIvbLogUiMenuEdit", objectArray);
        this.setText((String)objectArray[0]);
        this.setMnemonic(((Character)objectArray[1]).charValue());
        this.setShared(true);
        this.setPriority(-10);
        this.setActionCommand((String)objectArray[0]);
    }

    public void addMenuBarContribution(JFaceContext jFaceContext) {
        Application application = LogBrowser.getLBApplication();
        LBUtilities.addAMenuItem(application, (MenuData)this, "ComIbmIvbLogUiMiCut", icCut, this.actCut, jFaceContext);
        LBUtilities.addAMenuItem(application, (MenuData)this, "ComIbmIvbLogUiMiCopy", icCopy, this.actCopy, jFaceContext);
        LBUtilities.addAMenuItem(application, (MenuData)this, "ComIbmIvbLogUiMiPaste", icPaste, this.actPaste, jFaceContext);
        this.add(MenuComponentData.separator);
        LBUtilities.addAMenuItem(application, (MenuData)this, "ComIbmIvbLogUiMiFind", icFind, this.actFind, jFaceContext);
        LBUtilities.addAMenuItem(application, (MenuData)this, "ComIbmIvbLogUiMiFindAgain", null, this.actFindAgain, jFaceContext);
        LBUtilities.addAMenuItem(application, (MenuData)this, "ComIbmIvbLogUiMiReplace", null, this.actReplace, jFaceContext);
        this.add(MenuComponentData.separator);
        LBUtilities.addAMenuItem(application, (MenuData)this, "ComIbmIvbLogUiMiSelectAll", null, this.actSelectAll, jFaceContext);
    }

    public ToolBarContribution getToolBarContribution(ToolBarContribution toolBarContribution, JFaceContext jFaceContext) {
        Application application = LogBrowser.getLBApplication();
        LBUtilities.addAToolbarButton(application, toolBarContribution, "ComIbmIvbLogUiToolTextCut", "ComIbmIvbLogUiToolTipCut", icCut, this.actCut, jFaceContext);
        LBUtilities.addAToolbarButton(application, toolBarContribution, "ComIbmIvbLogUiToolTextCopy", "ComIbmIvbLogUiToolTipCopy", icCopy, this.actCopy, jFaceContext);
        LBUtilities.addAToolbarButton(application, toolBarContribution, "ComIbmIvbLogUiToolTextPaste", "ComIbmIvbLogUiToolTipPaste", icPaste, this.actPaste, jFaceContext);
        LBUtilities.addAToolbarButton(application, toolBarContribution, "ComIbmIvbLogUiToolTextFind", "ComIbmIvbLogUiToolTipFind", icFind, this.actFind, jFaceContext);
        return toolBarContribution;
    }

    public void enableActions(Tool tool) {
        this.actCut.setEnablement(tool);
        this.actCopy.setEnablement(tool);
        this.actPaste.setEnablement(tool);
        this.actFind.setEnablement(tool);
        this.actFindAgain.setEnablement(tool);
        this.actReplace.setEnablement(tool);
        this.actSelectAll.setEnablement(tool);
    }

    private static void loadIcons() {
        if (!iconsLoaded) {
            icCut = LBUtilities.loadIcon("images/cut.gif");
            icCopy = LBUtilities.loadIcon("images/copy.gif");
            icPaste = LBUtilities.loadIcon("images/paste.gif");
            icFind = LBUtilities.loadIcon("images/find.gif");
            iconsLoaded = true;
        }
    }

    private void createActions() {
        this.actCut = new FocusSensitiveAction("cut");
        this.actCopy = new FocusSensitiveAction("copy");
        this.actPaste = new FocusSensitiveAction("paste");
        this.actFind = new FocusSensitiveAction("find");
        this.actFindAgain = new FocusSensitiveAction("findAgain");
        this.actReplace = new FocusSensitiveAction("replace");
        this.actSelectAll = new FocusSensitiveAction("selectAll");
    }
}

