/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.log.AppModel;
import com.ibm.ivb.log.ui.LBUtilities;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.ibm.ivb.log.ui.util.FileHelper;
import com.sun.java.swing.JFrame;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;

public class LogChooser
extends FileDialog
implements TranslatableConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final int CHOOSE_TO_OPEN = 0;
    public static final int CHOOSE_TO_SAVE = 1;
    public static final int CHOOSE_TO_SAVEAS = 2;
    private static final String LOG_DIR = String.valueOf(AppModel.getAppHome()) + File.separator + "service" + File.separator;
    private static File visitedDirectory = new File(LOG_DIR);

    private LogChooser() {
        super((Frame)null);
    }

    public static File[] getLogs(int n, Component component) {
        File file = LogChooser.getLog(n, component);
        if (file == null) {
            return null;
        }
        return new File[]{file};
    }

    public static File getLog(int n, Component component) {
        Frame frame = component instanceof Frame ? (Frame)component : LBUtilities.getBrowserFrame(component);
        String string = new String();
        if (n == 0) {
            string = LogBrowser.getLBString("ComIbmIvbLogUiTitleAwtChooserOpen");
        } else if (n == 2) {
            string = LogBrowser.getLBString("ComIbmIvbLogUiTitleAwtChooserSaveAs");
        } else if (n == 1) {
            string = LogBrowser.getLBString("ComIbmIvbLogUiTitleAwtChooserSave");
        }
        int n2 = n == 0 ? 0 : 1;
        FileDialog fileDialog = new FileDialog(frame, string, n2);
        if (visitedDirectory != null && visitedDirectory.exists()) {
            fileDialog.setDirectory(visitedDirectory.getPath());
        }
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            visitedDirectory = new File(fileDialog.getDirectory());
            File file = new File(String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile());
            if ((n == 1 || n == 2) && FileHelper.getExtension(file) == null) {
                file = FileHelper.addExtension(file, "xml");
            }
            return file;
        }
        return null;
    }

    public static void setLogFileDirectory(File file) {
        visitedDirectory = file;
    }

    public static String getSaveTargetFile(JFrame jFrame) {
        File file = LogChooser.getLog(2, (Component)jFrame);
        if (file != null) {
            return file.getPath();
        }
        return null;
    }

    public static void main(String[] stringArray) {
        File[] fileArray = LogChooser.getLogs(0, null);
        System.out.println("A Total of " + fileArray.length + " logs selected. They are:");
        int n = 0;
        while (n < fileArray.length) {
            System.out.println("\t" + fileArray[n].getPath());
            ++n;
        }
        System.exit(0);
    }
}

