/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.jface.Action;
import com.ibm.ivb.jface.Application;
import com.ibm.ivb.jface.ContributionItem;
import com.ibm.ivb.jface.LinkEvent;
import com.ibm.ivb.jface.MenuComponentData;
import com.ibm.ivb.jface.MenuContribution;
import com.ibm.ivb.jface.MenuData;
import com.ibm.ivb.jface.StatusLineContribution;
import com.ibm.ivb.jface.Tool;
import com.ibm.ivb.jface.ToolBarContribution;
import com.ibm.ivb.jface.parts.PreferenceNode;
import com.ibm.ivb.log.AppModel;
import com.ibm.ivb.log.tree.LogTreeModel;
import com.ibm.ivb.log.tree.Node;
import com.ibm.ivb.log.tree.RecordNode;
import com.ibm.ivb.log.ui.ActionManager;
import com.ibm.ivb.log.ui.AdvAnalyzeAction;
import com.ibm.ivb.log.ui.AnalyzeAction;
import com.ibm.ivb.log.ui.FindAndReplaceDialog;
import com.ibm.ivb.log.ui.HelpMenu;
import com.ibm.ivb.log.ui.LBUtilities;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.LogTree;
import com.ibm.ivb.log.ui.MergeLogAction;
import com.ibm.ivb.log.ui.OpenLogAction;
import com.ibm.ivb.log.ui.PrintLogAction;
import com.ibm.ivb.log.ui.SaveAsLogAction;
import com.ibm.ivb.log.ui.SaveLogAction;
import com.ibm.ivb.log.ui.SaveModelAction;
import com.ibm.ivb.log.ui.SaveRecordAction;
import com.ibm.ivb.log.ui.SeverityPreferenceNode;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.ibm.ivb.log.ui.UIConstants;
import com.ibm.ivb.log.ui.events.AdvancedAnalysisEvent;
import com.ibm.ivb.log.ui.events.AnalysisEvent;
import com.ibm.ivb.log.ui.events.ClearRecordEvent;
import com.ibm.ivb.log.ui.events.FocusEvent;
import com.ibm.ivb.log.ui.events.InitiationEvent;
import com.ibm.ivb.log.ui.events.RefreshRecordMenuEvent;
import com.ibm.ivb.log.ui.events.TreeSelectionChangeEvent;
import com.ibm.ivb.log.ui.util.FileHelper;
import com.ibm.ivb.log.ui.util.FixedWidthStatusText;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JTree;
import com.sun.java.swing.tree.TreePath;
import java.awt.Component;
import java.io.File;
import java.util.Vector;

public class LogView
extends Tool
implements ActionManager,
UIConstants,
TranslatableConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private LogTree treePane = new LogTree();
    private static Icon icOpen;
    private static Icon icPrint;
    private static Icon icSave;
    private static Icon icAnalyze;
    private static boolean iconsLoaded;
    private OpenLogAction actOpen = new OpenLogAction(this);
    private MergeLogAction actMerge = new MergeLogAction(this);
    private SaveLogAction actSave = new SaveLogAction(this);
    private SaveAsLogAction actSaveAs = new SaveAsLogAction(this);
    private PrintLogAction actPrintTree;
    private CloseLogAction actClose = new CloseLogAction();
    private AnalyzeAction actAnalyze;
    private AdvAnalyzeAction actAdvAnalyze;
    private SaveRecordAction actSaveRecord;
    private PrintLogAction actPrintSubtree;
    private FindAction actFind;
    private FindAgainAction actFindAgain;
    private FixedWidthStatusText statAnalysis;
    private FixedWidthStatusText statAdvAnalysis;
    private static String[] eventList;

    public LogView() {
        this.actPrintTree = new PrintLogAction(this, true);
        this.actAnalyze = new AnalyzeAction(this);
        this.actAdvAnalyze = new AdvAnalyzeAction(this);
        this.actSaveRecord = new SaveRecordAction(this);
        this.actPrintSubtree = new PrintLogAction(this, false);
        this.actFind = new FindAction();
        this.actFindAgain = new FindAgainAction();
        LogView.loadIcons();
    }

    public Component getView() {
        return this.treePane;
    }

    public MenuContribution getMenuContribution() {
        MenuContribution menuContribution = new MenuContribution((Tool)this);
        Application application = LogBrowser.getLBApplication();
        MenuData menuData = new MenuData("MFile");
        LBUtilities.addAMenuItem(application, menuData, "ComIbmIvbLogUiMiOpenLogs", "open", icOpen, this.actOpen);
        LBUtilities.addAMenuItem(application, menuData, "ComIbmIvbLogUiMiMergeLogs", "merge", null, this.actMerge);
        menuData.add(MenuComponentData.separator);
        LBUtilities.addAMenuItem(application, menuData, "ComIbmIvbLogUiMiSaveAsLog", "saveAs", icSave, this.actSaveAs);
        LBUtilities.addAMenuItem(application, menuData, "ComIbmIvbLogUiMiSaveLogs", "save", null, this.actSave);
        LBUtilities.addAMenuItem(application, menuData, "ComIbmIvbLogUiMiPrintLogs", "print", icPrint, this.actPrintTree);
        LBUtilities.addAMenuItem(application, menuData, "ComIbmIvbLogUiMiClose", "close", null, this.actClose);
        menuData.add(MenuComponentData.separator);
        menuContribution.add(menuData);
        menuContribution.add((MenuData)new HelpMenu((JFrame)this.getParentFrame()));
        return menuContribution;
    }

    public ToolBarContribution getToolBarContribution() {
        ToolBarContribution toolBarContribution = new ToolBarContribution((Tool)this);
        toolBarContribution.setBorderStyle(2);
        Application application = LogBrowser.getLBApplication();
        LBUtilities.addAToolbarButton(application, toolBarContribution, "ComIbmIvbLogUiToolTextOpen", "ComIbmIvbLogUiToolTipOpenLogs", "open", icOpen, this.actOpen);
        LBUtilities.addAToolbarButton(application, toolBarContribution, "ComIbmIvbLogUiToolTextSaveAs", "ComIbmIvbLogUiToolTipSaveAsLogs", "saveAs", icSave, this.actSaveAs);
        LBUtilities.addAToolbarButton(application, toolBarContribution, "ComIbmIvbLogUiToolTextPrint", "ComIbmIvbLogUiToolTipPrintLogs", "print", icPrint, this.actPrintTree);
        return toolBarContribution;
    }

    public PreferenceNode getPreferenceContribution() {
        return new SeverityPreferenceNode(this);
    }

    public StatusLineContribution getStatusLineContribution() {
        StatusLineContribution statusLineContribution = new StatusLineContribution((Tool)this);
        String[] stringArray = new String[]{LogBrowser.getLBString("ComIbmIvbLogUiStatusAnalysisDone"), LogBrowser.getLBString("ComIbmIvbLogUiStatusAnalysisUndone")};
        this.statAnalysis = new FixedWidthStatusText(stringArray);
        String[] stringArray2 = new String[]{LogBrowser.getLBString("ComIbmIvbLogUiStatusAdvAnalysisDone"), LogBrowser.getLBString("ComIbmIvbLogUiStatusAdvAnalysisUndone")};
        this.statAdvAnalysis = new FixedWidthStatusText(stringArray2);
        statusLineContribution.add((ContributionItem)this.statAnalysis);
        statusLineContribution.add((ContributionItem)this.statAdvAnalysis);
        return statusLineContribution;
    }

    public void toolInstalled() {
        this.setViewButtonVisible(false);
        this.setTitleButtonVisible(false);
        this.setLinkButtonVisible(false);
        super.toolInstalled();
    }

    public void toolActive() {
        this.actOpen.setParentFrame(this.getParentFrame());
        this.actMerge.setParentFrame(this.getParentFrame());
        super.toolActive();
    }

    public void focusGained() {
        this.getParentFrame().fireLinkEvent((LinkEvent)new FocusEvent(this));
    }

    public Action getActionFor(String string) {
        if (string.equals("analyze")) {
            return this.actAnalyze;
        }
        if (string.equals("advAnalyze")) {
            return this.actAdvAnalyze;
        }
        if (string.equals("saveInFile")) {
            return this.actSaveRecord;
        }
        if (string.equals("print")) {
            return this.actPrintSubtree;
        }
        if (string.equals("find")) {
            return this.actFind;
        }
        if (string.equals("findAgain")) {
            return this.actFindAgain;
        }
        return null;
    }

    public boolean isActionEnabled(String string) {
        if (string.equals("analyze")) {
            return this.treePane.hasSelection() && !Node.isAnalysisDone(this.getSelectedNodes());
        }
        if (string.equals("advAnalyze")) {
            return this.treePane.hasSelection() && !Node.isAdvanceAnalysisDone(this.getSelectedNodes());
        }
        if (string.equals("saveInFile")) {
            return this.treePane.hasSelection();
        }
        if (string.equals("print")) {
            return this.treePane.hasSelection();
        }
        if (string.equals("find")) {
            return true;
        }
        if (string.equals("findAgain")) {
            return FindAndReplaceDialog.canFindAgain();
        }
        return false;
    }

    public String[] getLinkEventNames() {
        return eventList;
    }

    public void handleLinkEvent(InitiationEvent initiationEvent) {
        this.resetTree(initiationEvent.getModel());
        this.setStatusUnknown();
        this.treePane.requestFocus();
    }

    public void handleLinkEvent(TreeSelectionChangeEvent treeSelectionChangeEvent) {
        TreePath[] treePathArray = treeSelectionChangeEvent.getSelectedTreePaths();
        if (treePathArray == null) {
            this.fireLinkEvent(new ClearRecordEvent(this));
            this.setStatusUnknown();
        } else if (treePathArray.length == 1) {
            Node node = (Node)treePathArray[0].getLastPathComponent();
            if (node.isLeaf() && node instanceof RecordNode) {
                this.fireLinkEvent(treeSelectionChangeEvent);
            } else {
                this.fireLinkEvent(new ClearRecordEvent(this, node));
            }
            this.setAnalysisStatus(node.isAnalysisDone());
            this.setAdvAnalysisStatus(node.isAdvanceAnalysisDone());
        } else {
            Node[] nodeArray = new Node[treePathArray.length];
            int n = 0;
            while (n < treePathArray.length) {
                nodeArray[n] = (Node)treePathArray[n].getLastPathComponent();
                ++n;
            }
            this.fireLinkEvent(new ClearRecordEvent(this, nodeArray));
            this.setAnalysisStatus(Node.isAnalysisDone(nodeArray));
            this.setAdvAnalysisStatus(Node.isAdvanceAnalysisDone(nodeArray));
        }
        this.getParentFrame().fireLinkEvent((LinkEvent)new RefreshRecordMenuEvent(this));
    }

    public void handleLinkEvent(AnalysisEvent analysisEvent) {
        if (analysisEvent.showResult()) {
            this.fireLinkEvent(analysisEvent);
        }
        this.setAnalysisStatus(true);
        ((Component)((Object)this.treePane)).repaint();
        this.getParentFrame().fireLinkEvent((LinkEvent)new RefreshRecordMenuEvent(this));
    }

    public void handleLinkEvent(AdvancedAnalysisEvent advancedAnalysisEvent) {
        if (advancedAnalysisEvent.showResult()) {
            this.fireLinkEvent(advancedAnalysisEvent);
        }
        this.setAdvAnalysisStatus(true);
        ((Component)((Object)this.treePane)).repaint();
        this.getParentFrame().fireLinkEvent((LinkEvent)new RefreshRecordMenuEvent(this));
    }

    public void resetTree(LogTreeModel logTreeModel) {
        this.treePane.resetTreeModel(logTreeModel);
        String string = AppModel.getCurrLogFileName();
        if (logTreeModel != null && string != null) {
            int n = string.lastIndexOf(File.separator);
            if (n > -1) {
                string = string.substring(n + 1);
            }
            this.setTitle(string);
            this.actMerge.setEnabled(true);
            this.actSaveAs.setEnabled(true);
            String string2 = FileHelper.getExtension(string);
            this.actSave.setEnabled(string2.equals("xml"));
            this.actPrintTree.setEnabled(true);
            this.actClose.setEnabled(true);
            return;
        }
        this.setTitle(new String());
        this.actMerge.setEnabled(false);
        this.actSaveAs.setEnabled(false);
        this.actSave.setEnabled(false);
        this.actPrintTree.setEnabled(false);
        this.actClose.setEnabled(false);
    }

    public JTree getTree() {
        return this.treePane.getJTree();
    }

    public Node[] getSelectedNodes() {
        return this.treePane.getSelectedNodes();
    }

    public Vector getSelection() {
        Node[] nodeArray = this.getSelectedNodes();
        Vector<Node> vector = new Vector<Node>();
        int n = 0;
        while (n < nodeArray.length) {
            vector.addElement(nodeArray[n]);
            ++n;
        }
        return vector;
    }

    public boolean closeOpenedLogs() {
        if (this.treePane.getTreeModel() == null) {
            return true;
        }
        if (this.treePane.hasUnsavedChange()) {
            int n = JOptionPane.showConfirmDialog((Component)this.getParentFrame(), (Object)LogBrowser.getLBString("ComIbmIvbLogUiMsgSaveLogReminder"), (String)LogBrowser.getLBString("ComIbmIvbLogUiTitleWarningMsgBox"), (int)1, (int)2);
            if (n == 2) {
                return false;
            }
            if (n == 0) {
                SaveModelAction saveModelAction = new SaveModelAction(this, this.treePane.getTreeModel());
                saveModelAction.run();
            }
        }
        this.resetTree(null);
        this.fireLinkEvent(new ClearRecordEvent(this, this.treePane));
        return true;
    }

    void setAnalysisStatus(boolean bl) {
        if (bl) {
            this.statAnalysis.setText(LogBrowser.getLBString("ComIbmIvbLogUiStatusAnalysisDone"));
            return;
        }
        this.statAnalysis.setText(LogBrowser.getLBString("ComIbmIvbLogUiStatusAnalysisUndone"));
    }

    void setAdvAnalysisStatus(boolean bl) {
        if (bl) {
            this.statAdvAnalysis.setText(LogBrowser.getLBString("ComIbmIvbLogUiStatusAdvAnalysisDone"));
            return;
        }
        this.statAdvAnalysis.setText(LogBrowser.getLBString("ComIbmIvbLogUiStatusAdvAnalysisUndone"));
    }

    void setStatusUnknown() {
        this.statAnalysis.setText(new String());
        this.statAdvAnalysis.setText(new String());
    }

    private static void loadIcons() {
        if (!iconsLoaded) {
            icOpen = LBUtilities.loadIcon("images/open.gif");
            icSave = LBUtilities.loadIcon("images/save.gif");
            icPrint = LBUtilities.loadIcon("images/print.gif");
            icAnalyze = LBUtilities.loadIcon("images/analyze.gif");
            iconsLoaded = true;
        }
    }

    static {
        eventList = new String[]{"com.ibm.ivb.log.ui.events.ClearRecordEvent", "com.ibm.ivb.log.ui.events.AnalysisEvent", "com.ibm.ivb.log.ui.events.AdvancedAnalysisEvent", "com.ibm.ivb.log.ui.events.TreeSelectionChangeEvent"};
    }

    class CloseLogAction
    extends Action {
        public synchronized void run() {
            if (LogView.this.closeOpenedLogs()) {
                LogView.this.resetTree(null);
            }
        }

        CloseLogAction() {
            LogView.this = LogView.this;
        }
    }

    class FindAction
    extends Action {
        public synchronized void run() {
            LogView.this.treePane.find();
        }

        FindAction() {
            LogView.this = LogView.this;
        }
    }

    class FindAgainAction
    extends Action {
        public synchronized void run() {
            LogView.this.treePane.findAgain();
        }

        FindAgainAction() {
            LogView.this = LogView.this;
        }
    }
}

