/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hursley.devtools;

import com.ibm.hursley.devtools.CallStackTrace;
import com.ibm.hursley.devtools.Tracer;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;

class TraceReal
implements Tracer {
    private static final String sccsid = "%Z% %W%  %E% %U%";
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1997     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String traceFileExt = ".TRC";
    private Hashtable indentsTable;
    private boolean trace = false;
    private boolean methodTrace = false;
    private int methodTraceThreshold = 5;
    private int format = 15;
    private PrintWriter trc = new PrintWriter(System.err, true);
    private int traceLevel = 1;

    public boolean isOn() {
        return this.trace;
    }

    public final synchronized void setMethodTraceThreshold(int n) {
        this.methodTraceThreshold = n;
    }

    public final synchronized void setTraceLevel(int n) {
        this.traceLevel = n;
    }

    public final synchronized int getTraceLevel() {
        return this.traceLevel;
    }

    public final synchronized void setTraceStream(FileWriter fileWriter) {
        if (fileWriter != null) {
            this.trc = new PrintWriter(fileWriter);
        }
    }

    public final synchronized void setTraceStream(PrintWriter printWriter) {
        if (printWriter != null) {
            this.trc = printWriter;
        }
    }

    public final synchronized void turnMethodTracingOff() {
        Runtime.getRuntime().traceMethodCalls(false);
        this.methodTrace = false;
    }

    public final synchronized void turnMethodTracingOn() {
        Runtime.getRuntime().traceMethodCalls(true);
        this.methodTrace = true;
    }

    public final synchronized void turnTracingOff() {
        this.trace = false;
        if (this.trc != null) {
            try {
                this.trc.flush();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public final synchronized void turnTracingOn() {
        this.trace = true;
        this.indentsTable = new Hashtable();
    }

    public final synchronized void turnTracingOn(int n) {
        this.trace = true;
        this.indentsTable = new Hashtable();
        if (n == 0) {
            this.turnTracingOff();
            return;
        }
        this.setTraceLevel(n);
        this.trace("turnTracingOn", "trace level set to " + n);
        if (n >= this.methodTraceThreshold && this.methodTraceThreshold != 0) {
            this.turnMethodTracingOn();
            this.trace("turnTracingOn", "methodTrace set On (threshold=" + n + ")");
        }
    }

    public final synchronized void setFormat(int n) {
        this.format = n;
    }

    public final synchronized void dataTrace(int n, Object object, byte[] byArray) {
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        if (this.trace && this.traceLevel >= n) {
            this.traceTime();
            if ((this.format & 4) != 0) {
                this.trc.print("[" + Thread.currentThread().getName() + "] ");
            }
            if (object != null && (this.format & 8) != 0) {
                this.trc.print(String.valueOf(object) + " ");
            }
            this.trc.println("Data trace, " + byArray.length + " bytes of data follow: \n");
            this.printHexBytes(this.trc, byArray);
            this.trc.println();
        }
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public final synchronized void dumpCallStack() {
        this.dumpCallStack(null);
    }

    public final synchronized void dumpCallStack(String string) {
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        if (this.trace) {
            CallStackTrace callStackTrace = new CallStackTrace();
            try {
                throw callStackTrace;
            }
            catch (CallStackTrace callStackTrace2) {
                this.traceTime();
                if ((this.format & 4) != 0) {
                    this.trc.println("[" + Thread.currentThread().getName() + "] ");
                }
                this.trc.println("Stack Trace Follows: (stack trace requires java_g or appletviewer_g)");
                if (string != null) {
                    this.trc.println(string);
                }
                callStackTrace.printStackTrace(this.trc);
            }
        }
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public final synchronized void entry(int n, Object object, String string) {
        if (this.traceLevel >= n) {
            this.entry(object, string);
        }
    }

    public final synchronized void entry(int n, String string, String string2) {
        if (this.traceLevel >= n) {
            this.entry(string, string2);
        }
    }

    public final synchronized void entry(Object object, String string) {
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        if (this.trace) {
            String string2 = "";
            if ((this.format & 4) != 0) {
                string2 = "[" + Thread.currentThread().getName() + "] ";
            }
            String string3 = "";
            if ((this.format & 8) != 0) {
                string3 = String.valueOf(object.toString()) + " ";
            }
            this.traceTime();
            this.trc.println(String.valueOf(string2) + string3 + "==> " + string + "() entry");
            this.incrementIndents();
        }
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public final synchronized void entry(String string, String string2) {
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        if (this.trace) {
            String string3 = "";
            if ((this.format & 4) != 0) {
                string3 = "[" + Thread.currentThread().getName() + "] ";
            }
            this.traceTime();
            String string4 = "";
            if ((this.format & 8) != 0) {
                string4 = String.valueOf(string) + "::";
            }
            this.trc.println(String.valueOf(string3) + string4 + string2 + "() ==> entry");
            this.incrementIndents();
        }
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public final synchronized void exit(int n, Object object, String string) {
        if (this.traceLevel >= n) {
            this.exit(object, string);
        }
    }

    public final synchronized void exit(int n, String string, String string2) {
        if (this.traceLevel >= n) {
            this.exit(string, string2);
        }
    }

    public final synchronized void exit(Object object, String string) {
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        if (this.trace) {
            this.decrementIndents();
            String string2 = "";
            if ((this.format & 4) != 0) {
                string2 = "[" + Thread.currentThread().getName() + "] ";
            }
            this.traceTime();
            String string3 = "";
            if ((this.format & 8) != 0) {
                string3 = String.valueOf(object.toString()) + " ";
            }
            this.trc.println(String.valueOf(string2) + string3 + "<== " + string + "() exit");
        }
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public final synchronized void exit(String string, String string2) {
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        if (this.trace) {
            this.decrementIndents();
            String string3 = "";
            if ((this.format & 4) != 0) {
                string3 = "[" + Thread.currentThread().getName() + "] ";
            }
            this.traceTime();
            String string4 = "";
            if ((this.format & 8) != 0) {
                string4 = String.valueOf(string) + "::";
            }
            this.trc.println(String.valueOf(string3) + string4 + string2 + "() <== exit");
        }
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public final synchronized void trace(int n, Object object, String string) {
        if (this.traceLevel >= n) {
            this.trace(object, string);
        }
    }

    public final synchronized void trace(int n, String string, String string2) {
        if (this.traceLevel >= n) {
            this.trace(string, string2);
        }
    }

    public final synchronized void trace(Object object, String string) {
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        if (this.trace) {
            String string2 = "";
            if ((this.format & 4) != 0) {
                string2 = "[" + Thread.currentThread().getName() + "] ";
            }
            this.traceTime();
            String string3 = "";
            if ((this.format & 8) != 0) {
                string3 = String.valueOf(object.toString()) + " ";
            }
            this.trc.println(String.valueOf(string2) + string3 + string);
        }
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    public final synchronized void trace(String string, String string2) {
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(false);
        }
        if (this.trace) {
            String string3 = "";
            if ((this.format & 4) != 0) {
                string3 = "[" + Thread.currentThread().getName() + "] ";
            }
            this.traceTime();
            String string4 = "";
            if ((this.format & 8) != 0) {
                string4 = String.valueOf(string) + " ";
            }
            this.trc.println(String.valueOf(string3) + string4 + string2);
        }
        if (this.methodTrace) {
            Runtime.getRuntime().traceMethodCalls(true);
        }
    }

    private final void decrementIndents() {
        int n = this.getIndentationLevel();
        if (n > 0) {
            --n;
        }
        this.indentsTable.put(Thread.currentThread(), new Integer(n));
    }

    private final int getIndentationLevel() {
        int n = 0;
        this.indentsTable.containsKey(Thread.currentThread());
        return n;
    }

    private final void incrementIndents() {
        int n = this.getIndentationLevel();
        this.indentsTable.put(Thread.currentThread(), new Integer(++n));
    }

    private void printHexBytes(PrintWriter printWriter, byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2;
            int n3 = Math.min(n + 19, byArray.length);
            String string = "";
            int n4 = n;
            while (n4 < n3) {
                n2 = byArray[n4];
                if (n2 < 0) {
                    n2 += 256;
                }
                String string2 = Integer.toString(n2, 16);
                if (n2 < 16) {
                    string2 = "0" + string2;
                }
                printWriter.print(String.valueOf(string2) + " ");
                string = n2 >= 32 && n2 <= 126 ? String.valueOf(string) + new Character((char)n2) : String.valueOf(string) + '.';
                ++n4;
            }
            n2 = 19 - (n3 - n);
            int n5 = 0;
            while (n5 < n2) {
                printWriter.print("   ");
                ++n5;
            }
            printWriter.println("  " + string);
            n += 19;
        }
    }

    private final void traceTime() {
        Date date = new Date();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        int n = this.getIndentationLevel();
        int n2 = 0;
        while (n2 < n) {
            this.trc.print("  ");
            ++n2;
        }
        if ((this.format & 1) != 0) {
            int n3 = gregorianCalendar.get(10);
            int n4 = gregorianCalendar.get(12);
            int n5 = gregorianCalendar.get(13);
            if (n3 < 10) {
                this.trc.print("0" + n3 + ":");
            } else {
                this.trc.print(String.valueOf(n3) + ":");
            }
            if (n4 < 10) {
                this.trc.print("0" + n4 + ":");
            } else {
                this.trc.print(String.valueOf(n4) + ":");
            }
            if (n5 < 10) {
                this.trc.print("0" + n5 + " ");
            } else {
                this.trc.print(String.valueOf(n5) + " ");
            }
        }
        if ((this.format & 2) != 0) {
            this.trc.print("[" + date.getTime() + "] ");
        }
    }
}

