/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lex.lapapp;

import com.ibm.hursley.devtools.Commandline;
import com.ibm.hursley.devtools.InvalidCommandlineArgument;
import com.ibm.lex.lapapp.JLAP;
import com.ibm.lex.lapapp.LAPConstants;
import com.ibm.lex.lapapp.License;
import com.ibm.lex.lapapp.LicenseAcceptanceProcess;
import com.ibm.lex.lapapp.resource.LAPResources;
import com.ibm.lex.lapapp.resource.SupportedLanguages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.Vector;

public class LAP {
    private String flags = "";
    private String[] longFlags = new String[]{""};
    private String options = "tlsm";
    private String[] longOptions = new String[]{"no_export", "no_print", "win_style", "win_color", "dialog_size", "font_name", "font_size", "font_style", "text_only", "register", "uid", "desc", "show_exit_code"};
    public static final String STATUS_OPT = "t";
    public static final String LA_PATH_OPT = "l";
    public static final String MASTER_PATH_OPT = "m";
    public static final String STATUS_PATH_OPT = "s";
    public static final String REVALIDATE_OPT = "revalidate";
    public static final String NO_PRINT_OPT = "no_print";
    public static final String NO_EXPORT_OPT = "no_export";
    public static final String WIN_STYLE_OPT = "win_style";
    public static final String WIN_COLOR_OPT = "win_color";
    public static final String DIALOG_SIZE_OPT = "dialog_size";
    public static final String FONT_NAME_OPT = "font_name";
    public static final String FONT_STYLE_OPT = "font_style";
    public static final String FONT_SIZE_OPT = "font_size";
    public static final String TEXT_ONLY_OPT = "text_only";
    public static final String REG_OPT = "register";
    public static final String UNIQUE_ID_OPT = "uid";
    public static final String REG_DESC_OPT = "desc";
    public static final String SHOW_EXIT_CODE_OPT = "show_exit_code";
    public String laPath;
    private String mPath;
    private String statusPath;
    private boolean noExport = false;
    private boolean noPrint = false;
    private boolean bShowExitCode = false;
    private int cmdStatus = 1;
    private String winStyle = "1";
    private String winColorString;
    private String dialogSizeString;
    private String fontName = "sansserif";
    private String fontStyleString;
    private String fontSizeString;
    private boolean register = false;
    private String uniqueID;
    private String regDesc;
    private boolean textOnly = false;
    private boolean noExportLA = false;
    private LicenseAcceptanceProcess licenseAcceptanceProcess;
    private LAPResources lapResources;
    private LicenseAcceptanceProcess model;
    protected String logoFileName = "logo.gif";
    protected String languageButName = "language";
    protected String acceptButName = "accept";
    protected String declineButName = "decline";
    protected String printButName = "print";
    protected String yesButName = "yes";
    protected String noButName = "no";
    private String[] textLines;
    private int cliFontWidth;
    private int linesPerPage;
    private Commandline cline;

    public LAP() {
    }

    public LAP(String[] stringArray) {
        try {
            this.parseArgs(stringArray);
            this.setExportLA(!this.noExport);
            this.doLAP();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public String[] breakText(int n, int n2, String[] stringArray, Locale locale) {
        Object object;
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = stringArray[n4];
            BreakIterator breakIterator = BreakIterator.getLineInstance(locale);
            if (object == null) {
                object = " ";
            }
            breakIterator.setText((String)object);
            int n5 = breakIterator.first();
            int n6 = breakIterator.next();
            int n7 = 0;
            StringBuffer stringBuffer = new StringBuffer("");
            int n8 = 0;
            while (n6 != -1) {
                String string = ((String)object).substring(n5, n6);
                n8 = string.length() * n2;
                if (n7 + n8 > n) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer = new StringBuffer(string);
                    n7 = n8;
                } else {
                    stringBuffer.append(string);
                    n7 += n8;
                }
                n5 = n6;
                n6 = breakIterator.next();
            }
            vector.addElement(stringBuffer.toString());
            ++n4;
        }
        vector.trimToSize();
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private int confirmDecline() {
        Locale locale = this.getLicenseAcceptanceProcess().getCurrentLocale();
        String[] stringArray = new String[]{this.getLicenseAcceptanceProcess().getLAPResources().getText(45)};
        String[] stringArray2 = this.breakText(600, this.cliFontWidth, stringArray, locale);
        int n = -1;
        while (n != Integer.MIN_VALUE && n != 1 && n != 2) {
            int n2 = 0;
            while (n2 < stringArray2.length) {
                System.out.println(stringArray2[n2]);
                ++n2;
            }
            n = this.getInput();
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    protected int displayLA() {
        var1_1 = this.getLicenseAcceptanceProcess().getCurrentLocale();
        var2_2 = new String[]{this.getLicenseAcceptanceProcess().getLAPResources().getText(44)};
        var3_3 = this.breakText(600, this.cliFontWidth, var2_2, var1_1);
        var4_4 = this.breakText(600, this.cliFontWidth, this.getLicenseAgreement(var1_1), var1_1);
        var5_5 = var4_4.length;
        var6_6 = 0;
        var7_7 = this.linesPerPage - (var3_3.length + 2);
        var8_8 = -1;
        ** GOTO lbl69
        {
            var9_9 = var6_6;
            while (var9_9 < var6_6 + var7_7) {
                if (var9_9 < var5_5) {
                    System.out.println(var4_4[var9_9]);
                }
                ++var9_9;
            }
            var8_8 = -1;
            while (var8_8 != -2147483648 && var8_8 != 1 && var8_8 != 2 && var8_8 != 99) {
                System.out.println("");
                var10_11 = 0;
                while (var10_11 < var3_3.length) {
                    System.out.println(var3_3[var10_11]);
                    ++var10_11;
                }
                var8_8 = this.getInput();
            }
            switch (var8_8) {
                case -2147483648: {
                    if (var6_6 >= var5_5) break;
                    var6_6 += var7_7;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    var8_8 = this.confirmDecline();
                    break;
                }
                case 99: {
                    if (var6_6 == 0) {
                        var1_1 = this.getLanguage();
                        var2_2[0] = this.getLicenseAcceptanceProcess().getLAPResources().getText(44);
                        var3_3 = this.breakText(600, this.cliFontWidth, var2_2, var1_1);
                        var4_4 = this.breakText(600, this.cliFontWidth, this.getLicenseAgreement(var1_1), var1_1);
                        var5_5 = var4_4.length;
                        var6_6 = 0;
                        var7_7 = this.linesPerPage - (var3_3.length + 1);
                        break;
                    }
                    if ((var6_6 -= var7_7) >= 0) break;
                    var6_6 = 0;
                    break;
                }
            }
            do {
                if (var6_6 < var5_5 && var8_8 != 1 && var8_8 != 2) continue block9;
                if (var8_8 == 1 || var8_8 == 2) continue;
                var2_2[0] = this.getLicenseAcceptanceProcess().getLAPResources().getText(46);
                var9_10 = this.breakText(600, this.cliFontWidth, var2_2, var1_1);
                var8_8 = -1;
                while (var8_8 != 1 && var8_8 != 2) {
                    var10_11 = 0;
                    while (var10_11 < var9_10.length) {
                        System.out.println(var9_10[var10_11]);
                        ++var10_11;
                    }
                    var8_8 = this.getInput();
                }
                switch (var8_8) {
                    case 2: {
                        var8_8 = this.confirmDecline();
                        if (var8_8 != 0) break;
                        var6_6 = 0;
                        break;
                    }
                }
lbl69:
                // 5 sources

            } while (var8_8 != 1 && var8_8 != 2);
        }
        return var8_8;
    }

    public void doLAP() {
        if (this.getStatus() == 9 || this.cmdStatus == 9) {
            this.exitLAP(9);
        }
        if (this.cmdStatus == 5) {
            this.setStatus(9);
            this.exitLAP(9);
        }
        if (!this.licenseIsValid()) {
            this.exitLAP(11);
        }
        if (!this.textOnly) {
            JLAP jLAP = new JLAP(this);
        } else {
            int n = this.doLapCommandLine();
            this.exitLAP(n);
        }
    }

    public int doLapCommandLine() {
        int n;
        Locale locale = new Locale("en", "");
        SupportedLanguages supportedLanguages = null;
        try {
            supportedLanguages = new SupportedLanguages(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Locale locale2 = supportedLanguages.getSupportedLocale(Locale.getDefault());
        if (this.getLicenseAcceptanceProcess().getLicense().isLicenseAvailable(locale2)) {
            this.getLicenseAcceptanceProcess().setCurrentLocale(locale2);
        }
        try {
            this.cliFontWidth = Integer.parseInt(this.getLicenseAcceptanceProcess().getLAPResources().getText(47));
        }
        catch (NumberFormatException numberFormatException) {
            this.cliFontWidth = 18;
        }
        locale = this.getLanguage();
        int n2 = -1;
        int n3 = 18;
        try {
            n3 = Integer.parseInt(this.getLicenseAcceptanceProcess().getLAPResources().getText(48));
        }
        catch (NumberFormatException numberFormatException) {
            n3 = 18;
        }
        this.linesPerPage = 340 / n3;
        n2 = this.displayLA();
        switch (n2) {
            case 1: {
                n = 9;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            default: {
                n = 9;
            }
        }
        this.setStatus(n);
        return n;
    }

    public void statusChanged(int n) {
        switch (n) {
            case 9: {
                this.exitLAP(9);
                break;
            }
            case 3: {
                this.exitLAP(3);
                break;
            }
            default: {
                this.exitLAP(n);
            }
        }
    }

    private int getInput() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = "";
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string.length() == 0) {
            return Integer.MIN_VALUE;
        }
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n;
    }

    private Locale getLanguage() {
        String[] stringArray = new String[1];
        Locale locale = this.getLicenseAcceptanceProcess().getCurrentLocale();
        Locale locale2 = new Locale("en", "");
        int n = -1;
        String string = this.getLicenseAcceptanceProcess().getLAPResources().getText(40);
        stringArray[0] = this.getLicenseAcceptanceProcess().getLAPResources().getText(41);
        String[] stringArray2 = this.breakText(600, this.cliFontWidth, stringArray, locale);
        while (n < 1 || n > 13) {
            System.out.println(string);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                System.out.println(stringArray2[n2]);
                ++n2;
            }
            n = this.getInput();
        }
        switch (n) {
            case 1: {
                locale2 = SupportedLanguages.CZECH;
                break;
            }
            case 2: {
                locale2 = SupportedLanguages.ENGLISH;
                break;
            }
            case 3: {
                locale2 = SupportedLanguages.FRENCH;
                break;
            }
            case 4: {
                locale2 = SupportedLanguages.GERMAN;
                break;
            }
            case 5: {
                locale2 = SupportedLanguages.ITALIAN;
                break;
            }
            case 6: {
                locale2 = SupportedLanguages.POLISH;
                break;
            }
            case 7: {
                locale2 = SupportedLanguages.PORTUGUESE;
                break;
            }
            case 8: {
                locale2 = SupportedLanguages.SPANISH;
                break;
            }
            case 9: {
                locale2 = SupportedLanguages.TURKISH;
                break;
            }
            default: {
                locale2 = SupportedLanguages.DEFAULT_LANGUAGE;
            }
        }
        this.getLicenseAcceptanceProcess().setCurrentLocale(locale2);
        this.getLicenseAcceptanceProcess().getLAPResources().setLocale(locale2);
        try {
            this.cliFontWidth = Integer.parseInt(this.getLicenseAcceptanceProcess().getLAPResources().getText(47));
        }
        catch (NumberFormatException numberFormatException) {
            this.cliFontWidth = 18;
        }
        stringArray[0] = this.getLicenseAcceptanceProcess().getLAPResources().getText(42);
        stringArray2 = this.breakText(600, this.cliFontWidth, stringArray, locale2);
        int n3 = 0;
        while (n3 < stringArray2.length) {
            System.out.println(stringArray2[n3]);
            ++n3;
        }
        stringArray[0] = this.getLicenseAcceptanceProcess().getLAPResources().getText(43);
        stringArray2 = this.breakText(600, this.cliFontWidth, stringArray, locale2);
        int n4 = 0;
        while (n4 < stringArray2.length) {
            System.out.println(stringArray2[n4]);
            ++n4;
        }
        n = this.getInput();
        return locale2;
    }

    private String getLanguageLabel() {
        return "View in " + this.getLicenseAcceptanceProcess().getNextLocale().getDisplayLanguage(LAPConstants.DEFAULT_LOCALE);
    }

    private LAPResources getLAPResources() {
        return this.getLicenseAcceptanceProcess().getLAPResources();
    }

    public String getLAPTitle() {
        return this.getLAPResources().getText(0);
    }

    private License getLicense() {
        return this.getLicenseAcceptanceProcess().getLicense();
    }

    public LicenseAcceptanceProcess getLicenseAcceptanceProcess() {
        if (this.licenseAcceptanceProcess == null) {
            this.licenseAcceptanceProcess = new LicenseAcceptanceProcess(this, this.laPath, this.mPath, this.statusPath);
            if (this.noExportLA) {
                this.licenseAcceptanceProcess.setNoExportLA();
            }
        }
        return this.licenseAcceptanceProcess;
    }

    public String[] getLicenseAgreement(Locale locale) {
        return this.getLicenseAcceptanceProcess().getLicenseAgreement(locale);
    }

    public final String getRegDesc() {
        return this.regDesc;
    }

    public final boolean getRegister() {
        return this.register;
    }

    public int getStatus() {
        return this.getLicenseAcceptanceProcess().getStatus();
    }

    private SupportedLanguages getSupportedLanguages() {
        return this.getLicenseAcceptanceProcess().getSupportedLanguages();
    }

    public final String getUniqueID() {
        return this.uniqueID;
    }

    private boolean isCmdStatusValid(int n) {
        return n == 1 || n == 5 || n == 9;
    }

    public boolean licenseIsValid() {
        return this.getLicense().licenseExists(this.getSupportedLanguages().getSupportedLocales());
    }

    public static void main(String[] stringArray) {
        LAP lAP = new LAP(stringArray);
    }

    private void parseArgs(String[] stringArray) {
        try {
            this.cline = new Commandline(stringArray, this.flags, this.options, this.longFlags, this.longOptions);
            if (this.cline.hasOption(LA_PATH_OPT) && this.cline.hasOption(STATUS_PATH_OPT)) {
                this.validatePaths(this.cline);
            } else {
                this.exitLAP(17);
            }
            if (this.cline.hasOption(STATUS_OPT)) {
                this.validateCmdStatus(this.cline.getOption(STATUS_OPT));
            }
            if (this.cline.hasOption(MASTER_PATH_OPT)) {
                this.mPath = this.cline.getOption(MASTER_PATH_OPT);
            }
            if (this.cline.hasOption(NO_PRINT_OPT)) {
                this.noPrint = true;
            }
            if (this.cline.hasOption(NO_EXPORT_OPT)) {
                this.noExport = true;
            }
            if (this.cline.hasOption(WIN_STYLE_OPT)) {
                this.winStyle = this.cline.getOption(WIN_STYLE_OPT);
            }
            if (this.cline.hasOption(WIN_COLOR_OPT)) {
                this.winColorString = this.cline.getOption(WIN_COLOR_OPT);
            }
            if (this.cline.hasOption(DIALOG_SIZE_OPT)) {
                this.dialogSizeString = this.cline.getOption(DIALOG_SIZE_OPT);
            }
            if (this.cline.hasOption(FONT_NAME_OPT)) {
                this.fontName = this.cline.getOption(FONT_NAME_OPT);
            }
            if (this.cline.hasOption(FONT_STYLE_OPT)) {
                this.fontStyleString = this.cline.getOption(FONT_STYLE_OPT);
            }
            if (this.cline.hasOption(FONT_SIZE_OPT)) {
                this.fontSizeString = this.cline.getOption(FONT_SIZE_OPT);
            }
            if (this.cline.hasOption(SHOW_EXIT_CODE_OPT)) {
                this.bShowExitCode = true;
            }
            if (this.cline.hasOption(TEXT_ONLY_OPT)) {
                this.textOnly = true;
            }
            if (this.cline.hasOption(REG_OPT)) {
                this.register = true;
                if (this.cline.hasOption(UNIQUE_ID_OPT)) {
                    this.uniqueID = this.cline.getOption(UNIQUE_ID_OPT);
                } else {
                    this.exitLAP(17);
                }
                if (this.cline.hasOption(REG_DESC_OPT)) {
                    this.regDesc = this.cline.getOption(REG_DESC_OPT);
                } else {
                    this.exitLAP(17);
                }
            }
        }
        catch (InvalidCommandlineArgument invalidCommandlineArgument) {
            this.exitLAP(18);
        }
    }

    public void setExportLA(boolean bl) {
        this.noExportLA = !bl;
    }

    public void setStatus(int n) {
        this.getLicenseAcceptanceProcess().setStatus(n);
    }

    private void validateCmdStatus(String string) {
        try {
            this.cmdStatus = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.exitLAP(18);
        }
        if (!this.isCmdStatusValid(this.cmdStatus)) {
            this.exitLAP(18);
        }
    }

    private void validatePaths(Commandline commandline) {
        File file;
        File file2;
        this.laPath = commandline.getOption(LA_PATH_OPT);
        this.statusPath = commandline.getOption(STATUS_PATH_OPT);
        if (commandline.hasOption(MASTER_PATH_OPT)) {
            this.mPath = commandline.getOption(MASTER_PATH_OPT);
            if (!(this.mPath.equals("") || (file2 = new File(this.mPath)).exists() || file2.mkdirs())) {
                this.mPath = null;
            }
        }
        if (this.laPath.equals("") || this.statusPath.equals("")) {
            this.exitLAP(17);
        }
        file2 = new File(this.laPath);
        File file3 = new File(this.statusPath);
        if (!file2.exists()) {
            this.exitLAP(19);
        }
        if (!file3.exists() && !file3.mkdirs()) {
            this.exitLAP(20);
        }
        if (!(file = new File(file3, "status.dat")).exists()) {
            try {
                new FileOutputStream(file.toString(), true).close();
                file.delete();
            }
            catch (IOException iOException) {
                this.exitLAP(21);
            }
        }
    }

    private void exitLAP(int n) {
        if (this.bShowExitCode) {
            System.out.println("Exited with: " + n);
        } else if (n != 3 && n != 9) {
            System.out.println("Exited with: " + n);
        }
        System.exit(n);
    }

    public String getmPath() {
        return this.mPath;
    }

    public boolean getnoPrint() {
        return this.noPrint;
    }

    public boolean getnoExport() {
        return this.noExport;
    }

    public String getwinStyle() {
        return this.winStyle;
    }

    public String getwinColorString() {
        return this.winColorString;
    }

    public String getdialogSizeString() {
        return this.dialogSizeString;
    }

    public String getfontName() {
        return this.fontName;
    }

    public String getfontStyleString() {
        return this.fontStyleString;
    }

    public String getfontSizeString() {
        return this.fontSizeString;
    }

    public boolean getbShowExitCode() {
        return this.bShowExitCode;
    }
}

