/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.Debug;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.PKCS7;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public final class ContentInfo
extends PKCSDerObject
implements Cloneable {
    private ObjectIdentifier contentType;
    private Content content;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.ContentInfo";
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$Ljava$security$cert$Certificate;

    public ContentInfo(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ContentInfo", (Object)byArray);
            debug.exit(16384L, className, "ContentInfo");
        }
    }

    public ContentInfo(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "ContentInfo", byArray, string);
            debug.exit(16384L, className, "ContentInfo");
        }
    }

    public ContentInfo(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        this(objectIdentifier, byArray, null);
        if (debug != null) {
            debug.entry(16384L, className, "ContentInfo", objectIdentifier, byArray);
            debug.exit(16384L, className, "ContentInfo");
        }
    }

    public ContentInfo(ObjectIdentifier objectIdentifier, byte[] byArray, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "ContentInfo", objectIdentifier, byArray);
        }
        this.contentType = objectIdentifier;
        if (byArray == null) {
            this.content = null;
            if (debug != null) {
                debug.exit(16384L, className, "ContentInfo_1");
            }
            return;
        }
        if (PKCS7.isData(objectIdentifier)) {
            this.content = new Data(this.provider);
            Data data = (Data)this.content;
            try {
                data.setData(byArray);
            }
            catch (PKCSException pKCSException) {
                if (debug != null) {
                    debug.exception(16384L, className, "ContentInfo", pKCSException);
                }
                throw new IOException("Error setting data bytes for Data content type.");
            }
            if (debug != null) {
                debug.exit(16384L, className, "ContentInfo_2");
            }
            return;
        }
        if (PKCS7.isSignedData(objectIdentifier)) {
            this.content = new SignedData(byArray, this.provider);
            if (debug != null) {
                debug.exit(16384L, className, "ContentInfo_3");
            }
            return;
        }
        if (PKCS7.isEnvelopedData(objectIdentifier)) {
            this.content = this.createDynamicObject("com.ibm.security.pkcs7.EnvelopedData", byArray);
            if (debug != null) {
                debug.exit(16384L, className, "ContentInfo_4");
            }
            return;
        }
        if (PKCS7.isSignedAndEnvelopedData(objectIdentifier)) {
            this.content = this.createDynamicObject("com.ibm.security.pkcs7.SignedAndEnvelopedData", byArray);
            if (debug != null) {
                debug.exit(16384L, className, "ContentInfo_5");
            }
            return;
        }
        if (PKCS7.isDigestedData(objectIdentifier)) {
            this.content = this.createDynamicObject("com.ibm.security.pkcs7.DigestedData", byArray);
            if (debug != null) {
                debug.exit(16384L, className, "ContentInfo_6");
            }
            return;
        }
        if (PKCS7.isEncryptedData(objectIdentifier)) {
            this.content = this.createDynamicObject("com.ibm.security.pkcs7.EncryptedData", byArray);
            if (debug != null) {
                debug.exit(16384L, className, "ContentInfo_7");
            }
            return;
        }
        if (debug != null) {
            debug.text(16384L, className, "ContentInfo", "Unknown content type " + objectIdentifier);
        }
        throw new IllegalArgumentException("Unknown content type " + objectIdentifier);
    }

    private Content createDynamicObject(String string, byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(8192L, string, "createDynamicObject", string, byArray);
        }
        Object var3_3 = null;
        try {
            Class<?> clazz = Class.forName(string);
            if (clazz == null) {
                if (debug != null) {
                    debug.text(8192L, string, "createDynamicObject", "Could not find class " + string);
                }
                throw new IOException("Could not find class " + string);
            }
            Class[] classArray = new Class[]{array$B == null ? (array$B = ContentInfo.class$("[B")) : array$B};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{byArray};
            var3_3 = constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (debug != null) {
                debug.exception(8192L, string, "createDynamicObject", classNotFoundException);
            }
            throw new IOException(classNotFoundException.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (debug != null) {
                debug.exception(8192L, string, "createDynamicObject", noSuchMethodException);
            }
            throw new IOException(noSuchMethodException.toString());
        }
        catch (InstantiationException instantiationException) {
            if (debug != null) {
                debug.exception(8192L, string, "createDynamicObject", instantiationException);
            }
            throw new IOException(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            if (debug != null) {
                debug.exception(8192L, string, "createDynamicObject", illegalAccessException);
            }
            throw new IOException(illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (debug != null) {
                debug.exception(8192L, string, "createDynamicObject", invocationTargetException);
            }
            throw new IOException(invocationTargetException.toString());
        }
        if (debug != null) {
            debug.exit(8192L, (Object)string, "createDynamicObject", var3_3);
        }
        return var3_3;
    }

    public ContentInfo(Content content) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ContentInfo", content);
        }
        this.contentType = content.getObjectIdentifier();
        this.content = content;
        if (debug != null) {
            debug.exit(16384L, className, "ContentInfo");
        }
    }

    public ContentInfo(Content content, String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "ContentInfo", content, string);
        }
        this.contentType = content.getObjectIdentifier();
        this.content = content;
        if (debug != null) {
            debug.exit(16384L, className, "ContentInfo");
        }
    }

    private ContentInfo(Object object) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "ContentInfo", object);
        }
        if (!(object instanceof Content)) {
            if (debug != null) {
                debug.text(8192L, className, "ContentInfo", "objcontent not of Content type");
            }
            throw new IllegalArgumentException("objcontent not of Content type");
        }
        Content content = (Content)object;
        this.contentType = content.getObjectIdentifier();
        this.content = content;
        if (debug != null) {
            debug.exit(8192L, className, "ContentInfo");
        }
    }

    private ContentInfo(Object object, String string) {
        super(string);
        if (debug != null) {
            debug.entry(8192L, className, "ContentInfo", object, string);
        }
        if (!(object instanceof Content)) {
            if (debug != null) {
                debug.text(8192L, className, "ContentInfo", "objcontent not of Content type");
            }
            throw new IllegalArgumentException("objcontent not of Content type");
        }
        Content content = (Content)object;
        this.contentType = content.getObjectIdentifier();
        this.content = content;
        if (debug != null) {
            debug.exit(8192L, className, "ContentInfo");
        }
    }

    public ContentInfo(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "ContentInfo", string, new Boolean(bl));
            debug.exit(16384L, className, "ContentInfo");
        }
    }

    public ContentInfo(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "ContentInfo", objectArray);
            debug.exit(16384L, className, "ContentInfo");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            ContentInfo contentInfo = new ContentInfo(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", contentInfo);
            }
            return contentInfo;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (!(object instanceof ContentInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((ContentInfo)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.contentType);
        if (this.content != null) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            this.content.encode(derOutputStream3);
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "ContentInfo parsing error.  Expecting the sequence tag.");
            }
            throw new IOException("ContentInfo parsing error.  Expecting the sequence tag.");
        }
        this.contentType = derValue.getData().getOID();
        if (derValue.getData().available() != 0 && (derValue2 = derValue.getData().getDerValue()).isContextSpecific((byte)0) && derValue2.isConstructed()) {
            DerValue derValue3 = derValue2.getData().getDerValue();
            this.content = this.createContent(this.contentType, derValue3);
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private Content createContent(ObjectIdentifier objectIdentifier, DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "createContent", objectIdentifier, derValue);
        }
        if (PKCS7.isData(objectIdentifier)) {
            byte[] byArray = derValue.getOctetString();
            Data data = new Data(this.provider);
            try {
                data.setData(byArray);
            }
            catch (PKCSException pKCSException) {
                if (debug != null) {
                    debug.exception(8192L, className, "createContent", pKCSException);
                    debug.text(8192L, className, "createContent", "Error setting data bytes for Data content type.");
                }
                throw new IOException("Error setting data bytes for Data content type.");
            }
            if (debug != null) {
                debug.exit(8192L, (Object)className, "createContent", data);
            }
            return data;
        }
        if (PKCS7.isSignedData(objectIdentifier)) {
            SignedData signedData = new SignedData(derValue.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(8192L, (Object)className, "createContent", signedData);
            }
            return signedData;
        }
        if (PKCS7.isEnvelopedData(objectIdentifier)) {
            Content content = this.createDynamicObject("com.ibm.security.pkcs7.EnvelopedData", derValue.toByteArray());
            if (debug != null) {
                debug.exit(8192L, (Object)className, "createContent", content);
            }
            return content;
        }
        if (PKCS7.isSignedAndEnvelopedData(objectIdentifier)) {
            Content content = this.createDynamicObject("com.ibm.security.pkcs7.SignedAndEnvelopedData", derValue.toByteArray());
            if (debug != null) {
                debug.exit(8192L, (Object)className, "createContent", content);
            }
            return content;
        }
        if (PKCS7.isDigestedData(objectIdentifier)) {
            Content content = this.createDynamicObject("com.ibm.security.pkcs7.DigestedData", derValue.toByteArray());
            if (debug != null) {
                debug.exit(8192L, (Object)className, "createContent", content);
            }
            return content;
        }
        if (PKCS7.isEncryptedData(objectIdentifier)) {
            Content content = this.createDynamicObject("com.ibm.security.pkcs7.EncryptedData", derValue.toByteArray());
            if (debug != null) {
                debug.exit(8192L, (Object)className, "createContent", content);
            }
            return content;
        }
        if (debug != null) {
            debug.text(8192L, className, "createContent", "Unknown object identifier " + objectIdentifier);
        }
        throw new IllegalArgumentException("Unknown object identifier " + objectIdentifier);
    }

    public ObjectIdentifier getContentType() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentType");
            debug.exit(16384L, (Object)className, "getContentType", this.contentType);
        }
        return this.contentType;
    }

    public Content getContent() {
        if (debug != null) {
            debug.entry(16384L, className, "getContent");
        }
        if (this.content == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", null);
            }
            return null;
        }
        if (this.isData()) {
            Data data = (Data)((Data)this.content).clone();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", data);
            }
            return data;
        }
        if (this.isSignedData()) {
            SignedData signedData = (SignedData)((SignedData)this.content).clone();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", signedData);
            }
            return signedData;
        }
        if (this.isEnvelopedData()) {
            Content content = this.getDynamicClone("com.ibm.security.pkcs7.EnvelopedData", this.content);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", content);
            }
            return content;
        }
        if (this.isSignedAndEnvelopedData()) {
            Content content = this.getDynamicClone("com.ibm.security.pkcs7.SignedAndEnvelopedData", this.content);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", content);
            }
            return content;
        }
        if (this.isDigestedData()) {
            Content content = this.getDynamicClone("com.ibm.security.pkcs7.DigestedData", this.content);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", content);
            }
            return content;
        }
        if (this.isEncryptedData()) {
            Content content = this.getDynamicClone("com.ibm.security.pkcs7.EncryptedData", this.content);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContent", content);
            }
            return content;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContent_1", null);
        }
        return null;
    }

    private Content getDynamicClone(String string, Content content) {
        if (debug != null) {
            debug.entry(8192L, className, "getDynamicClone", string, content);
        }
        try {
            Class<?> clazz = Class.forName(string);
            if (clazz == null) {
                if (debug != null) {
                    debug.text(8192L, className, "getDynamicClone", "Could not find class " + string);
                }
                throw new IllegalArgumentException("Could not find class " + string);
            }
            Class[] classArray = new Class[]{};
            Method method = clazz.getMethod("clone", classArray);
            Object[] objectArray = new Object[]{};
            Content content2 = (Content)method.invoke((Object)content, objectArray);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getDynamicClone", content2);
            }
            return content2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (debug != null) {
                debug.exception(8192L, className, "getDynamicClone", classNotFoundException);
            }
            throw new IllegalArgumentException(classNotFoundException.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (debug != null) {
                debug.exception(8192L, className, "getDynamicClone", noSuchMethodException);
            }
            throw new IllegalArgumentException(noSuchMethodException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            if (debug != null) {
                debug.exception(8192L, className, "getDynamicClone", illegalAccessException);
            }
            throw new IllegalArgumentException(illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (debug != null) {
                debug.exception(8192L, className, "getDynamicClone", invocationTargetException);
            }
            throw new IllegalArgumentException(invocationTargetException.toString());
        }
    }

    public boolean isData() {
        if (debug != null) {
            debug.entry(16384L, className, "isData");
            debug.exit(16384L, (Object)className, "isData", new Boolean(PKCS7.isData(this.contentType)));
        }
        return PKCS7.isData(this.contentType);
    }

    public boolean isSignedData() {
        if (debug != null) {
            debug.entry(16384L, className, "isSignedData");
            debug.exit(16384L, (Object)className, "isSignedData", new Boolean(PKCS7.isSignedData(this.contentType)));
        }
        return PKCS7.isSignedData(this.contentType);
    }

    public boolean isEnvelopedData() {
        if (debug != null) {
            debug.entry(16384L, className, "isEnvelopedData");
            debug.exit(16384L, (Object)className, "isEnvelopedData", new Boolean(PKCS7.isEnvelopedData(this.contentType)));
        }
        return PKCS7.isEnvelopedData(this.contentType);
    }

    public boolean isSignedAndEnvelopedData() {
        if (debug != null) {
            debug.entry(16384L, className, "isSignedAndEnvelopedData");
            debug.exit(16384L, (Object)className, "isSignedAnd EnvelopedData", new Boolean(PKCS7.isSignedAndEnvelopedData(this.contentType)));
        }
        return PKCS7.isSignedAndEnvelopedData(this.contentType);
    }

    public boolean isDigestedData() {
        if (debug != null) {
            debug.entry(16384L, className, "isDigestedData");
            debug.exit(16384L, (Object)className, "isDigestedData", new Boolean(PKCS7.isDigestedData(this.contentType)));
        }
        return PKCS7.isDigestedData(this.contentType);
    }

    public boolean isEncryptedData() {
        if (debug != null) {
            debug.entry(16384L, className, "isEncryptedData");
            debug.exit(16384L, (Object)className, "isEncryptedData", new Boolean(PKCS7.isEncryptedData(this.contentType)));
        }
        return PKCS7.isEncryptedData(this.contentType);
    }

    public String getContentTypeString() {
        if (debug != null) {
            debug.entry(16384L, className, "getContentTypeString");
        }
        if (this.isData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentTypeString", "Data");
            }
            return "Data";
        }
        if (this.isSignedData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentTypeString", "Signed Data");
            }
            return "Signed Data";
        }
        if (this.isEnvelopedData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentTypeString", "Enveloped Data");
            }
            return "Enveloped Data";
        }
        if (this.isSignedAndEnvelopedData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentTypeString", "Signed and Enveloped Data");
            }
            return "Signed and Enveloped Data";
        }
        if (this.isDigestedData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentTypeString", "Digested Data");
            }
            return "Digested Data";
        }
        if (this.isEncryptedData()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getContentTypeString", "Encrypted Data");
            }
            return "Encrypted Data";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getContentTypeString", null);
        }
        return null;
    }

    public String toString() {
        String string = "";
        string = string + "PKCS7 ContentInfo:  " + this.getContentTypeString() + "\r\n";
        string = string + "\tOID = " + this.contentType.toString() + "\r\n";
        string = string + "\tContent = \r\n";
        string = string + this.content.toString();
        return string;
    }

    public ContentInfo encrypt(Certificate[] certificateArray, String string, int n) throws IOException, PKCSException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{certificateArray, string, new Integer(n)};
            debug.entry(16384L, (Object)className, "encrypt", objectArray);
        }
        objectArray = (Object[])this.clone();
        try {
            String string2 = "com.ibm.security.pkcs7.EnvelopedData";
            Class<?> clazz = Class.forName(string2);
            if (clazz == null) {
                if (debug != null) {
                    debug.text(16384L, className, "encrypt", "Could not find class " + string2);
                }
                throw new PKCSException("Could not find class " + string2);
            }
            Class[] classArray = new Class[]{array$Ljava$security$cert$Certificate == null ? (array$Ljava$security$cert$Certificate = ContentInfo.class$("[Ljava.security.cert.Certificate;")) : array$Ljava$security$cert$Certificate, Class.forName("com.ibm.security.pkcs7.ContentInfo"), Class.forName("java.lang.String"), Integer.TYPE, Class.forName("com.ibm.security.pkcsutil.PKCSAttributes")};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object var9_14 = null;
            Integer n2 = new Integer(n);
            Object[] objectArray2 = new Object[]{certificateArray, objectArray, string, n2, var9_14};
            Object obj = constructor.newInstance(objectArray2);
            ContentInfo contentInfo = new ContentInfo(obj, this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "encrypt", contentInfo);
            }
            return contentInfo;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", classNotFoundException);
            }
            throw new PKCSException(classNotFoundException, classNotFoundException.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", noSuchMethodException);
            }
            throw new PKCSException(noSuchMethodException, noSuchMethodException.toString());
        }
        catch (InstantiationException instantiationException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", instantiationException);
            }
            throw new PKCSException(instantiationException, instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", illegalAccessException);
            }
            throw new PKCSException(illegalAccessException, illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (debug != null) {
                debug.exception(16384L, className, "encrypt", invocationTargetException);
            }
            throw new PKCSException(invocationTargetException, invocationTargetException.toString());
        }
    }

    public ContentInfo decrypt(PrivateKey privateKey, Certificate certificate) throws IOException, PKCSException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{privateKey, certificate};
            debug.entry(16384L, (Object)className, "decrypt", objectArray);
        }
        if (!PKCS7.isEnvelopedData(this.contentType)) {
            objectArray = "ContentType must be EnvelopedData.  ContentType has oid = " + this.contentType;
            if (debug != null) {
                debug.text(16384L, className, "decrypt", (String)objectArray);
            }
            throw new IllegalArgumentException((String)objectArray);
        }
        try {
            objectArray = "com.ibm.security.pkcs7.EnvelopedData";
            Class<?> clazz = Class.forName((String)objectArray);
            if (clazz == null) {
                if (debug != null) {
                    debug.text(16384L, className, "decrypt", "Could not find class " + (String)objectArray);
                }
                throw new PKCSException("Could not find class " + (String)objectArray);
            }
            Class[] classArray = new Class[]{Class.forName("java.security.PrivateKey"), Class.forName("java.security.cert.Certificate")};
            Method method = clazz.getMethod("decrypt", classArray);
            Object[] objectArray2 = new Object[]{privateKey, certificate};
            ContentInfo contentInfo = (ContentInfo)method.invoke((Object)this.content, objectArray2);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decrypt", contentInfo);
            }
            return contentInfo;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", classNotFoundException);
            }
            throw new PKCSException(classNotFoundException, classNotFoundException.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", noSuchMethodException);
            }
            throw new PKCSException(noSuchMethodException, noSuchMethodException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", illegalAccessException);
            }
            throw new PKCSException(illegalAccessException, illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (debug != null) {
                debug.exception(16384L, className, "decrypt", invocationTargetException);
            }
            throw new PKCSException(invocationTargetException, invocationTargetException.toString());
        }
    }

    public ContentInfo sign(Certificate certificate, String string, PrivateKey privateKey, boolean bl) throws PKCSException, IOException, NoSuchAlgorithmException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{certificate, string, privateKey, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "sign", objectArray);
        }
        objectArray = (Object[])this.clone();
        SignedData signedData = new SignedData(certificate, (ContentInfo)objectArray, string, privateKey, bl, this.provider);
        ContentInfo contentInfo = new ContentInfo(signedData, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "sign", contentInfo);
        }
        return contentInfo;
    }

    public boolean verify(Certificate certificate) throws PKCSException, IOException, NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verify", certificate);
        }
        if (!PKCS7.isSignedData(this.contentType)) {
            String string = "ContentType must be SignedData.  ContentType has oid = " + this.contentType;
            if (debug != null) {
                debug.text(16384L, className, "verify", string);
            }
            throw new IllegalArgumentException(string);
        }
        boolean bl = ((SignedData)this.content).verify(certificate);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "verify", new Boolean(bl));
        }
        return bl;
    }

    public ContentInfo seal(Certificate[] certificateArray, String string, int n, Certificate certificate, String string2, PrivateKey privateKey, boolean bl) throws PKCSException, IOException, NoSuchAlgorithmException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{certificateArray, string, new Integer(n), certificate, string2, privateKey, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "seal", objectArray);
        }
        objectArray = (Object[])this.clone();
        SignedData signedData = new SignedData(certificate, (ContentInfo)objectArray, string2, privateKey, bl, this.provider);
        ContentInfo contentInfo = new ContentInfo(signedData, this.provider);
        ContentInfo contentInfo2 = contentInfo.encrypt(certificateArray, string, n);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "seal", contentInfo2);
        }
        return contentInfo2;
    }

    public ContentInfo unseal(Certificate certificate, Certificate certificate2, PrivateKey privateKey) throws PKCSException, IOException, NoSuchAlgorithmException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{certificate, certificate2, privateKey};
            debug.entry(16384L, (Object)className, "unseal", objectArray);
        }
        if (!PKCS7.isSignedData(this.contentType) && !PKCS7.isEnvelopedData(this.contentType)) {
            objectArray = "ContentType must be SignedData or EnvelopedData.  ContentType has oid = " + this.contentType;
            if (debug != null) {
                debug.text(16384L, className, "unseal", (String)objectArray);
            }
            throw new IllegalArgumentException((String)objectArray);
        }
        objectArray = this;
        if (PKCS7.isEnvelopedData(this.contentType)) {
            objectArray = this.decrypt(privateKey, certificate);
        }
        if (objectArray.verify(certificate2)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "unseal", objectArray);
            }
            return objectArray;
        }
        if (debug != null) {
            debug.text(16384L, className, "unseal", "ContentInfo verify failed.");
        }
        throw new PKCSException("ContentInfo verify failed.");
    }

    protected void readBASE64(String string) throws IOException {
        FileInputStream fileInputStream;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "readBASE64", string);
        }
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (debug != null) {
                debug.exception(16384L, className, "readBASE64", fileNotFoundException);
                debug.text(16384L, className, "readBASE64", "File " + string + " not found.");
            }
            throw new IOException("File " + string + " not found.");
        }
        int n = fileInputStream.available();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray);
        fileInputStream.close();
        String string2 = "\r\n";
        byte[] byArray2 = null;
        String string3 = null;
        try {
            byArray2 = string2.getBytes("8859_1");
            string3 = new String(byArray, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (debug != null) {
                debug.exception(16384L, className, "readBASE64", unsupportedEncodingException);
            }
            byArray2 = string2.getBytes();
            string3 = new String(byArray);
        }
        StringReader stringReader = new StringReader(string3);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        while ((string4 = bufferedReader.readLine()) != null) {
            try {
                byteArrayOutputStream2.write(string4.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (debug != null) {
                    debug.exception(16384L, className, "readBASE64", unsupportedEncodingException);
                }
                byteArrayOutputStream2.write(string4.getBytes());
            }
            if (string4.equals("-----BEGIN CERTIFICATE-----")) {
                bl = true;
                continue;
            }
            if (string4.equals("-----END CERTIFICATE-----")) {
                bl2 = true;
                break;
            }
            if (!bl) continue;
            try {
                byteArrayOutputStream.write(string4.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byteArrayOutputStream.write(string4.getBytes());
            }
            byteArrayOutputStream.write(byArray2);
        }
        ByteArrayInputStream byteArrayInputStream = null;
        if (!bl && !bl2) {
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream2.toByteArray());
        } else {
            if (!bl) {
                if (debug != null) {
                    debug.text(16384L, className, "readBASE64", "File found the following header, but did not find the footer: -----BEGIN CERTIFICATE-----");
                }
                throw new IOException("File found the following header, but did not find the footer: -----BEGIN CERTIFICATE-----");
            }
            if (!bl2) {
                if (debug != null) {
                    debug.text(16384L, className, "readBASE64", "File found the following footer, but did not find the header: -----END CERTIFICATE-----");
                }
                throw new IOException("File found the following footer, but did not find the header: -----END CERTIFICATE-----");
            }
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray3 = bASE64Decoder.decodeBuffer(byteArrayInputStream);
        if (debug != null) {
            debug.exit(16384L, className, "readBASE64");
        }
        this.decode(byArray3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

