/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class MessageDigest
extends PKCS9DerObject
implements Cloneable {
    private byte[] bytes;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.LocalKeyId";

    public MessageDigest() {
        if (debug != null) {
            debug.entry(16384L, className, "MessageDigest");
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public MessageDigest(String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "MessageDigest", string);
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public MessageDigest(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "MessageDigest", (Object)byArray);
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public MessageDigest(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "MessageDigest", byArray, string);
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public MessageDigest(byte[] byArray, int n) throws IOException {
        this.bytes = (byte[])byArray.clone();
        if (debug != null) {
            debug.entry(16384L, className, "MessageDigest", byArray, new Integer(n));
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public MessageDigest(byte[] byArray, int n, String string) throws IOException {
        super(string);
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, new Integer(n), string};
            debug.entry(16384L, (Object)className, "MessageDigest", objectArray);
        }
        this.bytes = (byte[])byArray.clone();
        if (debug != null) {
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public MessageDigest(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "MessageDigest", string, new Boolean(bl));
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public MessageDigest(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "MessageDigest", objectArray);
            debug.exit(16384L, className, "MessageDigest");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            MessageDigest messageDigest = new MessageDigest(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", messageDigest);
            }
            return messageDigest;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof MessageDigest) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((MessageDigest)object)));
            }
            return this.equals((MessageDigest)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.MESSAGE_DIGEST_OID);
        }
        return PKCSOID.MESSAGE_DIGEST_OID;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.bytes == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Byte array not specified.");
            }
            throw new IOException("Byte array not specified.");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.getObjectIdentifier());
        derOutputStream2.putOctetString(this.bytes);
        derOutputStream.write((byte)49, derOutputStream2.toByteArray());
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream.toByteArray());
        outputStream.write(derOutputStream3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public synchronized void setData(byte[] byArray) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setData", (Object)byArray);
        }
        if (this.bytes != null) {
            if (debug != null) {
                debug.text(16384L, className, "setData", "Message digest byte array already set.");
            }
            throw new PKCSException("Message digest byte array already set.");
        }
        this.bytes = byArray;
        if (debug != null) {
            debug.exit(16384L, className, "setData");
        }
    }

    public byte[] getBytes() {
        if (debug != null) {
            debug.entry(16384L, className, "getBytes");
            debug.exit(16384L, (Object)className, "getBytes", this.bytes.clone());
        }
        return (byte[])this.bytes.clone();
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getBytes());
        }
        return this.getBytes();
    }

    public boolean isTagValid(byte by) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(by));
        }
        if (by == 4) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(true));
        }
        return true;
    }

    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "MessageDigest");
        }
        return "MessageDigest";
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "PKCS9 MessageDigest:\r\n";
        string = this.bytes != null ? string + "\r\n" + hexDumpEncoder.encodeBuffer(this.bytes) + "\r\n" : string + "null";
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        super.decode(derValue);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        DerValue[] derValueArray = null;
        if (derValue.getTag() == 48) {
            DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
            DerValue[] derValueArray2 = derInputStream.getSequence(2);
            derValueArray = new DerInputStream(derValueArray2[1].toByteArray()).getSet(1);
        } else {
            derValueArray = new DerInputStream(derValue.toByteArray()).getSet(1);
        }
        this.bytes = new DerInputStream(derValueArray[0].toByteArray()).getOctetString();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(MessageDigest messageDigest) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", messageDigest);
        }
        if (messageDigest == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            messageDigest.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

