/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.AccessController;
import java.security.Policy;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import sun.plugin.ClassLoaderInfo;
import sun.plugin.JavaRunTime;
import sun.plugin.cache.FileCache;
import sun.plugin.cache.JarCache;
import sun.plugin.net.proxy.PluginProxyManager;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.CertificateHostnameVerifier;
import sun.plugin.security.TrustDecider;
import sun.plugin.security.X509PluginTrustManager;
import sun.plugin.services.ServiceProvider;
import sun.plugin.util.PluginLogger;
import sun.plugin.util.PluginSysUtil;
import sun.plugin.util.PluginUIManager;
import sun.plugin.util.Trace;
import sun.security.action.GetPropertyAction;

class ConsoleWindow
extends JFrame {
    private JTextArea textArea;
    private JScrollPane scroller;
    private JScrollBar sbHor;
    private JScrollBar sbVer;
    private boolean onWindows;
    private boolean isMozilla;
    private boolean iconifiedOnClose;
    protected static ActionListener traceLevel0;
    protected static ActionListener traceLevel1;
    protected static ActionListener traceLevel2;
    protected static ActionListener traceLevel3;
    protected static ActionListener traceLevel4;
    protected static ActionListener traceLevel5;
    private static final int TEXT_LIMIT = 1048575;

    ConsoleWindow() {
        super(ResourceHandler.getMessage("console.caption"));
        Object object;
        Object object2;
        Object object3;
        PluginUIManager.setTheme();
        this.onWindows = false;
        this.isMozilla = false;
        this.iconifiedOnClose = false;
        try {
            object3 = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (((String)object3).indexOf("Windows") != -1) {
                this.onWindows = true;
            }
            if (((String)object3).indexOf("OS/2") != -1) {
                this.onWindows = true;
            }
            if ((object2 = AccessController.doPrivileged(new GetPropertyAction("mozilla.workaround", "false"))) != null && ((String)object2).equalsIgnoreCase("true")) {
                this.isMozilla = true;
            }
            object = ServiceProvider.getService();
            this.iconifiedOnClose = object.isConsoleIconifiedOnClose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setSize(450, 400);
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
        if (!this.onWindows && this.isMozilla) {
            this.getRootPane().setDoubleBuffered(false);
            ((JPanel)this.getContentPane()).setDoubleBuffered(false);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setMargin(new Insets(0, 5, 0, 0));
        this.scroller = new JScrollPane(this.textArea);
        object3 = this.scroller.getViewport();
        ((JViewport)object3).setScrollMode(1);
        this.sbVer = this.scroller.getVerticalScrollBar();
        this.sbHor = this.scroller.getHorizontalScrollBar();
        this.getContentPane().add((Component)this.scroller, "Center");
        object2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(ResourceHandler.getMessage("console.dump.stack"));
                stringBuffer.append(ResourceHandler.getMessage("console.menu.text.top"));
                stringBuffer.append(JavaRunTime.dumpAllStacks());
                stringBuffer.append(ResourceHandler.getMessage("console.menu.text.tail"));
                stringBuffer.append(ResourceHandler.getMessage("console.done"));
                System.out.println(stringBuffer.toString());
            }
        };
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(ResourceHandler.getMessage("console.dump.thread"));
                Thread thread = Thread.currentThread();
                ThreadGroup threadGroup = JavaRunTime.getPluginThreadGroup().getParent();
                ConsoleWindow.this.dumpThreadGroup(threadGroup, stringBuffer);
                stringBuffer.append(ResourceHandler.getMessage("console.done"));
                System.out.println(stringBuffer.toString());
            }
        };
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Policy policy = Policy.getPolicy();
                System.out.print(ResourceHandler.getMessage("console.reload.policy"));
                policy.refresh();
                System.out.println(ResourceHandler.getMessage("console.completed"));
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(ResourceHandler.getMessage("console.reload.proxy"));
                PluginProxyManager.reset();
                System.out.println(ResourceHandler.getMessage("console.done"));
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleWindow.displaySystemProperties();
            }
        };
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ConsoleWindow.displayHelp();
                System.out.print(string);
            }
        };
        ActionListener actionListener5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassLoaderInfo.dumpClassLoaderCache(System.out);
            }
        };
        ActionListener actionListener6 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarCache.clearLoadedJars();
                FileCache.clearLoadedFiles();
                ClassLoaderInfo.clearClassLoaderCache();
                TrustDecider.reset();
                X509PluginTrustManager.reset();
                CertificateHostnameVerifier.reset();
                System.out.println(ResourceHandler.getMessage("console.clear.classloader"));
            }
        };
        ActionListener actionListener7 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ConsoleWindow.displayVersion();
                String string2 = ConsoleWindow.displayHelp();
                String string3 = string + "\n" + string2;
                ConsoleWindow.this.textArea.setText(string3);
                ConsoleWindow.this.textArea.revalidate();
            }
        };
        ActionListener actionListener8 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ConsoleWindow.this.textArea.getSelectionStart();
                int n2 = ConsoleWindow.this.textArea.getSelectionEnd();
                if (n2 - n <= 0) {
                    ConsoleWindow.this.textArea.selectAll();
                }
                ConsoleWindow.this.textArea.copy();
            }
        };
        ActionListener actionListener9 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ConsoleWindow.this.iconifiedOnClose) {
                    ConsoleWindow.this.setState(1);
                } else {
                    ConsoleWindow.this.setVisible(false);
                }
            }
        };
        final ActionListener actionListener10 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                long l = Runtime.getRuntime().freeMemory() / 1024L;
                long l2 = Runtime.getRuntime().totalMemory() / 1024L;
                long l3 = (long)(100.0 / ((double)l2 / (double)l));
                MessageFormat messageFormat = new MessageFormat(ResourceHandler.getMessage("console.memory"));
                Object[] objectArray = new Object[]{new Long(l2), new Long(l), new Long(l3)};
                System.out.print(messageFormat.format(objectArray));
                System.out.println(ResourceHandler.getMessage("console.completed"));
            }
        };
        ActionListener actionListener11 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.print(ResourceHandler.getMessage("console.finalize"));
                System.runFinalization();
                System.out.println(ResourceHandler.getMessage("console.completed"));
                actionListener10.actionPerformed(actionEvent);
            }
        };
        ActionListener actionListener12 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.print(ResourceHandler.getMessage("console.gc"));
                System.gc();
                System.out.println(ResourceHandler.getMessage("console.completed"));
                actionListener10.actionPerformed(actionEvent);
            }
        };
        traceLevel0 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(false);
                Trace.setNetTrace(false);
                Trace.setSecurityTrace(false);
                Trace.setExtTrace(false);
                Trace.setLiveConnectTrace(false);
                System.out.println(ResourceHandler.getMessage("console.trace.level.0"));
            }
        };
        traceLevel1 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(true);
                Trace.setNetTrace(false);
                Trace.setSecurityTrace(false);
                Trace.setExtTrace(false);
                Trace.setLiveConnectTrace(false);
                System.out.println(ResourceHandler.getMessage("console.trace.level.1"));
            }
        };
        traceLevel2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(true);
                Trace.setNetTrace(true);
                Trace.setSecurityTrace(false);
                Trace.setExtTrace(false);
                Trace.setLiveConnectTrace(false);
                System.out.println(ResourceHandler.getMessage("console.trace.level.2"));
            }
        };
        traceLevel3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(true);
                Trace.setNetTrace(true);
                Trace.setSecurityTrace(true);
                Trace.setExtTrace(false);
                Trace.setLiveConnectTrace(false);
                System.out.println(ResourceHandler.getMessage("console.trace.level.3"));
            }
        };
        traceLevel4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(true);
                Trace.setNetTrace(true);
                Trace.setSecurityTrace(true);
                Trace.setExtTrace(true);
                Trace.setLiveConnectTrace(false);
                System.out.println(ResourceHandler.getMessage("console.trace.level.4"));
            }
        };
        traceLevel5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Trace.setBasicTrace(true);
                Trace.setNetTrace(true);
                Trace.setSecurityTrace(true);
                Trace.setExtTrace(true);
                Trace.setLiveConnectTrace(true);
                System.out.println(ResourceHandler.getMessage("console.trace.level.5"));
            }
        };
        ActionListener actionListener13 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginLogger.setLogging(!PluginLogger.getLogging());
                System.out.println(ResourceHandler.getMessage("console.log") + PluginLogger.getLogging() + ResourceHandler.getMessage("console.completed"));
            }
        };
        this.textArea.registerKeyboardAction((ActionListener)object2, KeyStroke.getKeyStroke(86, 0), 2);
        this.textArea.registerKeyboardAction((ActionListener)object, KeyStroke.getKeyStroke(84, 0), 2);
        this.textArea.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke(80, 0), 2);
        this.textArea.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(82, 0), 2);
        this.textArea.registerKeyboardAction(actionListener3, KeyStroke.getKeyStroke(83, 0), 2);
        this.textArea.registerKeyboardAction(actionListener4, KeyStroke.getKeyStroke(72, 0), 2);
        this.textArea.registerKeyboardAction(actionListener10, KeyStroke.getKeyStroke(77, 0), 2);
        this.textArea.registerKeyboardAction(actionListener7, KeyStroke.getKeyStroke(67, 0), 2);
        this.textArea.registerKeyboardAction(actionListener12, KeyStroke.getKeyStroke(71, 0), 2);
        this.textArea.registerKeyboardAction(actionListener11, KeyStroke.getKeyStroke(70, 0), 2);
        this.textArea.registerKeyboardAction(actionListener9, KeyStroke.getKeyStroke(81, 0), 2);
        this.textArea.registerKeyboardAction(actionListener6, KeyStroke.getKeyStroke(88, 0), 2);
        this.textArea.registerKeyboardAction(actionListener5, KeyStroke.getKeyStroke(76, 0), 2);
        this.textArea.registerKeyboardAction(actionListener13, KeyStroke.getKeyStroke(79, 0), 2);
        this.textArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                ActionEvent actionEvent = new ActionEvent(keyEvent.getSource(), keyEvent.getID(), "");
                switch (c) {
                    case '0': {
                        traceLevel0.actionPerformed(actionEvent);
                        break;
                    }
                    case '1': {
                        traceLevel1.actionPerformed(actionEvent);
                        break;
                    }
                    case '2': {
                        traceLevel2.actionPerformed(actionEvent);
                        break;
                    }
                    case '3': {
                        traceLevel3.actionPerformed(actionEvent);
                        break;
                    }
                    case '4': {
                        traceLevel4.actionPerformed(actionEvent);
                        break;
                    }
                    case '5': {
                        traceLevel5.actionPerformed(actionEvent);
                        break;
                    }
                }
            }
        });
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>();
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        this.textArea.setFocusTraversalKeys(0, hashSet);
        hashSet.clear();
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 64));
        this.textArea.setFocusTraversalKeys(1, hashSet);
        this.textArea.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ConsoleWindow.this.textArea.getCaret().setVisible(true);
            }
        });
        JButton jButton = new JButton(ResourceHandler.getMessage("console.clear"));
        jButton.setMnemonic(ResourceHandler.getAcceleratorKey("console.clear"));
        JButton jButton2 = new JButton(ResourceHandler.getMessage("console.copy"));
        jButton2.setMnemonic(ResourceHandler.getAcceleratorKey("console.copy"));
        JButton jButton3 = new JButton(ResourceHandler.getMessage("console.close"));
        jButton3.setMnemonic(ResourceHandler.getAcceleratorKey("console.close"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(new JLabel("    "));
        jPanel.add(jButton2);
        jPanel.add(new JLabel("    "));
        jPanel.add(jButton3);
        this.getContentPane().add((Component)jPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (ConsoleWindow.this.iconifiedOnClose) {
                    ConsoleWindow.this.setState(1);
                } else {
                    ConsoleWindow.this.setVisible(false);
                }
            }
        });
        jButton.addActionListener(actionListener7);
        jButton2.addActionListener(actionListener8);
        jButton3.addActionListener(actionListener9);
    }

    public void append(final String string) {
        PluginSysUtil.invokeLater(new Runnable(){

            public void run() {
                int n = ConsoleWindow.this.textArea.getText().length() + string.length() - 1048575;
                if (n > 0) {
                    ConsoleWindow.this.textArea.replaceRange("", 0, n);
                }
                ConsoleWindow.this.textArea.append(string);
                ConsoleWindow.this.textArea.revalidate();
                ConsoleWindow.this.setScrollPosition();
            }
        });
    }

    private void dumpThreadGroup(ThreadGroup threadGroup, StringBuffer stringBuffer) {
        if (threadGroup != null) {
            try {
                if (threadGroup.activeCount() == 0 && threadGroup.activeGroupCount() == 0 && !threadGroup.isDestroyed()) {
                    threadGroup.destroy();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            stringBuffer.append("Group " + threadGroup.getName());
            stringBuffer.append(",ac=" + threadGroup.activeCount());
            stringBuffer.append(",agc=" + threadGroup.activeGroupCount());
            stringBuffer.append(",pri=" + threadGroup.getMaxPriority());
            if (threadGroup.isDestroyed()) {
                stringBuffer.append(",destoyed");
            }
            if (threadGroup.isDaemon()) {
                stringBuffer.append(",daemon");
            }
            stringBuffer.append("\n");
            Thread[] threadArray = new Thread[1000];
            threadGroup.enumerate(threadArray, false);
            for (int i = 0; i < threadArray.length; ++i) {
                if (threadArray[i] == null) continue;
                stringBuffer.append("    ");
                stringBuffer.append(threadArray[i].getName());
                stringBuffer.append(",");
                stringBuffer.append(threadArray[i].getPriority());
                if (threadArray[i].isAlive()) {
                    stringBuffer.append(",alive");
                } else {
                    stringBuffer.append(",not alive");
                }
                if (threadArray[i].isDaemon()) {
                    stringBuffer.append(",daemon");
                }
                if (threadArray[i].isInterrupted()) {
                    stringBuffer.append(",interrupted");
                }
                stringBuffer.append("\n");
            }
            ThreadGroup[] threadGroupArray = new ThreadGroup[1000];
            threadGroup.enumerate(threadGroupArray, false);
            for (int i = 0; i < threadGroupArray.length; ++i) {
                if (threadGroupArray[i] == null) continue;
                this.dumpThreadGroup(threadGroupArray[i], stringBuffer);
            }
        }
    }

    public static String displayHelp() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.top"));
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.c"));
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.f"));
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.g"));
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.h"));
        String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (string.indexOf("Windows") != -1 && System.getProperty("javaplugin.vm.options").indexOf("-Xrunjcov") != -1) {
            stringBuffer.append(ResourceHandler.getMessage("console.menu.text.j"));
        }
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.l"));
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.m"));
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.o"));
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.p"));
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.q"));
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.r"));
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.s"));
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.t"));
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.v"));
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.x"));
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.0"));
        stringBuffer.append(ResourceHandler.getMessage("console.menu.text.tail"));
        return stringBuffer.toString();
    }

    public static String displayVersion() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ResourceHandler.getMessage("product_name"));
        String string = System.getProperty("javaplugin.version");
        if (string != null) {
            stringBuffer.append(": " + ResourceHandler.getMessage("version") + " " + System.getProperty("javaplugin.version"));
        }
        stringBuffer.append("\n");
        stringBuffer.append(ResourceHandler.getMessage("using_jre_version"));
        stringBuffer.append(" ");
        stringBuffer.append(System.getProperty("java.version"));
        stringBuffer.append(" ");
        stringBuffer.append(System.getProperty("java.vm.name"));
        stringBuffer.append("\n");
        stringBuffer.append(ResourceHandler.getMessage("user_home_dir"));
        stringBuffer.append(" = ");
        stringBuffer.append(System.getProperty("user.home"));
        return stringBuffer.toString();
    }

    public static void displaySystemProperties() {
        TreeSet treeSet = new TreeSet();
        Object object = System.getProperties().propertyNames();
        while (object.hasMoreElements()) {
            treeSet.add(object.nextElement());
        }
        object = new StringBuffer();
        ((StringBuffer)object).append(ResourceHandler.getMessage("console.dump.properties"));
        ((StringBuffer)object).append(ResourceHandler.getMessage("console.menu.text.top"));
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = System.getProperty(string);
            if (string2 != null) {
                if (string2.equals("\n")) {
                    string2 = "\\n";
                } else if (string2.equals("\r")) {
                    string2 = "\\r";
                } else if (string2.equals("\r\n")) {
                    string2 = "\\r\\n";
                } else if (string2.equals("\n\r")) {
                    string2 = "\\n\\r";
                } else if (string2.equals("\n\n")) {
                    string2 = "\\n\\n";
                } else if (string2.equals("\r\r")) {
                    string2 = "\\r\\r";
                }
            }
            ((StringBuffer)object).append(string + " = " + string2 + "\n");
        }
        ((StringBuffer)object).append(ResourceHandler.getMessage("console.menu.text.tail"));
        ((StringBuffer)object).append(ResourceHandler.getMessage("console.done"));
        System.out.println(((StringBuffer)object).toString());
    }

    public void setScrollPosition() {
        this.scroller.validate();
        this.sbVer.setValue(this.sbVer.getMaximum());
        this.sbHor.setValue(this.sbHor.getMinimum());
    }

    public void showConsole(boolean bl) {
        if (this.iconifiedOnClose) {
            if (bl) {
                this.setState(0);
            } else {
                this.setState(1);
            }
            this.setVisible(true);
        } else {
            if (this.isVisible() != bl) {
                this.setVisible(bl);
            }
            if (bl) {
                this.toFront();
            }
        }
    }

    public boolean isConsoleVisible() {
        if (this.iconifiedOnClose) {
            return this.getState() == 0;
        }
        return this.isVisible();
    }
}

