/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthButtonUI;
import com.sun.java.swing.plaf.gtk.SynthCheckBoxMenuItemUI;
import com.sun.java.swing.plaf.gtk.SynthCheckBoxUI;
import com.sun.java.swing.plaf.gtk.SynthColorChooserUI;
import com.sun.java.swing.plaf.gtk.SynthComboBoxUI;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthDesktopIconUI;
import com.sun.java.swing.plaf.gtk.SynthDesktopPaneUI;
import com.sun.java.swing.plaf.gtk.SynthEditorPaneUI;
import com.sun.java.swing.plaf.gtk.SynthEventListener;
import com.sun.java.swing.plaf.gtk.SynthFormattedTextFieldUI;
import com.sun.java.swing.plaf.gtk.SynthInternalFrameUI;
import com.sun.java.swing.plaf.gtk.SynthLabelUI;
import com.sun.java.swing.plaf.gtk.SynthListUI;
import com.sun.java.swing.plaf.gtk.SynthMenuBarUI;
import com.sun.java.swing.plaf.gtk.SynthMenuItemUI;
import com.sun.java.swing.plaf.gtk.SynthMenuUI;
import com.sun.java.swing.plaf.gtk.SynthOptionPaneUI;
import com.sun.java.swing.plaf.gtk.SynthPainter;
import com.sun.java.swing.plaf.gtk.SynthPanelUI;
import com.sun.java.swing.plaf.gtk.SynthPasswordFieldUI;
import com.sun.java.swing.plaf.gtk.SynthPopupMenuUI;
import com.sun.java.swing.plaf.gtk.SynthProgressBarUI;
import com.sun.java.swing.plaf.gtk.SynthRadioButtonMenuItemUI;
import com.sun.java.swing.plaf.gtk.SynthRadioButtonUI;
import com.sun.java.swing.plaf.gtk.SynthRootPaneUI;
import com.sun.java.swing.plaf.gtk.SynthScrollBarUI;
import com.sun.java.swing.plaf.gtk.SynthScrollPaneUI;
import com.sun.java.swing.plaf.gtk.SynthSeparatorUI;
import com.sun.java.swing.plaf.gtk.SynthSliderUI;
import com.sun.java.swing.plaf.gtk.SynthSpinnerUI;
import com.sun.java.swing.plaf.gtk.SynthSplitPaneUI;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthStyleFactory;
import com.sun.java.swing.plaf.gtk.SynthTabbedPaneUI;
import com.sun.java.swing.plaf.gtk.SynthTableHeaderUI;
import com.sun.java.swing.plaf.gtk.SynthTableUI;
import com.sun.java.swing.plaf.gtk.SynthTextAreaUI;
import com.sun.java.swing.plaf.gtk.SynthTextFieldUI;
import com.sun.java.swing.plaf.gtk.SynthTextPaneUI;
import com.sun.java.swing.plaf.gtk.SynthToggleButtonUI;
import com.sun.java.swing.plaf.gtk.SynthToolBarUI;
import com.sun.java.swing.plaf.gtk.SynthToolTipUI;
import com.sun.java.swing.plaf.gtk.SynthTreeUI;
import com.sun.java.swing.plaf.gtk.SynthUI;
import com.sun.java.swing.plaf.gtk.SynthViewportUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import sun.awt.AppContext;

class SynthLookAndFeel
extends LookAndFeel {
    static final Insets EMPTY_UIRESOURCE_INSETS = new InsetsUIResource(0, 0, 0, 0);
    private static final Object STYLE_FACTORY_KEY = new StringBuffer("com.sun.java.swing.plaf.gtk.StyleCache");
    private static SynthStyleFactory lastFactory;
    private static boolean multipleApps;
    private static AppContext lastContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStyleFactory(SynthStyleFactory synthStyleFactory) {
        Class clazz = SynthLookAndFeel.class;
        synchronized (clazz) {
            if (lastFactory == null) {
                lastFactory = synthStyleFactory;
                lastContext = AppContext.getAppContext();
            } else if (synthStyleFactory == null) {
                AppContext appContext = AppContext.getAppContext();
                if (lastContext == appContext) {
                    lastFactory = null;
                }
                AppContext.getAppContext().put(STYLE_FACTORY_KEY, null);
            } else {
                multipleApps = true;
                AppContext.getAppContext().put(STYLE_FACTORY_KEY, synthStyleFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SynthStyleFactory getStyleFactory() {
        Class clazz = SynthLookAndFeel.class;
        synchronized (clazz) {
            if (!multipleApps) {
                return lastFactory;
            }
            AppContext appContext = AppContext.getAppContext();
            if (lastContext == appContext) {
                return lastFactory;
            }
            lastContext = appContext;
            lastFactory = (SynthStyleFactory)AppContext.getAppContext().get(STYLE_FACTORY_KEY);
            return lastFactory;
        }
    }

    public static int getComponentState(Component component) {
        if (component.isEnabled()) {
            if (component.isFocusOwner()) {
                return 257;
            }
            return 1;
        }
        return 8;
    }

    public static SynthStyle getStyle(JComponent jComponent, Region region) {
        return SynthLookAndFeel.getStyleFactory().getStyle(jComponent, region);
    }

    public static int getAcceleratorModifier() {
        return 8;
    }

    public static boolean isPrimaryMouseButton(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent);
    }

    static boolean shouldUpdateStyle(PropertyChangeEvent propertyChangeEvent) {
        return "ancestor" == propertyChangeEvent.getPropertyName() && propertyChangeEvent.getNewValue() != null;
    }

    static SynthStyle updateStyle(SynthContext synthContext, SynthUI synthUI) {
        SynthStyle synthStyle;
        SynthStyle synthStyle2 = SynthLookAndFeel.getStyle(synthContext.getComponent(), synthContext.getRegion());
        if (synthStyle2 != (synthStyle = synthContext.getStyle())) {
            if (synthStyle != null) {
                synthStyle.uninstallDefaults(synthContext);
            }
            synthContext.setStyle(synthStyle2);
            synthStyle2.installDefaults(synthContext, synthUI);
        }
        return synthStyle2;
    }

    static SynthEventListener getSynthEventListener(Component component) {
        PropertyChangeListener[] propertyChangeListenerArray = component.getPropertyChangeListeners();
        for (int i = propertyChangeListenerArray.length - 1; i >= 0; --i) {
            if (!(propertyChangeListenerArray[i] instanceof SynthEventListener)) continue;
            return (SynthEventListener)((Object)propertyChangeListenerArray[i]);
        }
        return null;
    }

    static void playSound(JComponent jComponent, Object object) {
    }

    public static Region getRegion(JComponent jComponent) {
        return Region.getRegion(jComponent);
    }

    public static Insets getPaintingInsets(SynthContext synthContext, Insets insets) {
        insets = synthContext.isSubregion() ? synthContext.getStyle().getInsets(synthContext, insets) : synthContext.getComponent().getInsets(insets);
        return insets;
    }

    static void compositeRequestFocus(Component component) {
        if (component instanceof Container) {
            Component component2;
            Object object;
            Object object2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (object2 = ((FocusTraversalPolicy)(object = container.getFocusTraversalPolicy())).getDefaultComponent(container)) != null) {
                ((Component)object2).requestFocus();
                return;
            }
            object = container.getFocusCycleRootAncestor();
            if (object != null && (component2 = ((FocusTraversalPolicy)(object2 = ((Container)object).getFocusTraversalPolicy())).getComponentAfter((Container)object, container)) != null && SwingUtilities.isDescendingFrom(component2, container)) {
                component2.requestFocus();
                return;
            }
        }
        component.requestFocus();
    }

    static void update(SynthContext synthContext, Graphics graphics) {
        SynthLookAndFeel.paintRegion(synthContext, graphics, null);
    }

    static void updateSubregion(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        SynthLookAndFeel.paintRegion(synthContext, graphics, rectangle);
    }

    static void paintForeground(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        JComponent jComponent = synthContext.getComponent();
        SynthPainter synthPainter = (SynthPainter)synthContext.getStyle().get(synthContext, "foreground");
        if (synthPainter != null) {
            if (rectangle == null) {
                synthPainter.paint(synthContext, "foreground", graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
            } else {
                synthPainter.paint(synthContext, "foreground", graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private static void paintRegion(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        SynthPainter synthPainter;
        SynthPainter synthPainter2;
        int n;
        int n2;
        int n3;
        int n4;
        JComponent jComponent = synthContext.getComponent();
        SynthStyle synthStyle = synthContext.getStyle();
        if (rectangle == null) {
            n4 = 0;
            n3 = 0;
            n2 = jComponent.getWidth();
            n = jComponent.getHeight();
        } else {
            n4 = rectangle.x;
            n3 = rectangle.y;
            n2 = rectangle.width;
            n = rectangle.height;
        }
        boolean bl = synthContext.isSubregion();
        if (bl && synthStyle.isOpaque(synthContext) || !bl && jComponent.isOpaque()) {
            graphics.setColor(synthStyle.getColor(synthContext, ColorType.BACKGROUND));
            graphics.fillRect(n4, n3, n2, n);
        }
        if ((synthPainter2 = synthStyle.getBackgroundPainter(synthContext)) != null) {
            synthPainter2.paint(synthContext, "background", graphics, n4, n3, n2, n);
        }
        if (synthContext.isSubregion() && (synthPainter = synthStyle.getBorderPainter(synthContext)) != null) {
            synthPainter.paint(synthContext, "border", graphics, n4, n3, n2, n);
        }
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        String string = jComponent.getUIClassID().intern();
        if (string == "ButtonUI") {
            return SynthButtonUI.createUI(jComponent);
        }
        if (string == "CheckBoxUI") {
            return SynthCheckBoxUI.createUI(jComponent);
        }
        if (string == "CheckBoxMenuItemUI") {
            return SynthCheckBoxMenuItemUI.createUI(jComponent);
        }
        if (string == "ColorChooserUI") {
            return SynthColorChooserUI.createUI(jComponent);
        }
        if (string == "ComboBoxUI") {
            return SynthComboBoxUI.createUI(jComponent);
        }
        if (string == "DesktopPaneUI") {
            return SynthDesktopPaneUI.createUI(jComponent);
        }
        if (string == "DesktopIconUI") {
            return SynthDesktopIconUI.createUI(jComponent);
        }
        if (string == "EditorPaneUI") {
            return SynthEditorPaneUI.createUI(jComponent);
        }
        if (string == "FormattedTextFieldUI") {
            return SynthFormattedTextFieldUI.createUI(jComponent);
        }
        if (string == "InternalFrameUI") {
            return SynthInternalFrameUI.createUI(jComponent);
        }
        if (string == "LabelUI") {
            return SynthLabelUI.createUI(jComponent);
        }
        if (string == "ListUI") {
            return SynthListUI.createUI(jComponent);
        }
        if (string == "MenuBarUI") {
            return SynthMenuBarUI.createUI(jComponent);
        }
        if (string == "MenuUI") {
            return SynthMenuUI.createUI(jComponent);
        }
        if (string == "MenuItemUI") {
            return SynthMenuItemUI.createUI(jComponent);
        }
        if (string == "OptionPaneUI") {
            return SynthOptionPaneUI.createUI(jComponent);
        }
        if (string == "PanelUI") {
            return SynthPanelUI.createUI(jComponent);
        }
        if (string == "PasswordFieldUI") {
            return SynthPasswordFieldUI.createUI(jComponent);
        }
        if (string == "PopupMenuSeparatorUI") {
            return SynthSeparatorUI.createUI(jComponent);
        }
        if (string == "PopupMenuUI") {
            return SynthPopupMenuUI.createUI(jComponent);
        }
        if (string == "ProgressBarUI") {
            return SynthProgressBarUI.createUI(jComponent);
        }
        if (string == "RadioButtonUI") {
            return SynthRadioButtonUI.createUI(jComponent);
        }
        if (string == "RadioButtonMenuItemUI") {
            return SynthRadioButtonMenuItemUI.createUI(jComponent);
        }
        if (string == "RootPaneUI") {
            return SynthRootPaneUI.createUI(jComponent);
        }
        if (string == "ScrollBarUI") {
            return SynthScrollBarUI.createUI(jComponent);
        }
        if (string == "ScrollPaneUI") {
            return SynthScrollPaneUI.createUI(jComponent);
        }
        if (string == "SeparatorUI") {
            return SynthSeparatorUI.createUI(jComponent);
        }
        if (string == "SliderUI") {
            return SynthSliderUI.createUI(jComponent);
        }
        if (string == "SpinnerUI") {
            return SynthSpinnerUI.createUI(jComponent);
        }
        if (string == "SplitPaneUI") {
            return SynthSplitPaneUI.createUI(jComponent);
        }
        if (string == "TabbedPaneUI") {
            return SynthTabbedPaneUI.createUI(jComponent);
        }
        if (string == "TableUI") {
            return SynthTableUI.createUI(jComponent);
        }
        if (string == "TableHeaderUI") {
            return SynthTableHeaderUI.createUI(jComponent);
        }
        if (string == "TextAreaUI") {
            return SynthTextAreaUI.createUI(jComponent);
        }
        if (string == "TextFieldUI") {
            return SynthTextFieldUI.createUI(jComponent);
        }
        if (string == "TextPaneUI") {
            return SynthTextPaneUI.createUI(jComponent);
        }
        if (string == "ToggleButtonUI") {
            return SynthToggleButtonUI.createUI(jComponent);
        }
        if (string == "ToolBarSeparatorUI") {
            return SynthSeparatorUI.createUI(jComponent);
        }
        if (string == "ToolBarUI") {
            return SynthToolBarUI.createUI(jComponent);
        }
        if (string == "ToolTipUI") {
            return SynthToolTipUI.createUI(jComponent);
        }
        if (string == "TreeUI") {
            return SynthTreeUI.createUI(jComponent);
        }
        if (string == "ViewportUI") {
            return SynthViewportUI.createUI(jComponent);
        }
        return null;
    }

    public void initialize() {
    }

    public void uninitialize() {
        super.uninitialize();
    }

    public UIDefaults getDefaults() {
        UIDefaults uIDefaults = new UIDefaults();
        Region.registerUIs(uIDefaults);
        uIDefaults.setDefaultLocale(Locale.getDefault());
        uIDefaults.addResourceBundle("com.sun.swing.internal.plaf.basic.resources.basic");
        uIDefaults.put("ColorChooser.swatchesRecentSwatchSize", new Dimension(10, 10));
        uIDefaults.put("ColorChooser.swatchesDefaultRecentColor", Color.RED);
        uIDefaults.put("ColorChooser.swatchesSwatchSize", new Dimension(10, 10));
        return uIDefaults;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public String getDescription() {
        return "Synth look and feel";
    }

    public String getName() {
        return "Synth look and feel";
    }

    public String getID() {
        return "Synth";
    }
}

