/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DisabledSecurity;
import com.sun.media.sound.JDK12;
import com.sun.media.sound.JDK12ConfigureThreadAction;
import com.sun.media.sound.JDK12NewMixerThreadAction;
import com.sun.media.sound.JDK12TopmostThreadGroupAction;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;

class MixerThread
extends Thread {
    private static Vector threadObjects = new Vector();
    private static ThreadGroup topmostThreadGroup = null;
    private static String threadName = "Headspace mixer frame proc thread";
    private static JSSecurity jsSecurity = null;
    private static boolean securityPrivilege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private boolean paused;
    private long frameProc;

    protected MixerThread() {
        super(topmostThreadGroup, "");
        if (jsSecurity == null || !(jsSecurity instanceof DisabledSecurity)) {
            if (jsSecurity != null && jsSecurity.getName().startsWith("JDK12")) {
                try {
                    Constructor constructor = JDK12ConfigureThreadAction.cons;
                    JDK12.doPrivM.invoke((Object)JDK12.ac, constructor.newInstance(this, threadName));
                }
                catch (Exception exception) {
                    this.configureThread();
                }
            } else {
                this.configureThread();
            }
        }
        this.paused = false;
    }

    private void setFrameProc(long l) {
        this.frameProc = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MixerThread getExistingThreadObject(long l) {
        Vector vector = threadObjects;
        synchronized (vector) {
            for (int i = 0; i < threadObjects.size(); ++i) {
                MixerThread mixerThread = (MixerThread)threadObjects.elementAt(i);
                if (mixerThread.frameProc != l) continue;
                return mixerThread;
            }
        }
        return null;
    }

    private static MixerThread getNewThreadObject(long l) {
        Method[] methodArray = new Method[1];
        Class[] classArray = new Class[1];
        Object[][] objectArray = new Object[1][0];
        MixerThread mixerThread = null;
        if (securityPrivilege && jsSecurity != null) {
            if (jsSecurity.getName().startsWith("JDK12")) {
                try {
                    Constructor constructor = JDK12NewMixerThreadAction.cons;
                    mixerThread = (MixerThread)JDK12.doPrivM.invoke((Object)JDK12.ac, constructor.newInstance(new Object[0]));
                }
                catch (Exception exception) {
                    mixerThread = new MixerThread();
                    mixerThread.setFrameProc(l);
                }
                mixerThread.setFrameProc(l);
            } else {
                try {
                    jsSecurity.requestPermission(methodArray, classArray, objectArray, 16);
                    methodArray[0].invoke((Object)classArray[0], objectArray[0]);
                    jsSecurity.requestPermission(methodArray, classArray, objectArray, 32);
                    methodArray[0].invoke((Object)classArray[0], objectArray[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mixerThread = new MixerThread();
                mixerThread.setFrameProc(l);
            }
        } else {
            mixerThread = new MixerThread();
            mixerThread.setFrameProc(l);
        }
        threadObjects.addElement(mixerThread);
        return mixerThread;
    }

    private void configureThread() {
        this.setDaemon(true);
        this.setPriority(10);
        this.setName(threadName);
    }

    private static ThreadGroup getTopmostThreadGroup() {
        ThreadGroup threadGroup = MixerThread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            this.runNative(this.frameProc);
            MixerThread mixerThread = this;
            synchronized (mixerThread) {
                this.paused = true;
                while (this.paused) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private synchronized void unpause() {
        this.paused = false;
        this.notify();
    }

    private native void runNative(long var1);

    static {
        Method[] methodArray = new Method[1];
        Class[] classArray = new Class[1];
        Object[][] objectArray = new Object[1][0];
        securityPrivilege = true;
        try {
            jsSecurity = JSSecurityManager.getJSSecurity();
            if (jsSecurity != null && !(jsSecurity instanceof DisabledSecurity)) {
                jsSecurity.requestPermission(methodArray, classArray, objectArray, 32);
                methodArray[0].invoke((Object)classArray[0], objectArray[0]);
            }
        }
        catch (Exception exception) {
            securityPrivilege = false;
        }
        if (securityPrivilege) {
            if (jsSecurity == null || !(jsSecurity instanceof DisabledSecurity)) {
                if (jsSecurity != null && jsSecurity.getName().startsWith("JDK12")) {
                    try {
                        Constructor constructor = JDK12TopmostThreadGroupAction.cons;
                        topmostThreadGroup = (ThreadGroup)JDK12.doPrivM.invoke((Object)JDK12.ac, constructor.newInstance(new Object[0]));
                    }
                    catch (Exception exception) {
                        topmostThreadGroup = MixerThread.getTopmostThreadGroup();
                    }
                } else {
                    topmostThreadGroup = MixerThread.getTopmostThreadGroup();
                }
            }
        } else {
            topmostThreadGroup = Thread.currentThread().getThreadGroup();
        }
    }
}

