/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractActionPropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class JCheckBox
extends JToggleButton
implements Accessible {
    public static final String BORDER_PAINTED_FLAT_CHANGED_PROPERTY = "borderPaintedFlat";
    private boolean flat = false;
    private static final String uiClassID = "CheckBoxUI";

    public JCheckBox() {
        this(null, null, false);
    }

    public JCheckBox(Icon icon) {
        this(null, icon, false);
    }

    public JCheckBox(Icon icon, boolean bl) {
        this(null, icon, bl);
    }

    public JCheckBox(String string) {
        this(string, null, false);
    }

    public JCheckBox(Action action) {
        this();
        this.setAction(action);
    }

    public JCheckBox(String string, boolean bl) {
        this(string, null, bl);
    }

    public JCheckBox(String string, Icon icon) {
        this(string, icon, false);
    }

    public JCheckBox(String string, Icon icon, boolean bl) {
        super(string, icon, bl);
        this.setBorderPainted(false);
        this.setHorizontalAlignment(10);
    }

    public void setBorderPaintedFlat(boolean bl) {
        boolean bl2 = this.flat;
        this.flat = bl;
        this.firePropertyChange(BORDER_PAINTED_FLAT_CHANGED_PROPERTY, bl2, this.flat);
        if (bl != bl2) {
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isBorderPaintedFlat() {
        return this.flat;
    }

    public void updateUI() {
        this.setUI((ButtonUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected void configurePropertiesFromAction(Action action) {
        String[] stringArray = new String[]{"MnemonicKey", "Name", "ShortDescription", "ActionCommandKey", "enabled"};
        this.configurePropertiesFromAction(action, stringArray);
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new AbstractActionPropertyChangeListener(this, action){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                AbstractButton abstractButton = (AbstractButton)this.getTarget();
                if (abstractButton == null) {
                    Action action = (Action)propertyChangeEvent.getSource();
                    action.removePropertyChangeListener(this);
                } else if (string.equals("Name")) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    abstractButton.setText(string2);
                    abstractButton.repaint();
                } else if (string.equals("ShortDescription")) {
                    String string3 = (String)propertyChangeEvent.getNewValue();
                    abstractButton.setToolTipText(string3);
                } else if (string.equals("enabled")) {
                    Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    abstractButton.setEnabled(bl);
                    abstractButton.repaint();
                } else if (string.equals("ActionCommandKey")) {
                    abstractButton.setActionCommand((String)propertyChangeEvent.getNewValue());
                }
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getUIClassID().equals(uiClassID)) {
            this.updateUI();
        }
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJCheckBox();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJCheckBox
    extends JToggleButton.AccessibleJToggleButton {
        protected AccessibleJCheckBox() {
            super(JCheckBox.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }
    }
}

