/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.VolatileImage;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.AncestorNotifier;
import javax.swing.Autoscroller;
import javax.swing.CellRendererPane;
import javax.swing.ComponentInputMap;
import javax.swing.DebugGraphics;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.LegacyGlueFocusTraversalPolicy;
import javax.swing.Popup;
import javax.swing.RepaintManager;
import javax.swing.SwingGraphics;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;

public abstract class JComponent
extends Container
implements Serializable {
    private static final String uiClassID = "ComponentUI";
    private static final Hashtable readObjectCallbacks = new Hashtable(1);
    private static Set managingFocusForwardTraversalKeys;
    private static Set managingFocusBackwardTraversalKeys;
    private static boolean suppressDropSupport;
    private static boolean checkedSuppressDropSupport;
    private static final int NOT_OBSCURED = 0;
    private static final int PARTIALLY_OBSCURED = 1;
    private static final int COMPLETELY_OBSCURED = 2;
    private Dimension preferredSize;
    private Dimension minimumSize;
    private Dimension maximumSize;
    private Float alignmentX;
    private Float alignmentY;
    private AncestorNotifier ancestorNotifier;
    Rectangle _bounds = new Rectangle();
    protected transient ComponentUI ui;
    protected EventListenerList listenerList = new EventListenerList();
    private Hashtable clientProperties;
    private VetoableChangeSupport vetoableChangeSupport;
    private Autoscroller autoscroller;
    private Border border;
    private int flags;
    private TransferHandler transfer;
    private InputVerifier inputVerifier = null;
    private boolean verifyInputWhenFocusTarget = true;
    private transient Rectangle tmpRect;
    transient Component paintingChild;
    public static final int WHEN_FOCUSED = 0;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;
    public static final int UNDEFINED_CONDITION = -1;
    private static final String KEYBOARD_BINDINGS_KEY = "_KeyboardBindings";
    private static final String WHEN_IN_FOCUSED_WINDOW_BINDINGS = "_WhenInFocusedWindow";
    public static final String TOOL_TIP_TEXT_KEY = "ToolTipText";
    private static final String NEXT_FOCUS = "nextFocus";
    private static final int IS_DOUBLE_BUFFERED = 0;
    private static final int ANCESTOR_USING_BUFFER = 1;
    private static final int IS_PAINTING_TILE = 2;
    private static final int IS_OPAQUE = 3;
    private static final int KEY_EVENTS_ENABLED = 4;
    private static final int FOCUS_INPUTMAP_CREATED = 5;
    private static final int ANCESTOR_INPUTMAP_CREATED = 6;
    private static final int WIF_INPUTMAP_CREATED = 7;
    private static final int ACTIONMAP_CREATED = 8;
    private static final int CREATED_DOUBLE_BUFFER = 9;
    private static final int IS_PRINTING = 11;
    private static final int IS_PRINTING_ALL = 12;
    private static final int IS_REPAINTING = 13;
    private static final int WRITE_OBJ_COUNTER_FIRST = 14;
    private static final int RESERVED_1 = 15;
    private static final int RESERVED_2 = 16;
    private static final int RESERVED_3 = 17;
    private static final int RESERVED_4 = 18;
    private static final int RESERVED_5 = 19;
    private static final int RESERVED_6 = 20;
    private static final int WRITE_OBJ_COUNTER_LAST = 21;
    private static final int REQUEST_FOCUS_DISABLED = 22;
    private InputMap focusInputMap;
    private InputMap ancestorInputMap;
    private ComponentInputMap windowInputMap;
    private ActionMap actionMap;
    private static final String defaultLocale = "JComponent.defaultLocale";
    protected AccessibleContext accessibleContext = null;
    private static final String htmlKey = "html";
    private Object htmlView;
    private SwingPropertyChangeSupport changeSupport;
    private Rectangle paintImmediatelyClip = new Rectangle(0, 0, 0, 0);
    static /* synthetic */ Class class$javax$swing$JComponent$KeyboardState;

    static Set getManagingFocusForwardTraversalKeys() {
        if (managingFocusForwardTraversalKeys == null) {
            managingFocusForwardTraversalKeys = new TreeSet();
            managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
        }
        return managingFocusForwardTraversalKeys;
    }

    static Set getManagingFocusBackwardTraversalKeys() {
        if (managingFocusBackwardTraversalKeys == null) {
            managingFocusBackwardTraversalKeys = new TreeSet();
            managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 3));
        }
        return managingFocusBackwardTraversalKeys;
    }

    private static boolean getSuppressDropTarget() {
        if (!checkedSuppressDropSupport) {
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty("suppressSwingDropSupport");
                    if (string != null) {
                        return Boolean.valueOf(string);
                    }
                    return Boolean.FALSE;
                }
            });
            suppressDropSupport = bl;
            checkedSuppressDropSupport = true;
        }
        return suppressDropSupport;
    }

    public JComponent() {
        this.enableEvents(8L);
        this.enableSerialization();
        if (this.isManagingFocus()) {
            this.setFocusTraversalKeys(0, JComponent.getManagingFocusForwardTraversalKeys());
            this.setFocusTraversalKeys(1, JComponent.getManagingFocusBackwardTraversalKeys());
        }
        super.setLocale(JComponent.getDefaultLocale());
    }

    public void updateUI() {
    }

    protected void setUI(ComponentUI componentUI) {
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        ComponentUI componentUI2 = this.ui;
        this.ui = componentUI;
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.firePropertyChange("UI", componentUI2, componentUI);
        this.revalidate();
        this.repaint();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        Graphics graphics2 = graphics;
        if (this.ui != null && DebugGraphics.debugComponentCount() != 0 && this.shouldDebugGraphics() != 0 && !(graphics instanceof DebugGraphics)) {
            if (graphics instanceof SwingGraphics) {
                if (!(((SwingGraphics)graphics).subGraphics() instanceof DebugGraphics)) {
                    DebugGraphics debugGraphics = new DebugGraphics(((SwingGraphics)graphics).subGraphics(), this);
                    graphics2 = SwingGraphics.createSwingGraphics(debugGraphics);
                    ((Graphics)debugGraphics).dispose();
                }
            } else {
                graphics2 = new DebugGraphics(graphics, this);
            }
        }
        graphics2.setColor(this.getForeground());
        graphics2.setFont(this.getFont());
        return graphics2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics graphics) {
        if (this.ui != null) {
            Graphics graphics2 = SwingGraphics.createSwingGraphics(graphics);
            try {
                this.ui.update(graphics2, this);
            }
            finally {
                graphics2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintChildren(Graphics graphics) {
        Graphics graphics2 = null;
        try {
            Object object = this.getTreeLock();
            synchronized (object) {
                int n;
                block35: {
                    if (n >= 0) break block35;
                    return;
                }
                graphics2 = SwingGraphics.createSwingGraphics(graphics);
                if (this.paintingChild != null && this.paintingChild instanceof JComponent && ((JComponent)this.paintingChild).isOpaque()) {
                    for (n = this.getComponentCount() - 1; n >= 0 && this.getComponent(n) != this.paintingChild; --n) {
                    }
                }
                if (this.tmpRect == null) {
                    this.tmpRect = new Rectangle();
                }
                boolean bl = !this.isOptimizedDrawingEnabled() && this.checkIfChildObscuredBySibling();
                Rectangle rectangle = null;
                if (bl && (rectangle = graphics2.getClipBounds()) == null) {
                    rectangle = new Rectangle(0, 0, this._bounds.width, this._bounds.height);
                }
                boolean bl2 = this.getFlag(11);
                while (n >= 0) {
                    block37: {
                        Object var17_17;
                        int n2;
                        Rectangle rectangle2;
                        boolean bl3;
                        Component component;
                        block38: {
                            component = this.getComponent(n);
                            if (component == null || !JComponent.isLightweightComponent(component) || !component.isVisible()) break block37;
                            bl3 = component instanceof JComponent;
                            if (bl3) {
                                rectangle2 = this.tmpRect;
                                ((JComponent)component).getBounds(rectangle2);
                            } else {
                                rectangle2 = component.getBounds();
                            }
                            boolean bl4 = graphics.hitClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                            if (!bl4) break block37;
                            if (!bl || n <= 0) break block38;
                            int n3 = rectangle2.x;
                            n2 = rectangle2.y;
                            int n4 = rectangle2.width;
                            int n5 = rectangle2.height;
                            SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
                            if (this.getObscuredState(n, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height) == 2) break block37;
                            rectangle2.x = n3;
                            rectangle2.y = n2;
                            rectangle2.width = n4;
                            rectangle2.height = n5;
                        }
                        Graphics graphics3 = SwingGraphics.createSwingGraphics(graphics2, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        graphics3.setColor(component.getForeground());
                        graphics3.setFont(component.getFont());
                        n2 = 0;
                        try {
                            if (bl3) {
                                if (this.getFlag(1)) {
                                    ((JComponent)component).setFlag(1, true);
                                    n2 = 1;
                                }
                                if (this.getFlag(2)) {
                                    ((JComponent)component).setFlag(2, true);
                                    n2 = 1;
                                }
                                if (!bl2) {
                                    ((JComponent)component).paint(graphics3);
                                } else if (!this.getFlag(12)) {
                                    component.print(graphics3);
                                } else {
                                    component.printAll(graphics3);
                                }
                            } else if (!bl2) {
                                component.paint(graphics3);
                            } else if (!this.getFlag(12)) {
                                component.print(graphics3);
                            } else {
                                component.printAll(graphics3);
                            }
                            var17_17 = null;
                            graphics3.dispose();
                            if (n2 != 0) {
                                ((JComponent)component).setFlag(1, false);
                                ((JComponent)component).setFlag(2, false);
                            }
                        }
                        catch (Throwable throwable) {
                            var17_17 = null;
                            graphics3.dispose();
                            if (n2 != 0) {
                                ((JComponent)component).setFlag(1, false);
                                ((JComponent)component).setFlag(2, false);
                            }
                            throw throwable;
                        }
                    }
                    --n;
                }
            }
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
            }
        }
    }

    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        Graphics graphics2 = this.getComponentGraphics(graphics);
        Graphics graphics3 = SwingGraphics.createSwingGraphics(graphics2);
        try {
            boolean bl3;
            int n;
            int n2;
            int n3;
            int n4;
            RepaintManager repaintManager = RepaintManager.currentManager(this);
            Rectangle rectangle = graphics3.getClipBounds();
            if (rectangle == null) {
                n4 = 0;
                n3 = 0;
                n2 = this._bounds.width;
                n = this._bounds.height;
            } else {
                n3 = rectangle.x;
                n4 = rectangle.y;
                n2 = rectangle.width;
                n = rectangle.height;
            }
            if (n2 > this.getWidth()) {
                n2 = this.getWidth();
            }
            if (n > this.getHeight()) {
                n = this.getHeight();
            }
            if (this.getParent() != null && !(this.getParent() instanceof JComponent)) {
                this.adjustPaintFlags();
                bl = true;
            }
            if (!(bl3 = this.getFlag(11)) && repaintManager.isDoubleBufferingEnabled() && !this.getFlag(1) && this.isDoubleBuffered()) {
                bl2 = this.paintDoubleBuffered(this, this, graphics3, n3, n4, n2, n);
            }
            if (!bl2) {
                if (rectangle == null) {
                    graphics3.setClip(n3, n4, n2, n);
                }
                if (!this.rectangleIsObscured(n3, n4, n2, n)) {
                    if (!bl3) {
                        this.paintComponent(graphics3);
                        this.paintBorder(graphics3);
                    } else {
                        this.printComponent(graphics3);
                        this.printBorder(graphics3);
                    }
                }
                if (!bl3) {
                    this.paintChildren(graphics3);
                } else {
                    this.printChildren(graphics3);
                }
            }
            Object var16_13 = null;
            graphics3.dispose();
            if (bl) {
                this.setFlag(1, false);
                this.setFlag(2, false);
                this.setFlag(11, false);
                this.setFlag(12, false);
            }
        }
        catch (Throwable throwable) {
            Object var16_14 = null;
            graphics3.dispose();
            if (bl) {
                this.setFlag(1, false);
                this.setFlag(2, false);
                this.setFlag(11, false);
                this.setFlag(12, false);
            }
            throw throwable;
        }
    }

    private void adjustPaintFlags() {
        JComponent jComponent = null;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JComponent)) continue;
            jComponent = (JComponent)container;
            if (jComponent.getFlag(1)) {
                this.setFlag(1, true);
            }
            if (jComponent.getFlag(2)) {
                this.setFlag(2, true);
            }
            if (jComponent.getFlag(11)) {
                this.setFlag(11, true);
            }
            if (!jComponent.getFlag(12)) break;
            this.setFlag(12, true);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printAll(Graphics graphics) {
        this.setFlag(12, true);
        try {
            this.print(graphics);
        }
        finally {
            this.setFlag(12, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        this.setFlag(11, true);
        try {
            this.paint(graphics);
        }
        finally {
            this.setFlag(11, false);
        }
    }

    protected void printComponent(Graphics graphics) {
        this.paintComponent(graphics);
    }

    protected void printChildren(Graphics graphics) {
        this.paintChildren(graphics);
    }

    protected void printBorder(Graphics graphics) {
        this.paintBorder(graphics);
    }

    public boolean isPaintingTile() {
        return this.getFlag(2);
    }

    public boolean isManagingFocus() {
        return false;
    }

    private void registerNextFocusableComponent() {
        this.registerNextFocusableComponent(this.getNextFocusableComponent());
    }

    private void registerNextFocusableComponent(Component component) {
        if (component == null) {
            return;
        }
        Container container = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (!(focusTraversalPolicy instanceof LegacyGlueFocusTraversalPolicy)) {
            focusTraversalPolicy = new LegacyGlueFocusTraversalPolicy(focusTraversalPolicy);
            container.setFocusTraversalPolicy(focusTraversalPolicy);
        }
        ((LegacyGlueFocusTraversalPolicy)focusTraversalPolicy).setNextFocusableComponent(this, component);
    }

    private void deregisterNextFocusableComponent() {
        Container container;
        Component component = this.getNextFocusableComponent();
        if (component == null) {
            return;
        }
        Container container2 = container = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        if (container == null) {
            return;
        }
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (focusTraversalPolicy instanceof LegacyGlueFocusTraversalPolicy) {
            ((LegacyGlueFocusTraversalPolicy)focusTraversalPolicy).unsetNextFocusableComponent(this, component);
        }
    }

    public void setNextFocusableComponent(Component component) {
        boolean bl = this.isDisplayable();
        if (bl) {
            this.deregisterNextFocusableComponent();
        }
        this.putClientProperty(NEXT_FOCUS, component);
        if (bl) {
            this.registerNextFocusableComponent(component);
        }
    }

    public Component getNextFocusableComponent() {
        return (Component)this.getClientProperty(NEXT_FOCUS);
    }

    public void setRequestFocusEnabled(boolean bl) {
        this.setFlag(22, !bl);
    }

    public boolean isRequestFocusEnabled() {
        return !this.getFlag(22);
    }

    private boolean runInputVerifier() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == this) {
            return true;
        }
        if (!this.getVerifyInputWhenFocusTarget()) {
            return true;
        }
        if (component == null || !(component instanceof JComponent)) {
            return true;
        }
        JComponent jComponent = (JComponent)component;
        InputVerifier inputVerifier = jComponent.getInputVerifier();
        if (inputVerifier == null) {
            return true;
        }
        return inputVerifier.shouldYieldFocus(jComponent);
    }

    public void requestFocus() {
        if (this.runInputVerifier()) {
            super.requestFocus();
        }
    }

    public boolean requestFocus(boolean bl) {
        return this.runInputVerifier() ? super.requestFocus(bl) : false;
    }

    public boolean requestFocusInWindow() {
        return this.runInputVerifier() ? super.requestFocusInWindow() : false;
    }

    protected boolean requestFocusInWindow(boolean bl) {
        return this.runInputVerifier() ? super.requestFocusInWindow(bl) : false;
    }

    public void grabFocus() {
        this.requestFocus();
    }

    public void setVerifyInputWhenFocusTarget(boolean bl) {
        boolean bl2 = this.verifyInputWhenFocusTarget;
        this.verifyInputWhenFocusTarget = bl;
        this.firePropertyChange("verifyInputWhenFocusTarget", bl2, bl);
    }

    public boolean getVerifyInputWhenFocusTarget() {
        return this.verifyInputWhenFocusTarget;
    }

    public void setPreferredSize(Dimension dimension) {
        Dimension dimension2 = this.preferredSize;
        this.preferredSize = dimension;
        this.firePropertyChange("preferredSize", dimension2, dimension);
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getPreferredSize(this);
        }
        return dimension != null ? dimension : super.getPreferredSize();
    }

    public void setMaximumSize(Dimension dimension) {
        Dimension dimension2 = this.maximumSize;
        this.maximumSize = dimension;
        this.firePropertyChange("maximumSize", dimension2, dimension);
    }

    public Dimension getMaximumSize() {
        if (this.maximumSize != null) {
            return this.maximumSize;
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getMaximumSize(this);
        }
        return dimension != null ? dimension : super.getMaximumSize();
    }

    public void setMinimumSize(Dimension dimension) {
        Dimension dimension2 = this.minimumSize;
        this.minimumSize = dimension;
        this.firePropertyChange("minimumSize", dimension2, dimension);
    }

    public Dimension getMinimumSize() {
        if (this.minimumSize != null) {
            return this.minimumSize;
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getMinimumSize(this);
        }
        return dimension != null ? dimension : super.getMinimumSize();
    }

    public boolean isMinimumSizeSet() {
        return this.minimumSize != null;
    }

    public boolean isPreferredSizeSet() {
        return this.preferredSize != null;
    }

    public boolean isMaximumSizeSet() {
        return this.maximumSize != null;
    }

    public boolean contains(int n, int n2) {
        return this.ui != null ? this.ui.contains(this, n, n2) : super.contains(n, n2);
    }

    public void setBorder(Border border) {
        Border border2 = this.border;
        this.border = border;
        this.firePropertyChange("border", border2, border);
        if (border != border2) {
            if (border == null || border2 == null || !border.getBorderInsets(this).equals(border2.getBorderInsets(this))) {
                this.revalidate();
            }
            this.repaint();
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public Insets getInsets() {
        if (this.border != null) {
            return this.border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public Insets getInsets(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.border != null) {
            if (this.border instanceof AbstractBorder) {
                return this.border.getBorderInsets(this);
            }
            return this.border.getBorderInsets(this);
        }
        insets.bottom = 0;
        insets.right = 0;
        insets.top = 0;
        insets.left = 0;
        return insets;
    }

    public float getAlignmentY() {
        return this.alignmentY != null ? this.alignmentY.floatValue() : super.getAlignmentY();
    }

    public void setAlignmentY(float f) {
        this.alignmentY = new Float(f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f));
    }

    public float getAlignmentX() {
        return this.alignmentX != null ? this.alignmentX.floatValue() : super.getAlignmentX();
    }

    public void setAlignmentX(float f) {
        this.alignmentX = new Float(f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f));
    }

    public void setInputVerifier(InputVerifier inputVerifier) {
        InputVerifier inputVerifier2 = this.inputVerifier;
        this.inputVerifier = inputVerifier;
        this.firePropertyChange("inputVerifier", inputVerifier2, inputVerifier);
    }

    public InputVerifier getInputVerifier() {
        return this.inputVerifier;
    }

    public Graphics getGraphics() {
        if (this.shouldDebugGraphics() != 0) {
            DebugGraphics debugGraphics = new DebugGraphics(super.getGraphics(), this);
            return debugGraphics;
        }
        return super.getGraphics();
    }

    public void setDebugGraphicsOptions(int n) {
        DebugGraphics.setDebugOptions(this, n);
    }

    public int getDebugGraphicsOptions() {
        return DebugGraphics.getDebugOptions(this);
    }

    int shouldDebugGraphics() {
        return DebugGraphics.shouldComponentDebug(this);
    }

    public void registerKeyboardAction(ActionListener actionListener, String string, KeyStroke keyStroke, int n) {
        InputMap inputMap = this.getInputMap(n, true);
        if (inputMap != null) {
            ActionMap actionMap = this.getActionMap(true);
            ActionStandin actionStandin = new ActionStandin(actionListener, string);
            Object object = inputMap.get(keyStroke);
            if (object != null && actionMap != null && actionMap.get(object) != null) {
                actionMap.remove(object);
            }
            inputMap.put(keyStroke, actionStandin);
            if (actionMap != null) {
                actionMap.put(actionStandin, actionStandin);
            }
        }
    }

    private void registerWithKeyboardManager(boolean bl) {
        int n;
        KeyStroke[] keyStrokeArray;
        InputMap inputMap = this.getInputMap(2, false);
        Hashtable<KeyStroke, KeyStroke> hashtable = (Hashtable<KeyStroke, KeyStroke>)this.getClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS);
        if (inputMap != null) {
            keyStrokeArray = inputMap.allKeys();
            if (keyStrokeArray != null) {
                for (n = keyStrokeArray.length - 1; n >= 0; --n) {
                    if (!bl || hashtable == null || hashtable.get(keyStrokeArray[n]) == null) {
                        this.registerWithKeyboardManager(keyStrokeArray[n]);
                    }
                    if (hashtable == null) continue;
                    hashtable.remove(keyStrokeArray[n]);
                }
            }
        } else {
            keyStrokeArray = null;
        }
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
                this.unregisterWithKeyboardManager(keyStroke);
            }
            hashtable.clear();
        }
        if (keyStrokeArray != null && keyStrokeArray.length > 0) {
            if (hashtable == null) {
                hashtable = new Hashtable<KeyStroke, KeyStroke>(keyStrokeArray.length);
                this.putClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS, hashtable);
            }
            for (n = keyStrokeArray.length - 1; n >= 0; --n) {
                hashtable.put(keyStrokeArray[n], keyStrokeArray[n]);
            }
        } else {
            this.putClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS, null);
        }
    }

    private void unregisterWithKeyboardManager() {
        Hashtable hashtable = (Hashtable)this.getClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS);
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
                this.unregisterWithKeyboardManager(keyStroke);
            }
        }
        this.putClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS, null);
    }

    void componentInputMapChanged(ComponentInputMap componentInputMap) {
        InputMap inputMap;
        for (inputMap = this.getInputMap(2, false); inputMap != componentInputMap && inputMap != null; inputMap = (ComponentInputMap)inputMap.getParent()) {
        }
        if (inputMap != null) {
            this.registerWithKeyboardManager(true);
        }
    }

    private void registerWithKeyboardManager(KeyStroke keyStroke) {
        KeyboardManager.getCurrentManager().registerKeyStroke(keyStroke, this);
    }

    private void unregisterWithKeyboardManager(KeyStroke keyStroke) {
        KeyboardManager.getCurrentManager().unregisterKeyStroke(keyStroke, this);
    }

    public void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke, int n) {
        this.registerKeyboardAction(actionListener, null, keyStroke, n);
    }

    public void unregisterKeyboardAction(KeyStroke keyStroke) {
        ActionMap actionMap = this.getActionMap(false);
        for (int i = 0; i < 3; ++i) {
            InputMap inputMap = this.getInputMap(i, false);
            if (inputMap == null) continue;
            Object object = inputMap.get(keyStroke);
            if (actionMap != null && object != null) {
                actionMap.remove(object);
            }
            inputMap.remove(keyStroke);
        }
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        int[] nArray = new int[3];
        KeyStroke[][] keyStrokeArrayArray = new KeyStroke[3][];
        for (int i = 0; i < 3; ++i) {
            InputMap inputMap = this.getInputMap(i, false);
            keyStrokeArrayArray[i] = inputMap != null ? inputMap.allKeys() : null;
            nArray[i] = keyStrokeArrayArray[i] != null ? keyStrokeArrayArray[i].length : 0;
        }
        KeyStroke[] keyStrokeArray = new KeyStroke[nArray[0] + nArray[1] + nArray[2]];
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            if (nArray[i] <= 0) continue;
            System.arraycopy(keyStrokeArrayArray[i], 0, keyStrokeArray, n, nArray[i]);
            n += nArray[i];
        }
        return keyStrokeArray;
    }

    public int getConditionForKeyStroke(KeyStroke keyStroke) {
        for (int i = 0; i < 3; ++i) {
            InputMap inputMap = this.getInputMap(i, false);
            if (inputMap == null || inputMap.get(keyStroke) == null) continue;
            return i;
        }
        return -1;
    }

    public ActionListener getActionForKeyStroke(KeyStroke keyStroke) {
        ActionMap actionMap = this.getActionMap(false);
        if (actionMap == null) {
            return null;
        }
        for (int i = 0; i < 3; ++i) {
            Object object;
            InputMap inputMap = this.getInputMap(i, false);
            if (inputMap == null || (object = inputMap.get(keyStroke)) == null) continue;
            Action action = actionMap.get(object);
            if (action instanceof ActionStandin) {
                return ((ActionStandin)action).actionListener;
            }
            return action;
        }
        return null;
    }

    public void resetKeyboardActions() {
        for (int i = 0; i < 3; ++i) {
            InputMap inputMap = this.getInputMap(i, false);
            if (inputMap == null) continue;
            inputMap.clear();
        }
        ActionMap actionMap = this.getActionMap(false);
        if (actionMap != null) {
            actionMap.clear();
        }
    }

    public final void setInputMap(int n, InputMap inputMap) {
        switch (n) {
            case 2: {
                if (inputMap != null && !(inputMap instanceof ComponentInputMap)) {
                    throw new IllegalArgumentException("WHEN_IN_FOCUSED_WINDOW InputMaps must be of type ComponentInputMap");
                }
                this.windowInputMap = (ComponentInputMap)inputMap;
                this.setFlag(7, true);
                this.registerWithKeyboardManager(false);
                break;
            }
            case 1: {
                this.ancestorInputMap = inputMap;
                this.setFlag(6, true);
                break;
            }
            case 0: {
                this.focusInputMap = inputMap;
                this.setFlag(5, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("condition must be one of JComponent.WHEN_IN_FOCUSED_WINDOW, JComponent.WHEN_FOCUSED or JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT");
            }
        }
    }

    public final InputMap getInputMap(int n) {
        return this.getInputMap(n, true);
    }

    public final InputMap getInputMap() {
        return this.getInputMap(0, true);
    }

    public final void setActionMap(ActionMap actionMap) {
        this.actionMap = actionMap;
        this.setFlag(8, true);
    }

    public final ActionMap getActionMap() {
        return this.getActionMap(true);
    }

    final InputMap getInputMap(int n, boolean bl) {
        switch (n) {
            case 0: {
                if (this.getFlag(5)) {
                    return this.focusInputMap;
                }
                if (!bl) break;
                InputMap inputMap = new InputMap();
                this.setInputMap(n, inputMap);
                return inputMap;
            }
            case 1: {
                if (this.getFlag(6)) {
                    return this.ancestorInputMap;
                }
                if (!bl) break;
                InputMap inputMap = new InputMap();
                this.setInputMap(n, inputMap);
                return inputMap;
            }
            case 2: {
                if (this.getFlag(7)) {
                    return this.windowInputMap;
                }
                if (!bl) break;
                ComponentInputMap componentInputMap = new ComponentInputMap(this);
                this.setInputMap(n, componentInputMap);
                return componentInputMap;
            }
            default: {
                throw new IllegalArgumentException("condition must be one of JComponent.WHEN_IN_FOCUSED_WINDOW, JComponent.WHEN_FOCUSED or JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT");
            }
        }
        return null;
    }

    final ActionMap getActionMap(boolean bl) {
        if (this.getFlag(8)) {
            return this.actionMap;
        }
        if (bl) {
            ActionMap actionMap = new ActionMap();
            this.setActionMap(actionMap);
            return actionMap;
        }
        return null;
    }

    public boolean requestDefaultFocus() {
        Container container;
        Container container2 = container = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        if (container == null) {
            return false;
        }
        Component component = container.getFocusTraversalPolicy().getDefaultComponent(this);
        if (component != null) {
            component.requestFocus();
            return true;
        }
        return false;
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            super.setVisible(bl);
            Container container = this.getParent();
            if (container != null) {
                Rectangle rectangle = this.getBounds();
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.revalidate();
        }
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        this.firePropertyChange("enabled", bl2, bl);
        if (bl != bl2) {
            this.repaint();
        }
    }

    public void setForeground(Color color) {
        Color color2 = this.getForeground();
        super.setForeground(color);
        if (color2 != null ? !color2.equals(color) : color != null && !color.equals(color2)) {
            this.repaint();
        }
    }

    public void setBackground(Color color) {
        Color color2 = this.getBackground();
        super.setBackground(color);
        if (color2 != null ? !color2.equals(color) : color != null && !color.equals(color2)) {
            this.repaint();
        }
    }

    public void setFont(Font font) {
        Font font2 = this.getFont();
        super.setFont(font);
        if (font != font2) {
            this.revalidate();
            this.repaint();
        }
    }

    public static Locale getDefaultLocale() {
        Locale locale = (Locale)SwingUtilities.appContextGet(defaultLocale);
        if (locale == null) {
            locale = Locale.getDefault();
            JComponent.setDefaultLocale(locale);
        }
        return locale;
    }

    public static void setDefaultLocale(Locale locale) {
        SwingUtilities.appContextPut(defaultLocale, locale);
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            this.processComponentKeyEvent(keyEvent);
        }
        boolean bl = KeyboardState.shouldProcess(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        if (bl && this.processKeyBindings(keyEvent, keyEvent.getID() == 401)) {
            keyEvent.consume();
        }
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        InputMap inputMap = this.getInputMap(n, false);
        ActionMap actionMap = this.getActionMap(false);
        if (inputMap != null && actionMap != null && this.isEnabled()) {
            Action action;
            Object object = inputMap.get(keyStroke);
            Action action2 = action = object == null ? null : actionMap.get(object);
            if (action != null) {
                return SwingUtilities.notifyAction(action, keyStroke, keyEvent, this, keyEvent.getModifiers());
            }
        }
        return false;
    }

    boolean processKeyBindings(KeyEvent keyEvent, boolean bl) {
        Container container;
        if (!SwingUtilities.isValidKeyEventForKeyBindings(keyEvent)) {
            return false;
        }
        KeyStroke keyStroke = keyEvent.getID() == 400 ? KeyStroke.getKeyStroke(keyEvent.getKeyChar()) : KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), !bl);
        if (this.processKeyBinding(keyStroke, keyEvent, 0, bl)) {
            return true;
        }
        for (container = this; container != null && !(container instanceof Window) && !(container instanceof Applet); container = container.getParent()) {
            if (container instanceof JComponent && container.processKeyBinding(keyStroke, keyEvent, 1, bl)) {
                return true;
            }
            if (!(container instanceof JInternalFrame) || !JComponent.processKeyBindingsForAllComponents(keyEvent, container, bl)) continue;
            return true;
        }
        if (container != null) {
            return JComponent.processKeyBindingsForAllComponents(keyEvent, container, bl);
        }
        return false;
    }

    static boolean processKeyBindingsForAllComponents(KeyEvent keyEvent, Container container, boolean bl) {
        while (true) {
            if (KeyboardManager.getCurrentManager().fireKeyboardAction(keyEvent, bl, container)) {
                return true;
            }
            if (!(container instanceof Popup.HeavyWeightWindow)) break;
            container = ((Window)container).getOwner();
        }
        return false;
    }

    public void setToolTipText(String string) {
        String string2 = this.getToolTipText();
        this.putClientProperty(TOOL_TIP_TEXT_KEY, string);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (string != null) {
            if (string2 == null) {
                toolTipManager.registerComponent(this);
            }
        } else {
            toolTipManager.unregisterComponent(this);
        }
    }

    public String getToolTipText() {
        return (String)this.getClientProperty(TOOL_TIP_TEXT_KEY);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getToolTipText();
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return null;
    }

    public JToolTip createToolTip() {
        JToolTip jToolTip = new JToolTip();
        jToolTip.setComponent(this);
        return jToolTip;
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        Container container;
        int n = this.getX();
        int n2 = this.getY();
        for (container = this.getParent(); container != null && !(container instanceof JComponent) && !(container instanceof CellRendererPane); container = container.getParent()) {
            Rectangle rectangle2 = container.getBounds();
            n += rectangle2.x;
            n2 += rectangle2.y;
        }
        if (container != null && !(container instanceof CellRendererPane)) {
            rectangle.x += n;
            rectangle.y += n2;
            ((JComponent)container).scrollRectToVisible(rectangle);
            rectangle.x -= n;
            rectangle.y -= n2;
        }
    }

    public void setAutoscrolls(boolean bl) {
        if (bl) {
            if (this.autoscroller == null) {
                this.autoscroller = new Autoscroller(this);
            }
        } else if (this.autoscroller != null) {
            this.autoscroller.dispose();
            this.autoscroller = null;
        }
    }

    public boolean getAutoscrolls() {
        return this.autoscroller != null;
    }

    public void setTransferHandler(TransferHandler transferHandler) {
        DropTarget dropTarget;
        TransferHandler transferHandler2 = this.transfer;
        this.transfer = transferHandler;
        if (!JComponent.getSuppressDropTarget() && ((dropTarget = this.getDropTarget()) == null || dropTarget instanceof UIResource)) {
            if (transferHandler == null) {
                this.setDropTarget(null);
            } else if (!GraphicsEnvironment.isHeadless()) {
                this.setDropTarget(new TransferHandler.SwingDropTarget(this));
            }
        }
        this.firePropertyChange("transferHandler", transferHandler2, this.transfer);
    }

    public TransferHandler getTransferHandler() {
        return this.transfer;
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        boolean bl = true;
        if (this.autoscroller != null && mouseEvent.getID() == 506) {
            bl = !this.autoscroller.timer.isRunning();
            this.autoscroller.mouseDragged(mouseEvent);
        }
        if (bl) {
            super.processMouseMotionEvent(mouseEvent);
        }
    }

    void superProcessMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
    }

    void setCreatedDoubleBuffer(boolean bl) {
        this.setFlag(9, bl);
    }

    boolean getCreatedDoubleBuffer() {
        return this.getFlag(9);
    }

    public void enable() {
        if (!this.isEnabled()) {
            super.enable();
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
            }
        }
    }

    public void disable() {
        if (this.isEnabled()) {
            super.disable();
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ENABLED, null);
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    private Dictionary getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable(2);
        }
        return this.clientProperties;
    }

    public final Object getClientProperty(Object object) {
        if (this.clientProperties == null) {
            return null;
        }
        if (object == htmlKey) {
            return this.htmlView;
        }
        return this.getClientProperties().get(object);
    }

    public final void putClientProperty(Object object, Object object2) {
        if (object2 == null && this.clientProperties == null) {
            return;
        }
        Object v = this.getClientProperties().get(object);
        if (object2 != null) {
            if (object == htmlKey) {
                this.htmlView = object2;
            } else {
                this.getClientProperties().put(object, object2);
                this.firePropertyChange(object.toString(), v, object2);
            }
        } else if (v != null) {
            this.getClientProperties().remove(object);
            this.firePropertyChange(object.toString(), v, object2);
        } else if (object == htmlKey) {
            this.htmlView = null;
        }
    }

    public static boolean isLightweightComponent(Component component) {
        return component.getPeer() instanceof LightweightPeer;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (this._bounds.x == n && this._bounds.y == n2 && this._bounds.width == n3 && this._bounds.height == n4) {
            return;
        }
        if (this.isShowing()) {
            if (this._bounds.x + this._bounds.width > n && this._bounds.y + this._bounds.height > n2 && this._bounds.x < n + n3 && this._bounds.y < n2 + n4) {
                Rectangle[] rectangleArray = SwingUtilities.computeDifference(this.getBounds(), new Rectangle(n, n2, n3, n4));
                Container container = this.getParent();
                int n5 = rectangleArray.length;
                for (int i = 0; i < n5; ++i) {
                    container.repaint(rectangleArray[i].x, rectangleArray[i].y, rectangleArray[i].width, rectangleArray[i].height);
                }
            } else {
                Container container = this.getParent();
                if (container != null) {
                    container.repaint(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
                }
            }
        }
        this._bounds.setBounds(n, n2, n3, n4);
        super.reshape(n, n2, n3, n4);
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rectangle.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rectangle;
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        dimension.setSize(this.getWidth(), this.getHeight());
        return dimension;
    }

    public Point getLocation(Point point) {
        if (point == null) {
            return new Point(this.getX(), this.getY());
        }
        point.setLocation(this.getX(), this.getY());
        return point;
    }

    public int getX() {
        return this._bounds.x;
    }

    public int getY() {
        return this._bounds.y;
    }

    public int getWidth() {
        return this._bounds.width;
    }

    public int getHeight() {
        return this._bounds.height;
    }

    public boolean isOpaque() {
        return this.getFlag(3);
    }

    public void setOpaque(boolean bl) {
        boolean bl2 = this.getFlag(3);
        this.setFlag(3, bl);
        this.firePropertyChange("opaque", bl2, bl);
    }

    boolean rectangleIsObscured(int n, int n2, int n3, int n4) {
        int n5 = this.getComponentCount();
        for (int i = 0; i < n5; ++i) {
            Component component = this.getComponent(i);
            Rectangle rectangle = component instanceof JComponent ? ((JComponent)component)._bounds : component.getBounds();
            if (n < rectangle.x || n + n3 > rectangle.x + rectangle.width || n2 < rectangle.y || n2 + n4 > rectangle.y + rectangle.height || !component.isVisible()) continue;
            if (component instanceof JComponent) {
                return ((JComponent)component).isOpaque();
            }
            return false;
        }
        return false;
    }

    static final void computeVisibleRect(Component component, Rectangle rectangle) {
        Container container = component.getParent();
        Rectangle rectangle2 = component.getBounds();
        if (container == null || container instanceof Window || container instanceof Applet) {
            rectangle.setBounds(0, 0, rectangle2.width, rectangle2.height);
        } else {
            JComponent.computeVisibleRect(container, rectangle);
            rectangle.x -= rectangle2.x;
            rectangle.y -= rectangle2.y;
            SwingUtilities.computeIntersection(0, 0, rectangle2.width, rectangle2.height, rectangle);
        }
    }

    public void computeVisibleRect(Rectangle rectangle) {
        JComponent.computeVisibleRect(this, rectangle);
    }

    public Rectangle getVisibleRect() {
        Rectangle rectangle = new Rectangle();
        this.computeVisibleRect(rectangle);
        return rectangle;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
        if (this.changeSupport != null && by != by2) {
            this.changeSupport.firePropertyChange(string, new Byte(by), new Byte(by2));
        }
    }

    public void firePropertyChange(String string, char c, char c2) {
        if (this.changeSupport != null && c != c2) {
            this.changeSupport.firePropertyChange(string, new Character(c), new Character(c2));
        }
    }

    public void firePropertyChange(String string, short s, short s2) {
        if (this.changeSupport != null && s != s2) {
            this.changeSupport.firePropertyChange(string, new Short(s), new Short(s2));
        }
    }

    public void firePropertyChange(String string, int n, int n2) {
        if (this.changeSupport != null && n != n2) {
            this.changeSupport.firePropertyChange(string, new Integer(n), new Integer(n2));
        }
    }

    public void firePropertyChange(String string, long l, long l2) {
        if (this.changeSupport != null && l != l2) {
            this.changeSupport.firePropertyChange(string, new Long(l), new Long(l2));
        }
    }

    public void firePropertyChange(String string, float f, float f2) {
        if (this.changeSupport != null && f != f2) {
            this.changeSupport.firePropertyChange(string, new Float(f), new Float(f2));
        }
    }

    public void firePropertyChange(String string, double d, double d2) {
        if (this.changeSupport != null && d != d2) {
            this.changeSupport.firePropertyChange(string, new Double(d), new Double(d2));
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (this.changeSupport != null && bl != bl2) {
            this.changeSupport.firePropertyChange(string, (Object)bl, (Object)bl2);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.fireVetoableChange(string, object, object2);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners() {
        if (this.vetoableChangeSupport == null) {
            return new VetoableChangeListener[0];
        }
        return this.vetoableChangeSupport.getVetoableChangeListeners();
    }

    public Container getTopLevelAncestor() {
        for (Container container = this; container != null; container = container.getParent()) {
            if (!(container instanceof Window) && !(container instanceof Applet)) continue;
            return container;
        }
        return null;
    }

    public void addAncestorListener(AncestorListener ancestorListener) {
        if (this.ancestorNotifier == null) {
            this.ancestorNotifier = new AncestorNotifier(this);
        }
        this.ancestorNotifier.addAncestorListener(ancestorListener);
    }

    public void removeAncestorListener(AncestorListener ancestorListener) {
        if (this.ancestorNotifier == null) {
            return;
        }
        this.ancestorNotifier.removeAncestorListener(ancestorListener);
        if (this.ancestorNotifier.listenerList.getListenerList().length == 0) {
            this.ancestorNotifier.removeAllListeners();
            this.ancestorNotifier = null;
        }
    }

    public AncestorListener[] getAncestorListeners() {
        if (this.ancestorNotifier == null) {
            return new AncestorListener[0];
        }
        return this.ancestorNotifier.getAncestorListeners();
    }

    public EventListener[] getListeners(Class clazz) {
        EventListener[] eventListenerArray = clazz == AncestorListener.class ? this.getAncestorListeners() : (clazz == VetoableChangeListener.class ? this.getVetoableChangeListeners() : (clazz == PropertyChangeListener.class ? this.getPropertyChangeListeners() : this.listenerList.getListeners(clazz)));
        if (eventListenerArray.length == 0) {
            return super.getListeners(clazz);
        }
        return eventListenerArray;
    }

    public void addNotify() {
        super.addNotify();
        this.firePropertyChange("ancestor", null, this.getParent());
        this.registerWithKeyboardManager(false);
        this.registerNextFocusableComponent();
    }

    public void removeNotify() {
        super.removeNotify();
        this.firePropertyChange("ancestor", this.getParent(), null);
        this.unregisterWithKeyboardManager();
        this.deregisterNextFocusableComponent();
        if (this.getCreatedDoubleBuffer()) {
            RepaintManager.currentManager(this).resetDoubleBuffer();
            this.setCreatedDoubleBuffer(false);
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        RepaintManager.currentManager(this).addDirtyRegion(this, n, n2, n3, n4);
    }

    public void repaint(Rectangle rectangle) {
        this.repaint(0L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void revalidate() {
        if (this.getParent() == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.invalidate();
            RepaintManager.currentManager(this).addInvalidComponent(this);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    JComponent.this.revalidate();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public boolean isValidateRoot() {
        return false;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    boolean isPaintingOrigin() {
        return false;
    }

    public void paintImmediately(int n, int n2, int n3, int n4) {
        Container container;
        Container container2 = this;
        if (!this.isShowing()) {
            return;
        }
        while (!container2.isOpaque() && (container = container2.getParent()) != null) {
            Rectangle rectangle = container2 instanceof JComponent ? container2._bounds : container2.getBounds();
            n += rectangle.x;
            n2 += rectangle.y;
            container2 = container;
            if (container2 instanceof JComponent) continue;
        }
        if (container2 instanceof JComponent) {
            container2._paintImmediately(n, n2, n3, n4);
        } else {
            container2.repaint(n, n2, n3, n4);
        }
    }

    public void paintImmediately(Rectangle rectangle) {
        this.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    boolean alwaysOnTop() {
        return false;
    }

    void setPaintingChild(Component component) {
        this.paintingChild = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void _paintImmediately(int n, int n2, int n3, int n4) {
        Vector<JComponent> vector;
        JComponent jComponent;
        block36: {
            block34: {
                block35: {
                    int n5;
                    Object object;
                    Container container;
                    int n6 = 0;
                    int n7 = 0;
                    boolean bl = false;
                    JComponent jComponent2 = null;
                    jComponent = this;
                    RepaintManager repaintManager = RepaintManager.currentManager(this);
                    vector = new Vector<JComponent>(7);
                    int n8 = -1;
                    int n9 = 0;
                    int n10 = 0;
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = 0;
                    this.paintImmediatelyClip.x = n;
                    this.paintImmediatelyClip.y = n2;
                    this.paintImmediatelyClip.width = n3;
                    this.paintImmediatelyClip.height = n4;
                    boolean bl2 = this.alwaysOnTop() && this.isOpaque();
                    JComponent jComponent3 = null;
                    for (container = this; container != null && !(container instanceof Window) && !(container instanceof Applet); container = container.getParent()) {
                        object = container instanceof JComponent ? container : null;
                        vector.addElement((JComponent)container);
                        if (!bl2 && object != null && !((JComponent)object).isOptimizedDrawingEnabled()) {
                            if (container != this) {
                                if (((JComponent)object).isPaintingOrigin()) {
                                    n5 = 1;
                                } else {
                                    int n14;
                                    Component[] componentArray = container.getComponents();
                                    for (n14 = 0; n14 < componentArray.length && componentArray[n14] != jComponent3; ++n14) {
                                    }
                                    switch (((JComponent)object).getObscuredState(n14, this.paintImmediatelyClip.x, this.paintImmediatelyClip.y, this.paintImmediatelyClip.width, this.paintImmediatelyClip.height)) {
                                        case 0: {
                                            n5 = 0;
                                            break;
                                        }
                                        case 2: {
                                            return;
                                        }
                                        default: {
                                            n5 = 1;
                                            break;
                                        }
                                    }
                                }
                            } else {
                                n5 = 0;
                            }
                            if (n5 != 0) {
                                jComponent = object;
                                n8 = n9;
                                n7 = 0;
                                n6 = 0;
                                bl = false;
                            }
                        }
                        ++n9;
                        if (repaintManager.isDoubleBufferingEnabled() && object != null && ((JComponent)object).isDoubleBuffered()) {
                            bl = true;
                            jComponent2 = object;
                        }
                        if (!bl2) {
                            Rectangle rectangle = object != null ? ((JComponent)object)._bounds : container.getBounds();
                            n11 = rectangle.width;
                            n10 = rectangle.height;
                            SwingUtilities.computeIntersection(n13, n12, n11, n10, this.paintImmediatelyClip);
                            this.paintImmediatelyClip.x += rectangle.x;
                            this.paintImmediatelyClip.y += rectangle.y;
                            n6 += rectangle.x;
                            n7 += rectangle.y;
                        }
                        jComponent3 = container;
                    }
                    if (container == null) return;
                    if (container.getPeer() == null) {
                        return;
                    }
                    if (this.paintImmediatelyClip.width <= 0) return;
                    if (this.paintImmediatelyClip.height <= 0) {
                        return;
                    }
                    jComponent.setFlag(13, true);
                    this.paintImmediatelyClip.x -= n6;
                    this.paintImmediatelyClip.y -= n7;
                    if (jComponent != this) {
                        for (n5 = n8; n5 > 0; --n5) {
                            object = (Component)vector.elementAt(n5);
                            if (!(object instanceof JComponent)) continue;
                            ((JComponent)object).setPaintingChild((Component)vector.elementAt(n5 - 1));
                        }
                    }
                    try {
                        Graphics graphics;
                        try {
                            object = jComponent.getGraphics();
                            graphics = SwingGraphics.createSwingGraphics((Graphics)object);
                            ((Graphics)object).dispose();
                        }
                        catch (NullPointerException nullPointerException) {
                            graphics = null;
                            nullPointerException.printStackTrace();
                        }
                        if (graphics == null) {
                            System.err.println("In paintImmediately null graphics");
                            Object var29_29 = null;
                            if (jComponent == this) break block34;
                            break block35;
                        }
                        try {
                            boolean bl3 = false;
                            if (bl) {
                                bl3 = this.paintDoubleBuffered(jComponent, jComponent2, graphics, this.paintImmediatelyClip.x, this.paintImmediatelyClip.y, this.paintImmediatelyClip.width, this.paintImmediatelyClip.height);
                            }
                            if (!bl3) {
                                graphics.setClip(this.paintImmediatelyClip.x, this.paintImmediatelyClip.y, this.paintImmediatelyClip.width, this.paintImmediatelyClip.height);
                                jComponent.paint(graphics);
                            }
                            break block36;
                        }
                        finally {
                            graphics.dispose();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var29_31 = null;
                        if (jComponent != this) {
                            for (int i = n8; i > 0; --i) {
                                Component component = (Component)vector.elementAt(i);
                                if (!(component instanceof JComponent)) continue;
                                ((JComponent)component).setPaintingChild(null);
                            }
                        }
                        vector.removeAllElements();
                        jComponent.setFlag(13, false);
                        throw throwable;
                    }
                }
                for (int i = n8; i > 0; --i) {
                    Component component = (Component)vector.elementAt(i);
                    if (!(component instanceof JComponent)) continue;
                    ((JComponent)component).setPaintingChild(null);
                }
            }
            vector.removeAllElements();
            jComponent.setFlag(13, false);
            return;
        }
        Object var29_30 = null;
        if (jComponent != this) {
            for (int i = n8; i > 0; --i) {
                Component component = (Component)vector.elementAt(i);
                if (!(component instanceof JComponent)) continue;
                ((JComponent)component).setPaintingChild(null);
            }
        }
        vector.removeAllElements();
        jComponent.setFlag(13, false);
    }

    private boolean paintDoubleBuffered(JComponent jComponent, Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        RepaintManager repaintManager = RepaintManager.currentManager(jComponent);
        boolean bl = false;
        Image image = null;
        if (repaintManager.useVolatileDoubleBuffer() && (image = repaintManager.getVolatileOffscreenBuffer(component, n3, n4)) != null && image.getWidth(null) > 0 && image.getHeight(null) > 0) {
            VolatileImage volatileImage = (VolatileImage)image;
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            for (int i = 0; !bl && i < 2; ++i) {
                if (volatileImage.validate(graphicsConfiguration) == 2) {
                    repaintManager.resetVolatileDoubleBuffer(graphicsConfiguration);
                    image = repaintManager.getVolatileOffscreenBuffer(component, n3, n4);
                    volatileImage = (VolatileImage)image;
                }
                this.paintWithOffscreenBuffer(jComponent, graphics, n, n2, n3, n4, image);
                bl = !volatileImage.contentsLost();
            }
        }
        if (!bl && (image = repaintManager.getOffscreenBuffer(component, n3, n4)) != null && image.getWidth(null) > 0 && image.getHeight(null) > 0) {
            this.paintWithOffscreenBuffer(jComponent, graphics, n, n2, n3, n4, image);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintWithOffscreenBuffer(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4, Image image) {
        Graphics graphics2 = image.getGraphics();
        Graphics graphics3 = SwingGraphics.createSwingGraphics(graphics2);
        graphics2.dispose();
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        if (n5 > n3) {
            n5 = n3;
        }
        if (n6 > n4) {
            n6 = n4;
        }
        try {
            jComponent.setFlag(1, true);
            jComponent.setFlag(2, true);
            int n7 = n + n3;
            for (int i = n; i < n7; i += n5) {
                int n8 = n2 + n4;
                for (int j = n2; j < n8; j += n6) {
                    if (j + n6 >= n8 && i + n5 >= n7) {
                        jComponent.setFlag(2, false);
                    }
                    graphics3.translate(-i, -j);
                    graphics3.setClip(i, j, n5, n6);
                    if (jComponent.getFlag(13)) {
                        jComponent.paint(graphics3);
                    } else {
                        if (!jComponent.rectangleIsObscured(n, n2, n5, n6)) {
                            jComponent.paintComponent(graphics3);
                            jComponent.paintBorder(graphics3);
                        }
                        jComponent.paintChildren(graphics3);
                    }
                    graphics.setClip(i, j, n5, n6);
                    graphics.drawImage(image, i, j, jComponent);
                    graphics3.translate(i, j);
                }
            }
            Object var17_16 = null;
            jComponent.setFlag(1, false);
            jComponent.setFlag(2, false);
            graphics3.dispose();
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            jComponent.setFlag(1, false);
            jComponent.setFlag(2, false);
            graphics3.dispose();
            throw throwable;
        }
    }

    private int getObscuredState(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        for (int i = n - 1; i >= 0; --i) {
            Rectangle rectangle;
            boolean bl;
            Component component = this.getComponent(i);
            if (!component.isVisible()) continue;
            if (component instanceof JComponent) {
                bl = ((JComponent)component).isOpaque();
                if (!bl && n6 == 1) continue;
                rectangle = ((JComponent)component).getBounds(this.tmpRect);
            } else {
                rectangle = component.getBounds();
                bl = true;
            }
            if (bl && n2 >= rectangle.x && n2 + n4 <= rectangle.x + rectangle.width && n3 >= rectangle.y && n3 + n5 <= rectangle.y + rectangle.height) {
                return 2;
            }
            if (n6 != 0 || n2 + n4 <= rectangle.x || n3 + n5 <= rectangle.y || n2 >= rectangle.x + rectangle.width || n3 >= rectangle.y + rectangle.height) continue;
            n6 = 1;
        }
        return n6;
    }

    boolean checkIfChildObscuredBySibling() {
        return true;
    }

    private void setFlag(int n, boolean bl) {
        this.flags = bl ? (this.flags |= 1 << n) : (this.flags &= ~(1 << n));
    }

    private boolean getFlag(int n) {
        int n2 = 1 << n;
        return (this.flags & n2) == n2;
    }

    static void setWriteObjCounter(JComponent jComponent, byte by) {
        jComponent.flags = jComponent.flags & 0xFFC03FFF | by << 14;
    }

    static byte getWriteObjCounter(JComponent jComponent) {
        return (byte)(jComponent.flags >> 14 & 0xFF);
    }

    public void setDoubleBuffered(boolean bl) {
        this.setFlag(0, bl);
    }

    public boolean isDoubleBuffered() {
        return this.getFlag(0);
    }

    public JRootPane getRootPane() {
        return SwingUtilities.getRootPane(this);
    }

    void compWriteObjectNotify() {
        byte by = JComponent.getWriteObjCounter(this);
        JComponent.setWriteObjCounter(this, (byte)(by + 1));
        if (by != 0) {
            return;
        }
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        if (this.getToolTipText() != null || this instanceof JTableHeader) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    void enableSerialization() {
        this.addFocusListener(new EnableSerializationFocusListener());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        ReadObjectCallback readObjectCallback = (ReadObjectCallback)readObjectCallbacks.get(objectInputStream);
        if (readObjectCallback == null) {
            try {
                readObjectCallback = new ReadObjectCallback(objectInputStream);
                readObjectCallbacks.put(objectInputStream, readObjectCallback);
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }
        readObjectCallback.registerComponent(this);
        if (this.getToolTipText() != null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
        JComponent.setWriteObjCounter(this, (byte)0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    protected String paramString() {
        String string = this.preferredSize != null ? this.preferredSize.toString() : "";
        String string2 = this.minimumSize != null ? this.minimumSize.toString() : "";
        String string3 = this.maximumSize != null ? this.maximumSize.toString() : "";
        String string4 = this.border != null ? this.border.toString() : "";
        return super.paramString() + ",alignmentX=" + this.alignmentX + ",alignmentY=" + this.alignmentY + ",border=" + string4 + ",flags=" + this.flags + ",maximumSize=" + string3 + ",minimumSize=" + string2 + ",preferredSize=" + string;
    }

    private class ReadObjectCallback
    implements ObjectInputValidation {
        private final Vector roots = new Vector(1);
        private final ObjectInputStream inputStream;

        ReadObjectCallback(ObjectInputStream objectInputStream) throws Exception {
            this.inputStream = objectInputStream;
            objectInputStream.registerValidation(this, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validateObject() throws InvalidObjectException {
            try {
                for (int i = 0; i < this.roots.size(); ++i) {
                    JComponent jComponent = (JComponent)this.roots.elementAt(i);
                    SwingUtilities.updateComponentTreeUI(jComponent);
                }
            }
            finally {
                readObjectCallbacks.remove(this.inputStream);
            }
        }

        private void registerComponent(JComponent jComponent) {
            Container container;
            JComponent jComponent2;
            int n;
            for (n = 0; n < this.roots.size(); ++n) {
                jComponent2 = (JComponent)this.roots.elementAt(n);
                for (container = jComponent; container != null; container = container.getParent()) {
                    if (container != jComponent2) continue;
                    return;
                }
            }
            block2: for (n = 0; n < this.roots.size(); ++n) {
                jComponent2 = (JComponent)this.roots.elementAt(n);
                for (container = jComponent2.getParent(); container != null; container = container.getParent()) {
                    if (container != jComponent) continue;
                    this.roots.removeElementAt(n--);
                    continue block2;
                }
            }
            this.roots.addElement(jComponent);
        }
    }

    private class EnableSerializationFocusListener
    implements FocusListener,
    Serializable {
        private EnableSerializationFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            JComponent.this.compWriteObjectNotify();
        }
    }

    public abstract class AccessibleJComponent
    extends Container.AccessibleAWTContainer
    implements AccessibleExtendedComponent {
        protected ContainerListener accessibleContainerHandler = null;
        protected FocusListener accessibleFocusHandler = null;

        protected AccessibleJComponent() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleFocusHandler == null) {
                this.accessibleFocusHandler = new AccessibleFocusHandler();
                JComponent.this.addFocusListener(this.accessibleFocusHandler);
            }
            if (this.accessibleContainerHandler == null) {
                this.accessibleContainerHandler = new AccessibleContainerHandler();
                JComponent.this.addContainerListener(this.accessibleContainerHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleFocusHandler != null) {
                JComponent.this.removeFocusListener(this.accessibleFocusHandler);
                this.accessibleFocusHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        protected String getBorderTitle(Border border) {
            if (border instanceof TitledBorder) {
                return ((TitledBorder)border).getTitle();
            }
            if (border instanceof CompoundBorder) {
                String string = this.getBorderTitle(((CompoundBorder)border).getInsideBorder());
                if (string == null) {
                    string = this.getBorderTitle(((CompoundBorder)border).getOutsideBorder());
                }
                return string;
            }
            return null;
        }

        public String getAccessibleName() {
            AccessibleContext accessibleContext;
            Object object;
            String string = this.accessibleName;
            if (string == null) {
                string = this.getBorderTitle(JComponent.this.getBorder());
            }
            if (string == null && (object = JComponent.this.getClientProperty("labeledBy")) instanceof Accessible && (accessibleContext = ((Accessible)object).getAccessibleContext()) != null) {
                string = accessibleContext.getAccessibleName();
            }
            return string;
        }

        public String getAccessibleDescription() {
            AccessibleContext accessibleContext;
            Object object;
            String string = this.accessibleDescription;
            if (string == null) {
                try {
                    string = this.getToolTipText();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string == null && (object = JComponent.this.getClientProperty("labeledBy")) instanceof Accessible && (accessibleContext = ((Accessible)object).getAccessibleContext()) != null) {
                string = accessibleContext.getAccessibleDescription();
            }
            return string;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JComponent.this.isOpaque()) {
                accessibleStateSet.add(AccessibleState.OPAQUE);
            }
            return accessibleStateSet;
        }

        public int getAccessibleChildrenCount() {
            return super.getAccessibleChildrenCount();
        }

        public Accessible getAccessibleChild(int n) {
            return super.getAccessibleChild(n);
        }

        AccessibleExtendedComponent getAccessibleExtendedComponent() {
            return this;
        }

        public String getToolTipText() {
            return null;
        }

        public String getTitledBorderText() {
            Border border = JComponent.this.getBorder();
            if (border instanceof TitledBorder) {
                return ((TitledBorder)border).getTitle();
            }
            return null;
        }

        public AccessibleKeyBinding getAccessibleKeyBinding() {
            return null;
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            protected AccessibleFocusHandler() {
            }

            public void focusGained(FocusEvent focusEvent) {
                if (((AccessibleJComponent)AccessibleJComponent.this).JComponent.this.accessibleContext != null) {
                    ((AccessibleJComponent)AccessibleJComponent.this).JComponent.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (((AccessibleJComponent)AccessibleJComponent.this).JComponent.this.accessibleContext != null) {
                    ((AccessibleJComponent)AccessibleJComponent.this).JComponent.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                }
            }
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleJComponent.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleJComponent.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
                }
            }
        }
    }

    static class KeyboardState
    implements Serializable {
        private static final Object keyCodesKey = class$javax$swing$JComponent$KeyboardState == null ? (class$javax$swing$JComponent$KeyboardState = JComponent.class$("javax.swing.JComponent$KeyboardState")) : class$javax$swing$JComponent$KeyboardState;

        KeyboardState() {
        }

        static IntVector getKeyCodeArray() {
            IntVector intVector = (IntVector)SwingUtilities.appContextGet(keyCodesKey);
            if (intVector == null) {
                intVector = new IntVector();
                SwingUtilities.appContextPut(keyCodesKey, intVector);
            }
            return intVector;
        }

        static void registerKeyPressed(int n, int n2) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n3 = intVector.size();
            for (int i = 0; i < n3; i += 2) {
                if (intVector.elementAt(i) != -1) continue;
                intVector.setElementAt(n, i);
                intVector.setElementAt(n2, i + 1);
                return;
            }
            intVector.addElement(n);
            intVector.addElement(n2);
        }

        static void registerKeyTyped(int n) {
            int n2;
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n3 = intVector.size();
            for (n2 = 1; n2 < n3; n2 += 2) {
                if (intVector.elementAt(n2) != n) continue;
                return;
            }
            for (n2 = 0; n2 < n3; n2 += 2) {
                if (intVector.elementAt(n2) != -1) continue;
                intVector.setElementAt(0, n2);
                intVector.setElementAt(n, n2 + 1);
                return;
            }
            intVector.addElement(0);
            intVector.addElement(n);
        }

        static void registerKeyReleased(int n, int n2) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n3 = intVector.size();
            for (int i = 0; i < n3; i += 2) {
                if (intVector.elementAt(i) == n) {
                    intVector.setElementAt(-1, i);
                    intVector.setElementAt(-1, i + 1);
                    return;
                }
                if (intVector.elementAt(i) != 0 || intVector.elementAt(i + 1) != n2) continue;
                intVector.setElementAt(-1, i);
                intVector.setElementAt(-1, i + 1);
                return;
            }
        }

        static boolean keyIsPressed(int n) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n2 = intVector.size();
            for (int i = 0; i < n2; i += 2) {
                if (intVector.elementAt(i) != n) continue;
                return true;
            }
            return false;
        }

        static boolean keyIsTyped(int n) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n2 = intVector.size();
            for (int i = 1; i < n2; i += 2) {
                if (intVector.elementAt(i) != n) continue;
                return true;
            }
            return false;
        }

        static boolean shouldProcess(KeyEvent keyEvent) {
            switch (keyEvent.getID()) {
                case 401: {
                    if (!KeyboardState.keyIsPressed(keyEvent.getKeyCode())) {
                        KeyboardState.registerKeyPressed(keyEvent.getKeyCode(), keyEvent.getKeyChar());
                    }
                    return true;
                }
                case 402: {
                    if (KeyboardState.keyIsPressed(keyEvent.getKeyCode())) {
                        KeyboardState.registerKeyReleased(keyEvent.getKeyCode(), keyEvent.getKeyChar());
                        return true;
                    }
                    if (KeyboardState.keyIsTyped(keyEvent.getKeyChar())) {
                        KeyboardState.registerKeyReleased(keyEvent.getKeyCode(), keyEvent.getKeyChar());
                        return true;
                    }
                    return false;
                }
                case 400: {
                    if (!KeyboardState.keyIsTyped(keyEvent.getKeyChar())) {
                        KeyboardState.registerKeyTyped(keyEvent.getKeyChar());
                    }
                    return true;
                }
            }
            return false;
        }
    }

    static final class IntVector {
        int[] array = null;
        int count = 0;
        int capacity = 0;

        IntVector() {
        }

        int size() {
            return this.count;
        }

        int elementAt(int n) {
            return this.array[n];
        }

        void addElement(int n) {
            if (this.count == this.capacity) {
                this.capacity = (this.capacity + 2) * 2;
                int[] nArray = new int[this.capacity];
                if (this.count > 0) {
                    System.arraycopy(this.array, 0, nArray, 0, this.count);
                }
                this.array = nArray;
            }
            this.array[this.count++] = n;
        }

        void setElementAt(int n, int n2) {
            this.array[n2] = n;
        }
    }

    final class ActionStandin
    implements Action {
        private final ActionListener actionListener;
        private final String command;
        private final Action action;

        ActionStandin(ActionListener actionListener, String string) {
            this.actionListener = actionListener;
            this.action = actionListener instanceof Action ? (Action)actionListener : null;
            this.command = string;
        }

        public Object getValue(String string) {
            if (string != null) {
                if (string.equals("ActionCommandKey")) {
                    return this.command;
                }
                if (this.action != null) {
                    return this.action.getValue(string);
                }
                if (string.equals("Name")) {
                    return "ActionStandin";
                }
            }
            return null;
        }

        public boolean isEnabled() {
            if (this.actionListener == null) {
                return false;
            }
            if (this.action == null) {
                return true;
            }
            return this.action.isEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(actionEvent);
            }
        }

        public void putValue(String string, Object object) {
        }

        public void setEnabled(boolean bl) {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }
    }
}

