/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.motif.MToolkitThreadBlockedHandler;

public class MDataTransferer
extends DataTransferer {
    private static final long FILE_NAME_ATOM = MDataTransferer.getAtomForTarget("FILE_NAME");
    private static final long DT_NET_FILE_ATOM = MDataTransferer.getAtomForTarget("_DT_NETFILE");
    private static final long PNG_ATOM = MDataTransferer.getAtomForTarget("PNG");
    private static final long JFIF_ATOM = MDataTransferer.getAtomForTarget("JFIF");
    private static MDataTransferer transferer;

    private MDataTransferer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MDataTransferer getInstanceImpl() {
        if (transferer == null) {
            Class clazz = MDataTransferer.class;
            synchronized (clazz) {
                if (transferer == null) {
                    transferer = new MDataTransferer();
                }
            }
        }
        return transferer;
    }

    public String getDefaultUnicodeEncoding() {
        return "iso-10646-ucs-2";
    }

    public boolean isLocaleDependentTextFormat(long l) {
        return false;
    }

    public boolean isFileFormat(long l) {
        return l == FILE_NAME_ATOM || l == DT_NET_FILE_ATOM;
    }

    public boolean isImageFormat(long l) {
        return l == PNG_ATOM || l == JFIF_ATOM;
    }

    protected Long getFormatForNativeAsLong(String string) {
        long l = MDataTransferer.getAtomForTarget(string);
        if (l <= 0L) {
            throw new InternalError("Cannot register a target");
        }
        return new Long(l);
    }

    protected String getNativeForFormat(long l) {
        return MDataTransferer.getTargetNameForAtom(l);
    }

    public ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler() {
        return MToolkitThreadBlockedHandler.getToolkitThreadBlockedHandler();
    }

    static native long getAtomForTarget(String var0);

    private static native String getTargetNameForAtom(long var0);

    protected byte[] imageToPlatformBytes(Image image, long l) throws IOException {
        String string = null;
        if (l == PNG_ATOM) {
            string = "image/png";
        } else if (l == JFIF_ATOM) {
            string = "image/jpeg";
        }
        if (string != null) {
            return this.imageToStandardBytes(image, string);
        }
        String string2 = this.getNativeForFormat(l);
        throw new IOException("Translation to " + string2 + " is not supported.");
    }

    protected Image platformImageBytesOrStreamToImage(InputStream inputStream, byte[] byArray, long l) throws IOException {
        String string = null;
        if (l == PNG_ATOM) {
            string = "image/png";
        } else if (l == JFIF_ATOM) {
            string = "image/jpeg";
        }
        if (string != null) {
            return this.standardImageBytesOrStreamToImage(inputStream, byArray, string);
        }
        String string2 = this.getNativeForFormat(l);
        throw new IOException("Translation from " + string2 + " is not supported.");
    }
}

