/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.print;

import java.awt.Frame;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.io.File;
import java.io.FilePermission;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import sun.awt.DebugHelper;
import sun.awt.print.PrintDialog;
import sun.awt.print.PrintStatusDialog;
import sun.awt.print.PrinterCapabilities;
import sun.awt.print.PrinterListUpdatable;

public abstract class PrintControl {
    public static final PageAttributes.MediaType[] SIZES = new PageAttributes.MediaType[]{PageAttributes.MediaType.ISO_4A0, PageAttributes.MediaType.ISO_2A0, PageAttributes.MediaType.ISO_A0, PageAttributes.MediaType.ISO_A1, PageAttributes.MediaType.ISO_A2, PageAttributes.MediaType.ISO_A3, PageAttributes.MediaType.ISO_A4, PageAttributes.MediaType.ISO_A5, PageAttributes.MediaType.ISO_A6, PageAttributes.MediaType.ISO_A7, PageAttributes.MediaType.ISO_A8, PageAttributes.MediaType.ISO_A9, PageAttributes.MediaType.ISO_A10, PageAttributes.MediaType.ISO_B0, PageAttributes.MediaType.ISO_B1, PageAttributes.MediaType.ISO_B2, PageAttributes.MediaType.ISO_B3, PageAttributes.MediaType.ISO_B4, PageAttributes.MediaType.ISO_B5, PageAttributes.MediaType.ISO_B6, PageAttributes.MediaType.ISO_B7, PageAttributes.MediaType.ISO_B8, PageAttributes.MediaType.ISO_B9, PageAttributes.MediaType.ISO_B10, PageAttributes.MediaType.JIS_B0, PageAttributes.MediaType.JIS_B1, PageAttributes.MediaType.JIS_B2, PageAttributes.MediaType.JIS_B3, PageAttributes.MediaType.JIS_B4, PageAttributes.MediaType.JIS_B5, PageAttributes.MediaType.JIS_B6, PageAttributes.MediaType.JIS_B7, PageAttributes.MediaType.JIS_B8, PageAttributes.MediaType.JIS_B9, PageAttributes.MediaType.JIS_B10, PageAttributes.MediaType.ISO_C0, PageAttributes.MediaType.ISO_C1, PageAttributes.MediaType.ISO_C2, PageAttributes.MediaType.ISO_C3, PageAttributes.MediaType.ISO_C4, PageAttributes.MediaType.ISO_C5, PageAttributes.MediaType.ISO_C6, PageAttributes.MediaType.ISO_C7, PageAttributes.MediaType.ISO_C8, PageAttributes.MediaType.ISO_C9, PageAttributes.MediaType.ISO_C10, PageAttributes.MediaType.ISO_DESIGNATED_LONG, PageAttributes.MediaType.EXECUTIVE, PageAttributes.MediaType.FOLIO, PageAttributes.MediaType.INVOICE, PageAttributes.MediaType.LEDGER, PageAttributes.MediaType.NA_LETTER, PageAttributes.MediaType.NA_LEGAL, PageAttributes.MediaType.QUARTO, PageAttributes.MediaType.A, PageAttributes.MediaType.B, PageAttributes.MediaType.C, PageAttributes.MediaType.D, PageAttributes.MediaType.E, PageAttributes.MediaType.NA_10X15_ENVELOPE, PageAttributes.MediaType.NA_10X14_ENVELOPE, PageAttributes.MediaType.NA_10X13_ENVELOPE, PageAttributes.MediaType.NA_9X12_ENVELOPE, PageAttributes.MediaType.NA_9X11_ENVELOPE, PageAttributes.MediaType.NA_7X9_ENVELOPE, PageAttributes.MediaType.NA_6X9_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_9_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_10_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_11_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_12_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_14_ENVELOPE, PageAttributes.MediaType.INVITE_ENVELOPE, PageAttributes.MediaType.ITALY_ENVELOPE, PageAttributes.MediaType.MONARCH_ENVELOPE, PageAttributes.MediaType.PERSONAL_ENVELOPE};
    public static final MediaSizeName[] JAVAXSIZES = new MediaSizeName[]{null, null, MediaSizeName.ISO_A0, MediaSizeName.ISO_A1, MediaSizeName.ISO_A2, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_A6, MediaSizeName.ISO_A7, MediaSizeName.ISO_A8, MediaSizeName.ISO_A9, MediaSizeName.ISO_A10, MediaSizeName.ISO_B0, MediaSizeName.ISO_B1, MediaSizeName.ISO_B2, MediaSizeName.ISO_B3, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ISO_B7, MediaSizeName.ISO_B8, MediaSizeName.ISO_B9, MediaSizeName.ISO_B10, MediaSizeName.ISO_C0, MediaSizeName.ISO_C1, MediaSizeName.ISO_C2, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C5, MediaSizeName.ISO_C6, null, null, null, null, MediaSizeName.ISO_DESIGNATED_LONG, MediaSizeName.EXECUTIVE, MediaSizeName.FOLIO, MediaSizeName.INVOICE, MediaSizeName.LEDGER, MediaSizeName.NA_LETTER, MediaSizeName.NA_LEGAL, MediaSizeName.QUARTO, MediaSizeName.A, MediaSizeName.B, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.NA_10X13_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.NA_9X11_ENVELOPE, MediaSizeName.NA_7X9_ENVELOPE, MediaSizeName.NA_6X9_ENVELOPE, MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, null, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE};
    public static final int[] WIDTHS = new int[]{4768, 3370, 2384, 1684, 1191, 842, 595, 420, 298, 210, 147, 105, 74, 2835, 2004, 1417, 1001, 709, 499, 354, 249, 176, 125, 88, 2920, 2064, 1460, 1032, 729, 516, 363, 258, 181, 128, 91, 2599, 1837, 1298, 918, 649, 459, 323, 230, 162, 113, 79, 312, 522, 612, 396, 792, 612, 612, 609, 612, 792, 1224, 1584, 2448, 720, 720, 720, 648, 648, 504, 432, 279, 297, 324, 342, 360, 624, 312, 279, 261};
    public static final int[] LENGTHS = new int[]{6741, 4768, 3370, 2384, 1684, 1191, 842, 595, 420, 298, 210, 147, 105, 4008, 2835, 2004, 1417, 1001, 729, 499, 354, 249, 176, 125, 4127, 2920, 2064, 1460, 1032, 729, 516, 363, 258, 181, 128, 3677, 2599, 1837, 1298, 918, 649, 459, 323, 230, 162, 113, 624, 756, 936, 612, 1224, 792, 1008, 780, 792, 1224, 1584, 2448, 3168, 1080, 1008, 936, 864, 792, 648, 648, 639, 684, 747, 792, 828, 624, 652, 540, 468};
    private static final DebugHelper dbg = DebugHelper.create(PrintControl.class);
    private static final double CM_TO_IN = 2.54;
    private static ResourceBundle messageRB;
    protected Frame dialogOwner;
    protected String doctitle;
    private JobAttributes jobAttributes;
    private PageAttributes pageAttributes;
    private String options = "";
    private FilePermission printToFilePermission;
    private boolean printToFileEnabled = false;

    public static int[] getSize(PageAttributes.MediaType mediaType) {
        int[] nArray = new int[]{612, 792};
        for (int i = 0; i < SIZES.length; ++i) {
            if (SIZES[i] != mediaType) continue;
            nArray[0] = WIDTHS[i];
            nArray[1] = LENGTHS[i];
            break;
        }
        return nArray;
    }

    public static MediaSizeName mapMedia(PageAttributes.MediaType mediaType) {
        MediaSizeName mediaSizeName = null;
        if (SIZES.length != JAVAXSIZES.length) {
            throw new RuntimeException("array lengths differ");
        }
        for (int i = 0; i < SIZES.length; ++i) {
            if (SIZES[i] != mediaType) continue;
            if (JAVAXSIZES[i] != null) {
                mediaSizeName = JAVAXSIZES[i];
                break;
            }
            float f = (float)Math.rint((double)(WIDTHS[i] * 25400) / 72.0);
            float f2 = (float)Math.rint((double)(LENGTHS[i] * 25400) / 72.0);
            mediaSizeName = MediaSize.findMedia(f, f2, 25400);
            break;
        }
        return mediaSizeName;
    }

    public PrintControl(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        this.dialogOwner = frame;
        this.doctitle = string != null ? string : "";
        this.jobAttributes = jobAttributes != null ? jobAttributes : new JobAttributes();
        this.pageAttributes = pageAttributes != null ? pageAttributes : new PageAttributes();
        int[][] nArray = this.jobAttributes.getPageRanges();
        int n = nArray[0][0];
        int n2 = nArray[nArray.length - 1][1];
        this.jobAttributes.setPageRanges(new int[][]{{n, n2}});
        this.jobAttributes.setToPage(n2);
        this.jobAttributes.setFromPage(n);
        if (frame == null && (jobAttributes == null || jobAttributes.getDialog() == JobAttributes.DialogType.NATIVE)) {
            throw new NullPointerException("frame");
        }
        int[] nArray2 = this.pageAttributes.getPrinterResolution();
        if (nArray2[0] != nArray2[1]) {
            throw new IllegalArgumentException("Differing cross feed and feed resolutions not supported.");
        }
        JobAttributes.DestinationType destinationType = this.jobAttributes.getDestination();
        if (destinationType == JobAttributes.DestinationType.FILE) {
            this.throwPrintToFile();
            this.printToFileEnabled = true;
        } else {
            this.printToFileEnabled = this.checkPrintToFile();
        }
    }

    public final PageAttributes.ColorType getColorAttrib() {
        return this.pageAttributes.getColor();
    }

    public final void setColorAttrib(PageAttributes.ColorType colorType) {
        this.pageAttributes.setColor(colorType);
    }

    public final int getCopiesAttrib() {
        return this.jobAttributes.getCopies();
    }

    public final void setCopiesAttrib(int n) {
        this.jobAttributes.setCopies(n);
    }

    public final JobAttributes.DefaultSelectionType getSelectAttrib() {
        return this.jobAttributes.getDefaultSelection();
    }

    public final void setSelectAttrib(JobAttributes.DefaultSelectionType defaultSelectionType) {
        this.jobAttributes.setDefaultSelection(defaultSelectionType);
    }

    public final JobAttributes.DestinationType getDestAttrib() {
        return this.jobAttributes.getDestination();
    }

    public final void setDestAttrib(JobAttributes.DestinationType destinationType) {
        this.jobAttributes.setDestination(destinationType);
    }

    public final JobAttributes.DialogType getDialogAttrib() {
        return this.jobAttributes.getDialog();
    }

    public final String getFileNameAttrib() {
        return this.jobAttributes.getFileName();
    }

    public final void setFileNameAttrib(String string) {
        this.jobAttributes.setFileName(string);
    }

    public final int getFromPageAttrib() {
        return this.jobAttributes.getFromPage();
    }

    public final void setFromPageAttrib(int n) {
        this.jobAttributes.setFromPage(n);
        this.jobAttributes.setPageRanges(new int[][]{{n, this.jobAttributes.getToPage()}});
    }

    public final int getMaxPageAttrib() {
        return this.jobAttributes.getMaxPage();
    }

    public final int getMediaAttrib() {
        return this.pageAttributes.getMedia().hashCode();
    }

    public final void setMediaAttrib(int n) {
        this.pageAttributes.setMedia(SIZES[n]);
    }

    public final int getMinPageAttrib() {
        return this.jobAttributes.getMinPage();
    }

    public final JobAttributes.MultipleDocumentHandlingType getMDHAttrib() {
        return this.jobAttributes.getMultipleDocumentHandling();
    }

    public final void setMDHAttrib(JobAttributes.MultipleDocumentHandlingType multipleDocumentHandlingType) {
        this.jobAttributes.setMultipleDocumentHandling(multipleDocumentHandlingType);
    }

    public final String getOptions() {
        return this.options;
    }

    public final void setOptions(String string) {
        this.options = string != null ? string : "";
    }

    public final PageAttributes.OrientationRequestedType getOrientAttrib() {
        return this.pageAttributes.getOrientationRequested();
    }

    public final void setOrientAttrib(PageAttributes.OrientationRequestedType orientationRequestedType) {
        this.pageAttributes.setOrientationRequested(orientationRequestedType);
    }

    public final PageAttributes.OriginType getOriginAttrib() {
        return this.pageAttributes.getOrigin();
    }

    public final PageAttributes.PrintQualityType getQualityAttrib() {
        return this.pageAttributes.getPrintQuality();
    }

    public final void setQualityAttrib(PageAttributes.PrintQualityType printQualityType) {
        this.pageAttributes.setPrintQuality(printQualityType);
    }

    public final String getPrinterAttrib() {
        String string = this.jobAttributes.getPrinter();
        return string != null ? string : this.getDefaultPrinterName();
    }

    public final void setPrinterAttrib(String string) {
        this.jobAttributes.setPrinter(string);
    }

    public final boolean getPrintToFileEnabled() {
        return this.printToFileEnabled;
    }

    public final int getResAttrib() {
        int[] nArray = this.pageAttributes.getPrinterResolution();
        if (nArray[2] == 3) {
            return nArray[0];
        }
        return (int)((double)nArray[0] * 2.54);
    }

    public JobAttributes.SidesType getSidesAttrib() {
        return this.jobAttributes.getSides();
    }

    public void setSidesAttrib(JobAttributes.SidesType sidesType) {
        this.jobAttributes.setSides(sidesType);
    }

    public int getToPageAttrib() {
        return this.jobAttributes.getToPage();
    }

    public void setToPageAttrib(int n) {
        this.jobAttributes.setToPage(n);
        this.jobAttributes.setPageRanges(new int[][]{{this.jobAttributes.getFromPage(), n}});
    }

    public abstract String getDefaultPrinterName();

    public abstract boolean getCapabilities(PrinterCapabilities var1);

    public abstract void getPrinterList(PrinterListUpdatable var1);

    static void initResource() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    messageRB = ResourceBundle.getBundle("sun.awt.print.resources.printcontrol");
                    return null;
                }
                catch (MissingResourceException missingResourceException) {
                    throw new Error("Fatal: Resource for AwtPrintControl is missing.");
                }
            }
        });
    }

    static synchronized String getMsg(String string) {
        if (messageRB == null) {
            PrintControl.initResource();
        }
        try {
            return messageRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for AwtPrintControl is broken. There is no " + string + " key in resource");
        }
    }

    public boolean displayDialog() {
        if (this.getDialogAttrib() == JobAttributes.DialogType.COMMON) {
            return this.displayCommonDialog();
        }
        if (this.getDialogAttrib() == JobAttributes.DialogType.NATIVE) {
            return this.displayNativeDialog();
        }
        return true;
    }

    protected final boolean displayCommonDialog() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        PrintDialog printDialog = (PrintDialog)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new PrintDialog(PrintControl.this.dialogOwner, PrintControl.this);
            }
        });
        printDialog.setDocumentTitle(this.doctitle);
        printDialog.setDestType(this.getDestAttrib());
        printDialog.setDestString(JobAttributes.DestinationType.PRINTER, this.getPrinterAttrib());
        printDialog.setDestString(JobAttributes.DestinationType.FILE, this.getFileNameAttrib());
        printDialog.setPrintToFileEnabled(this.getPrintToFileEnabled());
        printDialog.setOptionsString(this.getOptions());
        printDialog.setPrintRange(this.getSelectAttrib());
        printDialog.setMinMaxPage(this.getMinPageAttrib(), this.getMaxPageAttrib());
        printDialog.setFromPage(this.getFromPageAttrib());
        printDialog.setToPage(this.getToPageAttrib());
        printDialog.setCopies(this.getCopiesAttrib());
        printDialog.setCollate(this.getMDHAttrib() == JobAttributes.MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_COLLATED_COPIES);
        printDialog.setMedia(SIZES[this.getMediaAttrib()]);
        printDialog.setOrientation(this.getOrientAttrib());
        printDialog.setColor(this.getColorAttrib());
        printDialog.setQuality(this.getQualityAttrib());
        printDialog.setSides(this.getSidesAttrib());
        boolean bl = printDialog.display();
        if (bl) {
            String string;
            if (printDialog.getDestType() == JobAttributes.DestinationType.FILE && (string = printDialog.getDestString(JobAttributes.DestinationType.FILE)) != null && !string.equals("") && new File(string).exists()) {
                String string2 = PrintControl.getMsg("warning_button.cancel");
                String string3 = PrintControl.getMsg("warning_button.overwrite");
                PrintStatusDialog printStatusDialog = new PrintStatusDialog(printDialog, PrintControl.getMsg("warning_dialog.title"), PrintControl.getMsg("warning_msg.file_exists") + string, string3, string2);
                printStatusDialog.setLocationRelativeTo(printDialog);
                printStatusDialog.setVisible(true);
                if (printStatusDialog.getCommand().equals(string2)) {
                    bl = false;
                }
                printStatusDialog.dispose();
            }
            if (bl) {
                this.createAttributes(printDialog);
            }
        }
        printDialog.dispose();
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        return bl;
    }

    public JobAttributes getJobAttributes() {
        return this.jobAttributes;
    }

    public PageAttributes getPageAttributes() {
        return this.pageAttributes;
    }

    protected boolean displayNativeDialog() {
        return this.displayCommonDialog();
    }

    protected void createAttributes(PrintDialog printDialog) {
        int n;
        String string;
        JobAttributes jobAttributes = this.jobAttributes;
        PageAttributes pageAttributes = this.pageAttributes;
        this.jobAttributes = (JobAttributes)this.jobAttributes.clone();
        this.pageAttributes = (PageAttributes)this.pageAttributes.clone();
        this.doctitle = printDialog.getDocumentTitle();
        this.setDestAttrib(printDialog.getDestType());
        String string2 = printDialog.getDestString(JobAttributes.DestinationType.PRINTER);
        if (string2 != null && !string2.equals("")) {
            this.setPrinterAttrib(string2);
        }
        if (this.getDestAttrib() == JobAttributes.DestinationType.FILE && (string = printDialog.getDestString(JobAttributes.DestinationType.FILE)) != null && !string.equals("")) {
            this.setFileNameAttrib(string);
        }
        if ((string = printDialog.getOptionsString()) != null && !string.equals("")) {
            this.setOptions(string);
        }
        this.setSelectAttrib(printDialog.getPrintRange());
        if (this.getSelectAttrib() == JobAttributes.DefaultSelectionType.RANGE) {
            this.setToPageAttrib(printDialog.getToPage());
            this.setFromPageAttrib(printDialog.getFromPage());
        }
        if ((n = printDialog.getCopies()) > 0) {
            this.setCopiesAttrib(n);
        }
        this.setMDHAttrib(printDialog.getCollate() ? JobAttributes.MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_COLLATED_COPIES : JobAttributes.MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES);
        this.setMediaAttrib(printDialog.getMedia().hashCode());
        this.setOrientAttrib(printDialog.getOrientation());
        this.setColorAttrib(printDialog.getColor());
        this.setQualityAttrib(printDialog.getQuality());
        this.setSidesAttrib(printDialog.getSides());
        jobAttributes.set(this.jobAttributes);
        pageAttributes.set(this.pageAttributes);
        this.jobAttributes = jobAttributes;
        this.pageAttributes = pageAttributes;
    }

    private boolean checkPrintToFile() {
        try {
            this.throwPrintToFile();
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private void throwPrintToFile() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (this.printToFilePermission == null) {
                this.printToFilePermission = new FilePermission("<<ALL FILES>>", "read,write");
            }
            securityManager.checkPermission(this.printToFilePermission);
        }
    }
}

