/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import sun.awt.AppContext;
import sun.awt.FontProperties;
import sun.awt.font.NativeFontWrapper;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.FontSupport;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.security.action.GetPropertyAction;

public abstract class SunGraphicsEnvironment
extends GraphicsEnvironment
implements FontSupport {
    protected static boolean debugMapping;
    private static Font defaultFont;
    private static String[] logicalFontNames;
    private FontProperties fprops;
    private TreeMap terminalNames;
    private static HashSet physicalNames;
    private boolean loadedAllFonts = false;
    protected boolean registeredAllPaths = false;
    protected boolean noType1Font = false;
    protected String fontPath;
    protected TreeMap registeredFonts = new TreeMap();
    private Hashtable mapFamilyCache;
    protected boolean loadNativeFonts = false;
    protected static TreeMap predefinedNames;
    private ArrayList badFonts;
    protected GraphicsDevice[] screens;
    private Font[] allFonts;
    private static Hashtable mapFontCache;
    private static final String FPAKey = "FontPropertiesAttr";
    private static final String FPAName = "PLSFFallback";
    private static final String PLSF_PREFIX = "_plsf_";
    private String prefixPLSF = null;
    private boolean initPLSFFallback = false;
    private FontProperties fpropsPLSF = null;
    protected static boolean hasPLSF;
    protected static String fallbackFont;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SunGraphicsEnvironment() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string;
                Object object;
                Object object2;
                File file;
                if (System.getProperty("sun.java2d.debugfonts") != null) {
                    debugMapping = true;
                    NativeFontWrapper.setDebug(1);
                }
                SunGraphicsEnvironment.this.fontPath = System.getProperty("sun.java2d.fontpath");
                String string2 = null;
                if (System.getProperty("os.name", "").indexOf("4690") > -1) {
                    string2 = System.getProperty("sun.java2d.fontpath.default");
                }
                if (string2 == null) {
                    string2 = System.getProperty("java.home", "") + File.separator + "lib" + File.separator + "fonts";
                }
                if (System.getProperty("os.name", "").indexOf("Windows") > -1) {
                    string2 = string2 + File.pathSeparator + SunGraphicsEnvironment.this.fontPath;
                }
                if ((file = new File(string2 + File.separator + "badfonts.txt")).exists()) {
                    object2 = null;
                    try {
                        SunGraphicsEnvironment.this.badFonts = new ArrayList();
                        object2 = new FileInputStream(file);
                        object = new InputStreamReader((InputStream)object2);
                        BufferedReader bufferedReader = new BufferedReader((Reader)object);
                        while ((string = bufferedReader.readLine()) != null) {
                            if (debugMapping) {
                                System.out.println("read bad font " + string);
                            }
                            SunGraphicsEnvironment.this.badFonts.add(string);
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (object2 != null) {
                                ((FileInputStream)object2).close();
                            }
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                }
                SunGraphicsEnvironment.this.registerFontsWithPlatform(string2);
                SunGraphicsEnvironment.this.fprops = SunGraphicsEnvironment.this.createFontProperties();
                object2 = null;
                if (SunGraphicsEnvironment.this.fprops != null) {
                    object2 = SunGraphicsEnvironment.this.fprops.getProperty("appendedfontpath");
                }
                if (SunGraphicsEnvironment.this.fontPath.length() == 0) {
                    object = System.getProperty("sun.java2d.noType1Font");
                    if (object == null) {
                        SunGraphicsEnvironment.this.noType1Font = NativeFontWrapper.getType1FontVar();
                    }
                    if ("true".equals(object)) {
                        SunGraphicsEnvironment.this.noType1Font = true;
                    }
                    SunGraphicsEnvironment.this.loadNativeFonts = true;
                    SunGraphicsEnvironment.this.fontPath = SunGraphicsEnvironment.this.getBasePlatformFontPath(SunGraphicsEnvironment.this.noType1Font);
                    SunGraphicsEnvironment.this.fontPath = string2 + File.pathSeparator + SunGraphicsEnvironment.this.fontPath;
                } else {
                    SunGraphicsEnvironment.this.fontPath = SunGraphicsEnvironment.this.fontPath + File.pathSeparator + string2;
                }
                if (object2 != null) {
                    SunGraphicsEnvironment.this.fontPath = SunGraphicsEnvironment.this.fontPath + File.pathSeparator + (String)object2;
                } else if (!SunGraphicsEnvironment.this.registeredAllPaths) {
                    SunGraphicsEnvironment.this.fontPath = SunGraphicsEnvironment.this.fontPath + File.pathSeparator + SunGraphicsEnvironment.this.getPlatformFontPath(SunGraphicsEnvironment.this.noType1Font);
                }
                if (debugMapping) {
                    System.out.println("Java Font Path=" + SunGraphicsEnvironment.this.fontPath);
                }
                SunGraphicsEnvironment.this.registerFontPaths(SunGraphicsEnvironment.this.fontPath);
                SunGraphicsEnvironment.this.registerFonts(string2, true);
                SunGraphicsEnvironment.this.initCompositeFonts(SunGraphicsEnvironment.this.fprops);
                SunGraphicsEnvironment.this.setSubstitutes();
                object = SunGraphicsEnvironment.this.registeredFonts.keySet().toArray();
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    string = (String)object[i];
                    String string3 = NativeFontWrapper.getFullNameByFileName(string);
                    if (string3 != null) {
                        string3 = string3.toLowerCase();
                    }
                    if (string3 == null || SunGraphicsEnvironment.this.terminalNames.containsKey(string3)) continue;
                    SunGraphicsEnvironment.this.terminalNames.put(string3, new Integer(0));
                }
                return null;
            }
        });
    }

    protected String getBasePlatformFontPath(boolean bl) {
        return this.getPlatformFontPath(bl);
    }

    protected String getPlatformFontPath(boolean bl) {
        this.registeredAllPaths = true;
        return NativeFontWrapper.getFontPath(bl);
    }

    protected synchronized void loadFonts() {
        String string;
        if (this.loadedAllFonts) {
            return;
        }
        if (debugMapping) {
            System.out.println("loadfonts called");
        }
        if (!this.registeredAllPaths) {
            string = this.getPlatformFontPath(this.noType1Font);
            this.registerFontPaths(string);
            this.fontPath = this.fontPath + File.separator + string;
        } else {
            string = this.fontPath;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean bl = SunGraphicsEnvironment.this.registerFonts(string, false);
                boolean bl2 = false;
                if (SunGraphicsEnvironment.this.loadNativeFonts) {
                    bl2 = SunGraphicsEnvironment.this.registerNativeFonts();
                }
                if (!bl && !bl2 && SunGraphicsEnvironment.this.registeredFonts.size() == 0) {
                    System.out.println("\nNo fonts were found in '" + string + "'.\n");
                    System.exit(2);
                }
                SunGraphicsEnvironment.this.loadedAllFonts = true;
                return null;
            }
        });
    }

    public synchronized GraphicsDevice[] getScreenDevices() {
        GraphicsDevice[] graphicsDeviceArray = this.screens;
        if (graphicsDeviceArray == null) {
            int n = this.getNumScreens();
            graphicsDeviceArray = new GraphicsDevice[n];
            for (int i = 0; i < n; ++i) {
                graphicsDeviceArray[i] = this.makeScreenDevice(i);
            }
            this.screens = graphicsDeviceArray;
        }
        return graphicsDeviceArray;
    }

    protected abstract int getNumScreens();

    protected abstract GraphicsDevice makeScreenDevice(int var1);

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[0];
    }

    public Graphics2D createGraphics(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new NullPointerException("BufferedImage cannot be null");
        }
        SurfaceData surfaceData = BufImgSurfaceData.createData(bufferedImage);
        if (defaultFont == null) {
            defaultFont = new Font("Dialog", 0, 12);
        }
        return new SunGraphics2D(surfaceData, Color.white, Color.black, defaultFont);
    }

    public Font[] getAllFonts() {
        if (this.allFonts != null) {
            return this.allFonts;
        }
        this.loadFonts();
        Font[] fontArray = null;
        String[] stringArray = null;
        int n = NativeFontWrapper.getNumFonts();
        if (n > 0) {
            TreeMap treeMap = new TreeMap();
            for (int i = 0; i < n; ++i) {
                String string = NativeFontWrapper.getFullNameByIndex(i);
                if (string.startsWith(PLSF_PREFIX)) continue;
                treeMap.put(string, null);
            }
            if (treeMap.size() > 0) {
                stringArray = new String[treeMap.size()];
                Object[] objectArray = treeMap.keySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = (String)objectArray[i];
                }
            }
        }
        if (stringArray != null) {
            fontArray = new Font[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fontArray[i] = new Font(stringArray[i], 0, 1);
            }
        }
        this.allFonts = fontArray;
        return this.allFonts;
    }

    public String[] getAvailableFontFamilyNames(Locale locale) {
        if (locale == null) {
            return this.getAvailableFontFamilyNames();
        }
        this.loadFonts();
        String[] stringArray = null;
        int n = NativeFontWrapper.getNumFonts();
        short s = NativeFontWrapper.getLCIDFromLocale(locale);
        if (n > 0) {
            Object[] objectArray;
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            for (int i = 0; i < n; ++i) {
                objectArray = NativeFontWrapper.getFamilyNameByIndex(i, s);
                String string = objectArray.toLowerCase();
                if (string.endsWith(".bold") || string.endsWith(".bolditalic") || string.endsWith(".italic") || string.startsWith(PLSF_PREFIX)) continue;
                treeMap.put(string, objectArray);
            }
            treeMap.putAll(predefinedNames);
            treeMap.put("default", "Default");
            if (treeMap.size() > 0) {
                stringArray = new String[treeMap.size()];
                objectArray = treeMap.keySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = (String)treeMap.get(objectArray[i]);
                }
            }
        }
        return stringArray;
    }

    public String[] getAvailableFontFamilyNames() {
        return this.getAvailableFontFamilyNames(Locale.getDefault());
    }

    public String mapFontName(String string, int n) {
        String string2;
        String string3 = (String)mapFontCache.get(string + "." + SunGraphicsEnvironment.styleStr(n));
        if (string3 != null) {
            if (this.fprops.supportPLSF() || fallbackFont != null) {
                return this.getInternalFontName(string3);
            }
            return string3;
        }
        String string4 = string.toLowerCase(Locale.ENGLISH);
        if (string4.equals("sanserif") || string4.equals("san serif") || string4.equals("sans serif") || string4.equals("ms sans serif")) {
            string4 = "sansserif";
        } else if (string4.equals("ms serif")) {
            string4 = "serif";
        }
        if (string3 == null && (string2 = this.fprops.getAliasedFamilyName(string4)) != null) {
            string3 = this.getLogicalFontFaceName(string2, n);
        }
        if (string3 == null && FontProperties.isLogicalFontFamilyName(string4)) {
            string3 = this.getLogicalFontFaceName(string4, n);
        }
        if (string3 == null) {
            if (this.fprops.getFallbackFamilyName(string4, null) != null) {
                if (this.loadedAllFonts) {
                    if (NativeFontWrapper.isFontRegistered(string, n)) {
                        string3 = string;
                    }
                } else if (NativeFontWrapper.isFontRegistered(string, n)) {
                    string3 = string;
                } else {
                    if (debugMapping) {
                        System.out.println("calling loadFonts to find font " + string);
                    }
                    this.loadFonts();
                    if (NativeFontWrapper.isFontRegistered(string, n)) {
                        string3 = string;
                    }
                }
                if (string3 == null) {
                    string2 = this.fprops.getFallbackFamilyName(string4, "dialog");
                    string3 = this.getLogicalFontFaceName(string2, n);
                }
            } else {
                if (!(this.terminalNames.containsKey(string4) || physicalNames != null && physicalNames.contains(string4))) {
                    if (debugMapping) {
                        System.out.println("calling loadFonts to find font " + string);
                    }
                    this.loadFonts();
                }
                string3 = string;
            }
        }
        if (!$assertionsDisabled && string3 == null) {
            throw new AssertionError();
        }
        if (debugMapping) {
            System.out.println("mapped font " + string + " (" + SunGraphicsEnvironment.styleStr(n) + ") " + " to " + string3);
        }
        mapFontCache.put(string + "." + SunGraphicsEnvironment.styleStr(n), string3);
        if (this.fprops.supportPLSF() || fallbackFont != null) {
            if (debugMapping) {
                string2 = this.getInternalFontName(string3);
                System.out.println("==============================================================");
                System.out.println("originalName  =" + string3 + ", localeName=" + string2);
                System.out.println("currentThread=" + Thread.currentThread());
                return string2;
            }
            return this.getInternalFontName(string3);
        }
        return string3;
    }

    private String getLogicalFontFaceName(String string, int n) {
        String string2 = string.toLowerCase(Locale.ENGLISH) + "." + SunGraphicsEnvironment.styleStr(n);
        if (this.terminalNames.containsKey(string2)) {
            return string2;
        }
        return string;
    }

    protected String parseFamilyNameProperty(String string) {
        int n = string.indexOf(",");
        if (n == -1) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    protected String getFontPropertyFD(String string) {
        return this.parseFamilyNameProperty(string);
    }

    protected String getFileNameFromPlatformName(String string) {
        if (this.fprops == null) {
            return null;
        }
        string = string.replace(' ', '_');
        return this.fprops.getProperty("filename." + string);
    }

    public PrinterJob getPrinterJob() {
        new Exception().printStackTrace();
        return null;
    }

    protected void registerFontsWithPlatform(String string) {
    }

    protected void registerFontPaths(String string) {
    }

    private boolean registerFonts(String string, boolean bl) {
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                bl2 |= this.addPathFonts(string2, new TTFilter(), 0, bl);
                bl2 |= this.addPathFonts(string2, new T1Filter(), 1, bl);
                bl2 |= this.addPathFonts(string2, new T2KFilter(), 2, bl);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
        return bl2;
    }

    protected void registerFontFile(String string, Vector vector) {
        int n;
        if (this.registeredFonts.containsKey(string)) {
            return;
        }
        if (new TTFilter().accept(null, string)) {
            n = 0;
        } else if (new T1Filter().accept(null, string)) {
            n = 1;
        } else if (new T2KFilter().accept(null, string)) {
            n = 2;
        } else {
            this.registerNative(string);
            return;
        }
        StringTokenizer stringTokenizer = string.length() > 1 && (string.charAt(0) == '/' || string.charAt(0) == '\\' || string.charAt(1) == ':') ? new StringTokenizer(">", ";") : new StringTokenizer(this.fontPath, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3;
                File file;
                String string4 = stringTokenizer.nextToken();
                if (">".equals(string4)) {
                    string4 = null;
                }
                if (!(file = new File(string4, string)).canRead() && string.endsWith(".ttc") && (file = new File(string4, string3 = string.substring(0, string.length() - 1) + "f")).canRead()) {
                    string = string3;
                }
                string3 = null;
                try {
                    string3 = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string3 = file.getAbsolutePath();
                }
                if (!file.canRead()) continue;
                Vector<String> vector2 = new Vector<String>(1, 1);
                Vector<Vector> vector3 = new Vector<Vector>(1, 1);
                vector3.addElement(vector);
                vector2.addElement(string3);
                this.registeredFonts.put(string, string3);
                NativeFontWrapper.registerFonts(vector2, vector2.size(), vector3, n, false);
                if (physicalNames == null) {
                    physicalNames = new HashSet();
                }
                if ((string2 = NativeFontWrapper.getFullNameByFileName(string3)) != null) {
                    string2 = string2.toLowerCase();
                }
                if (!physicalNames.contains(string2)) {
                    physicalNames.add(string2);
                }
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
    }

    protected void registerFontPath(String string) {
    }

    protected void registerNative(String string) {
    }

    protected Vector getNativeNames(String string) {
        Vector vector = new Vector();
        return vector;
    }

    protected boolean registerNativeFonts() {
        return false;
    }

    private boolean addPathFonts(String string, FilenameFilter filenameFilter, int n, boolean bl) {
        boolean bl2 = false;
        Vector<String> vector = new Vector<String>(20, 10);
        Vector<Vector> vector2 = new Vector<Vector>(20, 10);
        File file = new File(string);
        String[] stringArray = file.list(filenameFilter);
        if (stringArray == null) {
            return bl2;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            String string2 = null;
            try {
                string2 = file2.getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = file2.getAbsolutePath();
            }
            if (this.registeredFonts.containsKey(string2)) continue;
            if (this.badFonts != null && this.badFonts.contains(string2)) {
                if (!debugMapping) continue;
                System.out.println("skip bad font " + string2);
                continue;
            }
            this.registeredFonts.put(string2, string2);
            if (debugMapping) {
                System.out.println("Registering font " + string2);
                Vector vector3 = this.getNativeNames(string2);
                if (vector3.size() == 0) {
                    System.out.println("No native name");
                } else {
                    for (int j = 0; j < vector3.size(); ++j) {
                        System.out.println("native name : " + (String)vector3.elementAt(j));
                    }
                }
            }
            vector.addElement(string2);
            vector2.addElement(this.getNativeNames(string2));
            bl2 = true;
        }
        NativeFontWrapper.registerFonts(vector, vector.size(), vector2, n, bl);
        return bl2;
    }

    public static Font getBestFontFor(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        char c = attributedCharacterIterator.setIndex(n);
        Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
        Font font = Font.getFont(map);
        while (!font.canDisplay(c) && attributedCharacterIterator.getRunLimit() < n2) {
            attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
            font = Font.getFont(attributedCharacterIterator.getAttributes());
        }
        if (!font.canDisplay(c)) {
            attributedCharacterIterator.setIndex(n);
            String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            for (int i = 0; i < stringArray.length; ++i) {
                Hashtable<AttributedCharacterIterator.Attribute, Object> hashtable = new Hashtable<AttributedCharacterIterator.Attribute, Object>();
                hashtable.putAll(map);
                hashtable.put(TextAttribute.FAMILY, stringArray[i]);
                font = Font.getFont(hashtable);
                if (font.canDisplay(c)) break;
            }
            if (!font.canDisplay(c)) {
                font = Font.getFont(map);
            }
        }
        return font;
    }

    protected boolean platformReady() {
        return true;
    }

    protected abstract FontProperties createFontProperties();

    private void initCompositeFonts(FontProperties fontProperties) {
        String string;
        if (!this.platformReady()) {
            return;
        }
        this.initTerminalNames(fontProperties);
        Object[] objectArray = this.terminalNames.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            Object object;
            String string2 = (String)objectArray[i];
            Integer n2 = (Integer)this.terminalNames.get(objectArray[i]);
            int n3 = n2;
            boolean bl = false;
            for (int j = 0; j < n3; ++j) {
                object = this.parseFamilyNameProperty(fontProperties.getProperty(string2 + "." + j));
                if (((String)object).compareToIgnoreCase("Lucida Sans Regular") != 0) continue;
                bl = true;
                break;
            }
            if (!bl) {
                ++n3;
            }
            if (fallbackFont != null && this.terminalNames.containsKey(fallbackFont.toLowerCase(Locale.ENGLISH))) {
                ++n3;
            }
            String[] stringArray = new String[n3];
            object = new int[n3];
            int[] nArray = new int[]{};
            int n4 = n3;
            if (!bl) {
                stringArray[n3 - 1] = "Lucida Sans Regular";
                --n4;
            }
            if (fallbackFont != null && this.terminalNames.containsKey(fallbackFont.toLowerCase(Locale.ENGLISH))) {
                if (!bl) {
                    stringArray[n3 - 2] = "Lucida Sans Regular";
                }
                stringArray[n3 - 1] = fallbackFont;
                --n4;
            }
            for (n = 0; n < n4; ++n) {
                stringArray[n] = this.parseFamilyNameProperty(fontProperties.getProperty(string2 + "." + n));
                if (debugMapping) {
                    System.out.println("The composite name = " + stringArray[n]);
                }
                nArray = this.appendExclusions(fontProperties, string2, n, nArray);
                object[n] = nArray.length;
            }
            if (debugMapping) {
                System.out.println("initCompositeFonts compositeFontName=" + string2);
            }
            if (this.initPLSFFallback) {
                string2 = this.prefixPLSF + string2;
            }
            if (debugMapping) {
                System.out.println("registerCompositeFont:" + string2);
                for (n = 0; n < n3; ++n) {
                    System.out.println("    slot=" + stringArray[n]);
                }
            }
            NativeFontWrapper.registerCompositeFont(string2, stringArray, nArray, (int[])object);
        }
        this.terminalNames.put("default", new Integer(0));
        if (!this.initPLSFFallback) {
            this.terminalNames = this.terminalNames;
        }
        if ((string = fontProperties.getProperty("ibm.java2d.useawtfonts", "?")).equals("0") || string.equals("1")) {
            NativeFontWrapper.setUsePlatformFont(string.equals("1"));
        }
    }

    private int[] appendExclusions(FontProperties fontProperties, String string, int n, int[] nArray) {
        int n2;
        String string2;
        String string3;
        int n3 = string.indexOf(46);
        if (n3 > 0) {
            string3 = string.substring(0, n3);
            string2 = string.substring(n3 + 1);
        } else {
            string3 = string;
            string2 = "plain";
        }
        String string4 = fontProperties.getProperty("exclusion." + string3 + "." + string2 + "." + n);
        if (string4 == null) {
            string4 = fontProperties.getProperty("exclusion." + string3 + "." + n);
        }
        if (string4 != null && (n2 = (string4.length() + 1) / 10) > 0) {
            Object object;
            int n4;
            int[] nArray2 = new int[n2 * 2];
            for (n4 = 0; n4 < n2; ++n4) {
                object = string4.substring(n4 * 10, n4 * 10 + 4);
                String string5 = string4.substring(n4 * 10 + 5, n4 * 10 + 9);
                nArray2[n4 * 2] = Integer.parseInt((String)object, 16);
                nArray2[n4 * 2 + 1] = Integer.parseInt(string5, 16);
            }
            n4 = nArray.length + nArray2.length;
            object = new int[n4];
            System.arraycopy(nArray, 0, object, 0, nArray.length);
            System.arraycopy(nArray2, 0, object, nArray.length, nArray2.length);
            nArray = object;
        }
        return nArray;
    }

    private void initTerminalNames(FontProperties fontProperties) {
        TreeMap treeMap = new TreeMap();
        this.addPlatformCompatibilityFileNames(treeMap);
        this.terminalNames = new TreeMap();
        String string = "Serif";
        predefinedNames.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "SansSerif";
        predefinedNames.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "Monospaced";
        predefinedNames.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "Dialog";
        predefinedNames.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "DialogInput";
        predefinedNames.put(string.toLowerCase(Locale.ENGLISH), string);
        if (fontProperties == null) {
            throw new Error("no font properties file found.");
        }
        int n = 0;
        while (fontProperties.containsKey("definedfont." + n)) {
            string = fontProperties.getProperty("definedfont." + n);
            predefinedNames.put(string.toLowerCase(Locale.ENGLISH), string);
        }
        Object[] objectArray = fontProperties.keySet().toArray();
        for (n = 0; n < objectArray.length; ++n) {
            String string2;
            String string3;
            String string4 = (String)objectArray[n];
            int n2 = string4.indexOf(".");
            if (n2 == -1) {
                n2 = string4.length();
            }
            if (!predefinedNames.containsKey(string3 = string4.substring(0, n2)) && !string3.equals("register") || (n2 = string4.lastIndexOf(".")) == -1 || this.terminalNames.containsKey(string2 = string4.substring(0, n2)) || !fontProperties.containsKey(string2 + ".0")) continue;
            int n3 = 0;
            while (fontProperties.containsKey(string2 + "." + n3)) {
                ++n3;
            }
            if (n3 == 0) continue;
            if (!string3.equals("register")) {
                this.terminalNames.put(string2, new Integer(n3));
            }
            if (debugMapping) {
                System.out.println("FamilyStyle: " + string2);
                System.out.println("NumSlots: " + n3);
                System.out.println("Key: " + (String)objectArray[n]);
            }
            for (int i = 0; i < n3; ++i) {
                String string5 = this.getFontPropertyFD(fontProperties.getProperty(string2 + "." + i));
                if (!this.initPLSFFallback) {
                    this.addPlatformNameForFontProperties(string5);
                }
                String string6 = this.getFileNameFromPlatformName(string5);
                if (debugMapping) {
                    System.out.println("FS: [" + string2 + "." + i + "] PN: [" + string5 + "] FN: [" + string6 + "]");
                }
                if (string6 == null) {
                    if (debugMapping) {
                        System.err.println("Font specified in font.properties not found [" + string5 + "]");
                    }
                    this.loadFonts();
                    continue;
                }
                HashSet<String> hashSet = (HashSet<String>)treeMap.get(string6);
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                    hashSet.add(string5);
                    treeMap.put(string6, hashSet);
                    continue;
                }
                if (hashSet.contains(string5)) continue;
                hashSet.add(string5);
            }
        }
        if (!this.initPLSFFallback) {
            this.registerFontPropertiesFonts(treeMap);
        }
    }

    protected void addPlatformCompatibilityFileNames(Map map) {
    }

    protected void addPlatformNameForFontProperties(String string) {
    }

    protected void registerFontPropertiesFonts(TreeMap treeMap) {
        Object[] objectArray = treeMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            HashSet hashSet = (HashSet)treeMap.get(string);
            String[] stringArray = hashSet.toArray(new String[0]);
            Vector vector = this.getNativeNames(string);
            for (int j = 0; j < stringArray.length; ++j) {
                if (vector.contains(stringArray[j])) continue;
                vector.add(stringArray[j]);
            }
            this.registerFontFile(string, vector);
        }
    }

    protected boolean isLocalHead() {
        return true;
    }

    public static String styleStr(int n) {
        switch (n) {
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    public static boolean isLogicalFont(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        return predefinedNames.containsKey(string);
    }

    public static boolean isLogicalFont(Font font) {
        String string = font.getFamily().toLowerCase(Locale.ENGLISH);
        return predefinedNames.containsKey(string);
    }

    public static String createFont(File file) {
        String string = null;
        string = NativeFontWrapper.createFont(file.getAbsolutePath(), 0);
        if (physicalNames == null) {
            physicalNames = new HashSet();
        }
        if (string != null && !physicalNames.contains(string = string.toLowerCase())) {
            physicalNames.add(string);
        }
        return string;
    }

    private void setSubstitutes() {
        int n = 0;
        while (this.fprops.containsKey("substitute." + n)) {
            ++n;
        }
        if (n > 0) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.fprops.getProperty("substitute." + i);
                if (!debugMapping) continue;
                System.out.println("Substitute " + i + " [" + stringArray[i] + "]");
            }
            NativeFontWrapper.setSubstitutes(stringArray);
            NativeFontWrapper.setSubstitutes2(stringArray);
        }
    }

    public FontProperties getFontProperties() {
        if (!FPAName.equals(AppContext.getAppContext().get(FPAKey)) || this.fpropsPLSF == null) {
            return this.fprops;
        }
        return this.fpropsPLSF;
    }

    public static Rectangle getUsableBounds(GraphicsDevice graphicsDevice) {
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        Rectangle rectangle = graphicsConfiguration.getBounds();
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    public static boolean fontSupportsDefaultEncoding(Font font) {
        String string = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        if (string == null || font == null) {
            return false;
        }
        string = string.toLowerCase(Locale.ENGLISH);
        return NativeFontWrapper.fontSupportsEncoding(font, string);
    }

    public static void preferLocaleSpecificFonts() {
        hasPLSF = true;
        AppContext.getAppContext().put(FPAKey, FPAName);
    }

    public static void setFallbackFont(String string) {
        fallbackFont = string;
        AppContext.getAppContext().put(FPAKey, FPAName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInternalFontName(String string) {
        if (!hasPLSF && fallbackFont == null) {
            return string;
        }
        Object object = AppContext.getAppContext().get(FPAKey);
        if (object == null || !object.equals(FPAName)) {
            return string;
        }
        String string2 = string.toLowerCase();
        boolean bl = false;
        for (int i = 0; i < logicalFontNames.length; ++i) {
            if (!string2.startsWith(logicalFontNames[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return string;
        }
        if (this.prefixPLSF != null) {
            return this.prefixPLSF + string;
        }
        SunGraphicsEnvironment sunGraphicsEnvironment = this;
        synchronized (sunGraphicsEnvironment) {
            if (this.prefixPLSF != null) {
                return this.prefixPLSF + string;
            }
            this.fpropsPLSF = hasPLSF ? this.fprops.applyPreferLocaleSpecificFonts(this.fprops) : this.fprops;
            this.initPLSFFallback = true;
            this.prefixPLSF = PLSF_PREFIX;
            this.initCompositeFonts(this.fpropsPLSF);
            return this.prefixPLSF + string;
        }
    }

    static {
        $assertionsDisabled = !SunGraphicsEnvironment.class.desiredAssertionStatus();
        debugMapping = false;
        logicalFontNames = new String[]{"default", "serif", "sansserif", "monospaced", "dialog", "dialoginput"};
        predefinedNames = new TreeMap();
        mapFontCache = new Hashtable(5, 0.9f);
        hasPLSF = false;
        fallbackFont = null;
    }

    public class T1Filter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.endsWith(".ps") || string.endsWith(".PS") || string.endsWith(".pfb") || string.endsWith(".PFB") || string.endsWith(".pfa") || string.endsWith(".PFA");
        }
    }

    public class T2KFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.endsWith(".t2k") || string.endsWith(".T2K");
        }
    }

    public class TTFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.endsWith(".ttf") || string.endsWith(".TTF") || string.endsWith(".tte") || string.endsWith(".TTE") || string.endsWith(".otf") || string.endsWith(".OTF") || string.endsWith(".ttc") || string.endsWith(".TTC");
        }
    }
}

