/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.j;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signer;
import java.util.Enumeration;
import java.util.Hashtable;

public class IdentityDatabase
extends IdentityScope
implements Serializable {
    private static final long serialVersionUID = 4923799573357658384L;
    private static final boolean debug = false;
    private static final boolean error = true;
    File sourceFile;
    Hashtable identities = new Hashtable();

    IdentityDatabase() throws InvalidParameterException {
        this(IdentityDatabase.d(",|\u001e\u0016*,p\u0003\u0005kp7"));
    }

    public IdentityDatabase(File file) throws InvalidParameterException {
        this(file.getName());
        this.sourceFile = file;
    }

    public IdentityDatabase(String string) throws InvalidParameterException {
        super(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IdentityDatabase fromStream(InputStream inputStream) throws IOException {
        IdentityDatabase identityDatabase = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            if (object instanceof IdentityDatabase) {
                identityDatabase = (IdentityDatabase)object;
            } else {
                Enumeration enumeration = ((sun.security.provider.IdentityDatabase)object).identities();
                identityDatabase = new IdentityDatabase();
                while (enumeration.hasMoreElements()) {
                    try {
                        identityDatabase.addIdentity((Identity)enumeration.nextElement());
                    }
                    catch (KeyManagementException keyManagementException) {
                        throw new IOException(keyManagementException.getMessage());
                    }
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            IdentityDatabase.a(IdentityDatabase.d("\nq\u0004\u0011e-q\u0002\u0017):9\u0003\r1~{\bB-?i\u001d\u0007+7w\nL"), classNotFoundException);
            IdentityDatabase.b(IdentityDatabase.d("\nq\bB3;k\u001e\u000b*09\u0002\u0004e*q\bB!?m\f\u0000$-|M\u000b6~v\u000f\u0011*2|\u0019\u0007k~Z\f\f+1mM\u000b+7m\u0004\u0003)7c\bL"));
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.a(IdentityDatabase.d("\nq\u0004\u0011e-q\u0002\u0017):9\u0003\r1~{\bB-?i\u001d\u0007+7w\nL"), invalidClassException);
            IdentityDatabase.b(IdentityDatabase.d("\u000bw\f\u0000);9\u0019\re7w\u0004\u0016,?u\u0004\u0018 ~j\u0014\u00111;tM\u000b!;w\u0019\u000b1'9\u001e\u0001*.|WBe\u0017w\u001b\u0003)7}.\u000e$-j(\u001a&;i\u0019\u000b*07Mh\u00116p\u001eB,-9\u0000\r6*9\u0001\u000b.;u\u0014B!+|M\u0016*~xM\u0011 ,p\f\u000e,$x\u0019\u000b*09\u001b\u00077-p\u0002\f,0~M\u001271{\u0001\u0007(d9\fB&2x\u001e\u0011e+j\b\u0006e7wM\t '9\u0000\u0003+?~\b\u000f 0mM\u0015$-9\u0002\u000061u\b\u0016 :"));
        }
        catch (StreamCorruptedException streamCorruptedException) {
            IdentityDatabase.a(IdentityDatabase.d("\nq\bB6;k\u0004\u0003)7c\f\u0016,1wM\u00111,|\f\u000fe7jM\u0001*,k\u0018\u00121;}CB\u00100x\u000f\u000e ~m\u0002B)1x\tL"), streamCorruptedException);
            IdentityDatabase.b(IdentityDatabase.d("\u000bw\f\u0000);9\u0019\re7w\u0004\u0016,?u\u0004\u0018 ~j\u0014\u00111;tM\u000b!;w\u0019\u000b1'9\u001e\u0001*.|CB\u0016*k\b\u0003(\u001dv\u001f\u00105+m\b\u0006\u0000&z\b\u001217v\u0003L"));
        }
        if (identityDatabase != null) return identityDatabase;
        return new IdentityDatabase(IdentityDatabase.d("+w\u0004\f,*p\f\u000e,$|\t"));
    }

    public static IdentityDatabase fromFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        IdentityDatabase identityDatabase = IdentityDatabase.fromStream(fileInputStream);
        identityDatabase.sourceFile = file;
        return identityDatabase;
    }

    public int size() {
        return this.identities.size();
    }

    public Identity getIdentity(String string) {
        Identity identity = (Identity)this.identities.get(string);
        if (identity instanceof Signer) {
            this.c(IdentityDatabase.d("9|\u0019L67~\u0003\u00077"));
        }
        return identity;
    }

    public Identity getIdentity(PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        Enumeration enumeration = this.identities();
        while (enumeration.hasMoreElements()) {
            Identity identity = (Identity)enumeration.nextElement();
            PublicKey publicKey2 = identity.getPublicKey();
            if (publicKey2 == null || !this.a(publicKey2, publicKey)) continue;
            if (identity instanceof Signer) {
                this.c(IdentityDatabase.d("9|\u0019L67~\u0003\u00077"));
            }
            return identity;
        }
        return null;
    }

    private boolean a(Key key, Key key2) {
        if (key == key2) {
            return true;
        }
        return MessageDigest.isEqual(key.getEncoded(), key2.getEncoded());
    }

    public void addIdentity(Identity identity) throws KeyManagementException {
        this.c(IdentityDatabase.d("?}\tL,:|\u0003\u0016,*`"));
        Identity identity2 = this.getIdentity(identity.getName());
        Identity identity3 = this.getIdentity(identity.getPublicKey());
        String string = null;
        if (identity2 != null) {
            string = IdentityDatabase.d("0x\u0000\u0007e=v\u0003\u0004)7z\u0019");
        }
        if (identity3 != null) {
            string = IdentityDatabase.d("5|\u0014B&1w\u000b\u000e,=m");
        }
        if (string != null) {
            throw new KeyManagementException(string);
        }
        this.identities.put(identity.getName(), identity);
    }

    public void removeIdentity(Identity identity) throws KeyManagementException {
        this.c(IdentityDatabase.d(",|\u0000\r3;7\u0004\u0006 0m\u0004\u0016<"));
        String string = identity.getName();
        if (this.identities.get(string) == null) {
            throw new KeyManagementException(IdentityDatabase.d("*q\b\u0010 ~p\u001eB+19\u0004\u0006 0m\u0004\u0016<~w\f\u000f :9") + string + IdentityDatabase.d("~p\u0003B") + this);
        }
        this.identities.remove(string);
    }

    public Enumeration identities() {
        return this.identities.elements();
    }

    void a(File file) {
        this.sourceFile = file;
    }

    File a() {
        return this.sourceFile;
    }

    public void save(OutputStream outputStream) throws IOException {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.a(IdentityDatabase.d("\nq\u0004\u0011e-q\u0002\u0017):9\u0003\r1~{\bB-?i\u001d\u0007+7w\nL"), invalidClassException);
            return;
        }
    }

    void b(File file) throws IOException {
        this.a(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.save(fileOutputStream);
    }

    public void save() throws IOException {
        if (this.sourceFile == null) {
            throw new IOException(IdentityDatabase.d("*q\u0004\u0011e:x\u0019\u0003'?j\bB-?jM\f*~j\u0002\u00177=|M\u0004,2|"));
        }
        this.b(this.sourceFile);
    }

    private static File b() {
        String string = Security.getProperty(IdentityDatabase.d("7}\b\f17m\u0014L!?m\f\u0000$-|"));
        if (string == null) {
            string = System.getProperty(IdentityDatabase.d("+j\b\u0010k6v\u0000\u0007")) + File.separatorChar + IdentityDatabase.d("7}\b\f17m\u0014\u0006'pv\u000f\b");
        }
        return new File(string);
    }

    private static void c() {
        File file = IdentityDatabase.b();
        try {
            IdentityDatabase identityDatabase;
            if (file.exists()) {
                IdentityDatabase.a(IdentityDatabase.d("2v\f\u0006,0~M\u0011<-m\b\u000fe:x\u0019\u0003'?j\bB#,v\u0000B#7u\bXe") + file);
                identityDatabase = IdentityDatabase.fromFile(file);
            } else {
                identityDatabase = new IdentityDatabase(file);
            }
            IdentityScope.setSystemScope(identityDatabase);
            IdentityDatabase.a(IdentityDatabase.d("\r`\u001e\u0016 39\t\u00031?{\f\u0011 ~p\u0003\u000b17x\u0001\u000b?;}WB") + identityDatabase);
        }
        catch (IOException iOException) {
            IdentityDatabase.a(IdentityDatabase.d("\u001bk\u001f\r7~p\u0003\u000b17x\u0001\u000b?7w\nB,:|\u0003\u0016,*`M\u0006$*x\u000f\u00036;#M") + file, iOException);
            return;
        }
        catch (InvalidParameterException invalidParameterException) {
            IdentityDatabase.a(IdentityDatabase.d("\u001bk\u001f\r7~m\u001f\u001b,0~M\u0016*~p\u0003\u00111?w\u0019\u000b$*|M\u0003e-`\u001e\u0016 39\u0004\u0006 0m\u0004\u0016,;jM\u0006'~p\u0003B") + file, invalidParameterException);
            return;
        }
    }

    public String toString() {
        return IdentityDatabase.d("=v\u0000L,<tC\u00017'i\u0019\rk.k\u0002\u0014,:|\u001fL\f:|\u0003\u0016,*`)\u00031?{\f\u0011 r9\u001e\r0,z\bB#7u\bXe") + this.sourceFile;
    }

    private static void a(String string) {
    }

    private static void a(String string, Throwable throwable) {
    }

    private static void b(String string) {
        System.err.println(string);
    }

    void c(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            string = this.getClass().getName() + "." + string + "." + this.d();
            securityManager.checkSecurityAccess(string);
        }
    }

    String d() {
        String string = this.getName();
        if (this.getScope() != null) {
            string = string + "." + this.getScope().getName();
        }
        return string;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.c(IdentityDatabase.d("-|\u001f\u000b$2p\u0017\u0007k7}\b\f17m\u0014L!?m\f\u0000$-|"));
        objectOutputStream.writeObject(this.identities);
        objectOutputStream.writeObject(this.sourceFile);
    }

    static void e() {
        IdentityDatabase.c();
    }

    static {
        AccessController.doPrivileged(new j());
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String d(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 94;
                        break;
                    }
                    case 1: {
                        n5 = 25;
                        break;
                    }
                    case 2: {
                        n5 = 109;
                        break;
                    }
                    case 3: {
                        n5 = 98;
                        break;
                    }
                    default: {
                        n5 = 69;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

