/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.scan.latin;

import com.ibm.xml.b2b.scan.DTDParams;
import com.ibm.xml.b2b.scan.DocumentEntityState;
import com.ibm.xml.b2b.scan.ExternalSubsetHandler;
import com.ibm.xml.b2b.scan.latin.LatinWFCMarkupDeclScanner;
import com.ibm.xml.b2b.scan.latin.LatinWFCScannerSupport;
import com.ibm.xml.b2b.util.QName;
import com.ibm.xml.b2b.util.XMLName;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.entity.ParsedEntity;

public final class LatinWFCExternalSubsetScanner
extends LatinWFCMarkupDeclScanner {
    private static final int ENTITYSTATE_DTD_EXTERNAL_SUBSET = 0;
    private static final int ENTITYSTATE_PE_BETWEEN_MARKUP = 1;
    private static final int ENTITYSTATE_PE_WITHIN_MARKUP = 2;
    private ExternalSubsetHandler fHandler;
    private LatinWFCScannerSupport fHelper;
    private DTDParams fDTDParams;
    private ParsedEntity fEntityContent;
    private byte[] fData;
    private int fCurrentOffset;
    private int fEntityDepth;
    private DTDParams[] fDTDParamsStack;
    private ParsedEntity[] fEntityContentStack;
    private byte[][] fDataStack;
    private int[] fCurrentOffsetStack;
    private int fEntityState;
    private int fIncludeSectDepth;
    private int fMarkupDepth;
    private int[] fEntityStateStack;

    public LatinWFCExternalSubsetScanner(ExternalSubsetHandler externalSubsetHandler, LatinWFCScannerSupport latinWFCScannerSupport) {
        this.fHandler = externalSubsetHandler;
        this.fHelper = latinWFCScannerSupport;
        this.fCurrentOffset = -1;
        this.fEntityState = -1;
        this.fDTDParamsStack = new DTDParams[4];
        this.fEntityContentStack = new ParsedEntity[4];
        this.fDataStack = new byte[4][];
        this.fCurrentOffsetStack = new int[4];
        this.fEntityStateStack = new int[4];
    }

    public void reset(boolean bl) {
        this.fIncludeSectDepth = 0;
        this.fMarkupDepth = 0;
        this.fEntityDepth = 0;
    }

    public boolean scanExternalSubset(DTDParams dTDParams, ParsedEntity parsedEntity) {
        boolean bl = false;
        this.setupContext(dTDParams, parsedEntity, 0);
        bl = this.scanExtSubsetDecl();
        bl = this.endExternalSubset(bl);
        return bl;
    }

    public boolean scanExtSubsetDecl(DTDParams dTDParams, ParsedEntity parsedEntity) {
        boolean bl = false;
        this.setupContext(dTDParams, parsedEntity, 1);
        bl = this.scanExtSubsetDecl();
        this.endPEReferenceBetweenMarkup();
        return bl;
    }

    public boolean scanPEWithinMarkup(DTDParams dTDParams, ParsedEntity parsedEntity) {
        this.setupContext(dTDParams, parsedEntity, 2);
        return true;
    }

    private void setupContext(DTDParams dTDParams, ParsedEntity parsedEntity, int n) {
        if (this.fEntityDepth > 0) {
            int n2 = this.fEntityDepth - 1;
            if (n2 == this.fDTDParamsStack.length) {
                this.growContext();
            }
            this.fDTDParamsStack[n2] = this.fDTDParams;
            this.fEntityContentStack[n2] = this.fEntityContent;
            this.fDataStack[n2] = this.fData;
            this.fCurrentOffsetStack[n2] = this.fCurrentOffset;
            this.fEntityStateStack[n2] = this.fEntityState;
        }
        this.fDTDParams = dTDParams;
        this.fEntityContent = parsedEntity;
        this.fData = parsedEntity.bytes;
        this.fCurrentOffset = parsedEntity.offset;
        this.fEntityState = n;
        ++this.fEntityDepth;
    }

    private boolean scanExtSubsetDecl() {
        block11: {
            int n = this.fIncludeSectDepth;
            int n2 = this.fEntityDepth;
            while (true) {
                byte by = this.fData[this.fCurrentOffset];
                while (by == 32 || by == 10 || by == 9 || by == 13) {
                    by = this.fData[++this.fCurrentOffset];
                }
                if (by == 60) {
                    ++this.fCurrentOffset;
                    ++this.fMarkupDepth;
                    if (!this.scanMarkupDecl()) {
                        return false;
                    }
                    --this.fMarkupDepth;
                    continue;
                }
                if (by == 37) {
                    XMLName xMLName = this.fDTDParams.getPEName();
                    this.fEntityContent.offset = ++this.fCurrentOffset;
                    if (!this.fHelper.scanPEReference(this.fEntityContent, xMLName)) {
                        this.fDTDParams.resetPEName();
                        return false;
                    }
                    this.fHandler.externalSubsetPEReference(xMLName);
                    this.fDTDParams.resetPEName();
                    this.fCurrentOffset = this.fEntityContent.offset;
                    continue;
                }
                if (by == 93) {
                    if (this.fData[this.fCurrentOffset + 1] == 93 && this.fData[this.fCurrentOffset + 2] == 62) {
                        this.fCurrentOffset += 3;
                        if (this.fIncludeSectDepth > n) {
                            --this.fIncludeSectDepth;
                            continue;
                        }
                        this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 101);
                        return false;
                    }
                    this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 19);
                    return false;
                }
                this.fEntityContent.offset = this.fCurrentOffset;
                if (by != 0 || this.fCurrentOffset != this.fEntityContent.endOffset) break block11;
                if (this.fEntityDepth == n2) {
                    if (this.fIncludeSectDepth > n) {
                        this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 46);
                        return false;
                    }
                    return true;
                }
                if (this.fEntityState != 2) break;
                this.endOfContentWithinMarkup();
                this.fDTDParams.resetPEReferenceName();
            }
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 19);
            return false;
        }
        this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 19);
        return false;
    }

    private boolean scanMarkupDecl() {
        byte by = this.fData[this.fCurrentOffset];
        if (by == 33) {
            if ((by = this.fData[++this.fCurrentOffset]) == 69 && this.fData[this.fCurrentOffset + 1] == 76 && this.fData[this.fCurrentOffset + 2] == 69 && this.fData[this.fCurrentOffset + 3] == 77 && this.fData[this.fCurrentOffset + 4] == 69 && this.fData[this.fCurrentOffset + 5] == 78 && this.fData[this.fCurrentOffset + 6] == 84) {
                this.fCurrentOffset += 7;
                return this.scanElementDecl();
            }
            if (by == 65 && this.fData[this.fCurrentOffset + 1] == 84 && this.fData[this.fCurrentOffset + 2] == 84 && this.fData[this.fCurrentOffset + 3] == 76 && this.fData[this.fCurrentOffset + 4] == 73 && this.fData[this.fCurrentOffset + 5] == 83 && this.fData[this.fCurrentOffset + 6] == 84) {
                this.fCurrentOffset += 7;
                return this.scanAttlistDecl();
            }
            if (by == 69 && this.fData[this.fCurrentOffset + 1] == 78 && this.fData[this.fCurrentOffset + 2] == 84 && this.fData[this.fCurrentOffset + 3] == 73 && this.fData[this.fCurrentOffset + 4] == 84 && this.fData[this.fCurrentOffset + 5] == 89) {
                this.fCurrentOffset += 6;
                return this.scanEntityDecl();
            }
            if (by == 78 && this.fData[this.fCurrentOffset + 1] == 79 && this.fData[this.fCurrentOffset + 2] == 84 && this.fData[this.fCurrentOffset + 3] == 65 && this.fData[this.fCurrentOffset + 4] == 84 && this.fData[this.fCurrentOffset + 5] == 73 && this.fData[this.fCurrentOffset + 6] == 79 && this.fData[this.fCurrentOffset + 7] == 78) {
                this.fCurrentOffset += 8;
                return this.scanNotationDecl();
            }
            if (by == 45) {
                if (this.fData[++this.fCurrentOffset] != 45) {
                    this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 27);
                    return false;
                }
                this.fEntityContent.offset = ++this.fCurrentOffset;
                if (!LatinWFCMarkupDeclScanner.scanComment(this.fHandler, this.fHelper, this.fDTDParams, this.fEntityContent)) {
                    return false;
                }
                this.fCurrentOffset = this.fEntityContent.offset;
                return true;
            }
            if (by == 91) {
                ++this.fCurrentOffset;
                int n = this.fEntityDepth;
                if (!this.checkForPEReference()) {
                    return false;
                }
                by = this.fData[this.fCurrentOffset];
                if (by == 73 && this.fData[this.fCurrentOffset + 1] == 78 && this.fData[this.fCurrentOffset + 2] == 67 && this.fData[this.fCurrentOffset + 3] == 76 && this.fData[this.fCurrentOffset + 4] == 85 && this.fData[this.fCurrentOffset + 5] == 68 && this.fData[this.fCurrentOffset + 6] == 69) {
                    this.fCurrentOffset += 7;
                    if (!this.checkForPEReference()) {
                        return false;
                    }
                    if (this.fEntityDepth != n) {
                        // empty if block
                    }
                    if (this.fData[this.fCurrentOffset] == 91) {
                        ++this.fCurrentOffset;
                        ++this.fIncludeSectDepth;
                        return true;
                    }
                } else if (by == 73 && this.fData[this.fCurrentOffset + 1] == 71 && this.fData[this.fCurrentOffset + 2] == 78 && this.fData[this.fCurrentOffset + 3] == 79 && this.fData[this.fCurrentOffset + 4] == 82 && this.fData[this.fCurrentOffset + 5] == 69) {
                    this.fCurrentOffset += 6;
                    if (!this.checkForPEReference()) {
                        return false;
                    }
                    if (this.fData[this.fCurrentOffset] == 91) {
                        ++this.fCurrentOffset;
                        return this.scanIgnoreSectContents();
                    }
                }
            }
        } else if (by == 63) {
            this.fEntityContent.offset = ++this.fCurrentOffset;
            if (!LatinWFCMarkupDeclScanner.scanPI(this.fHandler, this.fHelper, this.fDTDParams, this.fEntityContent)) {
                return false;
            }
            this.fCurrentOffset = this.fEntityContent.offset;
            return true;
        }
        this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 19);
        return false;
    }

    private boolean scanIgnoreSectContents() {
        int n = 1;
        block6: while (true) {
            byte by;
            if ((by = this.fData[this.fCurrentOffset]) >= 0) {
                switch (DocumentEntityState.contentMap[by]) {
                    case 1: 
                    case 3: {
                        ++this.fCurrentOffset;
                        continue block6;
                    }
                    case 2: {
                        if (this.fData[this.fCurrentOffset + 1] == 33 && this.fData[this.fCurrentOffset + 2] == 91) {
                            this.fCurrentOffset += 3;
                            ++n;
                            continue block6;
                        }
                        ++this.fCurrentOffset;
                        continue block6;
                    }
                    case 4: {
                        if (this.fData[this.fCurrentOffset + 1] == 93 && this.fData[this.fCurrentOffset + 2] == 62) {
                            this.fCurrentOffset += 3;
                            if (--n != 0) continue block6;
                            return true;
                        }
                        ++this.fCurrentOffset;
                        continue block6;
                    }
                    case 5: {
                        if (this.fCurrentOffset != this.fEntityContent.endOffset) break;
                        this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 47);
                        return false;
                    }
                }
                this.fEntityContent.offset = this.fCurrentOffset;
                this.fHelper.setInvalidCharParameter(0, this.fEntityContent);
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 7);
                return false;
            }
            this.fEntityContent.offset = this.fCurrentOffset;
            if (!this.fEntityContent.skipValidCharacter()) break;
            this.fCurrentOffset = this.fEntityContent.offset;
        }
        this.fHelper.setInvalidCharParameter(0, this.fEntityContent);
        this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 7);
        return false;
    }

    private boolean scanElementDecl() {
        if (!this.scanRequiredWhitespace()) {
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 21);
            return false;
        }
        if (!this.checkForPEReference()) {
            return false;
        }
        this.fEntityContent.offset = this.fCurrentOffset;
        DTDParams dTDParams = this.fDTDParams;
        QName qName = dTDParams.getElementType();
        int n = this.fHelper.scanQName(this.fEntityContent, qName);
        if (n == 0) {
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 22);
            return false;
        }
        this.fHandler.startElementDecl(qName);
        this.fCurrentOffset = this.fEntityContent.offset;
        if (!this.scanRequiredWhitespace()) {
            this.fHelper.setParameter(0, qName);
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 23);
            return false;
        }
        if (!this.checkForPEReference()) {
            return false;
        }
        byte by = this.fData[this.fCurrentOffset];
        if (by == 65 && this.fData[this.fCurrentOffset + 1] == 78 && this.fData[this.fCurrentOffset + 2] == 89) {
            this.fCurrentOffset += 3;
            this.fHandler.contentModelANY();
        } else if (by == 69 && this.fData[this.fCurrentOffset + 1] == 77 && this.fData[this.fCurrentOffset + 2] == 80 && this.fData[this.fCurrentOffset + 3] == 84 && this.fData[this.fCurrentOffset + 4] == 89) {
            this.fCurrentOffset += 5;
            this.fHandler.contentModelEMPTY();
        } else {
            if (by != 40) {
                this.fHelper.setParameter(0, qName);
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 24);
                return false;
            }
            ++this.fCurrentOffset;
            ++this.fMarkupDepth;
            this.fHandler.contentModelStartGroup();
            if (!this.checkForPEReference()) {
                return false;
            }
            by = this.fData[this.fCurrentOffset];
            if (by == 35 && this.fData[this.fCurrentOffset + 1] == 80 && this.fData[this.fCurrentOffset + 2] == 67 && this.fData[this.fCurrentOffset + 3] == 68 && this.fData[this.fCurrentOffset + 4] == 65 && this.fData[this.fCurrentOffset + 5] == 84 && this.fData[this.fCurrentOffset + 6] == 65) {
                this.fCurrentOffset += 7;
                this.fHandler.contentModelPCDATA();
                if (!this.scanMixed(qName)) {
                    return false;
                }
            } else if (!this.scanChildren(qName, 1)) {
                return false;
            }
        }
        if (!this.checkForPEReference()) {
            return false;
        }
        if (this.fData[this.fCurrentOffset] != 62) {
            this.fHelper.setParameter(0, qName);
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 25);
            return false;
        }
        this.fHandler.endElementDecl();
        dTDParams.resetElementType();
        ++this.fCurrentOffset;
        return true;
    }

    private boolean scanMixed(XMLString xMLString) {
        boolean bl = false;
        while (this.checkForPEReference()) {
            byte by = this.fData[this.fCurrentOffset];
            if (by != 124) {
                if (by != 41) {
                    this.fHelper.setParameter(0, xMLString);
                    this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 29);
                    return false;
                }
                by = this.fData[++this.fCurrentOffset];
                this.fHandler.contentModelEndGroup();
                --this.fMarkupDepth;
                if (by == 42) {
                    ++this.fCurrentOffset;
                    this.fHandler.contentModelOccurrence(1);
                } else if (bl) {
                    this.fHelper.setParameter(0, xMLString);
                    this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 30);
                    return false;
                }
                return true;
            }
            ++this.fCurrentOffset;
            this.fHandler.contentModelSeparator(0);
            bl = true;
            if (!this.checkForPEReference()) {
                return false;
            }
            this.fEntityContent.offset = this.fCurrentOffset;
            QName qName = this.fDTDParams.getContentModelElement();
            int n = this.fHelper.scanQName(this.fEntityContent, qName);
            if (n == 0) {
                this.fHelper.setParameter(0, xMLString);
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 28);
                return false;
            }
            this.fHandler.contentModelElement(qName);
            this.fDTDParams.resetContentModelElement();
            this.fCurrentOffset = this.fEntityContent.offset;
        }
        return false;
    }

    private boolean scanChildren(XMLString xMLString, int n) {
        int n2 = -1;
        do {
            if (!this.scanCp(xMLString, n)) {
                return false;
            }
            if (!this.checkForPEReference()) {
                return false;
            }
            byte by = this.fData[this.fCurrentOffset];
            if (by == 41) {
                by = this.fData[++this.fCurrentOffset];
                this.fHandler.contentModelEndGroup();
                --this.fMarkupDepth;
                if (by == 63) {
                    ++this.fCurrentOffset;
                    this.fHandler.contentModelOccurrence(0);
                } else if (by == 42) {
                    ++this.fCurrentOffset;
                    this.fHandler.contentModelOccurrence(1);
                } else if (by == 43) {
                    ++this.fCurrentOffset;
                    this.fHandler.contentModelOccurrence(2);
                }
                return true;
            }
            if (by == 124) {
                if (n2 == 1) {
                    this.fHelper.setParameter(0, xMLString);
                    this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 27);
                    return false;
                }
                n2 = 0;
            } else if (by == 44) {
                if (n2 == 0) {
                    this.fHelper.setParameter(0, xMLString);
                    this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 27);
                    return false;
                }
                n2 = 1;
            } else {
                this.fHelper.setParameter(0, xMLString);
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 27);
                return false;
            }
            ++this.fCurrentOffset;
            this.fHandler.contentModelSeparator(n2);
        } while (this.checkForPEReference());
        return false;
    }

    private boolean scanCp(XMLString xMLString, int n) {
        if (this.fData[this.fCurrentOffset] == 40) {
            ++this.fCurrentOffset;
            ++this.fMarkupDepth;
            this.fHandler.contentModelStartGroup();
            if (!this.checkForPEReference()) {
                return false;
            }
            return this.scanChildren(xMLString, n + 1);
        }
        this.fEntityContent.offset = this.fCurrentOffset;
        QName qName = this.fDTDParams.getContentModelElement();
        int n2 = this.fHelper.scanQName(this.fEntityContent, qName);
        if (n2 == 0) {
            this.fHelper.setParameter(0, xMLString);
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 26);
            return false;
        }
        this.fHandler.contentModelElement(qName);
        this.fDTDParams.resetContentModelElement();
        this.fCurrentOffset = this.fEntityContent.offset;
        byte by = this.fData[this.fCurrentOffset];
        if (by == 63) {
            ++this.fCurrentOffset;
            this.fHandler.contentModelOccurrence(0);
        } else if (by == 42) {
            ++this.fCurrentOffset;
            this.fHandler.contentModelOccurrence(1);
        } else if (by == 43) {
            ++this.fCurrentOffset;
            this.fHandler.contentModelOccurrence(2);
        }
        return true;
    }

    private boolean scanAttlistDecl() {
        DTDParams dTDParams = null;
        DTDParams dTDParams2 = null;
        if (!this.scanRequiredWhitespace()) {
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 31);
            return false;
        }
        if (!this.checkForPEReference()) {
            return false;
        }
        this.fEntityContent.offset = this.fCurrentOffset;
        DTDParams dTDParams3 = this.fDTDParams;
        QName qName = dTDParams3.getElementType();
        int n = this.fHelper.scanQName(this.fEntityContent, qName);
        if (n == 0) {
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 32);
            return false;
        }
        this.fHandler.startAttlistDecl(qName);
        this.fCurrentOffset = this.fEntityContent.offset;
        while (true) {
            boolean bl;
            XMLString xMLString;
            byte by;
            XMLString xMLString2;
            boolean bl2;
            boolean bl3 = this.scanRequiredWhitespace();
            if (!this.checkForPEReference()) {
                return false;
            }
            if (this.fData[this.fCurrentOffset] == 62) break;
            if (!bl3) {
                this.fHelper.setParameter(0, qName);
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 33);
                return false;
            }
            this.fEntityContent.offset = this.fCurrentOffset;
            DTDParams dTDParams4 = this.fDTDParams;
            QName qName2 = dTDParams4.getAttributeName();
            n = this.fHelper.scanQName(this.fEntityContent, qName2);
            if (n == 0) {
                this.fHelper.setParameter(0, qName);
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 34);
                return false;
            }
            this.fCurrentOffset = this.fEntityContent.offset;
            if (!this.scanRequiredWhitespace()) {
                this.fHelper.setParameter(0, qName);
                this.fHelper.setParameter(1, qName2);
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 35);
                return false;
            }
            if (!this.checkForPEReference()) {
                return false;
            }
            boolean bl4 = bl2 = this.fData[this.fCurrentOffset] == 40;
            if (!bl2) {
                dTDParams = this.fDTDParams;
                xMLString2 = dTDParams.getAttributeType();
                if (!this.scanAttType(xMLString2)) {
                    this.fHelper.setParameter(0, qName);
                    this.fHelper.setParameter(1, qName2);
                    this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 36);
                    return false;
                }
                if (this.fHelper.isNotationType(xMLString2)) {
                    if (!this.scanRequiredWhitespace()) {
                        this.fHelper.setParameter(0, qName);
                        this.fHelper.setParameter(1, qName2);
                        this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 39);
                        return false;
                    }
                    if (!this.checkForPEReference()) {
                        return false;
                    }
                    if (this.fData[this.fCurrentOffset] != 40) {
                        this.fHelper.setParameter(0, qName);
                        this.fHelper.setParameter(1, qName2);
                        this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 40);
                        return false;
                    }
                    bl2 = true;
                }
            } else {
                xMLString2 = null;
            }
            this.fHandler.startAttDef(qName2, xMLString2);
            if (bl2) {
                this.fHandler.startEnumerationType();
                do {
                    XMLString xMLString3;
                    ++this.fCurrentOffset;
                    if (!this.checkForPEReference()) {
                        return false;
                    }
                    this.fEntityContent.offset = this.fCurrentOffset;
                    if (xMLString2 != null) {
                        xMLString3 = this.fDTDParams.getEnumerationTypeName();
                        n = this.fHelper.scanName(this.fEntityContent, (XMLName)xMLString3);
                        if (n == 0) {
                            this.fHelper.setParameter(0, qName);
                            this.fHelper.setParameter(1, qName2);
                            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 41);
                            return false;
                        }
                        this.fHandler.enumerationType(xMLString3);
                        this.fDTDParams.resetEnumerationTypeName();
                    } else {
                        xMLString3 = this.fDTDParams.getEnumerationTypeToken();
                        n = this.fHelper.scanNmtoken(this.fEntityContent, xMLString3);
                        if (n == 0) {
                            this.fHelper.setParameter(0, qName);
                            this.fHelper.setParameter(1, qName2);
                            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 43);
                            return false;
                        }
                        this.fHandler.enumerationType(xMLString3);
                        this.fDTDParams.resetEnumerationTypeToken();
                    }
                    this.fCurrentOffset = this.fEntityContent.offset;
                    if (this.checkForPEReference()) continue;
                    return false;
                } while ((by = this.fData[this.fCurrentOffset]) == 124);
                if (by != 41) {
                    this.fHelper.setParameter(0, qName);
                    this.fHelper.setParameter(1, qName2);
                    if (xMLString2 != null) {
                        this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 42);
                    } else {
                        this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 44);
                    }
                    return false;
                }
                ++this.fCurrentOffset;
                this.fHandler.endEnumerationType();
            }
            if (!this.scanRequiredWhitespace()) {
                this.fHelper.setParameter(0, qName);
                this.fHelper.setParameter(1, qName2);
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 37);
                return false;
            }
            if (!this.checkForPEReference()) {
                return false;
            }
            by = this.fData[this.fCurrentOffset];
            if (by == 35) {
                dTDParams2 = this.fDTDParams;
                xMLString = dTDParams2.getAttributeDefaultType();
                xMLString.offset = this.fCurrentOffset++;
                by = this.fData[this.fCurrentOffset];
                if (by == 70 && this.fData[this.fCurrentOffset + 1] == 73 && this.fData[this.fCurrentOffset + 2] == 88 && this.fData[this.fCurrentOffset + 3] == 69 && this.fData[this.fCurrentOffset + 4] == 68) {
                    this.fCurrentOffset += 5;
                    xMLString.endOffset = this.fCurrentOffset;
                    if (!this.scanRequiredWhitespace()) {
                        this.fHelper.setParameter(0, qName);
                        this.fHelper.setParameter(1, qName2);
                        this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 45);
                        return false;
                    }
                    if (!this.checkForPEReference()) {
                        return false;
                    }
                    bl = true;
                    by = this.fData[this.fCurrentOffset];
                } else {
                    if (by == 73 && this.fData[this.fCurrentOffset + 1] == 77 && this.fData[this.fCurrentOffset + 2] == 80 && this.fData[this.fCurrentOffset + 3] == 76 && this.fData[this.fCurrentOffset + 4] == 73 && this.fData[this.fCurrentOffset + 5] == 69 && this.fData[this.fCurrentOffset + 6] == 68) {
                        this.fCurrentOffset += 7;
                    } else if (by == 82 && this.fData[this.fCurrentOffset + 1] == 69 && this.fData[this.fCurrentOffset + 2] == 81 && this.fData[this.fCurrentOffset + 3] == 85 && this.fData[this.fCurrentOffset + 4] == 73 && this.fData[this.fCurrentOffset + 5] == 82 && this.fData[this.fCurrentOffset + 6] == 69 && this.fData[this.fCurrentOffset + 7] == 68) {
                        this.fCurrentOffset += 8;
                    } else {
                        this.fHelper.setParameter(0, qName);
                        this.fHelper.setParameter(1, qName2);
                        this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 38);
                        return false;
                    }
                    xMLString.endOffset = this.fCurrentOffset;
                    bl = false;
                    by = this.fData[this.fCurrentOffset];
                }
            } else {
                xMLString = null;
                bl = true;
            }
            if (bl) {
                byte by2 = by;
                if (by2 != 39 && by2 != 34) {
                    this.fHelper.setParameter(0, qName);
                    this.fHelper.setParameter(1, qName2);
                    this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 24);
                    return false;
                }
                this.fHandler.startDefaultAttValue();
                this.fHelper.startDefaultAttValue(qName, qName2);
                this.fEntityContent.offset = ++this.fCurrentOffset;
                if (!LatinWFCMarkupDeclScanner.scanDefaultAttValue(this.fHandler, this.fHelper, this.fDTDParams, this.fEntityContent, by2)) {
                    return false;
                }
                this.fCurrentOffset = this.fEntityContent.offset;
            }
            this.fHandler.endAttDef(xMLString);
            dTDParams4.resetAttributeName();
            if (xMLString2 != null) {
                dTDParams.resetAttributeType();
            }
            if (xMLString == null) continue;
            dTDParams2.resetAttributeDefaultType();
        }
        ++this.fCurrentOffset;
        this.fHandler.endAttlistDecl();
        dTDParams3.resetElementType();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scanAttType(XMLString xMLString) {
        xMLString.offset = this.fCurrentOffset;
        byte by = this.fData[this.fCurrentOffset];
        if (by == 67 && this.fData[this.fCurrentOffset + 1] == 68 && this.fData[this.fCurrentOffset + 2] == 65 && this.fData[this.fCurrentOffset + 3] == 84 && this.fData[this.fCurrentOffset + 4] == 65) {
            this.fCurrentOffset += 5;
        } else if (by == 73 && this.fData[this.fCurrentOffset + 1] == 68) {
            this.fCurrentOffset = this.fData[this.fCurrentOffset + 2] == 82 && this.fData[this.fCurrentOffset + 3] == 69 && this.fData[this.fCurrentOffset + 4] == 70 ? (this.fData[this.fCurrentOffset + 5] == 83 ? (this.fCurrentOffset += 6) : (this.fCurrentOffset += 5)) : (this.fCurrentOffset += 2);
        } else if (by == 69 && this.fData[this.fCurrentOffset + 1] == 78 && this.fData[this.fCurrentOffset + 2] == 84 && this.fData[this.fCurrentOffset + 3] == 73 && this.fData[this.fCurrentOffset + 4] == 84) {
            if (this.fData[this.fCurrentOffset + 5] == 89) {
                this.fCurrentOffset += 6;
            } else {
                if (this.fData[this.fCurrentOffset + 5] != 73 || this.fData[this.fCurrentOffset + 6] != 69 || this.fData[this.fCurrentOffset + 7] != 83) return false;
                this.fCurrentOffset += 8;
            }
        } else if (by == 78 && this.fData[this.fCurrentOffset + 1] == 77 && this.fData[this.fCurrentOffset + 2] == 84 && this.fData[this.fCurrentOffset + 3] == 79 && this.fData[this.fCurrentOffset + 4] == 75 && this.fData[this.fCurrentOffset + 5] == 69 && this.fData[this.fCurrentOffset + 6] == 78) {
            this.fCurrentOffset = this.fData[this.fCurrentOffset + 7] == 83 ? (this.fCurrentOffset += 8) : (this.fCurrentOffset += 7);
        } else {
            if (by != 78 || this.fData[this.fCurrentOffset + 1] != 79 || this.fData[this.fCurrentOffset + 2] != 84 || this.fData[this.fCurrentOffset + 3] != 65 || this.fData[this.fCurrentOffset + 4] != 84 || this.fData[this.fCurrentOffset + 5] != 73 || this.fData[this.fCurrentOffset + 6] != 79 || this.fData[this.fCurrentOffset + 7] != 78) return false;
            this.fCurrentOffset += 8;
        }
        xMLString.endOffset = this.fCurrentOffset;
        return true;
    }

    private boolean scanEntityDecl() {
        XMLString xMLString;
        byte by;
        boolean bl;
        DTDParams dTDParams = null;
        boolean bl2 = false;
        byte by2 = this.fData[this.fCurrentOffset];
        if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
            while ((by2 = this.fData[++this.fCurrentOffset]) == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
            }
            if (by2 != 37) {
                bl = false;
            } else if ((by2 = this.fData[++this.fCurrentOffset]) == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                by2 = this.fData[++this.fCurrentOffset];
                if (!this.checkForPEReference()) {
                    return false;
                }
                bl = true;
            } else if (by2 == 37) {
                if (!this.checkForPEReference()) {
                    return false;
                }
                bl = true;
            } else {
                bl2 = true;
                bl = false;
            }
        } else {
            if (by2 != 37) {
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 50);
                return false;
            }
            if ((by2 = this.fData[++this.fCurrentOffset]) == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 51);
                return false;
            }
            bl2 = true;
            bl = false;
        }
        if (bl2) {
            while (true) {
                XMLName xMLName = this.fDTDParams.getPEReferenceName();
                this.fEntityContent.offset = ++this.fCurrentOffset;
                if (!this.fHelper.scanPEReference(this.fEntityContent, xMLName)) {
                    return false;
                }
                this.fCurrentOffset = this.fEntityContent.offset;
                this.fHandler.startPEReferenceWithinMarkup(xMLName, this.fMarkupDepth);
                while (true) {
                    by2 = this.fData[this.fCurrentOffset];
                    while (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                        by2 = this.fData[++this.fCurrentOffset];
                    }
                    this.fEntityContent.offset = this.fCurrentOffset;
                    if (by2 != 0 || this.fCurrentOffset != this.fEntityContent.endOffset) break;
                    if (!this.endOfContentWithinMarkup()) {
                        return false;
                    }
                    this.fDTDParams.resetPEReferenceName();
                }
                if (by2 != 37) break;
                ++this.fCurrentOffset;
                if (bl) continue;
                by2 = this.fData[this.fCurrentOffset];
                if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                    ++this.fCurrentOffset;
                    if (!this.checkForPEReference()) {
                        return false;
                    }
                    bl = true;
                    break;
                }
                bl = by2 == 37;
                if (!bl) continue;
            }
        }
        this.fEntityContent.offset = this.fCurrentOffset;
        DTDParams dTDParams2 = this.fDTDParams;
        XMLName xMLName = dTDParams2.getEntityDeclName();
        int n = this.fHelper.scanName(this.fEntityContent, xMLName);
        if (n == 0) {
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 53);
            return false;
        }
        this.fCurrentOffset = this.fEntityContent.offset;
        if (!this.scanRequiredWhitespace()) {
            this.fHelper.setParameter(0, xMLName);
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 54);
            return false;
        }
        if (!this.checkForPEReference()) {
            return false;
        }
        by2 = this.fData[this.fCurrentOffset];
        if (by2 == 34 || by2 == 39) {
            byte by3 = by2;
            ++this.fCurrentOffset;
            this.fHandler.startEntityValue();
            this.fEntityContent.offset = this.fCurrentOffset;
            if (!LatinWFCMarkupDeclScanner.scanEntityValue(this.fHandler, this.fHelper, this.fDTDParams, this.fEntityContent, by3, false)) {
                return false;
            }
            this.fCurrentOffset = this.fEntityContent.offset;
            if (!this.checkForPEReference()) {
                return false;
            }
            by2 = this.fData[this.fCurrentOffset];
            if (by2 != 62) {
                this.fHelper.setParameter(0, xMLName);
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 58);
                return false;
            }
            ++this.fCurrentOffset;
            if (bl) {
                this.fHandler.internalPEDecl(xMLName);
            } else {
                this.fHandler.internalEntityDecl(xMLName);
            }
            dTDParams2.resetEntityDeclName();
            return true;
        }
        if (by2 == 80 && this.fData[this.fCurrentOffset + 1] == 85 && this.fData[this.fCurrentOffset + 2] == 66 && this.fData[this.fCurrentOffset + 3] == 76 && this.fData[this.fCurrentOffset + 4] == 73 && this.fData[this.fCurrentOffset + 5] == 67) {
            this.fCurrentOffset += 6;
            if (!this.scanRequiredWhitespace()) {
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 60);
                return false;
            }
            if (!this.checkForPEReference()) {
                return false;
            }
            by = this.fData[this.fCurrentOffset];
            if (by != 34 && by != 39) {
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 10);
                return false;
            }
            this.fEntityContent.offset = ++this.fCurrentOffset;
            dTDParams = this.fDTDParams;
            xMLString = dTDParams.getPublicID();
            if (!this.fHelper.scanPublicID(this.fEntityContent, by, xMLString)) {
                return false;
            }
            this.fCurrentOffset = this.fEntityContent.offset;
        } else if (by2 == 83 && this.fData[this.fCurrentOffset + 1] == 89 && this.fData[this.fCurrentOffset + 2] == 83 && this.fData[this.fCurrentOffset + 3] == 84 && this.fData[this.fCurrentOffset + 4] == 69 && this.fData[this.fCurrentOffset + 5] == 77) {
            this.fCurrentOffset += 6;
            xMLString = null;
        } else {
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 59);
            return false;
        }
        if (!this.scanRequiredWhitespace()) {
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 62);
            return false;
        }
        if (!this.checkForPEReference()) {
            return false;
        }
        by = this.fData[this.fCurrentOffset];
        if (by != 34 && by != 39) {
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 8);
            return false;
        }
        this.fEntityContent.offset = ++this.fCurrentOffset;
        DTDParams dTDParams3 = this.fDTDParams;
        XMLString xMLString2 = dTDParams3.getSystemID();
        if (!this.fHelper.scanSystemID(this.fEntityContent, by, xMLString2)) {
            return false;
        }
        this.fCurrentOffset = this.fEntityContent.offset;
        boolean bl3 = this.scanRequiredWhitespace();
        if (!this.checkForPEReference()) {
            return false;
        }
        by2 = this.fData[this.fCurrentOffset];
        if (by2 == 62) {
            ++this.fCurrentOffset;
            if (bl) {
                this.fHandler.externalPEDecl(xMLName, xMLString, xMLString2);
            } else {
                this.fHandler.externalEntityDecl(xMLName, xMLString, xMLString2);
            }
        } else {
            if (bl || !bl3) {
                this.fHelper.setParameter(0, xMLName);
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 58);
                return false;
            }
            if (by2 == 78 && this.fData[this.fCurrentOffset + 1] == 68 && this.fData[this.fCurrentOffset + 2] == 65 && this.fData[this.fCurrentOffset + 3] == 84 && this.fData[this.fCurrentOffset + 4] == 65) {
                this.fCurrentOffset += 5;
            } else {
                this.fHelper.setParameter(0, xMLName);
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 58);
                return false;
            }
            if (!this.scanRequiredWhitespace()) {
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 56);
                return false;
            }
            if (!this.checkForPEReference()) {
                return false;
            }
            this.fEntityContent.offset = this.fCurrentOffset;
            DTDParams dTDParams4 = this.fDTDParams;
            XMLName xMLName2 = dTDParams4.getNotationName();
            n = this.fHelper.scanName(this.fEntityContent, xMLName2);
            if (n == 0) {
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 57);
                return false;
            }
            this.fCurrentOffset = this.fEntityContent.offset;
            if (!this.checkForPEReference()) {
                return false;
            }
            if (this.fData[this.fCurrentOffset] != 62) {
                this.fHelper.setParameter(0, xMLName);
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 58);
                return false;
            }
            ++this.fCurrentOffset;
            this.fHandler.unparsedEntityDecl(xMLName, xMLString, xMLString2, xMLName2);
            dTDParams4.resetNotationName();
        }
        dTDParams2.resetEntityDeclName();
        if (xMLString != null) {
            dTDParams.resetPublicID();
        }
        dTDParams3.resetSystemID();
        return true;
    }

    private boolean scanNotationDecl() {
        XMLString xMLString;
        XMLString xMLString2;
        byte by;
        DTDParams dTDParams = null;
        DTDParams dTDParams2 = null;
        if (!this.scanRequiredWhitespace()) {
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 64);
            return false;
        }
        if (!this.checkForPEReference()) {
            return false;
        }
        this.fEntityContent.offset = this.fCurrentOffset;
        DTDParams dTDParams3 = this.fDTDParams;
        XMLName xMLName = dTDParams3.getNotationName();
        int n = this.fHelper.scanName(this.fEntityContent, xMLName);
        if (n == 0) {
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 65);
            return false;
        }
        this.fCurrentOffset = this.fEntityContent.offset;
        if (!this.scanRequiredWhitespace()) {
            this.fHelper.setParameter(0, xMLName);
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 66);
            return false;
        }
        if (!this.checkForPEReference()) {
            return false;
        }
        byte by2 = this.fData[this.fCurrentOffset];
        if (by2 == 80 && this.fData[this.fCurrentOffset + 1] == 85 && this.fData[this.fCurrentOffset + 2] == 66 && this.fData[this.fCurrentOffset + 3] == 76 && this.fData[this.fCurrentOffset + 4] == 73 && this.fData[this.fCurrentOffset + 5] == 67) {
            this.fCurrentOffset += 6;
            if (!this.scanRequiredWhitespace()) {
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 60);
                return false;
            }
            if (!this.checkForPEReference()) {
                return false;
            }
            by = this.fData[this.fCurrentOffset];
            if (by != 34 && by != 39) {
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 10);
                return false;
            }
            this.fEntityContent.offset = ++this.fCurrentOffset;
            dTDParams = this.fDTDParams;
            xMLString2 = dTDParams.getPublicID();
            if (!this.fHelper.scanPublicID(this.fEntityContent, by, xMLString2)) {
                return false;
            }
            this.fCurrentOffset = this.fEntityContent.offset;
        } else if (by2 == 83 && this.fData[this.fCurrentOffset + 1] == 89 && this.fData[this.fCurrentOffset + 2] == 83 && this.fData[this.fCurrentOffset + 3] == 84 && this.fData[this.fCurrentOffset + 4] == 69 && this.fData[this.fCurrentOffset + 5] == 77) {
            this.fCurrentOffset += 6;
            xMLString2 = null;
        } else {
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 59);
            return false;
        }
        by2 = this.fData[this.fCurrentOffset];
        if (by2 == 62) {
            xMLString = null;
        } else {
            if (!this.scanRequiredWhitespace()) {
                this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 62);
                return false;
            }
            if (!this.checkForPEReference()) {
                return false;
            }
            by = this.fData[this.fCurrentOffset];
            if (by == 34 || by == 39) {
                this.fEntityContent.offset = ++this.fCurrentOffset;
                dTDParams2 = this.fDTDParams;
                xMLString = dTDParams2.getSystemID();
                if (!this.fHelper.scanSystemID(this.fEntityContent, by, xMLString)) {
                    return false;
                }
                this.fCurrentOffset = this.fEntityContent.offset;
            } else {
                xMLString = null;
            }
        }
        if (!this.checkForPEReference()) {
            return false;
        }
        if (this.fData[this.fCurrentOffset] != 62) {
            this.fHelper.setParameter(0, xMLName);
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 67);
            return false;
        }
        ++this.fCurrentOffset;
        this.fHandler.notationDecl(xMLName, xMLString2, xMLString);
        dTDParams3.resetNotationName();
        if (xMLString2 != null) {
            dTDParams.resetPublicID();
        }
        if (xMLString != null) {
            dTDParams2.resetSystemID();
        }
        return true;
    }

    private boolean scanRequiredWhitespace() {
        byte by = this.fData[this.fCurrentOffset];
        if (by == 32 || by == 10 || by == 9 || by == 13) {
            return true;
        }
        if (by == 37) {
            return true;
        }
        this.fEntityContent.offset = this.fCurrentOffset;
        return by == 0 && this.fCurrentOffset == this.fEntityContent.endOffset;
    }

    private boolean checkForPEReference() {
        while (true) {
            byte by = this.fData[this.fCurrentOffset];
            while (by == 32 || by == 10 || by == 9 || by == 13) {
                by = this.fData[++this.fCurrentOffset];
            }
            this.fEntityContent.offset = this.fCurrentOffset;
            if (by == 0 && this.fCurrentOffset == this.fEntityContent.endOffset) {
                if (!this.endOfContentWithinMarkup()) {
                    return false;
                }
                this.fDTDParams.resetPEReferenceName();
                continue;
            }
            if (by != 37) {
                return true;
            }
            this.fEntityContent.offset = ++this.fCurrentOffset;
            XMLName xMLName = this.fDTDParams.getPEReferenceName();
            if (!this.fHelper.scanPEReference(this.fEntityContent, xMLName)) {
                this.fDTDParams.resetPEReferenceName();
                return false;
            }
            this.fCurrentOffset = this.fEntityContent.offset;
            this.fHandler.startPEReferenceWithinMarkup(xMLName, this.fMarkupDepth);
        }
    }

    private boolean endExternalSubset(boolean bl) {
        --this.fEntityDepth;
        if (bl && this.fEntityDepth != 0) {
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 18);
            return false;
        }
        return bl;
    }

    private void endPEReferenceBetweenMarkup() {
        --this.fEntityDepth;
        if (this.fEntityDepth > 0) {
            int n = this.fEntityDepth - 1;
            this.fDTDParams = this.fDTDParamsStack[n];
            this.fEntityContent = this.fEntityContentStack[n];
            this.fData = this.fDataStack[n];
            this.fCurrentOffset = this.fCurrentOffsetStack[n];
            this.fEntityState = this.fEntityStateStack[n];
        }
    }

    private boolean endOfContentWithinMarkup() {
        if (this.fEntityState != 2) {
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 18);
            return false;
        }
        --this.fEntityDepth;
        if (this.fEntityDepth == 0) {
            this.fHelper.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 18);
            return false;
        }
        this.fHandler.endPEReferenceWithinMarkup(this.fMarkupDepth);
        int n = this.fEntityDepth - 1;
        this.fDTDParams = this.fDTDParamsStack[n];
        this.fEntityContent = this.fEntityContentStack[n];
        this.fData = this.fDataStack[n];
        this.fCurrentOffset = this.fCurrentOffsetStack[n];
        this.fEntityState = this.fEntityStateStack[n];
        return true;
    }

    private void growContext() {
        int n = this.fEntityDepth - 1;
        int n2 = n << 1;
        DTDParams[] dTDParamsArray = new DTDParams[n2];
        System.arraycopy(this.fDTDParamsStack, 0, dTDParamsArray, 0, n);
        this.fDTDParamsStack = dTDParamsArray;
        ParsedEntity[] parsedEntityArray = new ParsedEntity[n2];
        System.arraycopy(this.fEntityContentStack, 0, parsedEntityArray, 0, n);
        this.fEntityContentStack = parsedEntityArray;
        byte[][] byArrayArray = new byte[n2][];
        System.arraycopy(this.fDataStack, 0, byArrayArray, 0, n);
        this.fDataStack = byArrayArray;
        int[] nArray = new int[n2];
        System.arraycopy(this.fCurrentOffsetStack, 0, nArray, 0, n);
        this.fCurrentOffsetStack = nArray;
        nArray = new int[n2];
        System.arraycopy(this.fEntityStateStack, 0, nArray, 0, n);
        this.fEntityStateStack = nArray;
    }

    private LatinWFCExternalSubsetScanner() {
    }
}

